/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.util.Logger;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.api.RepositoryFactory;
import org.xml.sax.SAXException;

@ThreadSafe
public class JcrRepositoryFactory
implements RepositoryFactory {
    private static final Logger LOG = Logger.getLogger(JcrRepositoryFactory.class);
    private static final Map<String, JcrEngine> ENGINES = new HashMap<String, JcrEngine>();
    public static final String URL = "org.modeshape.jcr.URL";
    public static final String REPOSITORY_NAME_PARAM = "repositoryName";

    public Repository getRepository(Map parameters) {
        LOG.debug("Trying to load ModeShape JCR Repository with parameters: " + parameters, new Object[0]);
        if (parameters == null) {
            return null;
        }
        Object rawUrl = parameters.get(URL);
        if (rawUrl == null) {
            LOG.debug("No parameter found with key: org.modeshape.jcr.URL", new Object[0]);
            return null;
        }
        URL url = null;
        if (rawUrl instanceof URL) {
            url = (URL)rawUrl;
        } else {
            try {
                url = new URL(rawUrl.toString());
            }
            catch (MalformedURLException mue) {
                LOG.debug("Could not parse URL: " + mue.getMessage(), new Object[0]);
                return null;
            }
        }
        if (url.getPath() == null || url.getPath().trim().length() == 0) {
            LOG.debug("Cannot have null or empty path in repository URL", new Object[0]);
            return null;
        }
        JcrEngine engine = null;
        engine = "jndi".equals(url.getProtocol()) ? this.getEngineFromJndi(url.getPath(), parameters) : this.getEngineFromConfigFile(url);
        if (engine == null) {
            LOG.debug("Could not load engine from URL: " + url, new Object[0]);
            return null;
        }
        String query = url.getQuery();
        String repositoryName = null;
        if (query != null) {
            for (String keyValuePair : query.split("&")) {
                String[] splitPair = keyValuePair.split("=");
                if (splitPair.length != 2 || !REPOSITORY_NAME_PARAM.equals(splitPair[0])) continue;
                repositoryName = splitPair[1];
                break;
            }
        }
        if (repositoryName == null) {
            Set<String> repositoryNames = engine.getRepositoryNames();
            if (repositoryNames.size() != 1) {
                LOG.debug("No repository name provided in URL and multiple repositories configured in engine with following names: " + repositoryNames, new Object[0]);
                return null;
            }
            repositoryName = repositoryNames.iterator().next();
        }
        try {
            LOG.debug("Trying to access repository: " + repositoryName, new Object[0]);
            return engine.getRepository(repositoryName);
        }
        catch (RepositoryException re) {
            LOG.debug((Throwable)re, "Could not load repository named '{0}'", new Object[]{repositoryName});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JcrEngine getEngineFromConfigFile(URL configUrl) {
        assert (configUrl != null);
        Map<String, JcrEngine> map = ENGINES;
        synchronized (map) {
            String configKey = configUrl.toString();
            JcrEngine engine = ENGINES.get(configKey);
            if (engine != null) {
                return engine;
            }
            JcrConfiguration config = new JcrConfiguration();
            try {
                config.loadFrom(configUrl);
            }
            catch (FileNotFoundException fnfe) {
                if (!"file".equals(configUrl.getProtocol())) {
                    LOG.warn((Throwable)fnfe, JcrI18n.couldNotStartEngine, new Object[0]);
                    return null;
                }
                try {
                    InputStream in = this.getClass().getResourceAsStream(configUrl.getPath());
                    if (in == null) {
                        LOG.debug((Throwable)fnfe, JcrI18n.couldNotStartEngine.text(new Object[0]), new Object[0]);
                        return null;
                    }
                    config.loadFrom(in);
                }
                catch (IOException ioe) {
                    LOG.debug((Throwable)fnfe, JcrI18n.couldNotStartEngine.text(new Object[0]), new Object[0]);
                    return null;
                }
                catch (SAXException se) {
                    LOG.debug((Throwable)fnfe, JcrI18n.couldNotStartEngine.text(new Object[0]), new Object[0]);
                    return null;
                }
            }
            catch (IOException ioe) {
                LOG.warn((Throwable)ioe, JcrI18n.couldNotStartEngine, new Object[0]);
                return null;
            }
            catch (SAXException se) {
                LOG.warn((Throwable)se, JcrI18n.couldNotStartEngine, new Object[0]);
                return null;
            }
            engine = config.build();
            engine.start();
            if (engine.getProblems().hasProblems()) {
                LOG.warn(JcrI18n.couldNotStartEngine, new Object[0]);
                for (Problem problem : engine.getProblems()) {
                    LOG.warn(problem.getMessage(), problem.getParameters());
                }
                engine.shutdown();
                return null;
            }
            ENGINES.put(configKey, engine);
            return engine;
        }
    }

    private Hashtable<String, String> hashtable(Map<String, String> map) {
        assert (map != null);
        Hashtable<String, String> hash = new Hashtable<String, String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            hash.put(entry.getKey(), entry.getValue());
        }
        return hash;
    }

    private JcrEngine getEngineFromJndi(String engineJndiName, Map<String, String> parameters) {
        try {
            InitialContext ic = new InitialContext(this.hashtable(parameters));
            Object ob = ic.lookup(engineJndiName);
            if (!(ob instanceof JcrEngine)) {
                return null;
            }
            return (JcrEngine)((Object)ob);
        }
        catch (NamingException ne) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map<String, JcrEngine> map = ENGINES;
        synchronized (map) {
            for (JcrEngine engine : ENGINES.values()) {
                engine.shutdown();
            }
            ENGINES.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        Map<String, JcrEngine> map = ENGINES;
        synchronized (map) {
            for (JcrEngine engine : ENGINES.values()) {
                engine.shutdown();
            }
            boolean allShutDownClean = true;
            for (JcrEngine engine : ENGINES.values()) {
                allShutDownClean &= engine.awaitTermination(timeout, unit);
            }
            ENGINES.clear();
            return allShutDownClean;
        }
    }
}

