/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.snowball.SnowballAnalyzer;
import org.apache.lucene.util.Version;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.UrlEncoder;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.Observable;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.QueryEngine;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.optimize.Optimizer;
import org.modeshape.graph.query.optimize.RuleBasedOptimizer;
import org.modeshape.graph.query.plan.CanonicalPlanner;
import org.modeshape.graph.query.plan.PlanHints;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.plan.Planner;
import org.modeshape.graph.query.process.AbstractAccessComponent;
import org.modeshape.graph.query.process.ProcessingComponent;
import org.modeshape.graph.query.process.Processor;
import org.modeshape.graph.query.process.QueryProcessor;
import org.modeshape.graph.query.process.SelectComponent;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.processor.RequestProcessor;
import org.modeshape.graph.search.SearchEngine;
import org.modeshape.graph.search.SearchEngineIndexer;
import org.modeshape.graph.search.SearchEngineProcessor;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.search.lucene.IndexRules;
import org.modeshape.search.lucene.LuceneConfiguration;
import org.modeshape.search.lucene.LuceneConfigurations;
import org.modeshape.search.lucene.LuceneSearchEngine;

abstract class RepositoryQueryManager {
    protected final String sourceName;

    RepositoryQueryManager(String sourceName) {
        this.sourceName = sourceName;
    }

    public abstract QueryResults query(String var1, QueryCommand var2, Schemata var3, PlanHints var4, Map<String, Object> var5) throws InvalidQueryException;

    public abstract QueryResults search(String var1, String var2, int var3, int var4) throws InvalidQueryException;

    public void reindexContent() {
    }

    public void reindexContent(JcrWorkspace workspace) {
    }

    public void reindexContent(JcrWorkspace workspace, String path, int depth) {
    }

    static class SelfContained
    extends RepositoryQueryManager {
        private final ExecutionContext context;
        private final String sourceName;
        private final LuceneConfiguration configuration;
        private final SearchEngine searchEngine;
        private final Observer searchObserver;
        private final ExecutorService service;
        private final QueryEngine queryEngine;
        private final RepositoryConnectionFactory connectionFactory;

        SelfContained(ExecutionContext context, String nameOfSourceToBeSearchable, RepositoryConnectionFactory connectionFactory, Observable observable, RepositoryNodeTypeManager nodeTypeManager, String indexDirectory, boolean updateIndexesSynchronously) throws RepositoryException {
            super(nameOfSourceToBeSearchable);
            this.context = context;
            this.sourceName = nameOfSourceToBeSearchable;
            this.connectionFactory = connectionFactory;
            UrlEncoder encoder = new UrlEncoder();
            if (indexDirectory != null) {
                File indexDir = new File(indexDirectory);
                if (indexDir.exists()) {
                    if (!indexDir.isDirectory()) {
                        I18n msg = JcrI18n.searchIndexDirectoryOptionSpecifiesFileNotDirectory;
                        throw new RepositoryException(msg.text(new Object[]{indexDirectory, this.sourceName}));
                    }
                    if (!indexDir.canWrite()) {
                        I18n msg = JcrI18n.searchIndexDirectoryOptionSpecifiesDirectoryThatCannotBeWrittenTo;
                        throw new RepositoryException(msg.text(new Object[]{indexDirectory, this.sourceName}));
                    }
                    if (!indexDir.canRead()) {
                        I18n msg = JcrI18n.searchIndexDirectoryOptionSpecifiesDirectoryThatCannotBeRead;
                        throw new RepositoryException(msg.text(new Object[]{indexDirectory, this.sourceName}));
                    }
                } else if (!indexDir.mkdirs()) {
                    I18n msg = JcrI18n.searchIndexDirectoryOptionSpecifiesDirectoryThatCannotBeCreated;
                    throw new RepositoryException(msg.text(new Object[]{indexDirectory, this.sourceName}));
                }
                this.configuration = LuceneConfigurations.using((File)indexDir, (TextEncoder)encoder, (TextEncoder)encoder);
            } else {
                this.configuration = LuceneConfigurations.inMemory();
            }
            assert (this.configuration != null);
            IndexRules indexRules = nodeTypeManager.getRepositorySchemata().getIndexRules();
            SnowballAnalyzer analyzer = new SnowballAnalyzer(Version.LUCENE_30, "English");
            boolean verifyWorkspaces = false;
            this.searchEngine = new LuceneSearchEngine(nameOfSourceToBeSearchable, connectionFactory, verifyWorkspaces, this.configuration, indexRules, (Analyzer)analyzer);
            if (updateIndexesSynchronously) {
                this.service = null;
                this.searchObserver = new Observer(){

                    public void notify(Changes changes) {
                        if (changes.getSourceName().equals(SelfContained.this.sourceName)) {
                            SelfContained.this.process(changes);
                        }
                    }
                };
            } else {
                this.service = Executors.newCachedThreadPool();
                this.searchObserver = new Observer(){

                    public void notify(final Changes changes) {
                        if (changes.getSourceName().equals(SelfContained.this.sourceName)) {
                            SelfContained.this.service.submit(new Runnable(){

                                @Override
                                public void run() {
                                    SelfContained.this.process(changes);
                                }
                            });
                        }
                    }
                };
            }
            observable.register(this.searchObserver);
            CanonicalPlanner planner = new CanonicalPlanner();
            RuleBasedOptimizer optimizer = new RuleBasedOptimizer();
            QueryProcessor processor = new QueryProcessor(){

                protected ProcessingComponent createAccessComponent(QueryCommand originalQuery, QueryContext context, PlanNode accessNode, QueryResults.Columns resultColumns, SelectComponent.Analyzer analyzer) {
                    return new AccessQueryProcessor((GraphQueryContext)context, resultColumns, accessNode);
                }
            };
            this.queryEngine = new QueryEngine((Planner)planner, (Optimizer)optimizer, (Processor)processor);
            this.reindexContent();
        }

        protected void process(Changes changes) {
            try {
                this.searchEngine.index(this.context, (Iterable)changes.getChangeRequests());
            }
            catch (RuntimeException e) {
                Logger.getLogger(this.getClass()).error((Throwable)e, JcrI18n.errorUpdatingQueryIndexes, new Object[]{e.getLocalizedMessage()});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public QueryResults query(String workspaceName, QueryCommand query, Schemata schemata, PlanHints hints, Map<String, Object> variables) {
            TypeSystem typeSystem = this.context.getValueFactories().getTypeSystem();
            SearchEngineProcessor processor = this.searchEngine.createProcessor(this.context, null, true);
            try {
                GraphQueryContext context = new GraphQueryContext(schemata, typeSystem, hints, (Problems)new SimpleProblems(), variables, (RequestProcessor)processor, workspaceName);
                QueryResults queryResults = this.queryEngine.execute((QueryContext)context, query);
                return queryResults;
            }
            finally {
                processor.close();
            }
        }

        @Override
        public QueryResults search(String workspaceName, String searchExpression, int maxRowCount, int offset) {
            Graph graph = Graph.create((String)this.sourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)this.context);
            if (workspaceName != null) {
                graph.useWorkspace(workspaceName);
            }
            return graph.search(searchExpression, maxRowCount, offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reindexContent() {
            Set workspaces = Graph.create((String)this.sourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)this.context).getWorkspaces();
            SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.searchEngine, this.connectionFactory);
            try {
                for (String workspace : workspaces) {
                    indexer.index(workspace);
                }
            }
            finally {
                indexer.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reindexContent(JcrWorkspace workspace) {
            SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.searchEngine, this.connectionFactory);
            try {
                indexer.index(workspace.getName());
            }
            finally {
                indexer.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reindexContent(JcrWorkspace workspace, String path, int depth) {
            Path at = (Path)workspace.context().getValueFactories().getPathFactory().create(path);
            SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.searchEngine, this.connectionFactory);
            try {
                indexer.index(workspace.getName(), at, depth);
            }
            finally {
                indexer.close();
            }
        }

        protected static class AccessQueryProcessor
        extends AbstractAccessComponent {
            private final AccessQueryRequest accessRequest;

            protected AccessQueryProcessor(GraphQueryContext context, QueryResults.Columns columns, PlanNode accessNode) {
                super((QueryContext)context, columns, accessNode);
                this.accessRequest = new AccessQueryRequest(context.getWorkspaceName(), this.sourceName, this.getColumns(), this.andedConstraints, this.limit, context.getSchemata(), context.getVariables());
                context.getProcessor().process(this.accessRequest);
            }

            public AccessQueryRequest getAccessRequest() {
                return this.accessRequest;
            }

            public List<Object[]> execute() {
                if (this.accessRequest.getError() != null) {
                    I18n msg = GraphI18n.errorWhilePerformingQuery;
                    this.getContext().getProblems().addError(this.accessRequest.getError(), msg, new Object[]{this.accessNode.getString(), this.accessRequest.workspace(), this.sourceName, this.accessRequest.getError().getLocalizedMessage()});
                    return this.emptyTuples();
                }
                return this.accessRequest.getTuples();
            }
        }

        protected class GraphQueryContext
        extends QueryContext {
            private final RequestProcessor processor;
            private final String workspaceName;

            protected GraphQueryContext(Schemata schemata, TypeSystem typeSystem, PlanHints hints, Problems problems, Map<String, Object> variables, RequestProcessor processor, String workspaceName) {
                super(schemata, typeSystem, hints, problems, variables);
                this.processor = processor;
                this.workspaceName = workspaceName;
            }

            public RequestProcessor getProcessor() {
                return this.processor;
            }

            public String getWorkspaceName() {
                return this.workspaceName;
            }
        }
    }

    static class Disabled
    extends RepositoryQueryManager {
        Disabled(String sourceName) {
            super(sourceName);
        }

        @Override
        public QueryResults query(String workspaceName, QueryCommand query, Schemata schemata, PlanHints hints, Map<String, Object> variables) throws InvalidQueryException {
            throw new InvalidQueryException(JcrI18n.queryIsDisabledInRepository.text(new Object[]{this.sourceName}));
        }

        @Override
        public QueryResults search(String workspaceName, String searchExpression, int maxRowCount, int offset) throws InvalidQueryException {
            throw new InvalidQueryException(JcrI18n.queryIsDisabledInRepository.text(new Object[]{this.sourceName}));
        }
    }

    static class PushDown
    extends RepositoryQueryManager {
        private final ExecutionContext context;
        private final RepositoryConnectionFactory connectionFactory;

        PushDown(String sourceName, ExecutionContext context, RepositoryConnectionFactory connectionFactory) {
            super(sourceName);
            this.context = context;
            this.connectionFactory = connectionFactory;
        }

        private Graph workspaceGraph(String workspaceName) {
            Graph graph = Graph.create((String)this.sourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)this.context);
            if (workspaceName != null) {
                graph.useWorkspace(workspaceName);
            }
            return graph;
        }

        @Override
        public QueryResults query(String workspaceName, QueryCommand query, Schemata schemata, PlanHints hints, Map<String, Object> variables) {
            Graph.BuildQuery builder = this.workspaceGraph(workspaceName).query(query, schemata);
            if (variables != null) {
                builder.using(variables);
            }
            if (hints != null) {
                builder.using(hints);
            }
            return builder.execute();
        }

        @Override
        public QueryResults search(String workspaceName, String searchExpression, int maxRowCount, int offset) {
            return this.workspaceGraph(workspaceName).search(searchExpression, maxRowCount, offset);
        }
    }
}

