/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.query.RowIterator;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.Location;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.api.query.QueryResult;
import org.modeshape.jcr.api.query.Row;
import org.modeshape.jcr.query.JcrQueryContext;

@NotThreadSafe
public class JcrQueryResult
implements javax.jcr.query.QueryResult,
QueryResult {
    protected final JcrQueryContext context;
    protected final QueryResults results;
    protected final Schemata schemata;
    protected final String queryStatement;
    private List<String> columnTables;

    protected JcrQueryResult(JcrQueryContext context, String query, QueryResults graphResults, Schemata schemata) {
        this.context = context;
        this.results = graphResults;
        this.schemata = schemata;
        this.queryStatement = query;
        assert (this.context != null);
        assert (this.results != null);
        assert (this.schemata != null);
        assert (this.queryStatement != null);
    }

    protected QueryResults results() {
        return this.results;
    }

    public List<String> getColumnNameList() {
        return this.results.getColumns().getColumnNames();
    }

    public List<String> getColumnTypeList() {
        return this.results.getColumns().getColumnTypes();
    }

    public String[] getColumnNames() {
        List<String> names = this.getColumnNameList();
        return names.toArray(new String[names.size()]);
    }

    public String[] getColumnTypes() {
        List<String> types = this.getColumnTypeList();
        return types.toArray(new String[types.size()]);
    }

    public String[] getSelectorNames() {
        if (this.columnTables == null) {
            QueryResults.Columns columns = this.results.getColumns();
            ArrayList<String> tables = new ArrayList<String>(columns.getColumnCount());
            for (Column column : columns) {
                String tableName = "";
                Schemata.Table table = this.schemata.getTable(column.selectorName());
                if (table != null) {
                    tableName = table.getName().name();
                }
                tables.add(tableName);
            }
            this.columnTables = tables;
        }
        return this.columnTables.toArray(new String[this.columnTables.size()]);
    }

    public NodeIterator getNodes() throws RepositoryException {
        int numRows = this.results.getRowCount();
        if (numRows == 0) {
            return this.context.emptyNodeIterator();
        }
        ArrayList<Node> nodes = new ArrayList<Node>(numRows);
        String selectorName = (String)this.results.getColumns().getSelectorNames().get(0);
        int locationIndex = this.results.getColumns().getLocationIndex(selectorName);
        for (Object[] tuple : this.results.getTuples()) {
            Location location = (Location)tuple[locationIndex];
            Node node = this.context.getNode(location);
            if (node == null) continue;
            nodes.add(node);
        }
        return new QueryResultNodeIterator(nodes);
    }

    public RowIterator getRows() {
        int numRows = this.results.getRowCount();
        List tuples = this.results.getTuples();
        if (this.results.getColumns().getLocationCount() == 1) {
            return new SingleSelectorQueryResultRowIterator(this.context, this.queryStatement, this.results, tuples.iterator(), numRows);
        }
        return new QueryResultRowIterator(this.context, this.queryStatement, this.results, tuples.iterator(), numRows);
    }

    public String getPlan() {
        return this.results.getPlan();
    }

    public String toString() {
        return this.results.toString();
    }

    protected static class MultiSelectorQueryResultRow
    implements javax.jcr.query.Row,
    Row {
        protected final QueryResultRowIterator iterator;
        protected final Object[] tuple;
        private Value[] values = null;
        private Node[] nodes;
        private int[] locationIndexes;

        protected MultiSelectorQueryResultRow(QueryResultRowIterator iterator, Node[] nodes, int[] locationIndexes, Object[] tuple) {
            this.iterator = iterator;
            this.tuple = tuple;
            this.nodes = nodes;
            this.locationIndexes = locationIndexes;
            assert (this.iterator != null);
            assert (this.tuple != null);
        }

        public Node getNode(String selectorName) throws RepositoryException {
            try {
                int locationIndex = this.iterator.columns.getLocationIndex(selectorName);
                for (int i = 0; i != this.locationIndexes.length; ++i) {
                    if (this.locationIndexes[i] != locationIndex) continue;
                    return this.nodes[i];
                }
            }
            catch (NoSuchElementException e) {
                throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
            }
            assert (false);
            return null;
        }

        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            try {
                int locationIndex = this.iterator.columns.getLocationIndexForColumn(columnName);
                for (int i = 0; i != this.locationIndexes.length; ++i) {
                    if (this.locationIndexes[i] != locationIndex) continue;
                    Node node = this.nodes[i];
                    return node != null ? node.getProperty(columnName).getValue() : null;
                }
            }
            catch (NoSuchElementException e) {
                throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
            }
            assert (false);
            return null;
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                int i = 0;
                this.values = new Value[this.iterator.columnNames.size()];
                for (String columnName : this.iterator.columnNames) {
                    this.values[i++] = this.getValue(columnName);
                }
            }
            return this.values;
        }

        public Node getNode() throws RepositoryException {
            throw new UnsupportedRepositoryOperationException();
        }

        public String getPath() throws RepositoryException {
            throw new UnsupportedRepositoryOperationException();
        }

        public String getPath(String selectorName) throws RepositoryException {
            throw new UnsupportedRepositoryOperationException();
        }

        public double getScore() throws RepositoryException {
            throw new UnsupportedRepositoryOperationException();
        }

        public double getScore(String selectorName) throws RepositoryException {
            throw new UnsupportedRepositoryOperationException();
        }
    }

    protected static class SingleSelectorQueryResultRow
    implements javax.jcr.query.Row,
    Row {
        protected final SingleSelectorQueryResultRowIterator iterator;
        protected final Node node;
        protected final Object[] tuple;
        private Value[] values = null;

        protected SingleSelectorQueryResultRow(SingleSelectorQueryResultRowIterator iterator, Node node, Object[] tuple) {
            this.iterator = iterator;
            this.node = node;
            this.tuple = tuple;
            assert (this.iterator != null);
            assert (this.node != null);
            assert (this.tuple != null);
        }

        public Node getNode(String selectorName) throws RepositoryException {
            if (this.iterator.hasSelector(selectorName)) {
                throw new RepositoryException(JcrI18n.selectorNotUsedInQuery.text(new Object[]{selectorName, this.iterator.query}));
            }
            return this.node;
        }

        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            return this.node.getProperty(columnName).getValue();
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                int i = 0;
                this.values = new Value[this.iterator.columnNames.size()];
                for (String columnName : this.iterator.columnNames) {
                    this.values[i++] = this.getValue(columnName);
                }
            }
            return this.values;
        }

        public Node getNode() throws RepositoryException {
            throw new UnsupportedRepositoryOperationException();
        }

        public String getPath() throws RepositoryException {
            throw new UnsupportedRepositoryOperationException();
        }

        public String getPath(String selectorName) throws RepositoryException {
            throw new UnsupportedRepositoryOperationException();
        }

        public double getScore() throws RepositoryException {
            throw new UnsupportedRepositoryOperationException();
        }

        public double getScore(String selectorName) throws RepositoryException {
            throw new UnsupportedRepositoryOperationException();
        }
    }

    @NotThreadSafe
    protected static class SingleSelectorQueryResultRowIterator
    extends QueryResultRowIterator {
        protected final int locationIndex;
        protected final int scoreIndex;

        protected SingleSelectorQueryResultRowIterator(JcrQueryContext context, String query, QueryResults results, Iterator<Object[]> tuples, long numRows) {
            super(context, query, results, tuples, numRows);
            String selectorName = (String)this.columns.getSelectorNames().get(0);
            this.locationIndex = this.columns.getLocationIndex(selectorName);
            this.scoreIndex = this.columns.getFullTextSearchScoreIndexFor(selectorName);
        }

        @Override
        protected javax.jcr.query.Row getNextRow(Object[] tuple) throws RepositoryException {
            Location location = (Location)tuple[this.locationIndex];
            Node node = this.context.getNode(location);
            return node != null ? this.createRow(node, tuple) : null;
        }

        protected javax.jcr.query.Row createRow(Node node, Object[] tuple) {
            return new SingleSelectorQueryResultRow(this, node, tuple);
        }
    }

    @NotThreadSafe
    protected static class QueryResultRowIterator
    implements RowIterator {
        protected final List<String> columnNames;
        private final Iterator<Object[]> tuples;
        private final Set<String> selectorNames;
        protected final JcrQueryContext context;
        protected final QueryResults.Columns columns;
        protected final String query;
        private int[] locationIndexes;
        private long position = 0L;
        private long numRows;
        private javax.jcr.query.Row nextRow;

        protected QueryResultRowIterator(JcrQueryContext context, String query, QueryResults results, Iterator<Object[]> tuples, long numRows) {
            this.tuples = tuples;
            this.query = query;
            this.columns = results.getColumns();
            this.columnNames = this.columns.getColumnNames();
            this.context = context;
            this.numRows = numRows;
            this.selectorNames = new HashSet<String>(this.columns.getSelectorNames());
            int i = 0;
            this.locationIndexes = new int[this.selectorNames.size()];
            for (String selectorName : this.selectorNames) {
                this.locationIndexes[i++] = this.columns.getLocationIndex(selectorName);
            }
        }

        public boolean hasSelector(String selectorName) {
            return this.selectorNames.contains(selectorName);
        }

        public javax.jcr.query.Row nextRow() {
            if (this.nextRow == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            assert (this.nextRow != null);
            javax.jcr.query.Row result = this.nextRow;
            this.nextRow = null;
            return result;
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.numRows;
        }

        public void skip(long skipNum) {
            for (long i = 0L; i != skipNum; ++i) {
                this.tuples.next();
            }
            this.position += skipNum;
        }

        public boolean hasNext() {
            if (this.nextRow != null) {
                return true;
            }
            while (this.tuples.hasNext()) {
                Object[] tuple = this.tuples.next();
                ++this.position;
                try {
                    this.nextRow = this.getNextRow(tuple);
                    if (this.nextRow != null) {
                        return true;
                    }
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                --this.numRows;
            }
            return false;
        }

        protected javax.jcr.query.Row getNextRow(Object[] tuple) throws RepositoryException {
            Node[] nodes = new Node[this.locationIndexes.length];
            int index = 0;
            for (int locationIndex : this.locationIndexes) {
                Location location = (Location)tuple[locationIndex];
                try {
                    Node node = this.context.getNode(location);
                    if (node == null) {
                        return null;
                    }
                    nodes[index++] = node;
                }
                catch (AccessDeniedException e) {
                    return null;
                }
            }
            return new MultiSelectorQueryResultRow(this, nodes, this.locationIndexes, tuple);
        }

        public Object next() {
            return this.nextRow();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @NotThreadSafe
    protected static class QueryResultNodeIterator
    implements NodeIterator {
        private final Iterator<? extends Node> nodes;
        private final int size;
        private long position = 0L;

        protected QueryResultNodeIterator(List<? extends Node> nodes) {
            this.nodes = nodes.iterator();
            this.size = nodes.size();
        }

        public Node nextNode() {
            Node node = this.nodes.next();
            ++this.position;
            return node;
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.size;
        }

        public void skip(long skipNum) {
            for (long i = 0L; i != skipNum; ++i) {
                this.nextNode();
            }
        }

        public boolean hasNext() {
            return this.nodes.hasNext();
        }

        public Object next() {
            return this.nextNode();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

