/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.jcr.query.JcrQueryContext;
import org.modeshape.jcr.query.JcrQueryResult;

public class XPathQueryResult
extends JcrQueryResult {
    public static final String JCR_SCORE_COLUMN_NAME = "jcr:score";
    public static final String JCR_PATH_COLUMN_NAME = "jcr:path";
    private final List<String> columnNames;

    public XPathQueryResult(JcrQueryContext context, String query, QueryResults graphResults, Schemata schemata) {
        super(context, query, graphResults, schemata);
        LinkedList<String> columnNames = new LinkedList<String>(graphResults.getColumns().getColumnNames());
        if (graphResults.getColumns().hasFullTextSearchScores() && !columnNames.contains(JCR_SCORE_COLUMN_NAME)) {
            columnNames.add(0, JCR_SCORE_COLUMN_NAME);
        }
        columnNames.add(0, JCR_PATH_COLUMN_NAME);
        this.columnNames = Collections.unmodifiableList(columnNames);
    }

    @Override
    public List<String> getColumnNameList() {
        return this.columnNames;
    }

    @Override
    public RowIterator getRows() {
        int numRows = this.results.getRowCount();
        List tuples = this.results.getTuples();
        return new XPathQueryResultRowIterator(this.context, this.queryStatement, this.results, tuples.iterator(), numRows);
    }

    protected static class XPathQueryResultRow
    extends JcrQueryResult.SingleSelectorQueryResultRow {
        protected XPathQueryResultRow(JcrQueryResult.SingleSelectorQueryResultRowIterator iterator, Node node, Object[] tuple) {
            super(iterator, node, tuple);
        }

        @Override
        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            if (XPathQueryResult.JCR_PATH_COLUMN_NAME.equals(columnName)) {
                Location location = (Location)this.tuple[this.iterator.locationIndex];
                return ((XPathQueryResultRowIterator)this.iterator).jcrPath(location.getPath());
            }
            if (XPathQueryResult.JCR_SCORE_COLUMN_NAME.equals(columnName)) {
                Float score = (Float)this.tuple[this.iterator.scoreIndex];
                return ((XPathQueryResultRowIterator)this.iterator).jcrScore(score);
            }
            return super.getValue(columnName);
        }
    }

    protected static class XPathQueryResultRowIterator
    extends JcrQueryResult.SingleSelectorQueryResultRowIterator {
        protected XPathQueryResultRowIterator(JcrQueryContext context, String query, QueryResults results, Iterator<Object[]> tuples, long numRows) {
            super(context, query, results, tuples, numRows);
        }

        @Override
        protected Row createRow(Node node, Object[] tuple) {
            return new XPathQueryResultRow(this, node, tuple);
        }

        protected Value jcrPath(Path path) {
            return this.context.createValue(8, path);
        }

        protected Value jcrScore(Float score) {
            return this.context.createValue(4, score);
        }
    }
}

