/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeTypeDefinition;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.MockSecurityContext;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.observe.MockObservable;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.query.parse.QueryParser;
import org.modeshape.graph.query.parse.QueryParsers;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.CndNodeTypeReader;
import org.modeshape.jcr.JcrGraph;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNamespaceRegistry;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.RepositoryLockManager;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.WorkspaceLockManager;
import org.modeshape.jcr.query.JcrSql2QueryParser;
import org.modeshape.jcr.xpath.XPathQueryParser;

public abstract class AbstractSessionTest {
    protected String workspaceName;
    protected ExecutionContext context;
    protected InMemoryRepositorySource source;
    protected JcrWorkspace workspace;
    protected JcrSession session;
    protected JcrGraph graph;
    protected RepositoryConnectionFactory connectionFactory;
    protected RepositoryNodeTypeManager repoTypeManager;
    protected Map<String, Object> sessionAttributes;
    protected Map<JcrRepository.Option, String> options;
    protected NamespaceRegistry registry;
    protected WorkspaceLockManager workspaceLockManager;
    protected QueryParsers parsers;
    @Mock
    protected JcrRepository repository;
    @Mock
    protected RepositoryLockManager repoLockManager;

    protected void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.workspaceName = "workspace1";
        String repositorySourceName = "repository";
        this.source = new InMemoryRepositorySource();
        this.source.setName(this.workspaceName);
        this.source.setDefaultWorkspaceName(this.workspaceName);
        this.context = new ExecutionContext();
        this.context.getNamespaceRegistry().register("modetest", "http://www.modeshape.org/test/1.0");
        PathFactory pathFactory = this.context.getValueFactories().getPathFactory();
        this.graph = JcrGraph.create((RepositorySource)this.source, (ExecutionContext)this.context);
        this.graph.create("/jcr:system").and();
        ((Graph.SetValuesTo)this.graph.set("jcr:primaryType").on("/jcr:system")).to(ModeShapeLexicon.SYSTEM);
        this.graph.create("/jcr:system/mode:namespaces").and();
        ((Graph.SetValuesTo)this.graph.set("jcr:primaryType").on("/jcr:system/mode:namespaces")).to(ModeShapeLexicon.NAMESPACES);
        for (Map.Entry builtIn : JcrNamespaceRegistry.STANDARD_BUILT_IN_NAMESPACES_BY_PREFIX.entrySet()) {
            this.context.getNamespaceRegistry().register((String)builtIn.getKey(), (String)builtIn.getValue());
        }
        this.initializeContent();
        this.connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                return "repository".equals(sourceName) ? AbstractSessionTest.this.source.getConnection() : null;
            }
        };
        Mockito.when((Object)this.repository.getExecutionContext()).thenReturn((Object)this.context);
        Mockito.when((Object)this.repository.getRepositorySourceName()).thenReturn((Object)"repository");
        Mockito.when((Object)this.repository.getPersistentRegistry()).thenReturn((Object)this.context.getNamespaceRegistry());
        Mockito.when((Object)this.repository.createWorkspaceGraph(Matchers.anyString(), (ExecutionContext)Matchers.anyObject())).thenAnswer((Answer)new Answer<Graph>(){

            public Graph answer(InvocationOnMock invocation) throws Throwable {
                return AbstractSessionTest.this.graph;
            }
        });
        Mockito.when((Object)this.repository.createSystemGraph(this.context)).thenAnswer((Answer)new Answer<Graph>(){

            public Graph answer(InvocationOnMock invocation) throws Throwable {
                return AbstractSessionTest.this.graph;
            }
        });
        Mockito.when((Object)this.repository.getRepositoryObservable()).thenReturn((Object)new MockObservable());
        Mockito.when((Object)this.repository.getRepositoryLockManager()).thenReturn((Object)this.repoLockManager);
        this.repoTypeManager = new RepositoryNodeTypeManager(this.repository, null, true, true);
        Mockito.when((Object)this.repository.getRepositoryTypeManager()).thenReturn((Object)this.repoTypeManager);
        try {
            CndNodeTypeReader cndReader = new CndNodeTypeReader(this.context);
            cndReader.readBuiltInTypes();
            this.repoTypeManager.registerNodeTypes((Iterable)cndReader);
            this.repoTypeManager.registerNodeTypes(this.getTestTypes());
        }
        catch (RepositoryException re) {
            re.printStackTrace();
            throw new IllegalStateException("Could not load node type definition files", re);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IllegalStateException("Could not access node type definition files", ioe);
        }
        this.repoTypeManager.projectOnto((Graph)this.graph, (Path)pathFactory.create("/jcr:system/jcr:nodeTypes"));
        Path locksPath = pathFactory.createAbsolutePath(new Name[]{JcrLexicon.SYSTEM, ModeShapeLexicon.LOCKS});
        this.workspaceLockManager = new WorkspaceLockManager(this.context, this.repoLockManager, this.workspaceName, locksPath);
        Mockito.when((Object)this.repoLockManager.getLockManager(Matchers.anyString())).thenAnswer((Answer)new Answer<WorkspaceLockManager>(){

            public WorkspaceLockManager answer(InvocationOnMock invocation) throws Throwable {
                return AbstractSessionTest.this.workspaceLockManager;
            }
        });
        this.initializeOptions();
        Mockito.when((Object)this.repository.getOptions()).thenReturn(this.options);
        this.parsers = new QueryParsers(new QueryParser[]{new XPathQueryParser()});
        this.parsers = new QueryParsers(new QueryParser[]{new JcrSql2QueryParser()});
        Mockito.when((Object)this.repository.queryParsers()).thenReturn((Object)this.parsers);
        this.sessionAttributes = new HashMap<String, Object>();
        this.sessionAttributes.put("attribute1", "value1");
        MockSecurityContext mockSecurityContext = new MockSecurityContext("username", Collections.singleton("readwrite"));
        this.workspace = new JcrWorkspace(this.repository, this.workspaceName, this.context.with((SecurityContext)mockSecurityContext), this.sessionAttributes);
        this.session = (JcrSession)this.workspace.getSession();
        this.registry = this.session.getExecutionContext().getNamespaceRegistry();
        Mockito.when((Object)this.repository.getDescriptorValue("option.lifecycle.supported")).thenReturn((Object)this.value(true));
        Mockito.when((Object)this.repository.getDescriptorValue("option.retention.supported")).thenReturn((Object)this.value(true));
    }

    protected List<NodeTypeDefinition> getTestTypes() throws ConstraintViolationException {
        return Collections.emptyList();
    }

    protected void initializeContent() {
    }

    protected void initializeOptions() {
        this.options = new EnumMap<JcrRepository.Option, String>(JcrRepository.Option.class);
        this.options.put(JcrRepository.Option.PROJECT_NODE_TYPES, Boolean.FALSE.toString());
    }

    protected JcrValue value(boolean value) {
        return (JcrValue)this.session.getValueFactory().createValue(true);
    }

    protected String identifierPathFor(String pathToNode) throws Exception {
        AbstractJcrNode node = this.session.getNode(pathToNode);
        if (node.isNodeType("mix:referenceable")) {
            Assert.assertThat((Object)node.getUUID(), (Matcher)Is.is((Object)node.identifier()));
        }
        return node.identifierPath();
    }
}

