/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeExistsException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.jcr.CndNodeTypeReader;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.RepositoryNodeTypeManager;

public class CndNodeTypeRegistrationTest {
    private static final String CND_LOCATION = "/cndNodeTypeRegistration/";
    private ExecutionContext context;
    private RepositoryNodeTypeManager repoTypeManager;
    @Mock
    protected JcrRepository repository;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new ExecutionContext();
        this.context.getNamespaceRegistry().register("modetest", "http://www.modeshape.org/test/1.0");
        Mockito.when((Object)this.repository.getExecutionContext()).thenReturn((Object)this.context);
        this.repoTypeManager = new RepositoryNodeTypeManager(this.repository, null, true, true);
        try {
            CndNodeTypeReader cndReader = new CndNodeTypeReader(this.context);
            cndReader.readBuiltInTypes();
            this.repoTypeManager.registerNodeTypes((Iterable)cndReader);
        }
        catch (RepositoryException re) {
            re.printStackTrace();
            throw new IllegalStateException("Could not load node type definition files", re);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IllegalStateException("Could not access node type definition files", ioe);
        }
    }

    @Test(expected=IOException.class)
    public void shouldFailIfResourceFileCouldNotBeFoundOnClasspath() throws Exception {
        CndNodeTypeReader cndFactory = new CndNodeTypeReader(this.context);
        cndFactory.read("this/resource/file/does/not/exist");
    }

    @Test(expected=IOException.class)
    public void shouldFailIfResourceFileCouldNotBeFoundAsRelativeFile() throws Exception {
        CndNodeTypeReader cndFactory = new CndNodeTypeReader(this.context);
        cndFactory.read("/this/resource/file/does/not/exist");
    }

    @Test(expected=IOException.class)
    public void shouldFailIfResourceFileCouldNotBeFoundAsUrl() throws Exception {
        CndNodeTypeReader cndFactory = new CndNodeTypeReader(this.context);
        cndFactory.read("file://this/resource/file/does/not/exist");
    }

    @Test
    public void shouldLoadNodeTypesFromResourceFileFoundOnClasspath() throws Exception {
        CndNodeTypeReader cndFactory = new CndNodeTypeReader(this.context);
        cndFactory.read("cars.cnd");
        Assert.assertThat((Object)cndFactory.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldLoadNodeTypesFromResourceFileFoundWithRelativePathOnFileSystem() throws Exception {
        CndNodeTypeReader cndFactory = new CndNodeTypeReader(this.context);
        cndFactory.read("src/test/resources/cars.cnd");
        Assert.assertThat((Object)cndFactory.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldLoadNodeTypesFromResourceFileFoundWithAbsolutePathOnFileSystem() throws Exception {
        File file = new File("src/test/resources/cars.cnd");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        CndNodeTypeReader cndFactory = new CndNodeTypeReader(this.context);
        cndFactory.read(file.getAbsolutePath());
        Assert.assertThat((Object)cndFactory.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldLoadNodeTypesFromUrl() throws Exception {
        File file = new File("src/test/resources/cars.cnd");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        URL url = file.toURI().toURL();
        CndNodeTypeReader cndFactory = new CndNodeTypeReader(this.context);
        cndFactory.read(url.toString());
        Assert.assertThat((Object)cndFactory.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=NodeTypeExistsException.class)
    public void shouldNotAllowRedefinitionOfExistingTypes() throws Exception {
        CndNodeTypeReader cndFactory = new CndNodeTypeReader(this.context);
        cndFactory.read("/cndNodeTypeRegistration/existingType.cnd");
        this.repoTypeManager.registerNodeTypes((Iterable)cndFactory);
    }

    @Test
    public void shouldLoadMagnoliaTypes() throws Exception {
        CndNodeTypeReader cndFactory = new CndNodeTypeReader(this.context);
        cndFactory.read("/magnolia.cnd");
        this.repoTypeManager.registerNodeTypes((Iterable)cndFactory);
    }

    @Ignore
    @Test
    public void shouldRegisterValidTypes() throws Exception {
        CndNodeTypeReader cndFactory = new CndNodeTypeReader(this.context);
        cndFactory.read("/cndNodeTypeRegistration/validType.cnd");
        this.repoTypeManager.registerNodeTypes((Iterable)cndFactory);
        Name testNodeName = this.context.getValueFactories().getNameFactory().create("http://www.modeshape.org/test/1.0", "testType");
        JcrNodeType nodeType = this.repoTypeManager.getNodeType(testNodeName);
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)nodeType.getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)1));
        JcrNodeDefinition childNode = (JcrNodeDefinition)nodeType.getDeclaredChildNodeDefinitions()[0];
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"modetest:namespace"));
        Assert.assertThat((Object)childNode.getDefaultPrimaryType().getName(), (Matcher)Is.is((Object)"mode:namespace"));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes()[0].getName(), (Matcher)Is.is((Object)"mode:namespace"));
        Assert.assertThat((Object)childNode.allowsSameNameSiblings(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)1));
        JcrPropertyDefinition property = (JcrPropertyDefinition)nodeType.getDeclaredPropertyDefinitions()[0];
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)property.getRequiredType(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)property.getValueConstraints().length, (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)property.getValueConstraints()[0], (Matcher)Is.is((Object)"foo"));
        Assert.assertThat((Object)property.getValueConstraints()[1], (Matcher)Is.is((Object)"bar"));
        Assert.assertThat((Object)property.getValueConstraints()[2], (Matcher)Is.is((Object)"baz"));
        Assert.assertThat((Object)property.getDefaultValues().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)property.getDefaultValues()[0].getString(), (Matcher)Is.is((Object)"foo"));
    }
}

