/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.MockSecurityContext;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.observe.MockObservable;
import org.modeshape.graph.observe.Observable;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.CndNodeTypeReader;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSecurityContextCredentials;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrTools;

public class ImportExportTest {
    private static final String BAD_CHARACTER_STRING = "Test & <Test>*";
    private InMemoryRepositorySource source;
    private JcrSession session;
    private JcrRepository repository;
    private JcrTools tools;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.tools = new JcrTools();
        String workspaceName = "workspace1";
        this.source = new InMemoryRepositorySource();
        this.source.setName(workspaceName);
        this.source.setDefaultWorkspaceName(workspaceName);
        ExecutionContext context = new ExecutionContext();
        context.getNamespaceRegistry().register("modetest", "http://www.modeshape.org/test/1.0");
        RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                return ImportExportTest.this.source.getConnection();
            }
        };
        this.repository = new JcrRepository(context, connectionFactory, "unused", (Observable)new MockObservable(), null, null, null, null);
        MockSecurityContext mockSecurityContext = new MockSecurityContext("testuser", Collections.singleton("admin"));
        this.session = (JcrSession)this.repository.login((Credentials)new JcrSecurityContextCredentials((SecurityContext)mockSecurityContext));
    }

    @After
    public void after() throws Exception {
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
        }
    }

    private void testImportExport(String sourcePath, String targetPath, ExportType useSystemView, boolean skipBinary, boolean noRecurse, boolean useWorkspace) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (useSystemView == ExportType.SYSTEM) {
            this.session.exportSystemView(sourcePath, (OutputStream)baos, skipBinary, noRecurse);
        } else {
            this.session.exportDocumentView(sourcePath, (OutputStream)baos, skipBinary, noRecurse);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        if (useWorkspace) {
            this.session.getWorkspace().importXML(targetPath, (InputStream)bais, 0);
        } else {
            this.session.importXML(targetPath, (InputStream)bais, 0);
        }
    }

    @Test
    public void shouldImportExportEscapedXmlCharactersInSystemViewUsingSession() throws Exception {
        String testName = "importExportEscapedXmlCharacters";
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node sourceNode = rootNode.addNode(testName + "Source", "nt:unstructured");
        Node targetNode = rootNode.addNode(testName + "Target", "nt:unstructured");
        sourceNode.setProperty("badcharacters", BAD_CHARACTER_STRING);
        Assert.assertThat((Object)sourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
        sourceNode.addNode(BAD_CHARACTER_STRING);
        this.testImportExport(sourceNode.getPath(), targetNode.getPath(), ExportType.SYSTEM, false, false, false);
        Node newSourceNode = targetNode.getNode(testName + "Source");
        newSourceNode.getNode(BAD_CHARACTER_STRING);
        Assert.assertThat((Object)newSourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
    }

    @Test
    public void shouldImportExportEscapedXmlCharactersInSystemViewUsingWorkspace() throws Exception {
        String testName = "importExportEscapedXmlCharacters";
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node sourceNode = rootNode.addNode(testName + "Source", "nt:unstructured");
        Node targetNode = rootNode.addNode(testName + "Target", "nt:unstructured");
        sourceNode.setProperty("badcharacters", BAD_CHARACTER_STRING);
        Assert.assertThat((Object)sourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
        sourceNode.addNode(BAD_CHARACTER_STRING);
        this.session.save();
        this.testImportExport(sourceNode.getPath(), targetNode.getPath(), ExportType.SYSTEM, false, false, true);
        Node newSourceNode = targetNode.getNode(testName + "Source");
        newSourceNode.getNode(BAD_CHARACTER_STRING);
        Assert.assertThat((Object)newSourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
    }

    @Ignore(value="JR TCK is broken")
    @Test
    public void shouldImportExportEscapedXmlCharactersInDocumentViewUsingSession() throws Exception {
        String testName = "importExportEscapedXmlCharacters";
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node sourceNode = rootNode.addNode(testName + "Source", "nt:unstructured");
        Node targetNode = rootNode.addNode(testName + "Target", "nt:unstructured");
        sourceNode.setProperty("badcharacters", BAD_CHARACTER_STRING);
        Assert.assertThat((Object)sourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
        sourceNode.addNode(BAD_CHARACTER_STRING);
        this.testImportExport(sourceNode.getPath(), targetNode.getPath(), ExportType.DOCUMENT, false, false, false);
        Node newSourceNode = targetNode.getNode(testName + "Source");
        newSourceNode.getNode(BAD_CHARACTER_STRING);
        Assert.assertThat((Object)newSourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importFile(String importIntoPath, String resourceName, int importBehavior) throws Exception {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        Assert.assertThat((Object)stream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        try {
            this.session.importXML(importIntoPath, stream, importBehavior);
        }
        finally {
            stream.close();
        }
    }

    protected Node assertNode(String path) throws Exception {
        AbstractJcrNode node = this.session.getNode(path);
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        return node;
    }

    protected void assertNoNode(String path) throws Exception {
        try {
            this.session.getNode(path);
            Assert.fail((String)("Did not expect to find node at \"" + path + "\""));
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void shouldImportSystemViewWithUuidsAfterNodesWithSameUuidsAreDeletedInSessionAndSaved() throws Exception {
        CndNodeTypeReader reader = new CndNodeTypeReader((Session)this.session);
        reader.read("cars.cnd");
        this.session.getWorkspace().getNodeTypeManager().registerNodeTypes(reader.getNodeTypeDefinitions(), true);
        this.session.getRootNode().addNode("/someNode");
        this.session.save();
        this.importFile("/someNode", "io/cars-system-view-with-uuids.xml", 3);
        this.session.save();
        Node cars = this.assertNode("/someNode/Cars");
        Assert.assertThat((Object)cars.getIdentifier(), (Matcher)Is.is((Object)"e41075cb-a09a-4910-87b1-90ce8b4ca9dd"));
        this.assertNoNode("/someNode/Cars[2]");
        this.assertNoNode("/someNode[2]");
        cars.remove();
        this.session.save();
        this.importFile("/someNode", "io/cars-system-view-with-uuids.xml", 3);
        this.session.save();
        cars = this.assertNode("/someNode/Cars");
        Assert.assertThat((Object)cars.getIdentifier(), (Matcher)Is.is((Object)"e41075cb-a09a-4910-87b1-90ce8b4ca9dd"));
        this.assertNoNode("/someNode/Cars[2]");
        this.assertNoNode("/someNode[2]");
    }

    @Test
    public void shouldImportSystemViewWithUuidsAfterNodesWithSameUuidsAreDeletedInSessionButNotSaved() throws Exception {
        CndNodeTypeReader reader = new CndNodeTypeReader((Session)this.session);
        reader.read("cars.cnd");
        this.session.getWorkspace().getNodeTypeManager().registerNodeTypes(reader.getNodeTypeDefinitions(), true);
        this.session.getRootNode().addNode("/someNode");
        this.session.save();
        this.importFile("/someNode", "io/cars-system-view-with-uuids.xml", 3);
        this.session.save();
        Node cars = this.assertNode("/someNode/Cars");
        Assert.assertThat((Object)cars.getIdentifier(), (Matcher)Is.is((Object)"e41075cb-a09a-4910-87b1-90ce8b4ca9dd"));
        this.assertNoNode("/someNode/Cars[2]");
        this.assertNoNode("/someNode[2]");
        cars.remove();
        this.importFile("/someNode", "io/cars-system-view-with-uuids.xml", 3);
        this.session.save();
        cars = this.assertNode("/someNode/Cars");
        Assert.assertThat((Object)cars.getIdentifier(), (Matcher)Is.is((Object)"e41075cb-a09a-4910-87b1-90ce8b4ca9dd"));
        this.assertNoNode("/someNode/Cars[2]");
        this.assertNoNode("/someNode[2]");
    }

    @Test
    public void shouldImportSystemViewWithUuidsIntoDifferentSpotAfterNodesWithSameUuidsAreDeletedInSessionButNotSaved() throws Exception {
        CndNodeTypeReader reader = new CndNodeTypeReader((Session)this.session);
        reader.read("cars.cnd");
        this.session.getWorkspace().getNodeTypeManager().registerNodeTypes(reader.getNodeTypeDefinitions(), true);
        Node someNode = this.session.getRootNode().addNode("/someNode");
        this.session.getRootNode().addNode("/otherNode");
        this.session.save();
        this.importFile("/someNode", "io/cars-system-view-with-uuids.xml", 3);
        this.session.save();
        Node cars = this.assertNode("/someNode/Cars");
        Assert.assertThat((Object)cars.getIdentifier(), (Matcher)Is.is((Object)"e41075cb-a09a-4910-87b1-90ce8b4ca9dd"));
        this.assertNoNode("/someNode/Cars[2]");
        this.assertNoNode("/someNode[2]");
        cars.remove();
        Node newCars = someNode.addNode("Cars");
        Assert.assertThat((Object)newCars.getIdentifier(), (Matcher)Is.is((Matcher)IsNot.not((Object)"e41075cb-a09a-4910-87b1-90ce8b4ca9dd")));
        this.importFile("/otherNode", "io/cars-system-view-with-uuids.xml", 3);
        this.session.save();
        cars = this.assertNode("/otherNode/Cars");
        Assert.assertThat((Object)cars.getIdentifier(), (Matcher)Is.is((Object)"e41075cb-a09a-4910-87b1-90ce8b4ca9dd"));
        this.assertNoNode("/sameNode/Cars[2]");
        this.assertNoNode("/sameNode[2]");
        this.assertNoNode("/otherNode/Cars[2]");
        this.assertNoNode("/otherNode[2]");
    }

    private static enum ExportType {
        SYSTEM,
        DOCUMENT;

    }
}

