/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.nodetype.NodeTypeManager;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.jboss.security.config.IDTrustConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.IsNodeWithChildren;
import org.modeshape.graph.IsNodeWithProperty;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.cache.ImmutableCachePolicy;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.mimetype.ExtensionBasedMimeTypeDetector;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.repository.ModeShapeLexicon;

public class JcrConfigurationTest {
    private JcrConfiguration configuration;
    private JcrEngine engine;

    @Before
    public void beforeEach() {
        this.configuration = new JcrConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.engine != null) {
            try {
                this.engine.shutdown();
                this.engine.awaitTermination(3L, TimeUnit.SECONDS);
            }
            finally {
                this.engine = null;
            }
        }
    }

    protected ExecutionContext context() {
        return this.configuration.getConfigurationDefinition().getContext();
    }

    protected Path path(String path) {
        return (Path)this.context().getValueFactories().getPathFactory().create(path);
    }

    protected Path.Segment segment(String segment) {
        return this.context().getValueFactories().getPathFactory().createSegment(segment);
    }

    @Test
    public void shouldAllowCreatingWithNoArguments() {
        this.configuration = new JcrConfiguration();
    }

    @Test
    public void shouldAllowCreatingWithSpecifiedExecutionContext() {
        ExecutionContext newContext = new ExecutionContext();
        this.configuration = new JcrConfiguration(newContext);
        Assert.assertThat((Object)this.configuration.getConfigurationDefinition().getContext(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)newContext)));
    }

    @Test
    public void shouldHaveDefaultConfigurationSourceIfNotSpecified() {
        Assert.assertThat((Object)this.configuration.getConfigurationDefinition(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldAllowAddingRepositorySourceInstance() {
        UUID rootUuid = UUID.randomUUID();
        ImmutableCachePolicy cachePolicy = new ImmutableCachePolicy(100L);
        ((JcrConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("name").usingClass(InMemoryRepositorySource.class)).setRetryLimit(100).setProperty("defaultCachePolicy", (Object)cachePolicy)).setProperty("defaultWorkspaceName", "default workspace name")).setProperty("rootNodeUuid", (Object)rootUuid)).and()).save();
        ModeShapeConfiguration.ConfigurationDefinition content = this.configuration.getConfigurationDefinition();
        Subgraph subgraph = (Subgraph)content.graph().getSubgraphOfDepth(3).at("/");
        Assert.assertThat((Object)subgraph.getNode("/mode:sources"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/name"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/name"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.RETRY_LIMIT, (Object[])new Object[]{100}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/name"), (Matcher)IsNodeWithProperty.hasProperty((String)"defaultCachePolicy", (Object[])new Object[]{cachePolicy}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/name"), (Matcher)IsNodeWithProperty.hasProperty((String)"defaultWorkspaceName", (Object[])new Object[]{"default workspace name"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/name"), (Matcher)IsNodeWithProperty.hasProperty((String)"rootNodeUuid", (Object[])new Object[]{rootUuid}));
    }

    @Test
    public void shouldAllowSettingUpConfigurationRepositoryWithDifferentConfigurationSourceName() throws Exception {
        ((JcrConfiguration)((JcrConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("Source2").usingClass(InMemoryRepositorySource.class.getName()).loadedFromClasspath()).setDescription("description")).and()).repository("JCR Repository").setSource("Source2").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "test").and()).save();
        this.engine = this.configuration.build();
        this.engine.start();
        RepositorySource configReposSource = this.engine.getRepositoryService().getRepositoryLibrary().getSource("ModeShape Configuration Repository");
        Assert.assertThat((Object)configReposSource, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)configReposSource, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InMemoryRepositorySource.class)));
        Assert.assertThat((Object)configReposSource.getName(), (Matcher)Is.is((Object)"ModeShape Configuration Repository"));
        InMemoryRepositorySource configSource = (InMemoryRepositorySource)configReposSource;
        Assert.assertThat((Object)configSource.getDefaultWorkspaceName(), (Matcher)Is.is((Object)""));
        Graph graph = this.engine.getGraph("ModeShape Configuration Repository");
        Assert.assertThat((Object)graph, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)graph.getNodeAt("/"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)graph.getNodeAt("/mode:sources"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)graph.getNodeAt("/mode:sources/Source2"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.DESCRIPTION, (Object[])new Object[]{"description"}));
        Assert.assertThat((Object)graph.getNodeAt("/mode:repositories/JCR Repository"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.SOURCE_NAME, (Object[])new Object[]{"Source2"}));
        JcrRepository repository = this.engine.getRepository("JCR Repository");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldAllowSettingUpConfigurationRepositoryWithDifferentWorkspaceName() throws Exception {
        InMemoryRepositorySource configSource = new InMemoryRepositorySource();
        configSource.setName("config2");
        configSource.setRetryLimit(5);
        this.configuration.loadFrom((RepositorySource)configSource, "workspaceXYZ");
        ((JcrConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("Source2").usingClass(InMemoryRepositorySource.class.getName()).loadedFromClasspath()).setDescription("description")).and()).repository("JCR Repository").setSource("Source2").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "test");
        this.configuration.save();
        this.engine = this.configuration.build();
        this.engine.start();
        ModeShapeConfiguration.ConfigurationDefinition configDefn = this.configuration.getConfigurationDefinition();
        Assert.assertThat((Object)configDefn.getWorkspace(), (Matcher)Is.is((Object)"workspaceXYZ"));
        Assert.assertThat((Object)configDefn.getPath(), (Matcher)Is.is((Object)this.path("/")));
        RepositorySource configReposSource = this.engine.getRepositoryService().getRepositoryLibrary().getSource("config2");
        Assert.assertThat((Object)configReposSource, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)configReposSource, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InMemoryRepositorySource.class)));
        Assert.assertThat((Object)configReposSource.getName(), (Matcher)Is.is((Object)"config2"));
        InMemoryRepositorySource configSource2 = (InMemoryRepositorySource)configReposSource;
        Assert.assertThat((Object)configSource2.getDefaultWorkspaceName(), (Matcher)Is.is((Object)""));
        Graph graph = this.engine.getGraph("config2");
        Assert.assertThat((Object)graph, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)graph.getNodeAt("/"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)graph.getNodeAt("/mode:sources"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)graph.getNodeAt("/mode:sources/Source2"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.DESCRIPTION, (Object[])new Object[]{"description"}));
        Assert.assertThat((Object)graph.getNodeAt("/mode:repositories/JCR Repository"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.SOURCE_NAME, (Object[])new Object[]{"Source2"}));
        JcrRepository repository = this.engine.getRepository("JCR Repository");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldAllowSpecifyingOptions() throws Exception {
        ((JcrConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("Source2").usingClass(InMemoryRepositorySource.class.getName()).loadedFromClasspath()).setDescription("description")).and()).repository("JCR Repository").setSource("Source2").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "test");
        this.engine = this.configuration.build();
        this.engine.start();
        Graph config = this.engine.getGraph("ModeShape Configuration Repository");
        Subgraph subgraph = (Subgraph)config.getSubgraphOfDepth(6).at("/");
        Assert.assertThat((Object)subgraph.getNode("/mode:sources"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source2"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source2"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{InMemoryRepositorySource.class.getName()}));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories/JCR Repository"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories/JCR Repository"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.SOURCE_NAME, (Object[])new Object[]{"Source2"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories/JCR Repository/mode:options"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories/JCR Repository/mode:options/JAAS_LOGIN_CONFIG_NAME"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.VALUE, (Object[])new Object[]{"test"}));
        JcrRepository repository = this.engine.getRepository("JCR Repository");
        HashMap<JcrRepository.Option, String> options = new HashMap<JcrRepository.Option, String>();
        options.put(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "test");
        options.put(JcrRepository.Option.PROJECT_NODE_TYPES, JcrRepository.DefaultOption.PROJECT_NODE_TYPES);
        options.put(JcrRepository.Option.READ_DEPTH, "1");
        options.put(JcrRepository.Option.INDEX_READ_DEPTH, "4");
        options.put(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        options.put(JcrRepository.Option.TABLES_INCLUDE_COLUMNS_FOR_INHERITED_PROPERTIES, JcrRepository.DefaultOption.TABLES_INCLUDE_COLUMNS_FOR_INHERITED_PROPERTIES);
        options.put(JcrRepository.Option.QUERY_EXECUTION_ENABLED, JcrRepository.DefaultOption.QUERY_EXECUTION_ENABLED);
        options.put(JcrRepository.Option.QUERY_INDEX_DIRECTORY, JcrRepository.DefaultOption.QUERY_INDEX_DIRECTORY);
        options.put(JcrRepository.Option.QUERY_INDEXES_UPDATED_SYNCHRONOUSLY, JcrRepository.DefaultOption.QUERY_INDEXES_UPDATED_SYNCHRONOUSLY);
        options.put(JcrRepository.Option.PERFORM_REFERENTIAL_INTEGRITY_CHECKS, JcrRepository.DefaultOption.PERFORM_REFERENTIAL_INTEGRITY_CHECKS);
        options.put(JcrRepository.Option.EXPOSE_WORKSPACE_NAMES_IN_DESCRIPTOR, JcrRepository.DefaultOption.EXPOSE_WORKSPACE_NAMES_IN_DESCRIPTOR);
        options.put(JcrRepository.Option.VERSION_HISTORY_STRUCTURE, "hierarchical");
        options.put(JcrRepository.Option.REPOSITORY_JNDI_LOCATION, "");
        String defaultRemoveDerivedValue = JcrRepository.DefaultOption.REMOVE_DERIVED_CONTENT_WITH_ORIGINAL;
        if (this.engine.getSequencingService().getSequencers().isEmpty()) {
            defaultRemoveDerivedValue = Boolean.FALSE.toString();
        }
        options.put(JcrRepository.Option.REMOVE_DERIVED_CONTENT_WITH_ORIGINAL, defaultRemoveDerivedValue);
        Assert.assertThat((Object)repository.getOptions(), (Matcher)Is.is(options));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLoadConfigurationFromFilePath() throws Exception {
        File file = new File("src/test/resources/config/configRepository.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom("src/test/resources/config/configRepository.xml");
        Assert.assertThat((Object)this.configuration.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
        ModeShapeConfiguration.ConfigurationDefinition content = this.configuration.getConfigurationDefinition();
        Subgraph subgraph = (Subgraph)content.graph().getSubgraphOfDepth(6).at("/");
        Assert.assertThat((Object)subgraph.getNode("/mode:sources"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Cars"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Cars"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.RETRY_LIMIT, (Object[])new Object[]{"3"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Cars"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{InMemoryRepositorySource.class.getName()}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Aircraft"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Aircraft"), (Matcher)IsNodeWithProperty.hasProperty((String)"defaultWorkspaceName", (Object[])new Object[]{"default"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Aircraft"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{InMemoryRepositorySource.class.getName()}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Cache"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Cache"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{InMemoryRepositorySource.class.getName()}));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/mode:mimeTypeDetectors")).getChildren(), (Matcher)IsNodeWithChildren.hasChild((Path.Segment)this.segment("Detector")));
        Assert.assertThat((Object)subgraph.getNode("/mode:mimeTypeDetectors/Detector"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:mimeTypeDetectors/Detector"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.DESCRIPTION, (Object[])new Object[]{"Standard extension-based MIME type detector"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:mimeTypeDetectors/Detector"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{ExtensionBasedMimeTypeDetector.class.getName()}));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/mode:repositories")).getChildren(), (Matcher)IsNodeWithChildren.hasChild((Path.Segment)this.segment("Car Repository")));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories/Car Repository"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories/Car Repository"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.SOURCE_NAME, (Object[])new Object[]{"Cars"}));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/mode:repositories/Car Repository")).getChildren(), (Matcher)IsNodeWithChildren.hasChild((Path.Segment)this.segment("mode:options")));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories/Car Repository/mode:options"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/mode:repositories/Car Repository/mode:options")).getChildren(), (Matcher)IsNodeWithChildren.hasChild((Path.Segment)this.segment("jaasLoginConfigName")));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories/Car Repository/mode:options/jaasLoginConfigName"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories/Car Repository/mode:descriptors/query.xpath.doc.order"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories/Car Repository/mode:descriptors/myDescriptor"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        String configFile = "security/jaas.conf.xml";
        IDTrustConfiguration idtrustConfig = new IDTrustConfiguration();
        try {
            idtrustConfig.config(configFile);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        this.engine = this.configuration.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("Car Repository");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)repository.getDescriptor("query.xpath.doc.order"), (Matcher)Is.is((Object)"false"));
        Assert.assertThat((Object)repository.getDescriptor("myDescriptor"), (Matcher)Is.is((Object)"foo"));
        Session session = null;
        try {
            session = repository.login((Credentials)new SimpleCredentials("superuser", "superuser".toCharArray()));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAddNodeTypesAndNamespaces() throws Exception {
        File file = new File("src/test/resources/config/configRepository.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom("src/test/resources/config/configRepository.xml");
        Assert.assertThat((Object)this.configuration.repository("Car Repository").getSource(), (Matcher)Is.is((Object)"Cars"));
        InputStream nodeTypes = this.getClass().getResourceAsStream("/tck/tck_test_types.cnd");
        this.configuration.repository("Car Repository").addNodeTypes(nodeTypes);
        this.configuration.save();
        Assert.assertThat((Object)this.configuration.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.configuration.getConfigurationDefinition().getContext().getNamespaceRegistry().isRegisteredNamespaceUri("http://www.modeshape.org/test/1.0"), (Matcher)Is.is((Object)true));
        ModeShapeConfiguration.ConfigurationDefinition content = this.configuration.getConfigurationDefinition();
        Subgraph subgraph = (Subgraph)content.graph().getSubgraphOfDepth(6).at("/");
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/mode:repositories")).getChildren(), (Matcher)IsNodeWithChildren.hasChild((Path.Segment)this.segment("Car Repository")));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories/Car Repository"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories/Car Repository"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.SOURCE_NAME, (Object[])new Object[]{"Cars"}));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/mode:repositories/Car Repository")).getChildren(), (Matcher)IsNodeWithChildren.hasChild((Path.Segment)this.segment("mode:options")));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories/Car Repository/jcr:nodeTypes"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/mode:repositories/Car Repository/jcr:nodeTypes")).getChildren(), (Matcher)IsNodeWithChildren.hasChildren((Path.Segment[])new Path.Segment[]{this.segment("modetest:noSameNameSibs"), this.segment("modetest:referenceableUnstructured"), this.segment("modetest:nodeWithMandatoryProperty"), this.segment("modetest:nodeWithMandatoryChild"), this.segment("modetest:unorderableUnstructured")}));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories/Car Repository/mode:namespaces"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/mode:repositories/Car Repository/mode:namespaces")).getChildren(), (Matcher)IsNodeWithChildren.hasChild((Path.Segment)this.segment("modetest")));
        Assert.assertThat((Object)subgraph.getNode("/mode:repositories/Car Repository/mode:namespaces/modetest"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.URI, (Object[])new Object[]{"http://www.modeshape.org/test/1.0"}));
        String configFile = "security/jaas.conf.xml";
        IDTrustConfiguration idtrustConfig = new IDTrustConfiguration();
        try {
            idtrustConfig.config(configFile);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        this.engine = this.configuration.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("Car Repository");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Session session = null;
        try {
            session = repository.login((Credentials)new SimpleCredentials("superuser", "superuser".toCharArray()));
            Assert.assertThat((Object)session.getNamespacePrefix("http://www.modeshape.org/test/1.0"), (Matcher)Is.is((Object)"modetest"));
            NodeTypeManager ntm = session.getWorkspace().getNodeTypeManager();
            Assert.assertThat((Object)ntm.getNodeType("modetest:noSameNameSibs"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)ntm.getNodeType("modetest:referenceableUnstructured"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)ntm.getNodeType("modetest:nodeWithMandatoryProperty"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)ntm.getNodeType("modetest:nodeWithMandatoryChild"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)ntm.getNodeType("modetest:unorderableUnstructured"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

