/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.Graph;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.jcr.AbstractSessionTest;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNodeTypeTemplate;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrPropertyDefinitionTemplate;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.TestLexicon;

public class JcrPropertyDefinitionTest
extends AbstractSessionTest {
    protected final String[] EXPECTED_BINARY_CONSTRAINTS = new String[]{"[,5)", "[10, 20)", "(30,40]", "[50,]"};
    protected final String[] EXPECTED_DATE_CONSTRAINTS = new String[]{"[,+1945-08-01T01:30:00.000Z]", "[+1975-08-01T01:30:00.000Z,)"};
    protected final String[] EXPECTED_DOUBLE_CONSTRAINTS = new String[]{"[,5.0)", "[10.1, 20.2)", "(30.3,40.4]", "[50.5,]"};
    protected final String[] EXPECTED_LONG_CONSTRAINTS = new String[]{"[,5)", "[10, 20)", "(30,40]", "[50,]"};
    protected final String[] EXPECTED_NAME_CONSTRAINTS = new String[]{"jcr:system", "modetest:constrainedType"};
    protected final String[] EXPECTED_PATH_CONSTRAINTS = new String[]{"/jcr:system/*", "b", "/a/b/c"};
    protected final String[] EXPECTED_REFERENCE_CONSTRAINTS = new String[]{"mode:root"};
    protected final String[] EXPECTED_STRING_CONSTRAINTS = new String[]{"foo", "bar*", ".*baz"};
    protected NodeTypeManager nodeTypeManager;

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.nodeTypeManager = this.workspace.getNodeTypeManager();
    }

    @Override
    protected void initializeContent() {
        this.context.getNamespaceRegistry().register("modetest", "http://www.modeshape.org/test/1.0");
        ((Graph)this.graph.create("/jcr:system").and()).create("/jcr:system/mode:namespaces");
        ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c");
        ((Graph.SetValuesTo)this.graph.set("jcr:mixinTypes").on("/a")).to(JcrMixLexicon.REFERENCEABLE);
    }

    @After
    public void after() throws Exception {
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
        }
    }

    private JcrPropertyDefinition propertyDefinitionFor(NodeType nodeType, Name propertyName) {
        PropertyDefinition[] propertyDefs = nodeType.getPropertyDefinitions();
        String property = propertyName.getString(this.context.getNamespaceRegistry());
        for (int i = 0; i < propertyDefs.length; ++i) {
            if (!propertyDefs[i].getName().equals(property)) continue;
            return (JcrPropertyDefinition)propertyDefs[i];
        }
        throw new IllegalStateException("Could not find property definition name " + property + " for type " + nodeType.getName() + ".  Test setup is invalid.");
    }

    private void checkConstraints(NodeType nodeType, Name propertyName, String[] expectedConstraints) {
        PropertyDefinition[] propertyDefs = nodeType.getPropertyDefinitions();
        String property = propertyName.getString(this.context.getNamespaceRegistry());
        String[] constraints = null;
        for (int i = 0; i < propertyDefs.length; ++i) {
            if (!propertyDefs[i].getName().equals(property)) continue;
            constraints = propertyDefs[i].getValueConstraints();
            break;
        }
        if (!Arrays.equals(constraints, expectedConstraints)) {
            throw new IllegalStateException("Unexpected constraints for property: " + property);
        }
    }

    private NodeType validateTypeDefinition() throws Exception {
        NamespaceRegistry nsr = this.context.getNamespaceRegistry();
        NodeType constrainedType = this.nodeTypeManager.getNodeType(TestLexicon.CONSTRAINED_TYPE.getString(nsr));
        Assert.assertThat((Object)constrainedType, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_BINARY), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_DATE), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_DOUBLE), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_LONG), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_NAME), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_PATH), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_REFERENCE), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_STRING), (Matcher)IsNull.notNullValue());
        this.checkConstraints(constrainedType, TestLexicon.CONSTRAINED_BINARY, this.EXPECTED_BINARY_CONSTRAINTS);
        this.checkConstraints(constrainedType, TestLexicon.CONSTRAINED_DATE, this.EXPECTED_DATE_CONSTRAINTS);
        this.checkConstraints(constrainedType, TestLexicon.CONSTRAINED_DOUBLE, this.EXPECTED_DOUBLE_CONSTRAINTS);
        this.checkConstraints(constrainedType, TestLexicon.CONSTRAINED_LONG, this.EXPECTED_LONG_CONSTRAINTS);
        this.checkConstraints(constrainedType, TestLexicon.CONSTRAINED_NAME, this.EXPECTED_NAME_CONSTRAINTS);
        this.checkConstraints(constrainedType, TestLexicon.CONSTRAINED_PATH, this.EXPECTED_PATH_CONSTRAINTS);
        this.checkConstraints(constrainedType, TestLexicon.CONSTRAINED_REFERENCE, this.EXPECTED_REFERENCE_CONSTRAINTS);
        this.checkConstraints(constrainedType, TestLexicon.CONSTRAINED_STRING, this.EXPECTED_STRING_CONSTRAINTS);
        return constrainedType;
    }

    private Value valueFor(Object value, int jcrType) {
        return new JcrValue(this.session.getExecutionContext().getValueFactories(), this.session.cache(), jcrType, value);
    }

    private String stringOfLength(int length) {
        StringBuffer buff = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            buff.append(i % 10);
        }
        return buff.toString();
    }

    private boolean satisfiesConstraints(JcrPropertyDefinition property, Value[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (property.satisfiesConstraints(values[i])) continue;
            return false;
        }
        return true;
    }

    @Test
    public void shouldAllowNullValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_BINARY);
        Assert.assertThat((Object)prop.satisfiesConstraints((Value)null), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowValidBinaryValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_BINARY);
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(this.stringOfLength(0), 2)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(this.stringOfLength(4), 2)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(this.stringOfLength(10), 2)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(this.stringOfLength(19), 2)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(this.stringOfLength(31), 2)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(this.stringOfLength(40), 2)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(this.stringOfLength(50), 2)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(this.stringOfLength(99), 2)), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowValidBinaryValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_BINARY);
        Value[] values = new Value[]{this.valueFor(this.stringOfLength(4), 2), this.valueFor(this.stringOfLength(10), 2), this.valueFor(this.stringOfLength(19), 2)};
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[0]), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{this.valueFor(this.stringOfLength(0), 2)}), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, values), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotAllowInvalidBinaryValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_BINARY);
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(this.stringOfLength(5), 2)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(this.stringOfLength(9), 2)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(this.stringOfLength(20), 2)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(this.stringOfLength(30), 2)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(this.stringOfLength(41), 2)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(this.stringOfLength(49), 2)), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotAllowInvalidBinaryValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_BINARY);
        Value[] values = new Value[]{this.valueFor(this.stringOfLength(4), 2), this.valueFor(this.stringOfLength(10), 2), this.valueFor(this.stringOfLength(20), 2)};
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{this.valueFor(this.stringOfLength(9), 2)}), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, values), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowValidDateValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_DATE);
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("-1945-08-01T01:30:00.000Z", 5)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("+1945-07-31T01:30:00.000Z", 5)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("+0001-08-01T01:30:00.000Z", 5)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("+1975-08-01T01:30:00.000Z", 5)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("+1975-08-01T01:31:00.000Z", 5)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("+2009-08-01T01:30:00.000Z", 5)), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowValidDateValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_DATE);
        Value[] values = new Value[]{this.valueFor("-1945-08-01T01:30:00.000Z", 5), this.valueFor("+2009-08-01T01:30:00.000Z", 5)};
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[0]), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{this.valueFor("+1975-08-01T01:31:00.000Z", 5)}), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, values), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotAllowInvalidDateValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_DATE);
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("+1945-08-01T01:30:00.001Z", 5)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("+1975-08-01T01:29:59.999Z", 5)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("+1945-08-01T01:30:00.000-05:00", 5)), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotAllowInvalidDateValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_DATE);
        Value[] values = new Value[]{this.valueFor("-1945-08-01T01:30:00.000", 5), this.valueFor("+1945-08-01T01:30:00.000-05:00", 5)};
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{this.valueFor("+1945-08-01T01:30:00.001Z", 5)}), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, values), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowValidDoubleValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_DOUBLE);
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(Double.MIN_VALUE, 4)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(0, 4)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(0.1, 4)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(4.99, 4)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(10.1, 4)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(20.19, 4)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(30.31, 4)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(40.4, 4)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(50.5, 4)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(Double.MAX_VALUE, 4)), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowValidDoubleValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_DOUBLE);
        Value[] values = new Value[]{this.valueFor(0.1, 4), this.valueFor(20.19, 4), this.valueFor(50.5, 4)};
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[0]), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{this.valueFor(4.99, 4)}), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, values), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotAllowInvalidDoubleValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_DOUBLE);
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(5, 4)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(9.99999999, 4)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(20.2, 4)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(30.3, 4)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(40.41, 4)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(49.9, 4)), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotAllowInvalidDoubleValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_DOUBLE);
        Value[] values = new Value[]{this.valueFor(0.1, 4), this.valueFor(20.19, 4), this.valueFor(50.49, 4)};
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{this.valueFor(20.2, 4)}), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, values), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowValidLongValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_LONG);
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(Long.MIN_VALUE, 3)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(0, 3)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(0.1, 3)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(4.99, 3)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(10, 3)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(10.1, 3)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(19, 3)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(31, 3)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(40, 3)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(50, 3)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(Long.MAX_VALUE, 3)), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowValidLongValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_LONG);
        Value[] values = new Value[]{this.valueFor(0.1, 3), this.valueFor(10, 3), this.valueFor(50, 3)};
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[0]), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{this.valueFor(4.99, 3)}), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, values), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotAllowInvalidLongValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_LONG);
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(5, 3)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(9, 3)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(20, 3)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(30, 3)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(41, 3)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor(49, 3)), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotAllowInvalidLongValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_LONG);
        Value[] values = new Value[]{this.valueFor(0.1, 3), this.valueFor(10, 3), this.valueFor(49, 3)};
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{this.valueFor(30, 3)}), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, values), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowValidNameValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_NAME);
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("jcr:system", 7)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("modetest:constrainedType", 7)), (Matcher)Is.is((Object)true));
        this.session.setNamespacePrefix("newprefix", "http://www.modeshape.org/test/1.0");
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("newprefix:constrainedType", 7)), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowValidNameValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_NAME);
        Value[] values = new Value[]{this.valueFor("jcr:system", 7), this.valueFor("modetest:constrainedType", 7)};
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[0]), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{this.valueFor("jcr:system", 7)}), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, values), (Matcher)Is.is((Object)true));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotAllowInvalidNameValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_NAME);
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("system", 7)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("jcr:system2", 7)), (Matcher)Is.is((Object)false));
        this.session.setNamespacePrefix("newprefix", "http://www.modeshape.org/test/1.0");
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("modetest:constrainedType", 7)), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotAllowInvalidNameValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_NAME);
        Value[] values = new Value[]{this.valueFor("jcr:system", 7), this.valueFor("modetest:constrainedType2", 7)};
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{this.valueFor("jcr:system2", 7)}), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, values), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowValidStringValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_STRING);
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("foo", 1)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("bar", 1)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("barr", 1)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("barrrrrrrrr", 1)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("baz", 1)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("shabaz", 1)), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowValidStringValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_STRING);
        Value[] values = new Value[]{this.valueFor("foo", 1), this.valueFor("barr", 1)};
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[0]), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{this.valueFor("baz", 1)}), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, values), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotAllowInvalidStringValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_STRING);
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("", 1)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("foot", 1)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("abar", 1)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("bard", 1)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("baz!", 1)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("bazzat", 1)), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotAllowInvalidStringValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_STRING);
        Value[] values = new Value[]{this.valueFor("foo", 1), this.valueFor("bard", 1)};
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{this.valueFor("bazzat", 1)}), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, values), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowValidPathValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_PATH);
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("b", 8)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("/a/b/c", 8)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("/jcr:system/mode:namespace", 8)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("/a/b/c/", 8)), (Matcher)Is.is((Object)true));
        this.session.setNamespacePrefix("jcr2", "http://www.jcp.org/jcr/1.0");
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("/jcr2:system/mode:foo", 8)), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowValidPathValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_PATH);
        Value[] values = new Value[]{this.valueFor("b", 8), this.valueFor("/a/b/c", 8)};
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[0]), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{this.valueFor("/a/b/c", 8)}), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, values), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotAllowInvalidPathValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_PATH);
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("a", 8)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("/a/b", 8)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("/jcr:system", 8)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.satisfiesConstraints(this.valueFor("/a/b/c/d", 8)), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotAllowInvalidPathValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_PATH);
        Value[] values = new Value[]{this.valueFor("b", 8), this.valueFor("/a/b/c/d", 8)};
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{this.valueFor("/a", 8)}), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, values), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowValidReferenceValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_REFERENCE);
        Value value = this.session.getValueFactory().createValue((Node)this.session.getRootNode());
        Assert.assertThat((Object)prop.satisfiesConstraints(value), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowValidReferenceValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_REFERENCE);
        Value value = this.session.getValueFactory().createValue((Node)this.session.getRootNode());
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[0]), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{value}), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotAllowInvalidReferenceValue() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_REFERENCE);
        Value value = this.session.getValueFactory().createValue((Node)this.session.getRootNode().getNode("a"));
        Assert.assertThat((Object)prop.satisfiesConstraints(value), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotAllowInvalidReferenceValues() throws Exception {
        NodeType constrainedType = this.validateTypeDefinition();
        JcrPropertyDefinition prop = this.propertyDefinitionFor(constrainedType, TestLexicon.CONSTRAINED_REFERENCE);
        Value value = this.session.getValueFactory().createValue((Node)this.session.getRootNode().getNode("a"));
        Assert.assertThat((Object)this.satisfiesConstraints(prop, new Value[]{value}), (Matcher)Is.is((Object)false));
    }

    @Override
    protected List<NodeTypeDefinition> getTestTypes() throws ConstraintViolationException {
        JcrNodeTypeTemplate constrainedType = new JcrNodeTypeTemplate(this.context);
        constrainedType.setName("modetest:constrainedType");
        JcrPropertyDefinitionTemplate propBinary = new JcrPropertyDefinitionTemplate(this.context);
        propBinary.setName("modetest:constrainedBinary");
        propBinary.setRequiredType(2);
        propBinary.setValueConstraints(this.EXPECTED_BINARY_CONSTRAINTS);
        constrainedType.getPropertyDefinitionTemplates().add(propBinary);
        JcrPropertyDefinitionTemplate propDate = new JcrPropertyDefinitionTemplate(this.context);
        propDate.setName("modetest:constrainedDate");
        propDate.setRequiredType(5);
        propDate.setValueConstraints(this.EXPECTED_DATE_CONSTRAINTS);
        constrainedType.getPropertyDefinitionTemplates().add(propDate);
        JcrPropertyDefinitionTemplate propDouble = new JcrPropertyDefinitionTemplate(this.context);
        propDouble.setName("modetest:constrainedDouble");
        propDouble.setRequiredType(4);
        propDouble.setValueConstraints(this.EXPECTED_DOUBLE_CONSTRAINTS);
        constrainedType.getPropertyDefinitionTemplates().add(propDouble);
        JcrPropertyDefinitionTemplate propLong = new JcrPropertyDefinitionTemplate(this.context);
        propLong.setName("modetest:constrainedLong");
        propLong.setRequiredType(3);
        propLong.setValueConstraints(this.EXPECTED_LONG_CONSTRAINTS);
        constrainedType.getPropertyDefinitionTemplates().add(propLong);
        JcrPropertyDefinitionTemplate propName = new JcrPropertyDefinitionTemplate(this.context);
        propName.setName("modetest:constrainedName");
        propName.setRequiredType(7);
        propName.setValueConstraints(this.EXPECTED_NAME_CONSTRAINTS);
        constrainedType.getPropertyDefinitionTemplates().add(propName);
        JcrPropertyDefinitionTemplate propPath = new JcrPropertyDefinitionTemplate(this.context);
        propPath.setName("modetest:constrainedPath");
        propPath.setRequiredType(8);
        propPath.setValueConstraints(this.EXPECTED_PATH_CONSTRAINTS);
        constrainedType.getPropertyDefinitionTemplates().add(propPath);
        JcrPropertyDefinitionTemplate propReference = new JcrPropertyDefinitionTemplate(this.context);
        propReference.setName("modetest:constrainedReference");
        propReference.setRequiredType(9);
        propReference.setValueConstraints(this.EXPECTED_REFERENCE_CONSTRAINTS);
        constrainedType.getPropertyDefinitionTemplates().add(propReference);
        JcrPropertyDefinitionTemplate propString = new JcrPropertyDefinitionTemplate(this.context);
        propString.setName("modetest:constrainedString");
        propString.setRequiredType(1);
        propString.setValueConstraints(this.EXPECTED_STRING_CONSTRAINTS);
        constrainedType.getPropertyDefinitionTemplates().add(propString);
        return Collections.singletonList(constrainedType);
    }
}

