/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.List;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeDefinitionTemplate;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrPropertyDefinitionTemplate;

public class NodeTypeAssertion {
    public static void compareTemplateToNodeType(NodeTypeTemplate template, NodeType nodeType) {
        NodeTypeAssertion.compareNodeTypeDefinitions((NodeTypeDefinition)template, (NodeTypeDefinition)nodeType);
        PropertyDefinition[] propertyDefs = nodeType.getDeclaredPropertyDefinitions();
        List propertyTemplates = template.getPropertyDefinitionTemplates();
        NodeTypeAssertion.comparePropertyDefinitions(propertyDefs, propertyTemplates);
        NodeDefinition[] childNodeDefs = nodeType.getDeclaredChildNodeDefinitions();
        List childNodeTemplates = template.getNodeDefinitionTemplates();
        NodeTypeAssertion.compareChildNodeDefinitions(childNodeDefs, childNodeTemplates);
    }

    private static void compareNodeTypeDefinitions(NodeTypeDefinition template, NodeTypeDefinition nodeType) {
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.getName(), (Matcher)Is.is((Object)template.getName()));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypeNames().length, (Matcher)Is.is((Object)template.getDeclaredSupertypeNames().length));
        for (int i = 0; i < template.getDeclaredSupertypeNames().length; ++i) {
            Assert.assertThat((Object)template.getDeclaredSupertypeNames()[i], (Matcher)Is.is((Object)nodeType.getDeclaredSupertypeNames()[i]));
        }
        Assert.assertThat((Object)template.isMixin(), (Matcher)Is.is((Object)nodeType.isMixin()));
        Assert.assertThat((Object)template.hasOrderableChildNodes(), (Matcher)Is.is((Object)nodeType.hasOrderableChildNodes()));
        Assert.assertThat((Object)template.isQueryable(), (Matcher)Is.is((Object)nodeType.isQueryable()));
        Assert.assertThat((Object)template.isAbstract(), (Matcher)Is.is((Object)nodeType.isAbstract()));
    }

    private static void comparePropertyDefinitions(PropertyDefinition[] propertyDefs, List<PropertyDefinitionTemplate> propertyTemplates) {
        Assert.assertThat((Object)propertyDefs.length, (Matcher)Is.is((Object)propertyTemplates.size()));
        for (PropertyDefinitionTemplate pt : propertyTemplates) {
            JcrPropertyDefinitionTemplate propertyTemplate = (JcrPropertyDefinitionTemplate)pt;
            PropertyDefinition matchingDefinition = null;
            for (int i = 0; i < propertyDefs.length; ++i) {
                String ptName;
                PropertyDefinition pd = propertyDefs[i];
                String string = ptName = propertyTemplate.getName() == null ? "*" : propertyTemplate.getName();
                if (!pd.getName().equals(ptName) || pd.getRequiredType() != propertyTemplate.getRequiredType() || pd.isMultiple() != propertyTemplate.isMultiple()) continue;
                matchingDefinition = pd;
                break;
            }
            NodeTypeAssertion.comparePropertyTemplateToPropertyDefinition(propertyTemplate, (JcrPropertyDefinition)matchingDefinition);
        }
    }

    private static void compareChildNodeDefinitions(NodeDefinition[] childNodeDefs, List<NodeDefinitionTemplate> childNodeTemplates) {
        Assert.assertThat((Object)childNodeDefs.length, (Matcher)Is.is((Object)childNodeTemplates.size()));
        for (NodeDefinitionTemplate nt : childNodeTemplates) {
            JcrNodeDefinitionTemplate childNodeTemplate = (JcrNodeDefinitionTemplate)nt;
            NodeDefinition matchingDefinition = null;
            for (int i = 0; i < childNodeDefs.length; ++i) {
                boolean onlyHasBase;
                String ntName;
                NodeDefinition nd = childNodeDefs[i];
                String string = ntName = childNodeTemplate.getName() == null ? "*" : childNodeTemplate.getName();
                if (!nd.getName().equals(ntName) || nd.allowsSameNameSiblings() != childNodeTemplate.allowsSameNameSiblings()) continue;
                boolean onlyBaseTypeRequired = nd.getRequiredPrimaryTypes().length == 0 || nd.getRequiredPrimaryTypes().length == 1 && nd.getRequiredPrimaryTypes()[0].getName().equals("nt:base");
                boolean bl = onlyHasBase = childNodeTemplate.getRequiredPrimaryTypeNames().length == 0 || childNodeTemplate.getRequiredPrimaryTypeNames().length == 1 && childNodeTemplate.getRequiredPrimaryTypeNames()[0].equals("nt:base");
                if (onlyBaseTypeRequired && onlyHasBase) {
                    matchingDefinition = nd;
                    break;
                }
                if (nd.getRequiredPrimaryTypes().length != childNodeTemplate.getRequiredPrimaryTypeNames().length) continue;
                boolean matchesOnRequiredTypes = true;
                for (int j = 0; j < nd.getRequiredPrimaryTypes().length; ++j) {
                    String tempName;
                    String ndName = nd.getRequiredPrimaryTypes()[j].getName();
                    if (ndName.equals(tempName = childNodeTemplate.getRequiredPrimaryTypeNames()[j])) continue;
                    matchesOnRequiredTypes = false;
                    break;
                }
                if (!matchesOnRequiredTypes) continue;
                matchingDefinition = nd;
                break;
            }
            if (matchingDefinition == null) {
                System.out.println(childNodeTemplate);
            }
            NodeTypeAssertion.compareNodeTemplateToNodeDefinition(childNodeTemplate, (JcrNodeDefinition)matchingDefinition);
        }
    }

    private static void comparePropertyTemplateToPropertyDefinition(JcrPropertyDefinitionTemplate template, JcrPropertyDefinition definition) {
        Assert.assertThat((Object)definition, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)definition.getDeclaringNodeType(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)NodeTypeAssertion.emptyIfNull(template.getValueConstraints()), (Matcher)Is.is((Object)definition.getValueConstraints()));
        Assert.assertThat((Object)template.getOnParentVersion(), (Matcher)Is.is((Object)definition.getOnParentVersion()));
        Assert.assertThat((Object)template.getRequiredType(), (Matcher)Is.is((Object)definition.getRequiredType()));
        Assert.assertThat((Object)template.isAutoCreated(), (Matcher)Is.is((Object)definition.isAutoCreated()));
        Assert.assertThat((Object)template.isMandatory(), (Matcher)Is.is((Object)definition.isMandatory()));
        Assert.assertThat((Object)template.isMultiple(), (Matcher)Is.is((Object)definition.isMultiple()));
        Assert.assertThat((Object)template.isProtected(), (Matcher)Is.is((Object)definition.isProtected()));
        Assert.assertThat((Object)template.isFullTextSearchable(), (Matcher)Is.is((Object)definition.isFullTextSearchable()));
        Assert.assertThat((Object)template.isQueryOrderable(), (Matcher)Is.is((Object)definition.isQueryOrderable()));
        String[] tempOps = template.getAvailableQueryOperators();
        if (tempOps == null) {
            tempOps = new String[]{"jcr.operator.equal.to", "jcr.operator.greater.than", "jcr.operator.greater.than.or.equal.to", "jcr.operator.less.than", "jcr.operator.less.than.or.equal.to", "jcr.operator.like", "jcr.operator.not.equal.to"};
        }
        Assert.assertThat((Object)tempOps, (Matcher)Is.is((Object)definition.getAvailableQueryOperators()));
    }

    private static void compareNodeTemplateToNodeDefinition(JcrNodeDefinitionTemplate template, JcrNodeDefinition definition) {
        Assert.assertThat((Object)definition, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)definition.getDeclaringNodeType(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)template.getOnParentVersion(), (Matcher)Is.is((Object)definition.getOnParentVersion()));
        Assert.assertThat((Object)template.isAutoCreated(), (Matcher)Is.is((Object)definition.isAutoCreated()));
        Assert.assertThat((Object)template.isMandatory(), (Matcher)Is.is((Object)definition.isMandatory()));
        Assert.assertThat((Object)template.isProtected(), (Matcher)Is.is((Object)definition.isProtected()));
        Assert.assertThat((Object)template.getDefaultPrimaryType(), (Matcher)Is.is((Object)definition.getDefaultPrimaryType()));
        Assert.assertThat((Object)template.allowsSameNameSiblings(), (Matcher)Is.is((Object)definition.allowsSameNameSiblings()));
    }

    private static String[] emptyIfNull(String[] incoming) {
        if (incoming != null) {
            return incoming;
        }
        return new String[0];
    }
}

