/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Set;
import javax.jcr.ValueFactory;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.modeshape.common.FixFor;
import org.modeshape.common.text.TokenStream;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.query.model.And;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Comparison;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.DescendantNodeJoinCondition;
import org.modeshape.graph.query.model.Join;
import org.modeshape.graph.query.model.JoinCondition;
import org.modeshape.graph.query.model.JoinType;
import org.modeshape.graph.query.model.Literal;
import org.modeshape.graph.query.model.NamedSelector;
import org.modeshape.graph.query.model.NodePath;
import org.modeshape.graph.query.model.Not;
import org.modeshape.graph.query.model.Or;
import org.modeshape.graph.query.model.Order;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.PropertyExistence;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.Query;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.SameNodeJoinCondition;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Source;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.parse.SqlQueryParser;
import org.modeshape.jcr.query.JcrSql2QueryParser;
import org.modeshape.jcr.query.JcrTypeSystem;

public class JcrSql2QueryParserTest {
    @Mock
    private ValueFactory valueFactory;
    private JcrTypeSystem typeSystem;
    private JcrSql2QueryParser parser;
    private Query query;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        this.typeSystem = new MockJcrTypeSystem(this.valueFactory);
        this.parser = new JcrSql2QueryParser();
    }

    @Test
    public void shouldParseNominalQueries() {
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE [drools:title] LIKE 'findRulesByNameArchived1' AND PATH() LIKE '/drools:repository/drools:package_area/%' AND [drools:archive] = 'false'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE [drools:title] LIKE 'findRulesByNameArchived1' AND PATH() LIKE '/drools:repository/drools:package_area/%'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE [drools:title] LIKE 'findRulesByNameArchived2' AND PATH() LIKE '/drools:repository/drools:package_area/%' AND [drools:archive] = 'false'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE [drools:title] LIKE 'findRulesByNameArchived%' AND PATH() LIKE '/drools:repository/drools:package_area/%' AND [drools:archive] = 'false'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE [drools:title] LIKE 'findRulesByNameArchived2' AND PATH() LIKE '/drools:repository/drools:package_area/%' AND [drools:archive] = 'false'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE [drools:title] LIKE 'findRulesByNameArchived1' AND PATH() LIKE '/drools:repository/drools:package_area/%'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE [drools:title] LIKE 'findRulesByNameArchived1' AND PATH() LIKE '/drools:repository/drools:package_area/%' AND [drools:archive] = 'false'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE [drools:title] LIKE 'findRulesByNameArchived%' AND PATH() LIKE '/drools:repository/drools:package_area/%' AND [drools:archive] = 'false'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE [drools:title] LIKE 'findRulesByNameArchived%' AND PATH() LIKE '/drools:repository/drools:package_area/%'");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/testRestPost/assets[%]/%' and  ( [drools:format]='drl' OR [drools:format]='xls' )  AND [drools:archive] = 'false' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/testRestDelete/assets[%]/%' and [drools:format]='drl' AND [drools:archive] = 'false' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/testRestDelete/assets[%]/%' and [drools:archive] = 'true' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/testRestDelete/assets[%]/%' and [drools:format]='drl' AND [drools:archive] = 'false' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/testPackageSnapshot/assets[%]/%' and [drools:format]='drl' AND [drools:archive] = 'false' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/testPackageSnapshot/assets[%]/%' and [drools:format]='drl' AND [drools:archive] = 'false' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:packagesnapshot_area/testPackageSnapshot/PROD 2.0/assets[%]/%' and [drools:format]='drl' AND [drools:archive] = 'false' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/searchByFormat/assets[%]/%' and [drools:format]='xyz' AND [drools:archive] = 'false' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/searchByFormat/assets[%]/%' and [drools:format]='xyz' AND [drools:archive] = 'false' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/searchByFormat/assets[%]/%' and  ( [drools:format]='xyz' OR [drools:format]='ABC' )  AND [drools:archive] = 'false' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/globalArea/assets[%]/%' and [drools:format]='testSearchSharedAssetByFormat' AND [drools:archive] = 'false' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/org.drools.archivedtest/assets[%]/%' and [drools:archive] = 'true' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/org.drools.archivedtest/assets[%]/%' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/testExcludeAssetTypes/assets[%]/%' and not [drools:format]='drl' AND [drools:archive] = 'false' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/testExcludeAssetTypes/assets[%]/%' and not ( [drools:format]='drl' OR [drools:format]='wang' )  AND [drools:archive] = 'false' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/testExcludeAssetTypes/assets[%]/%' and not ( [drools:format]='drl' OR [drools:format]='xls' )  AND [drools:archive] = 'false' ORDER BY [drools:title]");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE [drools:title] LIKE 'findRulesByNamex1' AND PATH() LIKE '/drools:repository/drools:package_area/%' AND [drools:archive] = 'false'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE [drools:title] LIKE 'findRulesByNamex2' AND PATH() LIKE '/drools:repository/drools:package_area/%' AND [drools:archive] = 'false'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE [drools:title] LIKE 'findRulesByNamex%' AND PATH() LIKE '/drools:repository/drools:package_area/%' AND [drools:archive] = 'false'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE [drools:title] LIKE 'findRulesByNamex2' AND PATH() LIKE '/drools:repository/drools:package_area/%' AND [drools:archive] = 'false'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE [drools:title] LIKE 'findRulesByNamex%' AND PATH() LIKE '/drools:repository/drools:package_area/%' AND [drools:archive] = 'false'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/%' AND [drools:subject] LIKE 'testQueryXXX42' AND [drools:archive] = 'false'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/%' AND [drools:subject] LIKE 'testQueryXXX42' AND [drools:source] LIKE 'database'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/%' AND ([drools:subject] LIKE 'testQueryXXX42' OR [drools:subject] LIKE 'wankle') AND ([drools:source] LIKE 'database' OR [drools:source] LIKE 'wankle') AND [drools:archive] = 'false'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/%' AND ([drools:source] LIKE 'database' OR [drools:source] LIKE 'wankle') AND [drools:archive] = 'false'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/%' AND ([drools:subject] LIKE 'testQueryXXX42' OR [drools:subject] LIKE 'wankle') AND ([drools:source] LIKE 'database' OR [drools:source] LIKE 'wankle') AND [drools:archive] = 'false' AND [jcr:created] > '1974-07-10T00:00:00.000-05:00' AND [jcr:created] < '3074-07-10T00:00:00.000-05:00'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/%' AND ([drools:subject] LIKE 'testQueryXXX42' OR [drools:subject] LIKE 'wankle') AND ([drools:source] LIKE 'database' OR [drools:source] LIKE 'wankle') AND [drools:archive] = 'false' AND [jcr:created] > '1974-07-10T00:00:00.000-05:00'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/%' AND ([drools:subject] LIKE 'testQueryXXX42' OR [drools:subject] LIKE 'wankle') AND ([drools:source] LIKE 'database' OR [drools:source] LIKE 'wankle') AND [drools:archive] = 'false' AND [jcr:created] < '3074-07-10T00:00:00.000-05:00'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/%' AND ([drools:subject] LIKE 'testQueryXXX42' OR [drools:subject] LIKE 'wankle') AND ([drools:source] LIKE 'database' OR [drools:source] LIKE 'wankle') AND [drools:archive] = 'false' AND [jcr:created] > '3074-07-10T00:00:00.000-05:00'");
        this.parse("SELECT [drools:title], [drools:description], [drools:archive] FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/%' AND ([drools:subject] LIKE 'testQueryXXX42' OR [drools:subject] LIKE 'wankle') AND ([drools:source] LIKE 'database' OR [drools:source] LIKE 'wankle') AND [drools:archive] = 'false' AND [jcr:created] < '1974-07-10T00:00:00.000-05:00'");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/globalArea/assets[%]/%' and [drools:format]='xyz' AND [drools:archive] = 'false' ORDER BY [drools:title]");
        this.parse("SELECT * FROM [drools:assetNodeType] WHERE PATH() LIKE '/drools:repository/drools:package_area/globalArea/assets[%]/%' and [drools:format]='xyz' AND [drools:archive] = 'false' ORDER BY [drools:title]");
        this.parse("select * from [mgnl:content] where PATH() like '/modules/%/templates'");
    }

    @Test
    public void shouldParseQueriesUsedInJcrTckTests() {
        this.parse("SELECT * FROM [nt:unstructured] JOIN [mix:referenceable] ON ISSAMENODE([nt:unstructured],[mix:referenceable]) WHERE PATH([nt:unstructured]) LIKE '/testroot/%'");
        this.parse("SELECT * FROM [nt:unstructured] JOIN [nt:base] ON ISSAMENODE([nt:base], [nt:unstructured]) WHERE PATH([nt:unstructured]) LIKE '/testroot/%'");
        this.parse("SELECT * FROM [nt:base] JOIN [mix:referenceable] ON ISSAMENODE([nt:base], [mix:referenceable]) WHERE PATH([nt:base]) LIKE '/testroot/%'");
        this.parse("SELECT * FROM [nt:unstructured] JOIN [mix:referenceable] ON ISSAMENODE([nt:unstructured], [mix:referenceable]) WHERE PATH([nt:unstructured]) LIKE '/testroot/%'");
        this.parse("SELECT prop1 FROM [nt:unstructured] WHERE prop2 IN ('two') AND prop1 = 'existence' AND PATH() LIKE '/testroot/%'");
    }

    @Test
    public void shouldParseSelectStarFromSingleSourceWithWhereContainingPathLikeConstraint() {
        this.query = this.parse("SELECT * FROM [mgnl:content] WHERE PATH() LIKE '/modules/%/templates'");
        Assert.assertThat((Object)this.query.source(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(NamedSelector.class)));
        Assert.assertThat((Object)this.query.columns().isEmpty(), (Matcher)Is.is((Object)true));
        NamedSelector selector = (NamedSelector)this.query.source();
        Assert.assertThat((Object)selector.name(), (Matcher)Is.is((Object)this.selectorName("mgnl:content")));
        Assert.assertThat((Object)selector.aliasOrName(), (Matcher)Is.is((Object)this.selectorName("mgnl:content")));
        Assert.assertThat((Object)selector.alias(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Comparison comparison = this.isComparison(this.query.constraint());
        Assert.assertThat((Object)comparison.operand1(), (Matcher)Is.is((Object)this.nodePath(this.selectorName("mgnl:content"))));
        Assert.assertThat((Object)comparison.operand2(), (Matcher)Is.is((Object)this.literal("/modules/%/templates")));
    }

    @Test
    public void shouldParseSelectStarFromSingleSourceWithWhereContainingTwoPathLikeConstraints() {
        this.query = this.parse("SELECT * FROM [mgnl:content] WHERE PATH() LIKE '/modules/%/templates' or PATH() like '/modules/%/other'");
        Assert.assertThat((Object)this.query.source(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(NamedSelector.class)));
        Assert.assertThat((Object)this.query.columns().isEmpty(), (Matcher)Is.is((Object)true));
        NamedSelector selector = (NamedSelector)this.query.source();
        Assert.assertThat((Object)selector.name(), (Matcher)Is.is((Object)this.selectorName("mgnl:content")));
        Assert.assertThat((Object)selector.aliasOrName(), (Matcher)Is.is((Object)this.selectorName("mgnl:content")));
        Assert.assertThat((Object)selector.alias(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Or and = this.isOr(this.query.constraint());
        Comparison comparison1 = this.isComparison(and.left());
        Assert.assertThat((Object)comparison1.operand1(), (Matcher)Is.is((Object)this.nodePath(this.selectorName("mgnl:content"))));
        Assert.assertThat((Object)comparison1.operand2(), (Matcher)Is.is((Object)this.literal("/modules/%/templates")));
        Comparison comparison2 = this.isComparison(and.right());
        Assert.assertThat((Object)comparison2.operand1(), (Matcher)Is.is((Object)this.nodePath(this.selectorName("mgnl:content"))));
        Assert.assertThat((Object)comparison2.operand2(), (Matcher)Is.is((Object)this.literal("/modules/%/other")));
    }

    @Test
    public void shouldParseSelectStarFromTwoJoinedSourcesWithWhereContainingJoinCriteria() {
        this.query = this.parse("SELECT * FROM [mgnl:content] JOIN [acme:stuff] ON ISSAMENODE([mgnl:content],[acme:stuff])");
        Assert.assertThat((Object)this.query.columns().isEmpty(), (Matcher)Is.is((Object)true));
        Join join = this.isJoin(this.query.source());
        Assert.assertThat((Object)join.left(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("mgnl:content"))));
        Assert.assertThat((Object)join.right(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("acme:stuff"))));
        Assert.assertThat((Object)join.type(), (Matcher)Is.is((Object)JoinType.INNER));
        SameNodeJoinCondition joinCondition = this.isSameNodeJoinCondition(join.joinCondition());
        Assert.assertThat((Object)joinCondition.selector1Name(), (Matcher)Is.is((Object)this.selectorName("mgnl:content")));
        Assert.assertThat((Object)joinCondition.selector2Name(), (Matcher)Is.is((Object)this.selectorName("acme:stuff")));
        Assert.assertThat((Object)joinCondition.selector2Path(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.query.constraint(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseSelectStarFromThreeJoinedSourcesWithWhereContainingJoinCriteria() {
        this.query = this.parse("SELECT * FROM [mgnl:content] JOIN [acme:stuff] ON ISSAMENODE([mgnl:content],[acme:stuff]) JOIN [foo:bar] ON ISSAMENODE([mgnl:content],[foo:bar])");
        Assert.assertThat((Object)this.query.columns().isEmpty(), (Matcher)Is.is((Object)true));
        Join join = this.isJoin(this.query.source());
        Join join2 = this.isJoin(join.left());
        Assert.assertThat((Object)join2.left(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("mgnl:content"))));
        Assert.assertThat((Object)join2.right(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("acme:stuff"))));
        Assert.assertThat((Object)join2.type(), (Matcher)Is.is((Object)JoinType.INNER));
        SameNodeJoinCondition joinCondition2 = this.isSameNodeJoinCondition(join2.joinCondition());
        Assert.assertThat((Object)joinCondition2.selector1Name(), (Matcher)Is.is((Object)this.selectorName("mgnl:content")));
        Assert.assertThat((Object)joinCondition2.selector2Name(), (Matcher)Is.is((Object)this.selectorName("acme:stuff")));
        Assert.assertThat((Object)joinCondition2.selector2Path(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)join.right(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("foo:bar"))));
        Assert.assertThat((Object)join.type(), (Matcher)Is.is((Object)JoinType.INNER));
        SameNodeJoinCondition joinCondition = this.isSameNodeJoinCondition(join.joinCondition());
        Assert.assertThat((Object)joinCondition.selector1Name(), (Matcher)Is.is((Object)this.selectorName("mgnl:content")));
        Assert.assertThat((Object)joinCondition.selector2Name(), (Matcher)Is.is((Object)this.selectorName("foo:bar")));
        Assert.assertThat((Object)joinCondition.selector2Path(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.query.constraint(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseSelectStarFromEquijoinAndAdditionalCriteria() {
        this.query = this.parse("SELECT * FROM [modetest:queryable] JOIN [mix:referenceable] ON ISSAMENODE([modetest:queryable],[mix:referenceable]) WHERE PATH([modetest:queryable]) LIKE '/testroot/someQueryableNodeD/%'");
        Assert.assertThat((Object)this.query.columns().isEmpty(), (Matcher)Is.is((Object)true));
        Join join = this.isJoin(this.query.source());
        Assert.assertThat((Object)join.left(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("modetest:queryable"))));
        Assert.assertThat((Object)join.right(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("mix:referenceable"))));
        Assert.assertThat((Object)join.type(), (Matcher)Is.is((Object)JoinType.INNER));
        SameNodeJoinCondition joinCondition = this.isSameNodeJoinCondition(join.joinCondition());
        Assert.assertThat((Object)joinCondition.selector1Name(), (Matcher)Is.is((Object)this.selectorName("modetest:queryable")));
        Assert.assertThat((Object)joinCondition.selector2Name(), (Matcher)Is.is((Object)this.selectorName("mix:referenceable")));
        Assert.assertThat((Object)joinCondition.selector2Path(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Comparison comparison = this.isComparison(this.query.constraint());
        Assert.assertThat((Object)comparison.operand1(), (Matcher)Is.is((Object)this.nodePath(this.selectorName("modetest:queryable"))));
        Assert.assertThat((Object)comparison.operand2(), (Matcher)Is.is((Object)this.literal("/testroot/someQueryableNodeD/%")));
    }

    @Test
    public void shouldParseSelectWithOrderByClause() {
        this.query = this.parse("SELECT [car:model] FROM [car:Car] WHERE [car:model] IS NOT NULL ORDER BY [car:model] ASC");
        Assert.assertThat((Object)this.query.columns().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((Column)this.query.columns().get(0)).selectorName(), (Matcher)Is.is((Object)this.selectorName("car:Car")));
        Assert.assertThat((Object)((Column)this.query.columns().get(0)).columnName(), (Matcher)Is.is((Object)"car:model"));
        Assert.assertThat((Object)((Column)this.query.columns().get(0)).propertyName(), (Matcher)Is.is((Object)"car:model"));
        NamedSelector selector = (NamedSelector)this.query.source();
        Assert.assertThat((Object)selector.name(), (Matcher)Is.is((Object)this.selectorName("car:Car")));
        Assert.assertThat((Object)selector.aliasOrName(), (Matcher)Is.is((Object)this.selectorName("car:Car")));
        Assert.assertThat((Object)selector.alias(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        PropertyExistence constraint = this.isPropertyExistence(this.query.constraint());
        Assert.assertThat((Object)constraint.propertyName(), (Matcher)Is.is((Object)"car:model"));
        Assert.assertThat((Object)constraint.selectorName(), (Matcher)Is.is((Object)this.selectorName("car:Car")));
        Assert.assertThat((Object)this.query.orderings().size(), (Matcher)Is.is((Object)1));
        Ordering ordering = (Ordering)this.query.orderings().get(0);
        Assert.assertThat((Object)ordering.order(), (Matcher)Is.is((Object)Order.ASCENDING));
        Assert.assertThat((Object)ordering.operand(), (Matcher)Is.is((Object)this.propertyValue(this.selectorName("car:Car"), "car:model")));
    }

    @Test
    public void shouldParseSelectWithChildAxisCriteria() {
        this.query = this.parse("SELECT * FROM [nt:base] WHERE PATH() LIKE '/a/b/%' AND NOT PATH() LIKE '/a/b/%/%'");
        Assert.assertThat((Object)this.query.columns().isEmpty(), (Matcher)Is.is((Object)true));
        NamedSelector selector = (NamedSelector)this.query.source();
        Assert.assertThat((Object)selector.name(), (Matcher)Is.is((Object)this.selectorName("nt:base")));
        Assert.assertThat((Object)selector.aliasOrName(), (Matcher)Is.is((Object)this.selectorName("nt:base")));
        Assert.assertThat((Object)selector.alias(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        And and = this.isAnd(this.query.constraint());
        Comparison comparison1 = this.isComparison(and.left());
        Assert.assertThat((Object)comparison1.operand1(), (Matcher)Is.is((Object)this.nodePath(this.selectorName("nt:base"))));
        Assert.assertThat((Object)comparison1.operand2(), (Matcher)Is.is((Object)this.literal("/a/b/%")));
        Not not = this.isNot(and.right());
        Comparison comparison2a = this.isComparison(not.constraint());
        Assert.assertThat((Object)comparison2a.operand1(), (Matcher)Is.is((Object)this.nodePath(this.selectorName("nt:base"))));
        Assert.assertThat((Object)comparison2a.operand2(), (Matcher)Is.is((Object)this.literal("/a/b/%/%")));
    }

    @Test
    public void shouldParseDescendantNodeJoinWithNoCriteria() {
        this.query = this.parse("select * from [lom:Metadata] as lom join [lom:LangString] as lang on isdescendantnode(lang,lom)");
        Assert.assertThat((Object)this.query.columns().isEmpty(), (Matcher)Is.is((Object)true));
        Join join = this.isJoin(this.query.source());
        Assert.assertThat((Object)join.left(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("lom:Metadata"), this.selectorName("lom"))));
        Assert.assertThat((Object)join.right(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("lom:LangString"), this.selectorName("lang"))));
        Assert.assertThat((Object)join.type(), (Matcher)Is.is((Object)JoinType.INNER));
        DescendantNodeJoinCondition joinCondition = this.isDescendantNodeJoinCondition(join.joinCondition());
        Assert.assertThat((Object)joinCondition.ancestorSelectorName(), (Matcher)Is.is((Object)this.selectorName("lom")));
        Assert.assertThat((Object)joinCondition.descendantSelectorName(), (Matcher)Is.is((Object)this.selectorName("lang")));
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedPathInSelect() {
        this.query = this.parse("select [jcr:primaryType], [jcr:path] FROM [nt:base]");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedNodeNameInSelect() {
        this.query = this.parse("select [jcr:primaryType], [jcr:name] FROM [nt:base]");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedNodeLocalNameInSelect() {
        this.query = this.parse("select [jcr:primaryType], [jcr:localName] FROM [nt:base]");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedNodeDepthInSelect() {
        this.query = this.parse("select [jcr:primaryType], [jcr:depth] FROM [nt:base]");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedNodeScoreInSelect() {
        this.query = this.parse("select [jcr:primaryType], [jcr:score] FROM [nt:base]");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithQualifiedPathInSelect() {
        this.query = this.parse("select [nt:base].[jcr:primaryType], [nt:base].[jcr:path] FROM [nt:base]");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithQualifiedNodeNameInSelect() {
        this.query = this.parse("select [nt:base].[jcr:primaryType], [nt:base].[jcr:name] FROM [nt:base]");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithQualifiedNodeLocalNameInSelect() {
        this.query = this.parse("select [nt:base].[jcr:primaryType], [nt:base].[jcr:localName] FROM [nt:base]");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithQualifiedNodeDepthInSelect() {
        this.query = this.parse("select [nt:base].[jcr:primaryType], [nt:base].[jcr:depth] FROM [nt:base]");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithQualifiedNodeScoreInSelect() {
        this.query = this.parse("select [nt:base].[jcr:primaryType], [nt:base].[jcr:score] FROM [nt:base]");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedPathInCriteria() {
        this.query = this.parse("select [jcr:primaryType] FROM [nt:base] WHERE [jcr:path] = '/some/path'");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedNodeNameInCriteria() {
        this.query = this.parse("select [jcr:primaryType] FROM [nt:base] WHERE [jcr:path] = 'mode:nodeName'");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedNodeLocalNameInCriteria() {
        this.query = this.parse("select [jcr:primaryType] FROM [nt:base] WHERE [jcr:localName] = 'nodeName'");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedNodeDepthInCriteria() {
        this.query = this.parse("select [jcr:primaryType] FROM [nt:base] WHERE [jcr:depth] = 2");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedNodeScoreInCriteria() {
        this.query = this.parse("select [jcr:primaryType] FROM [nt:base] WHERE [jcr:score] <= 2.0");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithQualifiedPathInCriteria() {
        this.query = this.parse("select [nt:base].[jcr:primaryType] FROM [nt:base] WHERE [nt:base].[jcr:path] = '/some/path'");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithQualifiedNodeNameInCriteria() {
        this.query = this.parse("select [nt:base].[jcr:primaryType] FROM [nt:base] WHERE [nt:base].[jcr:name] = 'mode:nodeName'");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithQualifiedNodeLocalNameInCriteria() {
        this.query = this.parse("select [nt:base].[jcr:primaryType] FROM [nt:base] WHERE [nt:base].[jcr:localName] = 'nodeName'");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithQualifiedNodeDepthInCriteria() {
        this.query = this.parse("select [nt:base].[jcr:primaryType] FROM [nt:base] WHERE [nt:base].[jcr:depth] = 3");
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithQualifiedNodeScoreInCriteria() {
        this.query = this.parse("select [nt:base].[jcr:primaryType] FROM [nt:base] WHERE [nt:base].[jcr:score] <= 1.3");
    }

    protected Join isJoin(Source source) {
        Assert.assertThat((Object)source, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Join.class)));
        return (Join)source;
    }

    protected PropertyExistence isPropertyExistence(Constraint constraint) {
        Assert.assertThat((Object)constraint, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(PropertyExistence.class)));
        return (PropertyExistence)constraint;
    }

    protected Not isNot(Constraint constraint) {
        Assert.assertThat((Object)constraint, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Not.class)));
        return (Not)constraint;
    }

    protected Comparison isComparison(Constraint constraint) {
        Assert.assertThat((Object)constraint, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Comparison.class)));
        return (Comparison)constraint;
    }

    protected SameNodeJoinCondition isSameNodeJoinCondition(JoinCondition condition) {
        Assert.assertThat((Object)condition, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(SameNodeJoinCondition.class)));
        return (SameNodeJoinCondition)condition;
    }

    protected DescendantNodeJoinCondition isDescendantNodeJoinCondition(JoinCondition condition) {
        Assert.assertThat((Object)condition, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(DescendantNodeJoinCondition.class)));
        return (DescendantNodeJoinCondition)condition;
    }

    protected And isAnd(Constraint constraint) {
        Assert.assertThat((Object)constraint, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(And.class)));
        return (And)constraint;
    }

    protected Or isOr(Constraint constraint) {
        Assert.assertThat((Object)constraint, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Or.class)));
        return (Or)constraint;
    }

    protected NodePath nodePath(SelectorName name) {
        return new NodePath(name);
    }

    protected PropertyValue propertyValue(SelectorName selectorName, String propertyName) {
        return new PropertyValue(selectorName, propertyName);
    }

    protected Literal literal(Object value) {
        return new Literal(value);
    }

    protected NamedSelector namedSelector(SelectorName selectorName) {
        return new NamedSelector(selectorName);
    }

    protected NamedSelector namedSelector(SelectorName selectorName, SelectorName alias) {
        return new NamedSelector(selectorName, alias);
    }

    protected Query parse(String query) {
        QueryCommand command = this.parseCommand(query);
        Assert.assertThat((Object)command, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Query.class)));
        return (Query)command;
    }

    protected QueryCommand parseCommand(String query) {
        return this.parser.parseQuery(query, (TypeSystem)this.typeSystem);
    }

    protected SelectorName selectorName(String name) {
        return new SelectorName(name);
    }

    protected Name name(String name) {
        return (Name)this.typeSystem.getTypeFactory(PropertyType.NAME.getName()).create(name);
    }

    protected Path path(String path) {
        return (Path)this.typeSystem.getTypeFactory(PropertyType.PATH.getName()).create(path);
    }

    protected TokenStream tokens(String content) {
        return new TokenStream(content, (TokenStream.Tokenizer)new SqlQueryParser.SqlTokenizer(false), false).start();
    }

    protected static class MockJcrTypeSystem
    implements JcrTypeSystem {
        protected final ValueFactory valueFactory;
        protected final TypeSystem delegate;
        protected final ExecutionContext executionContext = new ExecutionContext();

        protected MockJcrTypeSystem(ValueFactory valueFactory) {
            this.valueFactory = valueFactory;
            this.delegate = this.executionContext.getValueFactories().getTypeSystem();
        }

        public Set<String> getTypeNames() {
            return this.delegate.getTypeNames();
        }

        public TypeSystem.TypeFactory<?> getTypeFactory(Object prototype) {
            return this.delegate.getTypeFactory(prototype);
        }

        public TypeSystem.TypeFactory<?> getTypeFactory(String typeName) {
            return this.delegate.getTypeFactory(typeName);
        }

        public TypeSystem.TypeFactory<String> getStringFactory() {
            return this.delegate.getStringFactory();
        }

        public TypeSystem.TypeFactory<?> getReferenceFactory() {
            return this.delegate.getReferenceFactory();
        }

        public TypeSystem.TypeFactory<?> getPathFactory() {
            return this.delegate.getPathFactory();
        }

        public TypeSystem.TypeFactory<Long> getLongFactory() {
            return this.delegate.getLongFactory();
        }

        public TypeSystem.TypeFactory<Double> getDoubleFactory() {
            return this.delegate.getDoubleFactory();
        }

        public String getDefaultType() {
            return this.delegate.getDefaultType();
        }

        public Comparator<Object> getDefaultComparator() {
            return this.delegate.getDefaultComparator();
        }

        public TypeSystem.TypeFactory<BigDecimal> getDecimalFactory() {
            return this.delegate.getDecimalFactory();
        }

        public TypeSystem.TypeFactory<?> getDateTimeFactory() {
            return this.delegate.getDateTimeFactory();
        }

        public String getCompatibleType(String type1, String type2) {
            return this.delegate.getCompatibleType(type1, type2);
        }

        public TypeSystem.TypeFactory<Boolean> getBooleanFactory() {
            return this.delegate.getBooleanFactory();
        }

        public TypeSystem.TypeFactory<?> getBinaryFactory() {
            return this.delegate.getBinaryFactory();
        }

        public String asString(Object value) {
            return this.delegate.asString(value);
        }

        public ValueFactory getValueFactory() {
            return this.valueFactory;
        }
    }
}

