/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.nl;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.nl.DutchStemFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DutchAnalyzer
extends Analyzer {
    public static final String[] DUTCH_STOP_WORDS = new String[]{"de", "en", "van", "ik", "te", "dat", "die", "in", "een", "hij", "het", "niet", "zijn", "is", "was", "op", "aan", "met", "als", "voor", "had", "er", "maar", "om", "hem", "dan", "zou", "of", "wat", "mijn", "men", "dit", "zo", "door", "over", "ze", "zich", "bij", "ook", "tot", "je", "mij", "uit", "der", "daar", "haar", "naar", "heb", "hoe", "heeft", "hebben", "deze", "u", "want", "nog", "zal", "me", "zij", "nu", "ge", "geen", "omdat", "iets", "worden", "toch", "al", "waren", "veel", "meer", "doen", "toen", "moet", "ben", "zonder", "kan", "hun", "dus", "alles", "onder", "ja", "eens", "hier", "wie", "werd", "altijd", "doch", "wordt", "wezen", "kunnen", "ons", "zelf", "tegen", "na", "reeds", "wil", "kon", "niets", "uw", "iemand", "geweest", "andere"};
    private final Set<?> stoptable;
    private Set<?> excltable = Collections.emptySet();
    private Map<String, String> stemdict = new HashMap<String, String>();
    private final Version matchVersion;

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public DutchAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET);
        this.stemdict.put("fiets", "fiets");
        this.stemdict.put("bromfiets", "bromfiets");
        this.stemdict.put("ei", "eier");
        this.stemdict.put("kind", "kinder");
    }

    public DutchAnalyzer(Version matchVersion, Set<?> stopwords) {
        this(matchVersion, stopwords, CharArraySet.EMPTY_SET);
    }

    public DutchAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclusionTable) {
        this.stoptable = CharArraySet.unmodifiableSet(CharArraySet.copy(stopwords));
        this.excltable = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionTable));
        this.matchVersion = matchVersion;
        this.setOverridesTokenStreamMethod(DutchAnalyzer.class);
    }

    public DutchAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet(stopwords));
    }

    public DutchAnalyzer(Version matchVersion, HashSet<?> stopwords) {
        this(matchVersion, (Set<?>)stopwords);
    }

    public DutchAnalyzer(Version matchVersion, File stopwords) {
        this.setOverridesTokenStreamMethod(DutchAnalyzer.class);
        try {
            this.stoptable = WordlistLoader.getWordSet(stopwords);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.matchVersion = matchVersion;
    }

    public void setStemExclusionTable(String ... exclusionlist) {
        this.excltable = StopFilter.makeStopSet(exclusionlist);
        this.setPreviousTokenStream(null);
    }

    public void setStemExclusionTable(HashSet<?> exclusionlist) {
        this.excltable = exclusionlist;
        this.setPreviousTokenStream(null);
    }

    public void setStemExclusionTable(File exclusionlist) {
        try {
            this.excltable = WordlistLoader.getWordSet(exclusionlist);
            this.setPreviousTokenStream(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setStemDictionary(File stemdictFile) {
        try {
            this.stemdict = WordlistLoader.getStemDict(stemdictFile);
            this.setPreviousTokenStream(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new StandardTokenizer(this.matchVersion, reader);
        result = new StandardFilter(result);
        result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), result, this.stoptable);
        result = new DutchStemFilter(result, this.excltable, this.stemdict);
        return result;
    }

    @Override
    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new StandardTokenizer(this.matchVersion, reader);
            streams.result = new StandardFilter(streams.source);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), streams.result, this.stoptable);
            streams.result = new DutchStemFilter(streams.result, this.excltable, this.stemdict);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET = CharArraySet.unmodifiableSet(new CharArraySet(Arrays.asList(DUTCH_STOP_WORDS), false));

        private DefaultSetHolder() {
        }
    }
}

