/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query;

import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.plan.PlanHints;
import org.modeshape.graph.query.validate.Schemata;

@Immutable
public class QueryContext {
    private final TypeSystem typeSystem;
    private final PlanHints hints;
    private final Schemata schemata;
    private final Problems problems;
    private final Map<String, Object> variables;

    public QueryContext(Schemata schemata, TypeSystem typeSystem, PlanHints hints, Problems problems, Map<String, Object> variables) {
        CheckArg.isNotNull(typeSystem, "typeSystem");
        CheckArg.isNotNull(schemata, "schemata");
        this.typeSystem = typeSystem;
        this.hints = hints != null ? hints : new PlanHints();
        this.schemata = schemata;
        this.problems = problems != null ? problems : new SimpleProblems();
        Map<String, Object> map = this.variables = variables != null ? new HashMap<String, Object>(variables) : new HashMap();
        assert (this.typeSystem != null);
        assert (this.hints != null);
        assert (this.schemata != null);
        assert (this.problems != null);
        assert (this.variables != null);
    }

    public QueryContext(Schemata schemata, TypeSystem typeSystem, PlanHints hints, Problems problems) {
        this(schemata, typeSystem, hints, problems, null);
    }

    public QueryContext(Schemata schemata, TypeSystem typeSystem, PlanHints hints) {
        this(schemata, typeSystem, hints, null, null);
    }

    public QueryContext(Schemata schemata, TypeSystem typeSystem) {
        this(schemata, typeSystem, null, null, null);
    }

    protected QueryContext(QueryContext original) {
        this(original.schemata, original.typeSystem, original.hints, original.problems, original.variables);
    }

    public TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public final PlanHints getHints() {
        return this.hints;
    }

    public final Problems getProblems() {
        return this.problems;
    }

    public Schemata getSchemata() {
        return this.schemata;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QueryContext) {
            QueryContext that = (QueryContext)obj;
            if (!this.typeSystem.equals(that.getTypeSystem())) {
                return false;
            }
            if (!this.schemata.equals(that.getSchemata())) {
                return false;
            }
            return ((Object)this.variables).equals(that.getVariables());
        }
        return false;
    }

    public QueryContext with(TypeSystem typeSystem) {
        CheckArg.isNotNull(typeSystem, "typeSystem");
        return new QueryContext(this.schemata, typeSystem, this.hints, this.problems, this.variables);
    }

    public QueryContext with(Schemata schemata) {
        CheckArg.isNotNull(schemata, "schemata");
        return new QueryContext(schemata, this.typeSystem, this.hints, this.problems, this.variables);
    }

    public QueryContext with(PlanHints hints) {
        CheckArg.isNotNull(hints, "hints");
        return new QueryContext(this.schemata, this.typeSystem, hints, this.problems, this.variables);
    }

    public QueryContext with(Problems problems) {
        return new QueryContext(this.schemata, this.typeSystem, this.hints, problems, this.variables);
    }

    public QueryContext with(Map<String, Object> variables) {
        return new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems, variables);
    }
}

