/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.graph.query.model.Readable;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitable;
import org.modeshape.graph.query.model.Visitors;

@NotThreadSafe
public final class PlanNode
implements Iterable<PlanNode>,
Readable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Type type;
    private PlanNode parent;
    private LinkedList<PlanNode> children = new LinkedList();
    private List<PlanNode> childrenView = Collections.unmodifiableList(this.children);
    private Map<Property, Object> nodeProperties;
    private Set<SelectorName> selectors = new HashSet<SelectorName>();

    public PlanNode(Type type) {
        assert (type != null);
        this.type = type;
    }

    public PlanNode(Type type, PlanNode parent) {
        assert (type != null);
        this.type = type;
        if (parent != null) {
            this.parent = parent;
            this.parent.children.add(this);
        }
    }

    public PlanNode(Type type, SelectorName ... selectors) {
        this(type);
        for (SelectorName selector : selectors) {
            this.addSelector(selector);
        }
    }

    public PlanNode(Type type, Iterable<SelectorName> selectors) {
        this(type);
        this.addSelectors(selectors);
    }

    public PlanNode(Type type, PlanNode parent, SelectorName ... selectors) {
        this(type, parent);
        for (SelectorName selector : selectors) {
            this.addSelector(selector);
        }
    }

    public PlanNode(Type type, PlanNode parent, Iterable<SelectorName> selectors) {
        this(type, parent);
        this.addSelectors(selectors);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        assert (type != null);
        this.type = type;
    }

    public boolean isNot(Type type) {
        return this.type != type;
    }

    public boolean isNotOneOf(Type first, Type ... rest) {
        return this.isNotOneOf(EnumSet.of(first, rest));
    }

    public boolean isNotOneOf(Set<Type> types) {
        return !types.contains((Object)this.type);
    }

    public boolean is(Type type) {
        return this.type == type;
    }

    public boolean isOneOf(Type first, Type ... rest) {
        return this.isOneOf(EnumSet.of(first, rest));
    }

    public boolean isOneOf(Set<Type> types) {
        return types.contains((Object)this.type);
    }

    public boolean isBelow(PlanNode possibleAncestor) {
        for (PlanNode node = this; node != null; node = node.getParent()) {
            if (node != possibleAncestor) continue;
            return true;
        }
        return false;
    }

    public boolean isAbove(PlanNode possibleDescendant) {
        return possibleDescendant != null && possibleDescendant.isBelow(this);
    }

    public PlanNode getParent() {
        return this.parent;
    }

    public void setParent(PlanNode parent) {
        this.removeFromParent();
        if (parent != null) {
            this.parent = parent;
            this.parent.children.add(this);
        }
    }

    public void insertAsParent(PlanNode newParent) {
        if (newParent == null) {
            return;
        }
        newParent.removeFromParent();
        if (this.parent != null) {
            this.parent.replaceChild(this, newParent);
        }
        newParent.addLastChild(this);
    }

    public PlanNode removeFromParent() {
        PlanNode result = this.parent;
        if (this.parent != null) {
            this.parent.children.remove(this);
            this.parent = null;
        }
        return result;
    }

    public List<PlanNode> getChildren() {
        return this.childrenView;
    }

    @Override
    public Iterator<PlanNode> iterator() {
        return this.childrenView.iterator();
    }

    public List<PlanNode> removeAllChildren() {
        if (this.children.isEmpty()) {
            return new ArrayList<PlanNode>(0);
        }
        ArrayList<PlanNode> copyOfChildren = new ArrayList<PlanNode>(this.children);
        Iterator childIter = this.children.iterator();
        while (childIter.hasNext()) {
            PlanNode child = (PlanNode)childIter.next();
            childIter.remove();
            child.parent = null;
        }
        return copyOfChildren;
    }

    public boolean replaceChild(PlanNode child, PlanNode replacement) {
        assert (child != null);
        assert (replacement != null);
        if (child.parent == this) {
            int i = this.children.indexOf(child);
            if (replacement.parent == this) {
                int j = this.children.indexOf(replacement);
                this.children.set(i, replacement);
                this.children.set(j, child);
                return true;
            }
            this.children.set(i, replacement);
            replacement.removeFromParent();
            replacement.parent = this;
            child.parent = null;
            return true;
        }
        return false;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public PlanNode getFirstChild() {
        return this.children.isEmpty() ? null : this.children.getFirst();
    }

    public PlanNode getLastChild() {
        return this.children.isEmpty() ? null : this.children.getLast();
    }

    public PlanNode getChild(int index) {
        return this.children.isEmpty() ? null : this.children.get(index);
    }

    public void addFirstChild(PlanNode child) {
        assert (child != null);
        this.children.addFirst(child);
        child.removeFromParent();
        child.parent = this;
    }

    public void addLastChild(PlanNode child) {
        assert (child != null);
        this.children.addLast(child);
        child.removeFromParent();
        child.parent = this;
    }

    public void addChildren(Iterable<PlanNode> otherChildren) {
        assert (otherChildren != null);
        for (PlanNode planNode : otherChildren) {
            this.addLastChild(planNode);
        }
    }

    public void addChildren(PlanNode first, PlanNode second) {
        if (first != null) {
            this.addLastChild(first);
        }
        if (second != null) {
            this.addLastChild(second);
        }
    }

    public void addChildren(PlanNode first, PlanNode second, PlanNode third) {
        if (first != null) {
            this.addLastChild(first);
        }
        if (second != null) {
            this.addLastChild(second);
        }
        if (third != null) {
            this.addLastChild(third);
        }
    }

    public boolean removeChild(PlanNode child) {
        boolean result = this.children.remove(child);
        if (result) {
            child.parent = null;
        }
        return result;
    }

    public void extractChild(PlanNode child) {
        if (child.getChildCount() == 0) {
            this.removeChild(child);
        } else {
            PlanNode grandChild = child.getFirstChild();
            this.replaceChild(child, grandChild);
        }
    }

    public void extractFromParent() {
        this.parent.extractChild(this);
    }

    public Set<Property> getPropertyKeys() {
        return this.nodeProperties != null ? this.nodeProperties.keySet() : Collections.emptySet();
    }

    public Object getProperty(Property propertyId) {
        return this.nodeProperties != null ? this.nodeProperties.get((Object)propertyId) : null;
    }

    public <ValueType> ValueType getProperty(Property propertyId, Class<ValueType> type) {
        return this.nodeProperties != null ? (ValueType)type.cast(this.nodeProperties.get((Object)propertyId)) : null;
    }

    public <ValueType> Collection<ValueType> getPropertyAsCollection(Property propertyId, Class<ValueType> type) {
        if (this.nodeProperties == null) {
            return null;
        }
        return (Collection)this.nodeProperties.get((Object)propertyId);
    }

    public <ValueType> List<ValueType> getPropertyAsList(Property propertyId, Class<ValueType> type) {
        if (this.nodeProperties == null) {
            return null;
        }
        return (List)this.nodeProperties.get((Object)propertyId);
    }

    public Object setProperty(Property propertyId, Object value) {
        if (value == null) {
            return this.nodeProperties != null ? this.nodeProperties.remove((Object)propertyId) : null;
        }
        if (this.nodeProperties == null) {
            this.nodeProperties = new HashMap<Property, Object>();
        }
        return this.nodeProperties.put(propertyId, value);
    }

    public Object removeProperty(Object propertyId) {
        return this.nodeProperties != null ? this.nodeProperties.remove(propertyId) : null;
    }

    public boolean hasProperty(Property propertyId) {
        return this.nodeProperties != null && this.nodeProperties.containsKey((Object)propertyId);
    }

    public boolean hasCollectionProperty(Property propertyId) {
        Object value = this.getProperty(propertyId);
        return value instanceof Collection && !((Collection)value).isEmpty();
    }

    public boolean hasBooleanProperty(Property propertyId) {
        Object value = this.getProperty(propertyId);
        return value instanceof Boolean && (Boolean)value != false;
    }

    public void addSelector(SelectorName symbol) {
        if (symbol != null) {
            this.selectors.add(symbol);
        }
    }

    public void addSelector(SelectorName first, SelectorName second) {
        if (first != null) {
            this.selectors.add(first);
        }
        if (second != null) {
            this.selectors.add(second);
        }
    }

    public void addSelectors(Iterable<SelectorName> names) {
        for (SelectorName name : names) {
            if (name == null) continue;
            this.selectors.add(name);
        }
    }

    public Set<SelectorName> getSelectors() {
        return this.selectors;
    }

    public LinkedList<PlanNode> getPathTo(PlanNode descendant) {
        assert (descendant != null);
        LinkedList<PlanNode> stack = new LinkedList<PlanNode>();
        for (PlanNode node = descendant; node != this; node = node.getParent()) {
            stack.addFirst(node);
            assert (node != null) : "The supplied node is not a descendant of this node";
        }
        stack.addFirst(this);
        return stack;
    }

    public boolean hasAncestorOfType(Type type) {
        return this.hasAncestorOfType(EnumSet.of(type));
    }

    public boolean hasAncestorOfType(Type firstType, Type ... additionalTypes) {
        return this.hasAncestorOfType(EnumSet.of(firstType, additionalTypes));
    }

    public boolean hasAncestorOfType(Set<Type> types) {
        for (PlanNode node = this.parent; node != null; node = node.getParent()) {
            if (!types.contains((Object)node.getType())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getString();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public PlanNode clone() {
        return this.cloneWithoutNewParent();
    }

    protected PlanNode cloneWithoutNewParent() {
        PlanNode result = new PlanNode(this.type, null, this.selectors);
        if (this.nodeProperties != null && !this.nodeProperties.isEmpty()) {
            result.nodeProperties = new HashMap<Property, Object>(this.nodeProperties);
        }
        for (PlanNode child : this.children) {
            PlanNode childClone = child.cloneWithoutNewParent();
            result.addLastChild(childClone);
        }
        return result;
    }

    public boolean isSameAs(PlanNode other) {
        if (other == null) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (!ObjectUtil.isEqualWithNulls(this.nodeProperties, other.nodeProperties)) {
            return false;
        }
        if (!((Object)this.getSelectors()).equals(other.getSelectors())) {
            return false;
        }
        if (this.getChildCount() != other.getChildCount()) {
            return false;
        }
        Iterator<PlanNode> thisChildren = this.getChildren().iterator();
        Iterator<PlanNode> thatChildren = other.getChildren().iterator();
        while (thisChildren.hasNext() && thatChildren.hasNext()) {
            if (thisChildren.next().isSameAs(thatChildren.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getString() {
        StringBuilder sb = new StringBuilder();
        this.getRecursiveString(sb, 0);
        return sb.toString();
    }

    private void getRecursiveString(StringBuilder str, int indentLevel) {
        for (int i = 0; i < indentLevel; ++i) {
            str.append("  ");
        }
        this.getNodeString(str).append('\n');
        for (PlanNode child : this) {
            child.getRecursiveString(str, indentLevel + 1);
        }
    }

    private StringBuilder getNodeString(StringBuilder str) {
        boolean first;
        str.append(this.type.getSymbol());
        if (!this.selectors.isEmpty()) {
            str.append(" [");
            first = true;
            for (SelectorName selectorName : this.selectors) {
                if (first) {
                    first = false;
                } else {
                    str.append(',');
                }
                str.append(selectorName.name());
            }
            str.append(']');
        }
        if (this.nodeProperties != null && !this.nodeProperties.isEmpty()) {
            str.append(" <");
            first = true;
            for (Map.Entry entry : this.nodeProperties.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    str.append(", ");
                }
                str.append(entry.getKey()).append('=');
                Object value = entry.getValue();
                if (value instanceof Visitable) {
                    str.append(Visitors.readable((Visitable)value));
                    continue;
                }
                if (value instanceof Collection) {
                    boolean firstItem = true;
                    str.append('[');
                    for (Object item : (Collection)value) {
                        if (firstItem) {
                            firstItem = false;
                        } else {
                            str.append(", ");
                        }
                        if (item instanceof Visitable) {
                            str.append(Visitors.readable((Visitable)item));
                            continue;
                        }
                        str.append(item);
                    }
                    str.append(']');
                    continue;
                }
                str.append(value);
            }
            str.append('>');
        }
        return str;
    }

    public PlanNode findAncestor(Type typeToFind) {
        return this.findAncestor(EnumSet.of(typeToFind));
    }

    public PlanNode findAncestor(Type firstTypeToFind, Type ... additionalTypesToFind) {
        return this.findAncestor(EnumSet.of(firstTypeToFind, additionalTypesToFind));
    }

    public PlanNode findAncestor(Set<Type> typesToFind) {
        PlanNode node = this;
        PlanNode parent = null;
        while ((parent = node.getParent()) != null) {
            if (typesToFind.contains((Object)parent.getType())) {
                return parent;
            }
            node = parent;
        }
        return null;
    }

    public List<PlanNode> findAllFirstNodesAtOrBelow(Type typeToFind) {
        LinkedList<PlanNode> results = new LinkedList<PlanNode>();
        LinkedList<PlanNode> queue = new LinkedList<PlanNode>();
        queue.add(this);
        while (!queue.isEmpty()) {
            PlanNode aNode = (PlanNode)queue.poll();
            if (aNode.getType() == Type.PROJECT) {
                results.add(aNode);
                continue;
            }
            queue.addAll(0, aNode.getChildren());
        }
        return results;
    }

    public List<PlanNode> findAllAtOrBelow() {
        return this.findAllAtOrBelow(Traversal.PRE_ORDER);
    }

    public List<PlanNode> findAllAtOrBelow(Traversal order) {
        assert (order != null);
        LinkedList<PlanNode> results = new LinkedList<PlanNode>();
        LinkedList<PlanNode> queue = new LinkedList<PlanNode>();
        queue.add(this);
        while (!queue.isEmpty()) {
            PlanNode aNode = (PlanNode)queue.poll();
            switch (order) {
                case LEVEL_ORDER: {
                    queue.addAll(aNode.getChildren());
                    break;
                }
                case PRE_ORDER: {
                    queue.addAll(0, aNode.getChildren());
                }
            }
        }
        return results;
    }

    public List<PlanNode> findAllAtOrBelow(Type typeToFind) {
        return this.findAllAtOrBelow(EnumSet.of(typeToFind));
    }

    public List<PlanNode> findAllAtOrBelow(Type firstTypeToFind, Type ... additionalTypesToFind) {
        return this.findAllAtOrBelow(EnumSet.of(firstTypeToFind, additionalTypesToFind));
    }

    public List<PlanNode> findAllAtOrBelow(Set<Type> typesToFind) {
        return this.findAllAtOrBelow(Traversal.PRE_ORDER, typesToFind);
    }

    public List<PlanNode> findAllAtOrBelow(Traversal order, Type typeToFind) {
        return this.findAllAtOrBelow(order, EnumSet.of(typeToFind));
    }

    public List<PlanNode> findAllAtOrBelow(Traversal order, Type firstTypeToFind, Type ... additionalTypesToFind) {
        return this.findAllAtOrBelow(order, EnumSet.of(firstTypeToFind, additionalTypesToFind));
    }

    public List<PlanNode> findAllAtOrBelow(Traversal order, Set<Type> typesToFind) {
        assert (order != null);
        LinkedList<PlanNode> results = new LinkedList<PlanNode>();
        LinkedList<PlanNode> queue = new LinkedList<PlanNode>();
        queue.add(this);
        while (!queue.isEmpty()) {
            PlanNode aNode = (PlanNode)queue.poll();
            if (typesToFind.contains((Object)aNode.getType())) {
                results.add(aNode);
            }
            switch (order) {
                case LEVEL_ORDER: {
                    queue.addAll(aNode.getChildren());
                    break;
                }
                case PRE_ORDER: {
                    queue.addAll(0, aNode.getChildren());
                }
            }
        }
        return results;
    }

    public PlanNode findAtOrBelow(Type typeToFind) {
        return this.findAtOrBelow(EnumSet.of(typeToFind));
    }

    public PlanNode findAtOrBelow(Type firstTypeToFind, Type ... additionalTypesToFind) {
        return this.findAtOrBelow(EnumSet.of(firstTypeToFind, additionalTypesToFind));
    }

    public PlanNode findAtOrBelow(Set<Type> typesToFind) {
        return this.findAtOrBelow(Traversal.PRE_ORDER, typesToFind);
    }

    public PlanNode findAtOrBelow(Traversal order, Type typeToFind) {
        return this.findAtOrBelow(order, EnumSet.of(typeToFind));
    }

    public PlanNode findAtOrBelow(Traversal order, Type firstTypeToFind, Type ... additionalTypesToFind) {
        return this.findAtOrBelow(order, EnumSet.of(firstTypeToFind, additionalTypesToFind));
    }

    public PlanNode findAtOrBelow(Traversal order, Set<Type> typesToFind) {
        LinkedList<PlanNode> queue = new LinkedList<PlanNode>();
        queue.add(this);
        while (!queue.isEmpty()) {
            PlanNode aNode = (PlanNode)queue.poll();
            if (typesToFind.contains((Object)aNode.getType())) {
                return aNode;
            }
            switch (order) {
                case LEVEL_ORDER: {
                    queue.addAll(aNode.getChildren());
                    break;
                }
                case PRE_ORDER: {
                    queue.addAll(0, aNode.getChildren());
                }
            }
        }
        return null;
    }

    public static enum Traversal {
        LEVEL_ORDER,
        PRE_ORDER;

    }

    public static enum Property {
        IS_DEPENDENT,
        SELECT_CRITERIA,
        SET_OPERATION,
        SET_USE_ALL,
        JOIN_TYPE,
        JOIN_ALGORITHM,
        JOIN_CONDITION,
        JOIN_CONSTRAINTS,
        SOURCE_NAME,
        SOURCE_ALIAS,
        SOURCE_COLUMNS,
        PROJECT_COLUMNS,
        PROJECT_COLUMN_TYPES,
        GROUP_COLUMNS,
        SORT_ORDER_BY,
        LIMIT_COUNT,
        LIMIT_OFFSET,
        ACCESS_NO_RESULTS,
        VARIABLE_NAME;

    }

    public static enum Type {
        ACCESS("Access"),
        DUP_REMOVE("DupRemoval"),
        JOIN("Join"),
        PROJECT("Project"),
        SELECT("Select"),
        SORT("Sort"),
        SOURCE("Source"),
        GROUP("Group"),
        NULL("Null"),
        LIMIT("Limit"),
        SET_OPERATION("SetOperation"),
        DEPENDENT_QUERY("DependentQuery");

        private static final Map<String, Type> TYPE_BY_SYMBOL;
        private final String symbol;

        private Type(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String toString() {
            return this.symbol;
        }

        public static Type forSymbol(String symbol) {
            CheckArg.isNotNull(symbol, "symbol");
            return TYPE_BY_SYMBOL.get(symbol.toUpperCase().trim());
        }

        static {
            HashMap<String, Type> typesBySymbol = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                typesBySymbol.put(type.getSymbol().toUpperCase(), type);
            }
            TYPE_BY_SYMBOL = Collections.unmodifiableMap(typesBySymbol);
        }
    }
}

