/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.search.SearchEngine;
import org.modeshape.graph.search.SearchEngineException;
import org.modeshape.graph.search.SearchEngineProcessor;
import org.modeshape.graph.search.SearchEngineWorkspace;

@ThreadSafe
public abstract class AbstractSearchEngine<WorkspaceType extends SearchEngineWorkspace, ProcessorType extends SearchEngineProcessor>
implements SearchEngine {
    public static final boolean DEFAULT_VERIFY_WORKSPACE_IN_SOURCE = false;
    private final boolean verifyWorkspaceInSource;
    private final RepositoryConnectionFactory connectionFactory;
    private final String sourceName;
    private volatile Workspaces<WorkspaceType> workspaces;

    protected AbstractSearchEngine(String sourceName, RepositoryConnectionFactory connectionFactory) {
        this(sourceName, connectionFactory, false);
    }

    protected AbstractSearchEngine(String sourceName, RepositoryConnectionFactory connectionFactory, boolean verifyWorkspaceInSource) {
        CheckArg.isNotNull(sourceName, "sourceName");
        CheckArg.isNotNull(connectionFactory, "connectionFactory");
        this.sourceName = sourceName;
        this.connectionFactory = connectionFactory;
        this.verifyWorkspaceInSource = verifyWorkspaceInSource;
        this.workspaces = new SearchWorkspaces(connectionFactory);
    }

    protected RepositoryConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    public boolean isVerifyWorkspaceInSource() {
        return this.verifyWorkspaceInSource;
    }

    protected Graph graph(ExecutionContext context) {
        assert (context != null);
        return Graph.create(this.sourceName, this.connectionFactory, context);
    }

    protected abstract WorkspaceType createWorkspace(ExecutionContext var1, String var2) throws SearchEngineException;

    protected abstract ProcessorType createProcessor(ExecutionContext var1, Workspaces<WorkspaceType> var2, Observer var3, boolean var4);

    @Override
    public SearchEngineProcessor createProcessor(ExecutionContext context, Observer observer, boolean readOnly) {
        return this.createProcessor(context, this.workspaces, observer, readOnly);
    }

    protected class SearchWorkspaces
    implements Workspaces<WorkspaceType> {
        private final ReadWriteLock workspacesLock = new ReentrantReadWriteLock();
        @GuardedBy(value="workspacesLock")
        private final Map<String, WorkspaceType> workspacesByName = new HashMap();
        private final RepositoryConnectionFactory connectionFactory;

        protected SearchWorkspaces(RepositoryConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        @Override
        public RepositoryConnectionFactory getRepositoryConnectionFactory() {
            return this.connectionFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WorkspaceType getWorkspace(ExecutionContext context, String workspaceName, boolean createIfMissing) {
            assert (context != null);
            assert (workspaceName != null);
            SearchEngineWorkspace workspace = null;
            try {
                this.workspacesLock.readLock().lock();
                workspace = (SearchEngineWorkspace)this.workspacesByName.get(workspaceName);
            }
            finally {
                this.workspacesLock.readLock().unlock();
            }
            if (workspace == null) {
                if (AbstractSearchEngine.this.isVerifyWorkspaceInSource() && this.connectionFactory != null && !AbstractSearchEngine.this.graph(context).getWorkspaces().contains(workspaceName)) {
                    String msg = GraphI18n.workspaceDoesNotExistInRepository.text(workspaceName, AbstractSearchEngine.this.getSourceName());
                    throw new InvalidWorkspaceException(msg);
                }
                try {
                    this.workspacesLock.writeLock().lock();
                    workspace = (SearchEngineWorkspace)this.workspacesByName.get(workspaceName);
                    if (workspace == null) {
                        workspace = AbstractSearchEngine.this.createWorkspace(context, workspaceName);
                        this.workspacesByName.put(workspaceName, workspace);
                    }
                }
                finally {
                    this.workspacesLock.writeLock().unlock();
                }
            }
            return workspace;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<WorkspaceType> getWorkspaces() {
            try {
                this.workspacesLock.writeLock().lock();
                ArrayList arrayList = new ArrayList(this.workspacesByName.values());
                return arrayList;
            }
            finally {
                this.workspacesByName.clear();
                this.workspacesLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WorkspaceType removeWorkspace(String workspaceName) {
            CheckArg.isNotNull(workspaceName, "workspaceName");
            try {
                this.workspacesLock.writeLock().lock();
                SearchEngineWorkspace searchEngineWorkspace = (SearchEngineWorkspace)this.workspacesByName.remove(workspaceName);
                return searchEngineWorkspace;
            }
            finally {
                this.workspacesLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, WorkspaceType> removeAllWorkspaces() {
            try {
                this.workspacesLock.writeLock().lock();
                HashMap hashMap = new HashMap(this.workspacesByName);
                return hashMap;
            }
            finally {
                this.workspacesByName.clear();
                this.workspacesLock.writeLock().unlock();
            }
        }
    }

    public static interface Workspaces<WorkspaceType extends SearchEngineWorkspace> {
        public RepositoryConnectionFactory getRepositoryConnectionFactory();

        public WorkspaceType getWorkspace(ExecutionContext var1, String var2, boolean var3);

        public Collection<WorkspaceType> getWorkspaces();

        public WorkspaceType removeWorkspace(String var1);

        public Map<String, WorkspaceType> removeAllWorkspaces();
    }
}

