/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.sequencer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.component.ClassLoaderFactory;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;

@ThreadSafe
public class StreamSequencerContext
extends ExecutionContext {
    private final Path inputPath;
    private final Map<Name, Property> inputPropertiesByName;
    private final Set<Property> inputProperties;
    private final Problems problems;
    private final String mimeType;

    public StreamSequencerContext(ExecutionContext context, Path inputPath, Set<Property> inputProperties, String mimeType, Problems problems) {
        super(context);
        this.inputPath = inputPath;
        this.inputProperties = inputProperties != null ? new HashSet<Property>(inputProperties) : new HashSet();
        this.mimeType = mimeType;
        this.problems = problems != null ? problems : new SimpleProblems();
        HashMap<Name, Property> inputPropertiesByName = new HashMap<Name, Property>();
        for (Property property : this.inputProperties) {
            inputPropertiesByName.put(property.getName(), property);
        }
        this.inputPropertiesByName = Collections.unmodifiableMap(inputPropertiesByName);
    }

    public Path getInputPath() {
        return this.inputPath;
    }

    public Set<Property> getInputProperties() {
        return this.inputProperties;
    }

    public Property getInputProperty(Name name) {
        return this.inputPropertiesByName.get(name);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Problems getProblems() {
        return this.problems;
    }

    @Override
    public StreamSequencerContext with(ClassLoaderFactory classLoaderFactory) {
        return new StreamSequencerContext(super.with(classLoaderFactory), this.inputPath, this.inputProperties, this.mimeType, this.problems);
    }

    @Override
    public StreamSequencerContext with(Map<String, String> data) {
        return new StreamSequencerContext(super.with(data), this.inputPath, this.inputProperties, this.mimeType, this.problems);
    }

    @Override
    public StreamSequencerContext with(MimeTypeDetector mimeTypeDetector) {
        return new StreamSequencerContext(super.with(mimeTypeDetector), this.inputPath, this.inputProperties, this.mimeType, this.problems);
    }

    @Override
    public StreamSequencerContext with(NamespaceRegistry namespaceRegistry) {
        return new StreamSequencerContext(super.with(namespaceRegistry), this.inputPath, this.inputProperties, this.mimeType, this.problems);
    }

    @Override
    public StreamSequencerContext with(SecurityContext securityContext) {
        return new StreamSequencerContext(super.with(securityContext), this.inputPath, this.inputProperties, this.mimeType, this.problems);
    }

    @Override
    public StreamSequencerContext with(String key, String value) {
        return new StreamSequencerContext(super.with(key, value), this.inputPath, this.inputProperties, this.mimeType, this.problems);
    }

    @Override
    public StreamSequencerContext with(String processId) {
        return new StreamSequencerContext(super.with(processId), this.inputPath, this.inputProperties, this.mimeType, this.problems);
    }
}

