/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import javax.jcr.version.OnParentVersionAction;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.IoUtil;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.io.Destination;
import org.modeshape.graph.io.GraphBatchDestination;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.LocalNamespaceRegistry;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeDefinitionTemplate;
import org.modeshape.jcr.JcrNodeTypeTemplate;
import org.modeshape.jcr.JcrPropertyDefinitionTemplate;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;

@NotThreadSafe
class GraphNodeTypeReader
implements Iterable<NodeTypeDefinition> {
    private static final Map<String, Integer> PROPERTY_TYPE_VALUES_FROM_NAME;
    protected final Problems problems = new SimpleProblems();
    protected final List<NodeTypeDefinition> types = new ArrayList<NodeTypeDefinition>();
    protected final List<NodeTypeDefinition> immutableTypes = Collections.unmodifiableList(this.types);
    protected final ExecutionContext context;
    protected final ValueFactories valueFactories;
    protected final PathFactory pathFactory;
    protected final NameFactory nameFactory;
    protected final ValueFactory<Boolean> booleanFactory;
    protected final ValueFactory<String> stringFactory;
    protected final Path root;

    protected GraphNodeTypeReader(Session session) {
        this(CheckArg.getInstanceOf(session, JcrSession.class, "session").getExecutionContext());
    }

    protected GraphNodeTypeReader(ExecutionContext executionContext) {
        LocalNamespaceRegistry localRegistry = new LocalNamespaceRegistry(executionContext.getNamespaceRegistry());
        this.context = executionContext.with(localRegistry);
        this.valueFactories = this.context.getValueFactories();
        this.pathFactory = this.valueFactories.getPathFactory();
        this.nameFactory = this.valueFactories.getNameFactory();
        this.booleanFactory = this.valueFactories.getBooleanFactory();
        this.stringFactory = this.valueFactories.getStringFactory();
        this.root = this.pathFactory.createRootPath();
    }

    public void read(InputStream stream, String resourceName) throws IOException {
        this.read(IoUtil.read(stream), resourceName);
    }

    public void read(File file) throws IOException {
        CheckArg.isNotNull(file, "file");
        if (!file.exists() || !file.canRead()) {
            throw new IOException(JcrI18n.fileMustExistAndBeReadable.text(file.getCanonicalPath()));
        }
        this.read(IoUtil.read(file), file.getCanonicalPath());
    }

    public void read(URL url) throws IOException {
        CheckArg.isNotNull(url, "url");
        InputStream stream = url.openStream();
        boolean error = false;
        try {
            this.read(IoUtil.read(stream), url.toString());
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            block14: {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    if (!error) {
                        throw e;
                    }
                }
                catch (RuntimeException e) {
                    if (error) break block14;
                    throw e;
                }
            }
        }
    }

    public void read(String resourceFile) throws IOException {
        CheckArg.isNotEmpty(resourceFile, "resourceFile");
        ClassLoader classLoader = this.context.getClassLoader(new String[0]);
        InputStream stream = IoUtil.getResourceAsStream(resourceFile, classLoader, this.getClass());
        if (stream == null) {
            throw new IOException(JcrI18n.unableToFindResourceOnClasspathOrFileOrUrl.text(resourceFile));
        }
        boolean error = false;
        try {
            this.read(IoUtil.read(stream), resourceFile);
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            block15: {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    if (!error) {
                        throw e;
                    }
                }
                catch (RuntimeException e) {
                    if (error) break block15;
                    throw e;
                }
            }
        }
    }

    public void read(String content, String resourceName) {
        InMemoryRepositorySource source = new InMemoryRepositorySource();
        source.setName("Node Type Import Source");
        Graph graph = Graph.create(source, this.context);
        Graph.Batch batch = graph.batch();
        GraphBatchDestination destination = new GraphBatchDestination(batch);
        try {
            this.importFrom(destination, this.root, content, resourceName);
            List<NodeTypeDefinition> types = this.readTypesFrom(graph, this.root, null);
            this.types.addAll(types);
        }
        catch (Throwable t) {
            this.problems.addError(t, JcrI18n.errorImportingNodeTypeContent, resourceName, t.getMessage());
        }
    }

    public void read(Graph graph, Path parentOfTypes, String resourceName) {
        this.types.addAll(this.readTypesFrom(graph, parentOfTypes, null));
    }

    public void read(Graph graph, Path parentOfTypes, Collection<Name> nodeTypesToRead, String resourceName) {
        this.types.addAll(this.readTypesFrom(graph, parentOfTypes, nodeTypesToRead));
    }

    public void read(Subgraph subgraph, Location locationOfParent, String resourceName) {
        this.types.addAll(this.readTypesFrom(subgraph, locationOfParent, null));
    }

    public Problems getProblems() {
        return this.problems;
    }

    public NodeTypeDefinition[] getNodeTypeDefinitions() {
        return this.types.toArray(new NodeTypeDefinition[this.types.size()]);
    }

    @Override
    public Iterator<NodeTypeDefinition> iterator() {
        return this.immutableTypes.iterator();
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.context.getNamespaceRegistry();
    }

    public Set<NamespaceRegistry.Namespace> getNamespaces() {
        return ((LocalNamespaceRegistry)this.context.getNamespaceRegistry()).getLocalNamespaces();
    }

    protected List<NodeTypeDefinition> readTypesFrom(Graph graph, Path parentOfTypes, Collection<Name> nodeTypesToRead) {
        Subgraph subgraph = graph.getSubgraphOfDepth(5).at(parentOfTypes);
        return this.readTypesFrom(subgraph, subgraph.getLocation(), nodeTypesToRead);
    }

    protected List<NodeTypeDefinition> readTypesFrom(Subgraph nodeTypeSubgraph, Location locationOfParentOfNodeTypes, Collection<Name> nodeTypesToRead) {
        List<Location> nodeTypeLocations = ((SubgraphNode)nodeTypeSubgraph.getNode(locationOfParentOfNodeTypes)).getChildren();
        ArrayList<NodeTypeDefinition> results = new ArrayList<NodeTypeDefinition>(nodeTypeLocations.size());
        boolean shouldFilterNodes = locationOfParentOfNodeTypes.hasPath() && nodeTypesToRead != null;
        for (Location location : nodeTypeLocations) {
            Path relativeNodeTypePath;
            SubgraphNode nodeTypeNode = (SubgraphNode)nodeTypeSubgraph.getNode(location);
            assert (location.getPath() != null);
            Path path = relativeNodeTypePath = shouldFilterNodes ? location.getPath().relativeTo(locationOfParentOfNodeTypes.getPath()) : null;
            if (shouldFilterNodes && !nodeTypesToRead.contains(relativeNodeTypePath.getSegment(0).getName())) continue;
            try {
                NodeTypeTemplate nodeType = this.nodeTypeFrom(nodeTypeNode, nodeTypeSubgraph);
                results.add((NodeTypeDefinition)nodeType);
            }
            catch (ConstraintViolationException e) {
                String resource = this.stringFactory.create(locationOfParentOfNodeTypes.getPath());
                this.problems.addError((Throwable)e, JcrI18n.errorImportingNodeTypeContent, resource, e.getMessage());
            }
        }
        return results;
    }

    protected NodeTypeTemplate nodeTypeFrom(SubgraphNode nodeTypeNode, Subgraph subgraph) throws ConstraintViolationException {
        List<Location> children = nodeTypeNode.getChildren();
        String name = this.readString(nodeTypeNode, JcrLexicon.NODE_TYPE_NAME, null);
        String primaryItemName = this.readString(nodeTypeNode, JcrLexicon.PRIMARY_ITEM_NAME, null);
        boolean mixin = this.readBoolean(nodeTypeNode, JcrLexicon.IS_MIXIN, false);
        boolean isAbstract = this.readBoolean(nodeTypeNode, JcrLexicon.IS_ABSTRACT, false);
        boolean queryable = this.readBoolean(nodeTypeNode, JcrLexicon.IS_QUERYABLE, true);
        boolean orderableChildNodes = this.readBoolean(nodeTypeNode, JcrLexicon.HAS_ORDERABLE_CHILD_NODES, false);
        List<String> supertypes = this.readStrings(nodeTypeNode, JcrLexicon.SUPERTYPES);
        JcrNodeTypeTemplate template = new JcrNodeTypeTemplate(this.context);
        template.setAbstract(isAbstract);
        template.setDeclaredSuperTypeNames(supertypes.toArray(new String[supertypes.size()]));
        template.setMixin(mixin);
        template.setName(name);
        template.setOrderableChildNodes(orderableChildNodes);
        template.setPrimaryItemName(primaryItemName);
        template.setQueryable(queryable);
        for (Location childLocation : children) {
            if (JcrLexicon.PROPERTY_DEFINITION.equals(childLocation.getPath().getLastSegment().getName())) {
                template.getPropertyDefinitionTemplates().add(this.propertyDefinitionFrom(subgraph, childLocation));
                continue;
            }
            if (JcrLexicon.CHILD_NODE_DEFINITION.equals(childLocation.getPath().getLastSegment().getName())) {
                template.getNodeDefinitionTemplates().add(this.childNodeDefinitionFrom(subgraph, childLocation));
                continue;
            }
            throw new IllegalStateException("Unexpected child of node type at: " + childLocation);
        }
        return template;
    }

    protected PropertyDefinitionTemplate propertyDefinitionFrom(Subgraph nodeTypeGraph, Location propertyLocation) throws ConstraintViolationException {
        SubgraphNode propertyDefinitionNode = (SubgraphNode)nodeTypeGraph.getNode(propertyLocation);
        String name = this.readString(propertyDefinitionNode, JcrLexicon.NAME, null);
        String onParentVersionName = this.readString(propertyDefinitionNode, JcrLexicon.ON_PARENT_VERSION, OnParentVersionAction.nameFromValue((int)1));
        int onParentVersion = OnParentVersionAction.valueFromName((String)onParentVersionName);
        int requiredType = PROPERTY_TYPE_VALUES_FROM_NAME.get(this.readString(propertyDefinitionNode, JcrLexicon.REQUIRED_TYPE, null));
        boolean mandatory = this.readBoolean(propertyDefinitionNode, JcrLexicon.MANDATORY, false);
        boolean multiple = this.readBoolean(propertyDefinitionNode, JcrLexicon.MULTIPLE, false);
        boolean autoCreated = this.readBoolean(propertyDefinitionNode, JcrLexicon.AUTO_CREATED, false);
        boolean isProtected = this.readBoolean(propertyDefinitionNode, JcrLexicon.PROTECTED, false);
        boolean isSearchable = this.readBoolean(propertyDefinitionNode, JcrLexicon.IS_FULL_TEXT_SEARCHABLE, true);
        boolean isOrderable = this.readBoolean(propertyDefinitionNode, JcrLexicon.IS_QUERY_ORDERABLE, true);
        List<Value> defaultValues = this.readValues(propertyDefinitionNode, JcrLexicon.DEFAULT_VALUES, requiredType);
        List<String> constraints = this.readStrings(propertyDefinitionNode, JcrLexicon.VALUE_CONSTRAINTS);
        List<String> queryOps = this.readStrings(propertyDefinitionNode, JcrLexicon.QUERY_OPERATORS);
        JcrPropertyDefinitionTemplate template = new JcrPropertyDefinitionTemplate(this.context);
        if (name != null) {
            template.setName(name);
        }
        template.setAutoCreated(autoCreated);
        template.setMandatory(mandatory);
        template.setMultiple(multiple);
        template.setProtected(isProtected);
        template.setFullTextSearchable(isSearchable);
        template.setAvailableQueryOperators(queryOps.toArray(new String[queryOps.size()]));
        template.setQueryOrderable(isOrderable);
        template.setProtected(isProtected);
        template.setOnParentVersion(onParentVersion);
        template.setDefaultValues(defaultValues.toArray(new Value[defaultValues.size()]));
        template.setRequiredType(requiredType);
        template.setValueConstraints(constraints.toArray(new String[constraints.size()]));
        return template;
    }

    protected NodeDefinitionTemplate childNodeDefinitionFrom(Subgraph nodeTypeGraph, Location childNodeLocation) throws ConstraintViolationException {
        SubgraphNode childNodeDefinitionNode = (SubgraphNode)nodeTypeGraph.getNode(childNodeLocation);
        String childNodeName = this.readString(childNodeDefinitionNode, JcrLexicon.NAME, null);
        String defaultPrimaryTypeName = this.readString(childNodeDefinitionNode, JcrLexicon.DEFAULT_PRIMARY_TYPE, null);
        String onParentVersionName = this.readString(childNodeDefinitionNode, JcrLexicon.ON_PARENT_VERSION, OnParentVersionAction.nameFromValue((int)1));
        int onParentVersion = OnParentVersionAction.valueFromName((String)onParentVersionName);
        boolean mandatory = this.readBoolean(childNodeDefinitionNode, JcrLexicon.MANDATORY, false);
        boolean allowsSns = this.readBoolean(childNodeDefinitionNode, JcrLexicon.SAME_NAME_SIBLINGS, false);
        boolean autoCreated = this.readBoolean(childNodeDefinitionNode, JcrLexicon.AUTO_CREATED, false);
        boolean isProtected = this.readBoolean(childNodeDefinitionNode, JcrLexicon.PROTECTED, false);
        List<String> requiredTypes = this.readStrings(childNodeDefinitionNode, JcrLexicon.REQUIRED_PRIMARY_TYPES);
        JcrNodeDefinitionTemplate template = new JcrNodeDefinitionTemplate(this.context);
        if (childNodeName != null) {
            template.setName(childNodeName);
        }
        template.setAutoCreated(autoCreated);
        template.setMandatory(mandatory);
        template.setSameNameSiblings(allowsSns);
        template.setProtected(isProtected);
        template.setOnParentVersion(onParentVersion);
        template.setDefaultPrimaryTypeName(defaultPrimaryTypeName);
        template.setRequiredPrimaryTypeNames(requiredTypes.toArray(new String[requiredTypes.size()]));
        return template;
    }

    protected Name nameFrom(SubgraphNode node) {
        return node.getLocation().getPath().getLastSegment().getName();
    }

    protected Name name(String name) {
        return (Name)this.nameFactory.create(name);
    }

    protected String string(Object value) {
        return this.stringFactory.create(value);
    }

    protected boolean readBoolean(SubgraphNode node, String propertyName, boolean defaultValue) {
        return this.readBoolean(node, (Name)this.nameFactory.create(propertyName), defaultValue);
    }

    protected boolean readBoolean(SubgraphNode node, Name propertyName, boolean defaultValue) {
        Property property = node.getProperty(propertyName);
        return property != null ? this.booleanFactory.create(property.getFirstValue()) : defaultValue;
    }

    protected String readString(SubgraphNode node, String propertyName, String defaultValue) {
        return this.readString(node, (Name)this.nameFactory.create(propertyName), defaultValue);
    }

    protected String readString(SubgraphNode node, Name propertyName, String defaultValue) {
        Property property = node.getProperty(propertyName);
        return property != null ? this.stringFactory.create(property.getFirstValue()) : defaultValue;
    }

    protected List<String> readStrings(SubgraphNode node, String propertyName) {
        return this.readStrings(node, (Name)this.nameFactory.create(propertyName));
    }

    protected List<String> readStrings(SubgraphNode node, Name propertyName) {
        ArrayList<String> results = new ArrayList<String>();
        Property property = node.getProperty(propertyName);
        if (property != null) {
            for (Object value : property) {
                String str = this.stringFactory.create(value);
                if (str == null || str.length() == 0) continue;
                results.add(str);
            }
        }
        return results;
    }

    protected List<Value> readValues(SubgraphNode node, Name propertyName, int requiredType) {
        List<String> results = this.readStrings(node, propertyName);
        ArrayList<Value> values = new ArrayList<Value>(results.size());
        for (String result : results) {
            values.add(new JcrValue(this.valueFactories, null, requiredType, result));
        }
        return values;
    }

    protected Name readName(SubgraphNode node, String propertyName, Name defaultValue) {
        return this.readName(node, (Name)this.nameFactory.create(propertyName), defaultValue);
    }

    protected Name readName(SubgraphNode node, Name propertyName, Name defaultValue) {
        String firstValue;
        Property property = node.getProperty(propertyName);
        if (property != null && !property.isEmpty() && (firstValue = this.stringFactory.create(property.getFirstValue())) != null && firstValue.trim().length() != 0) {
            return (Name)this.valueFactories.getNameFactory().create(firstValue);
        }
        return defaultValue;
    }

    protected List<Name> readNames(SubgraphNode node, String propertyName, Name defaultIfNone) {
        return this.readNames(node, (Name)this.nameFactory.create(propertyName), defaultIfNone);
    }

    protected List<Name> readNames(SubgraphNode node, Name propertyName, Name defaultIfNone) {
        ArrayList<Name> results = new ArrayList<Name>();
        Property property = node.getProperty(propertyName);
        if (property != null) {
            for (Object value : property) {
                Name name = (Name)this.nameFactory.create(value);
                if (name == null) continue;
                results.add(name);
            }
        }
        if (results.isEmpty() && defaultIfNone != null) {
            results.add(defaultIfNone);
        }
        return results;
    }

    protected void importFrom(Destination graphDestination, Path path, String content, String resourceName) throws Exception {
        throw new UnsupportedOperationException();
    }

    static {
        HashMap<String, Integer> temp = new HashMap<String, Integer>();
        temp.put("Binary".toUpperCase(), 2);
        temp.put("Boolean".toUpperCase(), 6);
        temp.put("Date".toUpperCase(), 5);
        temp.put("Decimal".toUpperCase(), 12);
        temp.put("Double".toUpperCase(), 4);
        temp.put("Long".toUpperCase(), 3);
        temp.put("Name".toUpperCase(), 7);
        temp.put("Path".toUpperCase(), 8);
        temp.put("String".toUpperCase(), 1);
        temp.put("Reference".toUpperCase(), 9);
        temp.put("WeakReference".toUpperCase(), 10);
        temp.put("undefined".toUpperCase(), 0);
        temp.put("URI".toUpperCase(), 11);
        PROPERTY_TYPE_VALUES_FROM_NAME = Collections.unmodifiableMap(temp);
    }
}

