/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.cnd.CndImporter;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.component.ClassLoaderFactory;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.io.GraphBatchDestination;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.repository.ModeShapeConfigurationException;
import org.xml.sax.SAXException;

@NotThreadSafe
public class JcrConfiguration
extends ModeShapeConfiguration {
    private final Map<String, RepositoryDefinition<? extends JcrConfiguration>> repositoryDefinitions = new HashMap<String, RepositoryDefinition<? extends JcrConfiguration>>();

    public JcrConfiguration() {
    }

    public JcrConfiguration(ExecutionContext context) {
        super(context);
    }

    @Override
    public JcrConfiguration loadFrom(String pathToFile) throws IOException, SAXException {
        super.loadFrom(pathToFile);
        return this;
    }

    @Override
    public JcrConfiguration loadFrom(String pathToConfigurationFile, String path) throws IOException, SAXException {
        super.loadFrom(pathToConfigurationFile, path);
        return this;
    }

    @Override
    public JcrConfiguration loadFrom(File configurationFile) throws IOException, SAXException {
        super.loadFrom(configurationFile);
        return this;
    }

    @Override
    public JcrConfiguration loadFrom(File configurationFile, String path) throws IOException, SAXException {
        super.loadFrom(configurationFile, path);
        return this;
    }

    @Override
    public JcrConfiguration loadFrom(URL urlToConfigurationFile) throws IOException, SAXException {
        super.loadFrom(urlToConfigurationFile);
        return this;
    }

    @Override
    public JcrConfiguration loadFrom(URL urlToConfigurationFile, String path) throws IOException, SAXException {
        super.loadFrom(urlToConfigurationFile, path);
        return this;
    }

    @Override
    public JcrConfiguration loadFrom(InputStream configurationFileInputStream) throws IOException, SAXException {
        super.loadFrom(configurationFileInputStream);
        return this;
    }

    @Override
    public JcrConfiguration loadFrom(InputStream configurationFileInputStream, String path) throws IOException, SAXException {
        super.loadFrom(configurationFileInputStream, path);
        return this;
    }

    @Override
    public JcrConfiguration loadFrom(RepositorySource source) {
        super.loadFrom(source);
        return this;
    }

    @Override
    public JcrConfiguration loadFrom(RepositorySource source, String workspaceName) {
        super.loadFrom(source, workspaceName);
        return this;
    }

    @Override
    public JcrConfiguration loadFrom(RepositorySource source, String workspaceName, String pathInWorkspace) {
        super.loadFrom(source, workspaceName, pathInWorkspace);
        return this;
    }

    @Override
    public JcrConfiguration and() {
        return this;
    }

    @Override
    public JcrConfiguration withClassLoaderFactory(ClassLoaderFactory classLoaderFactory) {
        super.withClassLoaderFactory(classLoaderFactory);
        return this;
    }

    public ModeShapeConfiguration.MimeTypeDetectorDefinition<JcrConfiguration> mimeTypeDetector(String name) {
        return this.mimeTypeDetectorDefinition(this, name);
    }

    public ModeShapeConfiguration.RepositorySourceDefinition<JcrConfiguration> repositorySource(String name) {
        return this.repositorySourceDefinition(this, name);
    }

    public ModeShapeConfiguration.SequencerDefinition<JcrConfiguration> sequencer(String name) {
        return this.sequencerDefinition(this, name);
    }

    public RepositoryDefinition<JcrConfiguration> repository(String name) {
        return this.repositoryDefinition(this, name);
    }

    public Set<String> repositoryNames() {
        Set<String> names = this.getNamesOfComponentsUnder(ModeShapeLexicon.REPOSITORIES);
        names.addAll(this.repositoryDefinitions.keySet());
        return names;
    }

    public Set<RepositoryDefinition<JcrConfiguration>> repositories() {
        Set<String> names = this.getNamesOfComponentsUnder(ModeShapeLexicon.REPOSITORIES);
        names.addAll(this.repositoryDefinitions.keySet());
        HashSet<RepositoryDefinition<JcrConfiguration>> results = new HashSet<RepositoryDefinition<JcrConfiguration>>();
        for (String name : names) {
            results.add(this.repository(name));
        }
        return Collections.unmodifiableSet(results);
    }

    @Override
    public JcrConfiguration save() {
        super.save();
        this.repositoryDefinitions.clear();
        return this;
    }

    @Override
    public JcrEngine build() {
        this.save();
        return new JcrEngine(this.getExecutionContextForEngine(), this.getConfigurationDefinition());
    }

    protected <ReturnType extends JcrConfiguration> RepositoryDefinition<ReturnType> repositoryDefinition(ReturnType returnObject, String name) {
        RepositoryDefinition<? extends JcrConfiguration> definition = this.repositoryDefinitions.get(name);
        if (definition == null) {
            definition = new RepositoryBuilder<JcrConfiguration>(returnObject, this.changes(), this.path(), ModeShapeLexicon.REPOSITORIES, this.name(name));
            this.repositoryDefinitions.put(name, definition);
        }
        return definition;
    }

    protected class RepositoryBuilder<ReturnType>
    extends ModeShapeConfiguration.GraphReturnable<ReturnType, RepositoryDefinition<ReturnType>>
    implements RepositoryDefinition<ReturnType> {
        private final EnumMap<JcrRepository.Option, String> optionValues;

        protected RepositoryBuilder(ReturnType returnObject, Graph.Batch batch, Path path, Name ... names) {
            super(returnObject, batch, path, names);
            this.optionValues = new EnumMap(JcrRepository.Option.class);
            try {
                Path optionsPath = this.context.getValueFactories().getPathFactory().create(path, ModeShapeLexicon.OPTIONS);
                Subgraph options = batch.getGraph().getSubgraphOfDepth(2).at(optionsPath);
                for (Location optionChild : options.getRoot().getChildren()) {
                    Object option = options.getNode(optionChild);
                    Property property = option.getProperty(ModeShapeLexicon.VALUE);
                    if (property == null || !property.isEmpty()) continue;
                    try {
                        JcrRepository.Option key = JcrRepository.Option.findOption(optionChild.getPath().getLastSegment().getString(this.context.getNamespaceRegistry()));
                        String value = this.context.getValueFactories().getStringFactory().create(property.getFirstValue());
                        this.optionValues.put(key, value);
                    }
                    catch (IllegalArgumentException e) {}
                }
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
        }

        @Override
        protected RepositoryDefinition<ReturnType> thisType() {
            return this;
        }

        @Override
        public RepositoryDefinition<ReturnType> setSource(String sourceName) {
            this.setProperty(ModeShapeLexicon.SOURCE_NAME, (Object)sourceName);
            return this;
        }

        @Override
        public String getSource() {
            Property property = this.getProperty(ModeShapeLexicon.SOURCE_NAME);
            if (property != null && !property.isEmpty()) {
                return this.context.getValueFactories().getStringFactory().create(property.getFirstValue());
            }
            return null;
        }

        @Override
        public RepositoryDefinition<ReturnType> setOption(JcrRepository.Option option, String value) {
            CheckArg.isNotNull((Object)option, "option");
            CheckArg.isNotNull(value, "value");
            this.createIfMissing(ModeShapeLexicon.OPTIONS, option.name()).with(ModeShapeLexicon.VALUE, value.trim()).and();
            this.optionValues.put(option, value);
            return this;
        }

        @Override
        public RepositoryDefinition<ReturnType> setOption(JcrRepository.Option option, boolean value) {
            return this.setOption(option, Boolean.toString(value));
        }

        @Override
        public RepositoryDefinition<ReturnType> setOption(JcrRepository.Option option, int value) {
            return this.setOption(option, Integer.toString(value));
        }

        @Override
        public RepositoryDefinition<ReturnType> setOption(JcrRepository.Option option, long value) {
            return this.setOption(option, Long.toString(value));
        }

        @Override
        public RepositoryDefinition<ReturnType> setOption(JcrRepository.Option option, float value) {
            return this.setOption(option, Float.toString(value));
        }

        @Override
        public RepositoryDefinition<ReturnType> setOption(JcrRepository.Option option, double value) {
            return this.setOption(option, Double.toString(value));
        }

        @Override
        public String getOption(JcrRepository.Option option) {
            CheckArg.isNotNull((Object)option, "option");
            return this.optionValues.get((Object)option);
        }

        @Override
        public RepositoryDefinition<ReturnType> registerNamespace(String prefix, String uri) {
            CheckArg.isNotEmpty(prefix, "prefix");
            CheckArg.isNotEmpty(uri, "uri");
            prefix = prefix.trim();
            uri = uri.trim();
            this.createIfMissing(ModeShapeLexicon.NAMESPACES, prefix).with(ModeShapeLexicon.URI, uri).and();
            return this;
        }

        @Override
        public RepositoryDefinition<ReturnType> addNodeTypes(String pathToCndFile) {
            CheckArg.isNotEmpty(pathToCndFile, "pathToCndFile");
            return this.addNodeTypes(new File(pathToCndFile));
        }

        @Override
        public RepositoryDefinition<ReturnType> setInitialContent(String path, String firstWorkspace, String ... otherWorkspaces) {
            CheckArg.isNotEmpty(path, "path");
            path = path.trim();
            File file = new File(path);
            return this.setInitialContent(file, firstWorkspace, otherWorkspaces);
        }

        @Override
        public RepositoryDefinition<ReturnType> setInitialContent(File file, String firstWorkspace, String ... otherWorkspaces) {
            CheckArg.isNotNull(file, "file");
            CheckArg.isNotEmpty(firstWorkspace, "firstWorkspace");
            String workspaces = firstWorkspace.trim();
            if (otherWorkspaces.length != 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(workspaces);
                for (String other : otherWorkspaces) {
                    if (other == null || (other = other.trim()).length() == 0) continue;
                    sb.append(',').append(other);
                }
                workspaces = sb.toString();
            }
            this.createIfMissing(ModeShapeLexicon.INITIAL_CONTENT).with(ModeShapeLexicon.WORKSPACES, workspaces).and(ModeShapeLexicon.CONTENT, file.getAbsolutePath()).and();
            return this;
        }

        @Override
        public RepositoryDefinition<ReturnType> addNodeTypes(File file) {
            CheckArg.isNotNull(file, "file");
            if (file.exists() && file.canRead()) {
                CndImporter importer = this.createCndImporter();
                try {
                    Set<NamespaceRegistry.Namespace> namespacesBefore = this.batch.getGraph().getContext().getNamespaceRegistry().getNamespaces();
                    importer.importFrom(file, JcrConfiguration.this.getProblems());
                    this.registerNewNamespaces(namespacesBefore);
                }
                catch (IOException e) {
                    throw new ModeShapeConfigurationException(e);
                }
                return this;
            }
            throw new ModeShapeConfigurationException(JcrI18n.fileDoesNotExist.text(file.getPath()));
        }

        @Override
        public RepositoryDefinition<ReturnType> addNodeTypes(URL url) {
            CheckArg.isNotNull(url, "url");
            InputStream stream = null;
            boolean foundError = false;
            try {
                Set<NamespaceRegistry.Namespace> namespacesBefore = this.batch.getGraph().getContext().getNamespaceRegistry().getNamespaces();
                stream = url.openStream();
                CndImporter importer = this.createCndImporter();
                importer.importFrom(stream, JcrConfiguration.this.getProblems(), url.toString());
                if (JcrConfiguration.this.getProblems().hasErrors()) {
                    for (Problem problem : JcrConfiguration.this.getProblems()) {
                        if (problem.getStatus() != Problem.Status.ERROR) continue;
                        throw new ModeShapeConfigurationException(problem.getThrowable());
                    }
                }
                this.registerNewNamespaces(namespacesBefore);
            }
            catch (IOException e) {
                foundError = true;
                throw new ModeShapeConfigurationException(e);
            }
            finally {
                block13: {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            if (foundError) break block13;
                            throw new ModeShapeConfigurationException(e);
                        }
                    }
                }
            }
            return this;
        }

        @Override
        public RepositoryDefinition<ReturnType> addNodeTypes(InputStream cndContent) {
            CndImporter importer = this.createCndImporter();
            try {
                Set<NamespaceRegistry.Namespace> namespacesBefore = this.batch.getGraph().getContext().getNamespaceRegistry().getNamespaces();
                importer.importFrom(cndContent, JcrConfiguration.this.getProblems(), "stream");
                this.registerNewNamespaces(namespacesBefore);
            }
            catch (IOException e) {
                throw new ModeShapeConfigurationException(e);
            }
            return this;
        }

        protected void registerNewNamespaces(Set<NamespaceRegistry.Namespace> namespacesBefore) {
            Set<NamespaceRegistry.Namespace> namespacesAfter = this.batch.getGraph().getContext().getNamespaceRegistry().getNamespaces();
            HashSet<NamespaceRegistry.Namespace> newNamespaces = new HashSet<NamespaceRegistry.Namespace>(namespacesAfter);
            newNamespaces.removeAll(namespacesBefore);
            for (NamespaceRegistry.Namespace namespace : newNamespaces) {
                this.registerNamespace(namespace.getPrefix(), namespace.getNamespaceUri());
            }
        }

        protected CndImporter createCndImporter() {
            Path nodeTypesPath = this.subpath(JcrLexicon.NODE_TYPES);
            this.createIfMissing(JcrLexicon.NODE_TYPES).and();
            GraphBatchDestination destination = new GraphBatchDestination(this.batch, true);
            return new CndImporter(destination, nodeTypesPath);
        }
    }

    public static interface RepositoryDefinition<ReturnType>
    extends ModeShapeConfiguration.Returnable<ReturnType>,
    ModeShapeConfiguration.Removable<ReturnType>,
    ModeShapeConfiguration.SetDescription<RepositoryDefinition<ReturnType>> {
        public RepositoryDefinition<ReturnType> setSource(String var1);

        public String getSource();

        public String getName();

        public RepositoryDefinition<ReturnType> setOption(JcrRepository.Option var1, String var2);

        public RepositoryDefinition<ReturnType> setOption(JcrRepository.Option var1, boolean var2);

        public RepositoryDefinition<ReturnType> setOption(JcrRepository.Option var1, int var2);

        public RepositoryDefinition<ReturnType> setOption(JcrRepository.Option var1, long var2);

        public RepositoryDefinition<ReturnType> setOption(JcrRepository.Option var1, float var2);

        public RepositoryDefinition<ReturnType> setOption(JcrRepository.Option var1, double var2);

        public String getOption(JcrRepository.Option var1);

        public RepositoryDefinition<ReturnType> addNodeTypes(String var1);

        public RepositoryDefinition<ReturnType> addNodeTypes(File var1);

        public RepositoryDefinition<ReturnType> addNodeTypes(URL var1);

        public RepositoryDefinition<ReturnType> addNodeTypes(InputStream var1);

        public RepositoryDefinition<ReturnType> registerNamespace(String var1, String var2);

        public RepositoryDefinition<ReturnType> setInitialContent(String var1, String var2, String ... var3);

        public RepositoryDefinition<ReturnType> setInitialContent(File var1, String var2, String ... var3);
    }
}

