/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;

class JcrGraph
extends Graph {
    private ExecutionContext context = super.getContext();

    public static JcrGraph create(String sourceName, RepositoryConnectionFactory connectionFactory, ExecutionContext context) {
        return new JcrGraph(sourceName, connectionFactory, context);
    }

    public static JcrGraph create(final RepositoryConnection connection, ExecutionContext context) {
        CheckArg.isNotNull(connection, "connection");
        final String connectorSourceName = connection.getSourceName();
        RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

            @Override
            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                if (connectorSourceName.equals(sourceName)) {
                    return connection;
                }
                return null;
            }
        };
        return new JcrGraph(connectorSourceName, connectionFactory, context);
    }

    public static JcrGraph create(final RepositorySource source, ExecutionContext context) {
        CheckArg.isNotNull(source, "source");
        final String connectorSourceName = source.getName();
        RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

            @Override
            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                if (connectorSourceName.equals(sourceName)) {
                    return source.getConnection();
                }
                return null;
            }
        };
        return new JcrGraph(connectorSourceName, connectionFactory, context);
    }

    protected JcrGraph(String sourceName, RepositoryConnectionFactory connectionFactory, ExecutionContext context) {
        super(sourceName, connectionFactory, context);
    }

    @Override
    public ExecutionContext getContext() {
        return this.context;
    }

    void setContext(ExecutionContext context) {
        this.context = context;
    }
}

