/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.jcr.JcrGraph;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSystemObserver;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.WorkspaceLockManager;

@ThreadSafe
class RepositoryLockManager
implements JcrSystemObserver {
    private static final Logger LOGGER = Logger.getLogger(RepositoryLockManager.class);
    private final JcrRepository repository;
    private final ConcurrentMap<String, WorkspaceLockManager> lockManagers;
    private final Path locksPath;

    RepositoryLockManager(JcrRepository repository) {
        this.repository = repository;
        ExecutionContext executionContext = repository.getExecutionContext();
        PathFactory pathFactory = executionContext.getValueFactories().getPathFactory();
        this.lockManagers = new ConcurrentHashMap<String, WorkspaceLockManager>();
        this.locksPath = pathFactory.create(pathFactory.createRootPath(), JcrLexicon.SYSTEM, ModeShapeLexicon.LOCKS);
        if (this.locksPath != null) {
            Property locksPrimaryType = executionContext.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.LOCKS);
            repository.createSystemGraph(executionContext).create(this.locksPath, locksPrimaryType).ifAbsent().and();
        }
    }

    WorkspaceLockManager getLockManager(String workspaceName) {
        assert (workspaceName != null);
        WorkspaceLockManager lockManager = (WorkspaceLockManager)this.lockManagers.get(workspaceName);
        if (lockManager != null) {
            return lockManager;
        }
        ExecutionContext executionContext = this.repository.getExecutionContext();
        lockManager = new WorkspaceLockManager(executionContext, this, workspaceName, this.locksPath);
        WorkspaceLockManager newLockManager = this.lockManagers.putIfAbsent(workspaceName, lockManager);
        if (newLockManager != null) {
            return newLockManager;
        }
        return lockManager;
    }

    JcrGraph createSystemGraph(ExecutionContext context) {
        return this.repository.createSystemGraph(context);
    }

    JcrGraph createWorkspaceGraph(String workspaceName, ExecutionContext workspaceContext) {
        return this.repository.createWorkspaceGraph(workspaceName, workspaceContext);
    }

    void cleanUpLocks() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(JcrI18n.cleaningUpLocks.text(new Object[0]), new Object[0]);
        }
        Set<JcrSession> activeSessions = this.repository.activeSessions();
        HashSet<String> activeSessionIds = new HashSet<String>(activeSessions.size());
        for (JcrSession activeSession : activeSessions) {
            activeSessionIds.add(activeSession.sessionId());
        }
        ExecutionContext executionContext = this.repository.getExecutionContext();
        JcrGraph systemGraph = this.createSystemGraph(executionContext);
        PathFactory pathFactory = executionContext.getValueFactories().getPathFactory();
        ValueFactory<Boolean> booleanFactory = executionContext.getValueFactories().getBooleanFactory();
        ValueFactory<String> stringFactory = executionContext.getValueFactories().getStringFactory();
        DateTimeFactory dateFactory = executionContext.getValueFactories().getDateFactory();
        DateTime now = dateFactory.create();
        DateTime newExpirationDate = now.plusMillis(60000);
        Path locksPath = pathFactory.createAbsolutePath(JcrLexicon.SYSTEM, ModeShapeLexicon.LOCKS);
        Subgraph locksGraph = null;
        try {
            locksGraph = systemGraph.getSubgraphOfDepth(2).at(locksPath);
        }
        catch (PathNotFoundException pnfe) {
            return;
        }
        for (Location lockLocation : locksGraph.getRoot().getChildren()) {
            Object lockNode = locksGraph.getNode(lockLocation);
            Boolean isSessionScoped = booleanFactory.create(lockNode.getProperty(ModeShapeLexicon.IS_SESSION_SCOPED).getFirstValue());
            if (!isSessionScoped.booleanValue()) continue;
            String lockingSession = stringFactory.create(lockNode.getProperty(ModeShapeLexicon.LOCKING_SESSION).getFirstValue());
            if (activeSessionIds.contains(lockingSession)) {
                ((Graph.SetValuesTo)systemGraph.set(ModeShapeLexicon.EXPIRATION_DATE).on(lockLocation)).to(newExpirationDate);
                continue;
            }
            DateTime expirationDate = (DateTime)dateFactory.create(lockNode.getProperty(ModeShapeLexicon.EXPIRATION_DATE).getFirstValue());
            if (!expirationDate.isBefore(now)) continue;
            String workspaceName = stringFactory.create(lockNode.getProperty(ModeShapeLexicon.WORKSPACE).getFirstValue());
            WorkspaceLockManager lockManager = (WorkspaceLockManager)this.lockManagers.get(workspaceName);
            lockManager.unlock(executionContext, lockManager.createLock((Node)lockNode));
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(JcrI18n.cleanedUpLocks.text(new Object[0]), new Object[0]);
        }
    }

    @Override
    public Path getObservedPath() {
        return this.locksPath;
    }

    @Override
    public void notify(Changes changes) {
        block4: for (ChangeRequest change : changes.getChangeRequests()) {
            assert (change.changedLocation().hasPath());
            Path changedPath = change.changedLocation().getPath();
            if (changedPath.equals(this.locksPath)) continue;
            assert (this.locksPath.isAncestorOf(changedPath));
            Path.Segment rawUuid = changedPath.getLastSegment();
            UUID lockedNodeUuid = UUID.fromString(this.string(rawUuid));
            assert (lockedNodeUuid != null);
            switch (change.getType()) {
                case CREATE_NODE: {
                    CreateNodeRequest create = (CreateNodeRequest)change;
                    Property workspaceNameProp = null;
                    Property lockOwnerProp = null;
                    Property lockUuidProp = null;
                    Property isDeepProp = null;
                    Property isSessionScopedProp = null;
                    for (Property prop : create.properties()) {
                        if (JcrLexicon.LOCK_OWNER.equals(prop.getName())) {
                            lockOwnerProp = prop;
                            continue;
                        }
                        if (JcrLexicon.LOCK_IS_DEEP.equals(prop.getName())) {
                            isDeepProp = prop;
                            continue;
                        }
                        if (ModeShapeLexicon.IS_HELD_BY_SESSION.equals(prop.getName())) {
                            isSessionScopedProp = prop;
                            continue;
                        }
                        if (JcrLexicon.UUID.equals(prop.getName())) {
                            isSessionScopedProp = prop;
                            continue;
                        }
                        if (!ModeShapeLexicon.WORKSPACE.equals(prop.getName())) continue;
                        workspaceNameProp = prop;
                    }
                    String lockOwner = this.firstString(lockOwnerProp);
                    String workspaceName = this.firstString(workspaceNameProp);
                    UUID lockUuid = this.firstUuid(lockUuidProp);
                    boolean isDeep = this.firstBoolean(isDeepProp);
                    boolean isSessionScoped = this.firstBoolean(isSessionScopedProp);
                    WorkspaceLockManager workspaceManager = this.getLockManager(workspaceName);
                    assert (workspaceManager != null);
                    workspaceManager.lockNodeInternally(lockOwner, lockUuid, lockedNodeUuid, isDeep, isSessionScoped);
                    continue block4;
                }
                case DELETE_BRANCH: {
                    boolean success = false;
                    for (WorkspaceLockManager workspaceLockManager : this.lockManagers.values()) {
                        if (workspaceLockManager.lockFor(lockedNodeUuid) == null) continue;
                        success |= workspaceLockManager.unlockNodeInternally(lockedNodeUuid);
                        break;
                    }
                    assert (success) : "No internal lock existed for node " + lockedNodeUuid.toString();
                    continue block4;
                }
            }
            assert (false) : "Unexpected change request: " + change;
        }
    }

    private final String string(Path.Segment rawString) {
        ExecutionContext context = this.repository.getExecutionContext();
        return context.getValueFactories().getStringFactory().create(rawString);
    }

    private final String firstString(Property property) {
        if (property == null) {
            return null;
        }
        Object firstValue = property.getFirstValue();
        ExecutionContext context = this.repository.getExecutionContext();
        return context.getValueFactories().getStringFactory().create(firstValue);
    }

    private final UUID firstUuid(Property property) {
        if (property == null) {
            return null;
        }
        Object firstValue = property.getFirstValue();
        ExecutionContext context = this.repository.getExecutionContext();
        return (UUID)context.getValueFactories().getUuidFactory().create(firstValue);
    }

    private final boolean firstBoolean(Property property) {
        if (property == null) {
            return false;
        }
        Object firstValue = property.getFirstValue();
        ExecutionContext context = this.repository.getExecutionContext();
        return context.getValueFactories().getBooleanFactory().create(firstValue);
    }
}

