/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.plan.PlanHints;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.jcr.query.JcrQueryContext;
import org.modeshape.jcr.query.JcrQueryResult;
import org.modeshape.jcr.query.JcrSqlQueryResult;
import org.modeshape.jcr.query.XPathQueryResult;
import org.modeshape.jcr.query.qom.JcrAbstractQuery;
import org.modeshape.jcr.query.qom.JcrLiteral;

@NotThreadSafe
public class JcrQuery
extends JcrAbstractQuery {
    private QueryCommand query;
    private final PlanHints hints;
    private final Map<String, Object> variables;

    public JcrQuery(JcrQueryContext context, String statement, String language, QueryCommand query, PlanHints hints, Path storedAtPath) {
        super(context, statement, language, storedAtPath);
        assert (query != null);
        this.query = query;
        this.hints = hints;
        this.variables = new HashMap<String, Object>();
    }

    protected QueryCommand query() {
        return this.query;
    }

    public QueryCommand getAbstractQueryModel() {
        return this.query;
    }

    public QueryResult execute() throws RepositoryException {
        this.context.isLive();
        Schemata schemata = this.context.getSchemata();
        QueryResults result = this.context.execute(this.query, this.hints, this.variables);
        this.checkForProblems(result.getProblems());
        if ("xpath".equals(this.language)) {
            return new XPathQueryResult(this.context, this.statement, result, schemata);
        }
        if ("sql".equals(this.language)) {
            return new JcrSqlQueryResult(this.context, this.statement, result, schemata);
        }
        return new JcrQueryResult(this.context, this.statement, result, schemata);
    }

    public String toString() {
        return this.language + " -> " + this.statement + "\n" + StringUtil.createString(' ', Math.min(this.language.length() - 3, 0)) + "AQM -> " + this.query;
    }

    public void bindValue(String varName, Value value) throws IllegalArgumentException, RepositoryException {
        CheckArg.isNotNull(varName, "varName");
        CheckArg.isNotNull(value, "value");
        this.variables.put(varName, JcrLiteral.rawValue(value));
    }

    public String[] getBindVariableNames() {
        Set<String> keys = this.variables.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public void setLimit(long limit) {
        if (limit > Integer.MAX_VALUE) {
            limit = Integer.MAX_VALUE;
        }
        this.query = this.query.withLimit((int)limit);
    }

    public void setOffset(long offset) {
        if (offset > Integer.MAX_VALUE) {
            offset = Integer.MAX_VALUE;
        }
        this.query = this.query.withOffset((int)offset);
    }
}

