/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.PrintStream;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.MockitoAnnotations;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.MockSecurityContext;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.observe.MockObservable;
import org.modeshape.graph.observe.Observable;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSecurityContextCredentials;
import org.modeshape.jcr.JcrSession;

public abstract class AbstractJcrAccessTest {
    private InMemoryRepositorySource source;
    private JcrSession session;
    private JcrRepository repository;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        String workspaceName = "workspace1";
        this.source = new InMemoryRepositorySource();
        this.source.setName(workspaceName);
        this.source.setDefaultWorkspaceName(workspaceName);
        ExecutionContext context = new ExecutionContext();
        context.getNamespaceRegistry().register("modetest", "http://www.modeshape.org/test/1.0");
        RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                return AbstractJcrAccessTest.this.source.getConnection();
            }
        };
        this.repository = new JcrRepository(context, connectionFactory, "unused", (Observable)new MockObservable(), null, null, null, null);
        MockSecurityContext mockSecurityContext = new MockSecurityContext("testuser", Collections.singleton("readwrite"));
        this.session = (JcrSession)this.repository.login((Credentials)new JcrSecurityContextCredentials((SecurityContext)mockSecurityContext));
    }

    @After
    public void after() throws Exception {
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
        }
    }

    protected JcrSession session() {
        return this.session;
    }

    private String getRandomString(int length) {
        StringBuffer buff = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            buff.append((char)(Math.random() * 26.0 + 97.0));
        }
        return buff.toString();
    }

    private int createChildren(Node parent, int numProperties, int width, int depth) throws Exception {
        if (depth < 1) {
            return 0;
        }
        int count = width;
        for (int i = 0; i < width; ++i) {
            Node newNode = parent.addNode(this.getRandomString(9), "nt:unstructured");
            for (int j = 0; j < numProperties; ++j) {
                newNode.setProperty(this.getRandomString(8), this.getRandomString(16));
            }
            count += this.createChildren(newNode, numProperties, width, depth - 1);
        }
        return count;
    }

    protected int createSubgraph(JcrSession session, String initialPath, int depth, int numberOfChildrenPerNode, int numberOfPropertiesPerNode, boolean oneBatch, Stopwatch stopwatch, PrintStream output, String description) throws Exception {
        long totalNumber = this.calculateTotalNumberOfNodesInTree(numberOfChildrenPerNode, depth, false);
        if (initialPath == null) {
            initialPath = "";
        }
        if (description == null) {
            description = "" + numberOfChildrenPerNode + "x" + depth + " tree with " + numberOfPropertiesPerNode + " properties per node";
        }
        if (output != null) {
            output.println(description + " (" + totalNumber + " nodes):");
        }
        long totalNumberCreated = 0L;
        PathFactory pathFactory = session.getExecutionContext().getValueFactories().getPathFactory();
        AbstractJcrNode parentNode = session.getNode((Path)pathFactory.create(initialPath));
        if (stopwatch != null) {
            stopwatch.start();
        }
        Assert.assertThat((Object)(totalNumberCreated += (long)this.createChildren((Node)parentNode, numberOfPropertiesPerNode, numberOfChildrenPerNode, depth)), (Matcher)Is.is((Object)totalNumber));
        session.save();
        if (stopwatch != null) {
            stopwatch.stop();
            if (output != null) {
                output.println("    " + this.getTotalAndAverageDuration(stopwatch, totalNumberCreated));
            }
        }
        return (int)totalNumberCreated;
    }

    protected int traverseSubgraph(JcrSession session, String initialPath, int depth, int numberOfChildrenPerNode, int numberOfPropertiesPerNode, boolean oneBatch, Stopwatch stopwatch, PrintStream output, String description) throws Exception {
        long totalNumber = this.calculateTotalNumberOfNodesInTree(numberOfChildrenPerNode, depth, false);
        if (initialPath == null) {
            initialPath = "";
        }
        if (description == null) {
            description = "" + numberOfChildrenPerNode + "x" + depth + " tree with " + numberOfPropertiesPerNode + " properties per node";
        }
        if (output != null) {
            output.println(description + " (" + totalNumber + " nodes):");
        }
        long totalNumberTraversed = 0L;
        PathFactory pathFactory = session.getExecutionContext().getValueFactories().getPathFactory();
        AbstractJcrNode parentNode = session.getNode((Path)pathFactory.create(initialPath));
        if (stopwatch != null) {
            stopwatch.start();
        }
        Assert.assertThat((Object)(totalNumberTraversed += (long)this.traverseChildren((Node)parentNode)), (Matcher)Is.is((Object)totalNumber));
        session.save();
        if (stopwatch != null) {
            stopwatch.stop();
            if (output != null) {
                output.println("    " + this.getTotalAndAverageDuration(stopwatch, totalNumberTraversed));
            }
        }
        return (int)totalNumberTraversed;
    }

    protected int traverseChildren(Node parentNode) throws Exception {
        int childCount = 0;
        NodeIterator children = parentNode.getNodes();
        while (children.hasNext()) {
            ++childCount;
            childCount += this.traverseChildren(children.nextNode());
        }
        return childCount;
    }

    protected String getTotalAndAverageDuration(Stopwatch stopwatch, long numNodes) {
        long totalDurationInMilliseconds = TimeUnit.NANOSECONDS.toMillis(stopwatch.getTotalDuration().longValue());
        if (numNodes == 0L) {
            numNodes = 1L;
        }
        long avgDuration = totalDurationInMilliseconds / numNodes;
        String units = " millisecond(s)";
        if (avgDuration < 1L) {
            long totalDurationInMicroseconds = TimeUnit.NANOSECONDS.toMicros(stopwatch.getTotalDuration().longValue());
            avgDuration = totalDurationInMicroseconds / numNodes;
            units = " microsecond(s)";
        }
        return "total = " + stopwatch.getTotalDuration() + "; avg = " + avgDuration + units;
    }

    protected int calculateTotalNumberOfNodesInTree(int numberOfChildrenPerNode, int depth, boolean countRoot) {
        assert (depth > 0);
        assert (numberOfChildrenPerNode > 0);
        int totalNumber = 0;
        for (int i = 0; i <= depth; ++i) {
            totalNumber += (int)Math.pow(numberOfChildrenPerNode, i);
        }
        return countRoot ? totalNumber : totalNumber - 1;
    }
}

