/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.HashMap;
import java.util.UUID;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeDefinition;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrTest;
import org.modeshape.jcr.CorrespondenceId;
import org.modeshape.jcr.JcrLockManager;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrPropertyDefinitionTemplate;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.RepositoryLockManager;
import org.modeshape.jcr.SessionCache;
import org.modeshape.jcr.WorkspaceLockManager;
import org.modeshape.jcr.nodetype.NodeDefinitionTemplate;
import org.modeshape.jcr.nodetype.NodeTypeTemplate;

public class AbstractJcrNodeTest
extends AbstractJcrTest {
    private static final String ID_PATH = "[" + UUID.randomUUID() + "]";
    private AbstractJcrNode rootNode;
    private AbstractJcrNode cars;
    private AbstractJcrNode hybrid;
    private AbstractJcrNode prius;
    private AbstractJcrNode highlander;
    private AbstractJcrNode altima;

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.rootNode = this.cache.findJcrRootNode();
        this.cars = this.cache.findJcrNode(null, this.path("/Cars"));
        this.hybrid = this.cache.findJcrNode(null, this.path("/Cars/Hybrid"));
        this.prius = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Toyota Prius"));
        this.highlander = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Toyota Highlander"));
        this.altima = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
    }

    @Test
    public void shouldAllowVisitation() throws Exception {
        ItemVisitor visitor = (ItemVisitor)Mockito.mock(ItemVisitor.class);
        this.hybrid.accept(visitor);
        ((ItemVisitor)Mockito.verify((Object)visitor)).visit((Node)this.hybrid);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowVisitationIfNoVisitor() throws Exception {
        this.hybrid.accept(null);
    }

    @Test(expected=ItemNotFoundException.class)
    public void shouldNotAllowNegativeAncestorDepth() throws Exception {
        this.hybrid.getAncestor(-1);
    }

    @Test
    public void shouldReturnRootForAncestorOfDepthZero() throws Exception {
        Assert.assertThat((Object)this.hybrid.getAncestor(0), (Matcher)Is.is((Object)this.rootNode));
    }

    @Test
    public void shouldReturnAncestorAtLevelOneForAncestorOfDepthOne() throws Exception {
        Assert.assertThat((Object)this.hybrid.getAncestor(1), (Matcher)Is.is((Object)this.cars));
    }

    @Test
    public void shouldReturnSelfForAncestorOfDepthEqualToDepthOfNode() throws Exception {
        Assert.assertThat((Object)this.hybrid.getAncestor(this.hybrid.getDepth()), (Matcher)Is.is((Object)this.hybrid));
    }

    @Test(expected=ItemNotFoundException.class)
    public void shouldFailToReturnAncestorWhenDepthIsGreaterThanNodeDepth() throws Exception {
        this.hybrid.getAncestor(this.hybrid.getDepth() + 1);
    }

    @Test
    public void shouldIndicateIsNode() {
        Assert.assertThat((Object)this.prius.isNode(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnPropertyFromGetPropertyWithValidName() throws Exception {
        Property property = this.prius.getProperty("vehix:model");
        Assert.assertThat((Object)property, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"vehix:model"));
        Assert.assertThat((Object)property.getString(), (Matcher)Is.is((Object)"Prius"));
    }

    @Test
    public void shouldReturnPropertyFromGetPropertyWithValidRelativePath() throws Exception {
        Property property = this.prius.getProperty("./vehix:model");
        Assert.assertThat((Object)property, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"vehix:model"));
        Assert.assertThat((Object)property.getString(), (Matcher)Is.is((Object)"Prius"));
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldFailToReturnPropertyFromGetPropertyWithNameOfPropertyThatDoesNotExist() throws Exception {
        this.prius.getProperty("nonExistantProperty");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToReturnPropertyFromGetPropertyWithAbsolutePath() throws Exception {
        this.prius.getProperty("/test");
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldFailToReturnPropertyFromGetPropertyWithRelativePathToNonExistantItem() throws Exception {
        this.prius.getProperty("../bogus/path");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToReturnPropertyFromGetPropertyWithIdentifierPath() throws Exception {
        this.prius.getProperty(ID_PATH);
    }

    @Test
    public void shouldReturnPropertyFromGetPropertyWithRelativePathToPropertyOnOtherNode() throws Exception {
        Property property = this.prius.getProperty("../Nissan Altima/vehix:model");
        Assert.assertThat((Object)property, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"vehix:model"));
        Assert.assertThat((Object)property.getString(), (Matcher)Is.is((Object)"Altima"));
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldReturnPropertyFromGetPropertyWithRelativePathToOtherNode() throws Exception {
        this.prius.getProperty("../Nissan Altima");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowGetPropertyWithNullPath() throws Exception {
        this.prius.getProperty((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowGetPropertyWithEmptyPath() throws Exception {
        this.prius.getProperty("");
    }

    @Test
    public void shouldReturnTrueFromHasPropertyWithValidName() throws Exception {
        Assert.assertThat((Object)this.prius.hasProperty("vehix:model"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnTrueFromHasPropertyWithValidRelativePath() throws Exception {
        Assert.assertThat((Object)this.prius.hasProperty("./vehix:model"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnFalseFromHasPropertyWithNameOfPropertyThatDoesNotExist() throws Exception {
        Assert.assertThat((Object)this.prius.hasProperty("non-existant"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnFalseFromHasPropertyWithRelativePathToNonExistantItem() throws Exception {
        Assert.assertThat((Object)this.prius.hasProperty("../Nissan Altima/non-existant"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnTrueFromHasPropertyWithRelativePathToPropertyOnOtherNode() throws Exception {
        Assert.assertThat((Object)this.prius.hasProperty("../Nissan Altima/vehix:model"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnFalseFromHasPropertyWithRelativePathToOtherNode() throws Exception {
        Assert.assertThat((Object)this.prius.hasProperty("../Nissan Altima"), (Matcher)Is.is((Object)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowHasNodeWithIdentifierPath() throws Exception {
        this.prius.hasNode(ID_PATH);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowHasNodeWithAbsolutePath() throws Exception {
        this.prius.hasNode("/something");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowHasPropertyWithAbsolutePath() throws Exception {
        this.prius.hasProperty("/Cars/Hybrid/Toyota Prius/vehix:model");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowHasPropertyWithNullPath() throws Exception {
        this.prius.hasProperty((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowHasPropertyWithEmptyPath() throws Exception {
        this.prius.hasProperty("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowHasPropertyWithIdentifierPath() throws Exception {
        this.prius.hasProperty(ID_PATH);
    }

    @Test
    public void shouldReturnFalseFromHasPropertyIfPathIsParentPath() throws Exception {
        Assert.assertThat((Object)this.prius.hasProperty(".."), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnFalseFromHasPropertyIfPathIsSelfPath() throws Exception {
        Assert.assertThat((Object)this.prius.hasProperty("."), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnTrueFromHasPropertiesIfNodeHasAtLeastOneProperty() throws Exception {
        Assert.assertThat((Object)this.prius.hasProperties(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnFalseFromHasPropertiesIfNodeHasNoProperties() throws Exception {
    }

    @Test
    public void shouldReturnChildNodeFromGetNodeWithValidName() throws Exception {
        Assert.assertThat((Object)this.hybrid.getNode("Toyota Prius"), (Matcher)Is.is((Object)this.prius));
        Assert.assertThat((Object)this.hybrid.getNode("Toyota Prius"), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.prius)));
    }

    @Test
    public void shouldReturnNonChildNodeFromGetNodeWithValidRelativePath() throws Exception {
        Assert.assertThat((Object)this.altima.getNode("../Toyota Prius"), (Matcher)Is.is((Object)this.prius));
        Assert.assertThat((Object)this.altima.getNode("../Toyota Prius"), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.prius)));
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldFailToReturnNodeFromGetNodeWithValidRelativePathToProperty() throws Exception {
        this.altima.getNode("../Toyota Prius/vehix:model");
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldFailToReturnNodeFromGetNodeWithValidRelativePathToNoNodeOrProperty() throws Exception {
        this.altima.getNode("../../nonExistant");
    }

    @Test
    public void shouldReturnSelfFromGetNodeWithRelativePathContainingOnlySelfReference() throws Exception {
        Assert.assertThat((Object)this.hybrid.getNode("."), (Matcher)Is.is((Object)this.hybrid));
        Assert.assertThat((Object)this.hybrid.getNode("."), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.hybrid)));
    }

    @Test
    public void shouldReturnSelfFromGetNodeWithRelativePathResolvingToSelf() throws Exception {
        Assert.assertThat((Object)this.hybrid.getNode("Toyota Prius/.."), (Matcher)Is.is((Object)this.hybrid));
        Assert.assertThat((Object)this.hybrid.getNode("Toyota Prius/.."), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.hybrid)));
    }

    @Test
    public void shouldReturnParentFromGetNodeWithRelativePathContainingOnlyParentReference() throws Exception {
        Assert.assertThat((Object)this.prius.getNode("../.."), (Matcher)Is.is((Object)this.cars));
        Assert.assertThat((Object)this.prius.getNode("../.."), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.cars)));
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldFailToReturnChildNodeFromGetNodeWithNameOfChildThatDoesNotExist() throws Exception {
        this.altima.getNode("nonExistant");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowGetNodeWithNoPath() throws Exception {
        this.prius.getNode((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowGetNodeWithIdentifierPath() throws Exception {
        this.prius.getNode(ID_PATH);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowGetNodeWithAbsolutePath() throws Exception {
        this.prius.getNode("/something");
    }

    @Test
    public void shouldProvideNodeIterator() throws Exception {
        NodeIterator iter = this.hybrid.getNodes();
        Assert.assertThat((Object)iter, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)iter.getSize(), (Matcher)Is.is((Object)3L));
        Assert.assertThat((Object)iter.next(), (Matcher)Is.is((Object)this.prius));
        Assert.assertThat((Object)iter.next(), (Matcher)Is.is((Object)this.highlander));
        Assert.assertThat((Object)iter.next(), (Matcher)Is.is((Object)this.altima));
        Assert.assertThat((Object)iter.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldProvideFilteredNodeIteratorForPattern() throws Exception {
        NodeIterator iter = this.hybrid.getNodes(" Toyota P*|*lander ");
        Assert.assertThat((Object)iter, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)iter.getSize(), (Matcher)Is.is((Object)2L));
        Assert.assertThat((Object)iter.next(), (Matcher)Is.is((Object)this.prius));
        Assert.assertThat((Object)iter.next(), (Matcher)Is.is((Object)this.highlander));
        Assert.assertThat((Object)iter.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldProvideFilteredNodeIteratorForPatternArray() throws Exception {
        NodeIterator iter = this.hybrid.getNodes(new String[]{" Toyota P*", "*lander"});
        Assert.assertThat((Object)iter, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)iter.getSize(), (Matcher)Is.is((Object)2L));
        Assert.assertThat((Object)iter.next(), (Matcher)Is.is((Object)this.prius));
        Assert.assertThat((Object)iter.next(), (Matcher)Is.is((Object)this.highlander));
        Assert.assertThat((Object)iter.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnEmptyIteratorForEmptyPattern() throws Exception {
        NodeIterator iter = this.hybrid.getNodes("");
        Assert.assertThat((Object)iter, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)iter.getSize(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)iter.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnEmptyIteratorForEmptyPatternArray() throws Exception {
        NodeIterator iter = this.hybrid.getNodes(new String[]{""});
        Assert.assertThat((Object)iter, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)iter.getSize(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)iter.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldProvidePropertyIterator() throws Exception {
        Assert.assertThat((Object)this.prius.getProperties(), (Matcher)IsNull.notNullValue());
        HashMap<String, Property> properties = new HashMap<String, Property>();
        PropertyIterator iter = this.prius.getProperties();
        while (iter.hasNext()) {
            Property prop = iter.nextProperty();
            properties.put(prop.getName(), prop);
        }
        Assert.assertThat((Object)properties.size(), (Matcher)Is.is((Object)9));
        Assert.assertThat((Object)((Property)properties.get("vehix:maker")).getString(), (Matcher)Is.is((Object)"Toyota"));
        Assert.assertThat((Object)((Property)properties.get("vehix:model")).getString(), (Matcher)Is.is((Object)"Prius"));
        Assert.assertThat((Object)((Property)properties.get("vehix:year")).getString(), (Matcher)Is.is((Object)"2008"));
        Assert.assertThat((Object)((Property)properties.get("vehix:msrp")).getString(), (Matcher)Is.is((Object)"$21,500"));
        Assert.assertThat((Object)((Property)properties.get("vehix:userRating")).getString(), (Matcher)Is.is((Object)"4.2"));
        Assert.assertThat((Object)((Property)properties.get("vehix:valueRating")).getString(), (Matcher)Is.is((Object)"5"));
        Assert.assertThat((Object)((Property)properties.get("vehix:mpgCity")).getString(), (Matcher)Is.is((Object)"48"));
        Assert.assertThat((Object)((Property)properties.get("vehix:mpgHighway")).getString(), (Matcher)Is.is((Object)"45"));
        Assert.assertThat((Object)((Property)properties.get("jcr:primaryType")).getString(), (Matcher)Is.is((Object)"vehix:car"));
        Assert.assertThat((Object)this.prius.isNodeType(JcrMixLexicon.REFERENCEABLE), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldProvidePropertyIteratorForPattern() throws Exception {
        String pattern = "vehix:ma*|vehix:mo*";
        Assert.assertThat((Object)this.prius.getProperties(pattern), (Matcher)IsNull.notNullValue());
        HashMap<String, Property> properties = new HashMap<String, Property>();
        PropertyIterator iter = this.prius.getProperties(pattern);
        while (iter.hasNext()) {
            Property prop = iter.nextProperty();
            properties.put(prop.getName(), prop);
        }
        Assert.assertThat((Object)properties.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)((Property)properties.get("vehix:maker")).getString(), (Matcher)Is.is((Object)"Toyota"));
        Assert.assertThat((Object)((Property)properties.get("vehix:model")).getString(), (Matcher)Is.is((Object)"Prius"));
    }

    @Test
    public void shouldProvideEmptyPropertyIteratorForEmptyPattern() throws Exception {
        String pattern = "";
        Assert.assertThat((Object)this.prius.getProperties(pattern), (Matcher)IsNull.notNullValue());
        HashMap<String, Property> properties = new HashMap<String, Property>();
        PropertyIterator iter = this.prius.getProperties(pattern);
        while (iter.hasNext()) {
            Property prop = iter.nextProperty();
            properties.put(prop.getName(), prop);
        }
        Assert.assertThat((Object)properties.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldProvidePropertyIteratorForPatternArray() throws Exception {
        String[] pattern = new String[]{"vehix:ma*", "vehix:mo*"};
        Assert.assertThat((Object)this.prius.getProperties(pattern), (Matcher)IsNull.notNullValue());
        HashMap<String, Property> properties = new HashMap<String, Property>();
        PropertyIterator iter = this.prius.getProperties(pattern);
        while (iter.hasNext()) {
            Property prop = iter.nextProperty();
            properties.put(prop.getName(), prop);
        }
        Assert.assertThat((Object)properties.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)((Property)properties.get("vehix:maker")).getString(), (Matcher)Is.is((Object)"Toyota"));
        Assert.assertThat((Object)((Property)properties.get("vehix:model")).getString(), (Matcher)Is.is((Object)"Prius"));
    }

    @Test
    public void shouldProvideEmptyPropertyIteratorForEmptyPatternArray() throws Exception {
        String[] pattern = new String[]{""};
        Assert.assertThat((Object)this.prius.getProperties(pattern), (Matcher)IsNull.notNullValue());
        HashMap<String, Property> properties = new HashMap<String, Property>();
        PropertyIterator iter = this.prius.getProperties(pattern);
        while (iter.hasNext()) {
            Property prop = iter.nextProperty();
            properties.put(prop.getName(), prop);
        }
        Assert.assertThat((Object)properties.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnTrueFromHasNodeWithValidName() throws Exception {
        Assert.assertThat((Object)this.hybrid.hasNode("Toyota Prius"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnTrueFromHasNodeWithValidRelativePath() throws Exception {
        Assert.assertThat((Object)this.altima.hasNode("../Toyota Prius"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnFalseFromHasNodeWithValidRelativePathToProperty() throws Exception {
        Assert.assertThat((Object)this.altima.hasNode("../Toyota Prius/vehix:model"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnFalseFromHasNodeWithWithValidRelativePathToNoNodeOrProperty() throws Exception {
        Assert.assertThat((Object)this.altima.hasNode("../../nonExistant"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.altima.hasNode("../nonExistant"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.altima.hasNode("nonExistant"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnTrueFromHasNodeWithRelativePathContainingOnlySelfReference() throws Exception {
        Assert.assertThat((Object)this.hybrid.hasNode("."), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnTrueFromHasNodeWithRelativePathResolvingToSelf() throws Exception {
        Assert.assertThat((Object)this.hybrid.hasNode("Toyota Prius/.."), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnTrueFromHasNodeWithRelativePathContainingOnlyParentReference() throws Exception {
        Assert.assertThat((Object)this.prius.hasNode("../.."), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnFalseFromHasNodeWithNameOfChildThatDoesNotExist() throws Exception {
        Assert.assertThat((Object)this.altima.hasNode("nonExistant"), (Matcher)Is.is((Object)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowHasNodeWithNoPath() throws Exception {
        this.prius.hasNode(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAbsolutePathInHasNode() throws Exception {
        this.cars.hasNode("/a/b/c");
    }

    @Test
    public void shouldReturnTrueFromHasNodesIfThereIsAtLeastOneChild() throws Exception {
        Assert.assertThat((Object)this.hybrid.hasNodes(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnFalseFromHasNodesIfThereAreNoChildren() throws Exception {
        Assert.assertThat((Object)this.prius.hasNodes(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=LockException.class)
    public void shouldNotAllowGetLockIfNoLock() throws Exception {
        this.hybrid.getLock();
    }

    @Test
    public void shouldTreatNonVersionableNodesAsCheckedOut() throws Exception {
        Assert.assertThat((Object)this.hybrid.isCheckedOut(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotAllowIsLocked() throws Exception {
        Assert.assertThat((Object)this.hybrid.isLocked(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowOrderBeforeWithNullArgs() throws Exception {
        this.hybrid.orderBefore(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowOrderBeforeWithIdentifierPathAsFirstParameter() throws Exception {
        this.hybrid.orderBefore(ID_PATH, "/something");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowOrderBeforeWithIdentifierPathAsSecondParameter() throws Exception {
        this.hybrid.orderBefore("/something", ID_PATH);
    }

    @Test
    public void shouldReturnItemFromGetPrimaryNodeType() throws Exception {
        JcrNodeType carType = this.nodeTypes.getNodeType("vehix:car");
        Assert.assertThat((Object)carType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.prius.getPrimaryNodeType(), (Matcher)Is.is((Object)carType));
    }

    @Test
    public void shouldReturnItemFromGetPrimaryItemIfItExists() throws Exception {
        JcrNodeType carType = this.nodeTypes.getNodeType("vehix:car");
        Assert.assertThat((Object)carType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)carType.getPrimaryItemName(), (Matcher)Is.is((Object)"vehix:model"));
        Assert.assertThat((Object)this.prius.getPrimaryItem(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.prius.getProperty("vehix:model"))));
    }

    @Test(expected=ItemNotFoundException.class)
    public void shouldFailToReturnItemFromGetPrimaryItemIfPrimaryTypeDoesNotHavePrimaryItemName() throws Exception {
        JcrNodeType ntUnstructured = this.nodeTypes.getNodeType("nt:unstructured");
        Assert.assertThat((Object)ntUnstructured, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)ntUnstructured.getPrimaryItemName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.cars.getPrimaryItem();
    }

    @Test(expected=ItemNotFoundException.class)
    public void shouldFailToReturnItemFromGetPrimaryItemIfTheNodeHasNoItemMatchingThatSpecifiedByThePrimaryType() throws Exception {
        JcrNodeType carType = this.nodeTypes.getNodeType("vehix:car");
        Assert.assertThat((Object)carType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)carType.getPrimaryItemName(), (Matcher)Is.is((Object)"vehix:model"));
        Assert.assertThat((Object)this.prius.getPrimaryItem(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.prius.getProperty("vehix:model"))));
        this.prius.getProperty("vehix:model").remove();
        this.prius.getPrimaryItem();
    }

    @Test
    public void shouldProvideSession() throws Exception {
        Assert.assertThat((Object)((JcrSession)this.prius.getSession()), (Matcher)Is.is((Object)this.jcrSession));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowIsSameWithNoItem() throws Exception {
        this.hybrid.isSame(null);
    }

    @Test
    public void shouldReturnFalseFromIsSameIfTheRepositoryInstanceIsDifferent() throws Exception {
        InMemoryRepositorySource source2 = new InMemoryRepositorySource();
        source2.setName("store");
        Graph store2 = Graph.create((RepositorySource)source2, (ExecutionContext)context);
        store2.importXmlFrom(AbstractJcrTest.class.getClassLoader().getResourceAsStream("cars.xml")).into("/");
        JcrSession jcrSession2 = (JcrSession)Mockito.mock(JcrSession.class);
        Mockito.when((Object)jcrSession2.nodeTypeManager()).thenReturn((Object)this.nodeTypes);
        Mockito.when((Object)jcrSession2.isLive()).thenReturn((Object)true);
        SessionCache cache2 = new SessionCache(jcrSession2, store2.getCurrentWorkspaceName(), context, this.nodeTypes, store2);
        Workspace workspace2 = (Workspace)Mockito.mock(Workspace.class);
        Repository repository2 = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)jcrSession2.getWorkspace()).thenReturn((Object)workspace2);
        Mockito.when((Object)jcrSession2.getRepository()).thenReturn((Object)repository2);
        Mockito.when((Object)workspace2.getName()).thenReturn((Object)"workspace1");
        AbstractJcrNode prius2 = cache2.findJcrNode(null, this.path("/Cars/Hybrid/Toyota Prius"));
        Assert.assertThat((Object)prius2.isSame((Item)this.prius), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnFalseFromIsSameIfTheWorkspaceNameIsDifferent() throws Exception {
        InMemoryRepositorySource source2 = new InMemoryRepositorySource();
        source2.setName("store");
        Graph store2 = Graph.create((RepositorySource)source2, (ExecutionContext)context);
        store2.importXmlFrom(AbstractJcrTest.class.getClassLoader().getResourceAsStream("cars.xml")).into("/");
        JcrSession jcrSession2 = (JcrSession)Mockito.mock(JcrSession.class);
        Mockito.when((Object)jcrSession2.nodeTypeManager()).thenReturn((Object)this.nodeTypes);
        Mockito.when((Object)jcrSession2.isLive()).thenReturn((Object)true);
        SessionCache cache2 = new SessionCache(jcrSession2, store2.getCurrentWorkspaceName(), context, this.nodeTypes, store2);
        Workspace workspace2 = (Workspace)Mockito.mock(Workspace.class);
        JcrRepository repository2 = (JcrRepository)Mockito.mock(JcrRepository.class);
        RepositoryLockManager repoLockManager2 = (RepositoryLockManager)Mockito.mock(RepositoryLockManager.class);
        Mockito.when((Object)jcrSession2.getWorkspace()).thenReturn((Object)workspace2);
        Mockito.when((Object)jcrSession2.getRepository()).thenReturn((Object)repository2);
        Mockito.when((Object)workspace2.getName()).thenReturn((Object)"workspace2");
        WorkspaceLockManager lockManager = new WorkspaceLockManager(context, repoLockManager2, "workspace2", null);
        JcrLockManager jcrLockManager = new JcrLockManager(jcrSession2, lockManager);
        Mockito.when((Object)jcrSession2.lockManager()).thenReturn((Object)jcrLockManager);
        AbstractJcrNode prius2 = cache2.findJcrNode(null, this.path("/Cars/Hybrid/Toyota Prius"));
        prius2.addMixin("mix:referenceable");
        this.prius.addMixin("mix:referenceable");
        String priusUuid2 = prius2.getIdentifier();
        String priusUuid = this.prius.getIdentifier();
        Assert.assertThat((Object)priusUuid, (Matcher)Is.is((Object)priusUuid2));
        Assert.assertThat((Object)prius2.isSame((Item)this.prius), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnFalseFromIsSameIfTheNodeUuidIsDifferent() throws Exception {
        InMemoryRepositorySource source2 = new InMemoryRepositorySource();
        source2.setName("store");
        Graph store2 = Graph.create((RepositorySource)source2, (ExecutionContext)context);
        store2.importXmlFrom(AbstractJcrTest.class.getClassLoader().getResourceAsStream("cars.xml")).into("/");
        JcrSession jcrSession2 = (JcrSession)Mockito.mock(JcrSession.class);
        Mockito.when((Object)jcrSession2.nodeTypeManager()).thenReturn((Object)this.nodeTypes);
        Mockito.when((Object)jcrSession2.isLive()).thenReturn((Object)true);
        SessionCache cache2 = new SessionCache(jcrSession2, store2.getCurrentWorkspaceName(), context, this.nodeTypes, store2);
        Workspace workspace2 = (Workspace)Mockito.mock(Workspace.class);
        JcrRepository repository2 = (JcrRepository)Mockito.mock(JcrRepository.class);
        RepositoryLockManager repoLockManager2 = (RepositoryLockManager)Mockito.mock(RepositoryLockManager.class);
        Mockito.when((Object)jcrSession2.getWorkspace()).thenReturn((Object)workspace2);
        Mockito.when((Object)jcrSession2.getRepository()).thenReturn((Object)repository2);
        Mockito.when((Object)workspace2.getName()).thenReturn((Object)"workspace1");
        WorkspaceLockManager lockManager = new WorkspaceLockManager(context, repoLockManager2, "workspace2", null);
        JcrLockManager jcrLockManager = new JcrLockManager(jcrSession2, lockManager);
        Mockito.when((Object)jcrSession2.lockManager()).thenReturn((Object)jcrLockManager);
        AbstractJcrNode altima2 = cache2.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
        altima2.addMixin("mix:referenceable");
        this.altima.addMixin("mix:referenceable");
        String altimaUuid = this.altima.getIdentifier();
        String altimaUuid2 = altima2.getIdentifier();
        Assert.assertThat((Object)altimaUuid, (Matcher)Is.is((Matcher)IsNot.not((Object)altimaUuid2)));
        Assert.assertThat((Object)altima2.isSame((Item)this.altima), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnTrueFromIsSameIfTheNodeUuidAndWorkspaceNameAndRepositoryInstanceAreSame() throws Exception {
        InMemoryRepositorySource source2 = new InMemoryRepositorySource();
        source2.setName("store");
        Graph store2 = Graph.create((RepositorySource)source2, (ExecutionContext)context);
        store2.importXmlFrom(AbstractJcrTest.class.getClassLoader().getResourceAsStream("cars.xml")).into("/");
        JcrSession jcrSession2 = (JcrSession)Mockito.mock(JcrSession.class);
        Mockito.when((Object)jcrSession2.nodeTypeManager()).thenReturn((Object)this.nodeTypes);
        Mockito.when((Object)jcrSession2.isLive()).thenReturn((Object)true);
        SessionCache cache2 = new SessionCache(jcrSession2, store2.getCurrentWorkspaceName(), context, this.nodeTypes, store2);
        Workspace workspace2 = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)jcrSession2.getWorkspace()).thenReturn((Object)workspace2);
        Mockito.when((Object)jcrSession2.getRepository()).thenReturn((Object)repository);
        Mockito.when((Object)workspace2.getName()).thenReturn((Object)"workspace1");
        WorkspaceLockManager lockManager = new WorkspaceLockManager(context, repository.getRepositoryLockManager(), "workspace1", null);
        JcrLockManager jcrLockManager = new JcrLockManager(jcrSession2, lockManager);
        Mockito.when((Object)jcrSession2.lockManager()).thenReturn((Object)jcrLockManager);
        AbstractJcrNode prius2 = cache2.findJcrNode(null, this.path("/Cars/Hybrid/Toyota Prius"));
        prius2.addMixin("mix:referenceable");
        this.prius.addMixin("mix:referenceable");
        String priusUuid = this.prius.getIdentifier();
        String priusUuid2 = prius2.getIdentifier();
        Assert.assertThat((Object)priusUuid, (Matcher)Is.is((Object)priusUuid2));
        Assert.assertThat((Object)prius2.isSame((Item)this.prius), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAlwaysHaveCorrespondenceIdForRootNodeThatContainsSelfPath() throws Exception {
        CorrespondenceId id = this.rootNode.getCorrespondenceId();
        Assert.assertThat((Object)id.getReferenceableId(), (Matcher)Is.is((Object)this.rootNode.getIdentifier()));
        Assert.assertThat((Object)id.getRelativePath().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)id.getRelativePath().getLastSegment().isSelfReference(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAlwaysHaveCorrespondenceId() throws Exception {
        Assert.assertThat((Object)this.cars.isReferenceable(), (Matcher)Is.is((Object)false));
        CorrespondenceId id = this.cars.getCorrespondenceId();
        Assert.assertThat((Object)id.getReferenceableId(), (Matcher)Is.is((Object)this.rootNode.getIdentifier()));
        Assert.assertThat((Object)id.getRelativePath().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)id.getRelativePath(), (Matcher)Is.is((Object)this.path("Cars")));
        Assert.assertThat((Object)this.hybrid.isReferenceable(), (Matcher)Is.is((Object)false));
        id = this.hybrid.getCorrespondenceId();
        Assert.assertThat((Object)id.getReferenceableId(), (Matcher)Is.is((Object)this.rootNode.getIdentifier()));
        Assert.assertThat((Object)id.getRelativePath().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)id.getRelativePath(), (Matcher)Is.is((Object)this.path("Cars/Hybrid")));
        this.altima.addMixin("mix:referenceable");
        Assert.assertThat((Object)this.altima.isReferenceable(), (Matcher)Is.is((Object)true));
        id = this.altima.getCorrespondenceId();
        Assert.assertThat((Object)id.getReferenceableId(), (Matcher)Is.is((Object)this.altima.getIdentifier()));
        Assert.assertThat((Object)id.getRelativePath().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)id.getRelativePath(), (Matcher)Is.is((Object)this.path(".")));
    }

    @Test
    public void shouldAddNodeWhenIntermediateNodesDoExist() throws Exception {
        Node newNode = this.rootNode.addNode("Cars/Hybrid/CreateThis", "nt:unstructured");
        Assert.assertThat((Object)newNode.getName(), (Matcher)Is.is((Object)"CreateThis"));
        Assert.assertThat((Object)newNode.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.hybrid)));
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldFailToAddNodeWhenIntermediateNodesDoNotExist() throws Exception {
        this.rootNode.addNode("Cars/nonExistant/CreateThis", "nt:unstructured");
    }

    private void registerTestNodeType() throws Exception {
        try {
            this.nodeTypes.getNodeType("autocreateTest");
            return;
        }
        catch (NoSuchNodeTypeException nsnte) {
            NodeTypeTemplate ntt = this.nodeTypes.createNodeTypeTemplate();
            JcrPropertyDefinitionTemplate pdt = (JcrPropertyDefinitionTemplate)this.nodeTypes.createPropertyDefinitionTemplate();
            NodeDefinitionTemplate ndt = this.nodeTypes.createNodeDefinitionTemplate();
            pdt.setName("autoProp");
            pdt.setRequiredType(1);
            pdt.setDefaultValues(new String[]{"default"});
            pdt.setAutoCreated(true);
            ndt.setName("autoChild");
            ndt.setRequiredPrimaryTypeNames(new String[]{"nt:base"});
            ndt.setDefaultPrimaryTypeName("nt:unstructured");
            ndt.setAutoCreated(true);
            ntt.setName("autocreateTest");
            ntt.getNodeDefinitionTemplates().add(ndt);
            ntt.getPropertyDefinitionTemplates().add(pdt);
            this.nodeTypes.registerNodeType((NodeTypeDefinition)ntt, false);
            return;
        }
    }

    @Test
    public void shouldAddAutocreatedPropertiesForNode() throws Exception {
        this.registerTestNodeType();
        Node testNode = this.rootNode.addNode("autoPropTest", "autocreateTest");
        Assert.assertThat((Object)testNode.hasProperty("autoProp"), (Matcher)Is.is((Object)true));
        Property autoProp = testNode.getProperty("autoProp");
        Assert.assertThat((Object)autoProp.getString(), (Matcher)Is.is((Object)"default"));
    }

    @Test
    public void shouldAddAutocreatedChildNodesForNode() throws Exception {
        this.registerTestNodeType();
        Node testNode = this.rootNode.addNode("autoChildTest", "autocreateTest");
        Assert.assertThat((Object)testNode.hasNode("autoChild"), (Matcher)Is.is((Object)true));
        Node autoProp = testNode.getNode("autoChild");
        Assert.assertThat((Object)autoProp.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"nt:unstructured"));
    }
}

