/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.Workspace;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.AbstractJcrTest;
import org.modeshape.jcr.JcrLockManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.RepositoryLockManager;
import org.modeshape.jcr.SessionCache;
import org.modeshape.jcr.Vehicles;
import org.modeshape.jcr.WorkspaceLockManager;

public class AbstractJcrPropertyTest
extends AbstractJcrTest {
    protected AbstractJcrNode rootNode;
    protected AbstractJcrNode cars;
    protected AbstractJcrNode prius;
    protected AbstractJcrNode altima;
    protected AbstractJcrProperty altimaModel;

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.rootNode = this.cache.findJcrRootNode();
        this.cars = this.cache.findJcrNode(null, this.path("/Cars"));
        this.prius = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Toyota Prius"));
        this.altima = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
        this.altimaModel = this.cache.findJcrProperty(this.altima.nodeId, this.altima.path(), Vehicles.Lexicon.MODEL);
    }

    @Test
    public void shouldAllowVisitation() throws Exception {
        ItemVisitor visitor = (ItemVisitor)Mockito.mock(ItemVisitor.class);
        this.altimaModel.accept(visitor);
        ((ItemVisitor)Mockito.verify((Object)visitor)).visit((Property)this.altimaModel);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowVisitationIfNoVisitor() throws Exception {
        this.altimaModel.accept(null);
    }

    @Test(expected=ItemNotFoundException.class)
    public void shouldNotAllowNegativeAncestorDepth() throws Exception {
        this.altimaModel.getAncestor(-1);
    }

    @Test
    public void shouldReturnRootForAncestorOfDepthZero() throws Exception {
        Assert.assertThat((Object)this.altimaModel.getAncestor(0), (Matcher)Is.is((Object)this.rootNode));
    }

    @Test
    public void shouldReturnAncestorAtLevelOneForAncestorOfDepthOne() throws Exception {
        Assert.assertThat((Object)this.altimaModel.getAncestor(1), (Matcher)Is.is((Object)this.cars));
    }

    @Test
    public void shouldReturnSelfForAncestorOfDepthEqualToDepthOfNode() throws Exception {
        Assert.assertThat((Object)this.altimaModel.getAncestor(this.altimaModel.getDepth()), (Matcher)Is.is((Object)this.altimaModel));
        Assert.assertThat((Object)this.altimaModel.getAncestor(this.altimaModel.getDepth() - 1), (Matcher)Is.is((Object)this.altima));
    }

    @Test(expected=ItemNotFoundException.class)
    public void shouldFailToReturnAncestorWhenDepthIsGreaterThanNodeDepth() throws Exception {
        this.altimaModel.getAncestor(40);
    }

    @Test
    public void shouldIndicateIsNotNode() {
        Assert.assertThat((Object)this.altimaModel.isNode(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldProvideExecutionContext() throws Exception {
        Assert.assertThat((Object)this.altimaModel.context(), (Matcher)Is.is((Object)context));
    }

    @Test
    public void shouldProvideName() throws Exception {
        Assert.assertThat((Object)this.altimaModel.getName(), (Matcher)Is.is((Object)"vehix:model"));
    }

    @Test
    public void shouldProvideParent() throws Exception {
        Assert.assertThat((Object)this.altimaModel.getParent(), (Matcher)Is.is((Object)this.altima));
    }

    @Test
    public void shouldProvidePath() throws Exception {
        Assert.assertThat((Object)this.altimaModel.getPath(), (Matcher)Is.is((Object)(this.altima.getPath() + "/vehix:model")));
    }

    @Test
    public void shouldProvideSession() throws Exception {
        Assert.assertThat((Object)this.altimaModel.getSession(), (Matcher)Is.is((Object)this.jcrSession));
    }

    @Test
    public void shouldReturnFalseFromIsSameIfTheRepositoryInstanceIsDifferent() throws Exception {
        InMemoryRepositorySource source2 = new InMemoryRepositorySource();
        source2.setName("store");
        Graph store2 = Graph.create((RepositorySource)source2, (ExecutionContext)context);
        store2.importXmlFrom(AbstractJcrTest.class.getClassLoader().getResourceAsStream("cars.xml")).into("/");
        JcrSession jcrSession2 = (JcrSession)Mockito.mock(JcrSession.class);
        Mockito.when((Object)jcrSession2.nodeTypeManager()).thenReturn((Object)this.nodeTypes);
        Mockito.when((Object)jcrSession2.isLive()).thenReturn((Object)true);
        SessionCache cache2 = new SessionCache(jcrSession2, store2.getCurrentWorkspaceName(), context, this.nodeTypes, store2);
        Workspace workspace2 = (Workspace)Mockito.mock(Workspace.class);
        Repository repository2 = (Repository)Mockito.mock(JcrRepository.class);
        Mockito.when((Object)jcrSession2.getWorkspace()).thenReturn((Object)workspace2);
        Mockito.when((Object)jcrSession2.getRepository()).thenReturn((Object)repository2);
        Mockito.when((Object)workspace2.getName()).thenReturn((Object)"workspace1");
        AbstractJcrNode prius2 = cache2.findJcrNode(null, this.path("/Cars/Hybrid/Toyota Prius"));
        Assert.assertThat((Object)prius2.isSame((Item)this.prius), (Matcher)Is.is((Object)false));
        Property model = this.prius.getProperty("vehix:model");
        Property model2 = prius2.getProperty("vehix:model");
        Assert.assertThat((Object)model.isSame((Item)model2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnFalseFromIsSameIfTheWorkspaceNameIsDifferent() throws Exception {
        InMemoryRepositorySource source2 = new InMemoryRepositorySource();
        source2.setName("store");
        Graph store2 = Graph.create((RepositorySource)source2, (ExecutionContext)context);
        store2.importXmlFrom(AbstractJcrTest.class.getClassLoader().getResourceAsStream("cars.xml")).into("/");
        JcrSession jcrSession2 = (JcrSession)Mockito.mock(JcrSession.class);
        Mockito.when((Object)jcrSession2.nodeTypeManager()).thenReturn((Object)this.nodeTypes);
        Mockito.when((Object)jcrSession2.isLive()).thenReturn((Object)true);
        SessionCache cache2 = new SessionCache(jcrSession2, store2.getCurrentWorkspaceName(), context, this.nodeTypes, store2);
        Workspace workspace2 = (Workspace)Mockito.mock(Workspace.class);
        JcrRepository repository2 = (JcrRepository)Mockito.mock(JcrRepository.class);
        RepositoryLockManager repoLockManager2 = (RepositoryLockManager)Mockito.mock(RepositoryLockManager.class);
        Mockito.when((Object)jcrSession2.getWorkspace()).thenReturn((Object)workspace2);
        Mockito.when((Object)jcrSession2.getRepository()).thenReturn((Object)repository2);
        Mockito.when((Object)workspace2.getName()).thenReturn((Object)"workspace2");
        WorkspaceLockManager lockManager = new WorkspaceLockManager(context, repoLockManager2, "workspace2", null);
        JcrLockManager jcrLockManager = new JcrLockManager(jcrSession2, lockManager);
        Mockito.when((Object)jcrSession2.lockManager()).thenReturn((Object)jcrLockManager);
        AbstractJcrNode prius2 = cache2.findJcrNode(null, this.path("/Cars/Hybrid/Toyota Prius"));
        prius2.addMixin("mix:referenceable");
        this.prius.addMixin("mix:referenceable");
        String priusUuid2 = prius2.getIdentifier();
        String priusUuid = this.prius.getIdentifier();
        Assert.assertThat((Object)priusUuid, (Matcher)Is.is((Object)priusUuid2));
        Assert.assertThat((Object)prius2.isSame((Item)this.prius), (Matcher)Is.is((Object)false));
        Property model = this.prius.getProperty("vehix:model");
        Property model2 = prius2.getProperty("vehix:model");
        Assert.assertThat((Object)model.isSame((Item)model2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnFalseFromIsSameIfTheNodeUuidIsDifferent() throws Exception {
        InMemoryRepositorySource source2 = new InMemoryRepositorySource();
        source2.setName("store");
        Graph store2 = Graph.create((RepositorySource)source2, (ExecutionContext)context);
        store2.importXmlFrom(AbstractJcrTest.class.getClassLoader().getResourceAsStream("cars.xml")).into("/");
        JcrSession jcrSession2 = (JcrSession)Mockito.mock(JcrSession.class);
        Mockito.when((Object)jcrSession2.nodeTypeManager()).thenReturn((Object)this.nodeTypes);
        Mockito.when((Object)jcrSession2.isLive()).thenReturn((Object)true);
        SessionCache cache2 = new SessionCache(jcrSession2, store2.getCurrentWorkspaceName(), context, this.nodeTypes, store2);
        Workspace workspace2 = (Workspace)Mockito.mock(Workspace.class);
        JcrRepository repository2 = (JcrRepository)Mockito.mock(JcrRepository.class);
        RepositoryLockManager repoLockManager2 = (RepositoryLockManager)Mockito.mock(RepositoryLockManager.class);
        Mockito.when((Object)jcrSession2.getWorkspace()).thenReturn((Object)workspace2);
        Mockito.when((Object)jcrSession2.getRepository()).thenReturn((Object)repository2);
        Mockito.when((Object)workspace2.getName()).thenReturn((Object)"workspace1");
        WorkspaceLockManager lockManager = new WorkspaceLockManager(context, repoLockManager2, "workspace2", null);
        JcrLockManager jcrLockManager = new JcrLockManager(jcrSession2, lockManager);
        Mockito.when((Object)jcrSession2.lockManager()).thenReturn((Object)jcrLockManager);
        AbstractJcrNode altima2 = cache2.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
        altima2.addMixin("mix:referenceable");
        this.altima.addMixin("mix:referenceable");
        String altimaUuid = this.altima.getIdentifier();
        String altimaUuid2 = altima2.getIdentifier();
        Assert.assertThat((Object)altimaUuid, (Matcher)Is.is((Matcher)IsNot.not((Object)altimaUuid2)));
        Assert.assertThat((Object)altima2.isSame((Item)this.altima), (Matcher)Is.is((Object)false));
        Property model = this.altima.getProperty("vehix:model");
        Property model2 = altima2.getProperty("vehix:model");
        Assert.assertThat((Object)model.isSame((Item)model2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnTrueFromIsSameIfTheNodeUuidAndWorkspaceNameAndRepositoryInstanceAreSame() throws Exception {
        InMemoryRepositorySource source2 = new InMemoryRepositorySource();
        source2.setName("store");
        Graph store2 = Graph.create((RepositorySource)source2, (ExecutionContext)context);
        store2.importXmlFrom(AbstractJcrTest.class.getClassLoader().getResourceAsStream("cars.xml")).into("/");
        JcrSession jcrSession2 = (JcrSession)Mockito.mock(JcrSession.class);
        Mockito.when((Object)jcrSession2.nodeTypeManager()).thenReturn((Object)this.nodeTypes);
        Mockito.when((Object)jcrSession2.isLive()).thenReturn((Object)true);
        SessionCache cache2 = new SessionCache(jcrSession2, store2.getCurrentWorkspaceName(), context, this.nodeTypes, store2);
        Workspace workspace2 = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)jcrSession2.getWorkspace()).thenReturn((Object)workspace2);
        Mockito.when((Object)jcrSession2.getRepository()).thenReturn((Object)repository);
        Mockito.when((Object)workspace2.getName()).thenReturn((Object)"workspace1");
        WorkspaceLockManager lockManager = new WorkspaceLockManager(context, repoLockManager, "workspace2", null);
        JcrLockManager jcrLockManager = new JcrLockManager(jcrSession2, lockManager);
        Mockito.when((Object)jcrSession2.lockManager()).thenReturn((Object)jcrLockManager);
        AbstractJcrNode prius2 = cache2.findJcrNode(null, this.path("/Cars/Hybrid/Toyota Prius"));
        prius2.addMixin("mix:referenceable");
        this.prius.addMixin("mix:referenceable");
        String priusUuid = this.prius.getIdentifier();
        String priusUuid2 = prius2.getIdentifier();
        Assert.assertThat((Object)priusUuid, (Matcher)Is.is((Object)priusUuid2));
        Assert.assertThat((Object)prius2.isSame((Item)this.prius), (Matcher)Is.is((Object)true));
        Property model = this.prius.getProperty("vehix:model");
        Property model2 = prius2.getProperty("vehix:model");
        Property year2 = prius2.getProperty("vehix:year");
        Assert.assertThat((Object)model.isSame((Item)model2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)model.isSame((Item)year2), (Matcher)Is.is((Object)false));
    }
}

