/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JaasTestUtil;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;

public class AccessRolesTest {
    private JcrEngine engine;
    private Repository repository;
    private Session session;

    @BeforeClass
    public static void beforeAll() {
        JaasTestUtil.initJaas("security/jaas.conf.xml");
    }

    @AfterClass
    public static void afterAll() {
        JaasTestUtil.releaseJaas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            try {
                this.session.logout();
            }
            finally {
                this.session = null;
            }
        }
        this.repository = null;
        try {
            this.engine.shutdown();
        }
        finally {
            this.engine = null;
        }
    }

    @Test
    public void shouldLogInAsAnonymousUsingNoCredentials() throws RepositoryException {
        JcrConfiguration config = new JcrConfiguration();
        config.repositorySource("source").usingClass(InMemoryRepositorySource.class);
        config.repository("repo").setSource("source").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr-non-existant");
        this.engine = config.build();
        this.engine.start();
        this.repository = this.engine.getRepository("repo");
        this.session = this.repository.login();
        this.session.getRootNode().getPath();
        this.session.getRootNode().addNode("someNewNode");
    }

    @Test
    public void shouldLogInAsUserWithReadOnlyRole() throws RepositoryException {
        JcrConfiguration config = new JcrConfiguration();
        config.repositorySource("source").usingClass(InMemoryRepositorySource.class);
        config.repository("repo").setSource("source").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr");
        this.engine = config.build();
        this.engine.start();
        this.repository = this.engine.getRepository("repo");
        this.session = this.repository.login((Credentials)new SimpleCredentials("readonly", "readonly".toCharArray()));
        this.session.getRootNode().getPath();
        this.session.getRootNode().getDefinition();
    }

    @Test
    public void shouldLogInAsUserWithReadWriteRole() throws RepositoryException {
        JcrConfiguration config = new JcrConfiguration();
        config.repositorySource("source").usingClass(InMemoryRepositorySource.class);
        config.repository("repo").setSource("source").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr");
        this.engine = config.build();
        this.engine.start();
        this.repository = this.engine.getRepository("repo");
        this.session = this.repository.login((Credentials)new SimpleCredentials("readwrite", "readwrite".toCharArray()));
        this.session.getRootNode().getPath();
        this.session.getRootNode().getDefinition();
        this.session.getRootNode().addNode("someNewNode");
    }
}

