/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.common.collection.Problem;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.jcr.CndNodeTypeReader;
import org.modeshape.jcr.JackrabbitXmlNodeTypeReader;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.RepositoryNodeTypeManager;

public class JackrabbitXmlNodeTypeRegistrationTest {
    private static final String XML_LOCATION = "/xmlNodeTypeRegistration/";
    private ExecutionContext context;
    private RepositoryNodeTypeManager repoTypeManager;
    private JackrabbitXmlNodeTypeReader factory;
    @Mock
    protected JcrRepository repository;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new ExecutionContext();
        this.context.getNamespaceRegistry().register("modetest", "http://www.modeshape.org/test/1.0");
        Mockito.when((Object)this.repository.getExecutionContext()).thenReturn((Object)this.context);
        this.repoTypeManager = new RepositoryNodeTypeManager(this.repository, null, true, true);
        try {
            CndNodeTypeReader cndFactory = new CndNodeTypeReader(this.context);
            cndFactory.readBuiltInTypes();
            this.repoTypeManager.registerNodeTypes((Iterable)cndFactory);
        }
        catch (RepositoryException re) {
            re.printStackTrace();
            throw new IllegalStateException("Could not load node type definition files", re);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IllegalStateException("Could not access node type definition files", ioe);
        }
        this.factory = new JackrabbitXmlNodeTypeReader(this.context);
    }

    @Test
    public void shouldLoadCustomNodeTypes() throws Exception {
        this.register("/xmlNodeTypeRegistration/custom_nodetypes.xml");
        JcrNodeType nodeType = this.repoTypeManager.getNodeType(this.name("mgnl:metaData"));
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.isAbstract(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isQueryable(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.getPrimaryItemName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[0].getName(), (Matcher)Is.is((Object)"mix:referenceable"));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[1].getName(), (Matcher)Is.is((Object)"nt:hierarchyNode"));
        Assert.assertThat((Object)nodeType.getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)nodeType.getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)1));
        JcrPropertyDefinition property = (JcrPropertyDefinition)nodeType.getDeclaredPropertyDefinitions()[0];
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)property.getRequiredType(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getValueConstraints().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getDefaultValues().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMultiple(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.getOnParentVersion(), (Matcher)Is.is((Object)1));
        nodeType = this.repoTypeManager.getNodeType(this.name("mgnl:content"));
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.isAbstract(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isQueryable(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.getPrimaryItemName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[0].getName(), (Matcher)Is.is((Object)"mix:referenceable"));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[1].getName(), (Matcher)Is.is((Object)"nt:hierarchyNode"));
        Assert.assertThat((Object)nodeType.getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)nodeType.getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)2));
        JcrNodeDefinition childNode = (JcrNodeDefinition)nodeType.getDeclaredChildNodeDefinitions()[0];
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)childNode.getDefaultPrimaryType(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes()[0].getName(), (Matcher)Is.is((Object)"nt:base"));
        Assert.assertThat((Object)childNode.allowsSameNameSiblings(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)childNode.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.getOnParentVersion(), (Matcher)Is.is((Object)1));
        childNode = (JcrNodeDefinition)nodeType.getDeclaredChildNodeDefinitions()[1];
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"MetaData"));
        Assert.assertThat((Object)childNode.getDefaultPrimaryType().getName(), (Matcher)Is.is((Object)"mgnl:metaData"));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes()[0].getName(), (Matcher)Is.is((Object)"mgnl:metaData"));
        Assert.assertThat((Object)childNode.allowsSameNameSiblings(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isAutoCreated(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)childNode.isMandatory(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)childNode.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.getOnParentVersion(), (Matcher)Is.is((Object)1));
        property = (JcrPropertyDefinition)nodeType.getDeclaredPropertyDefinitions()[0];
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)property.getRequiredType(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getValueConstraints().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getDefaultValues().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMultiple(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)property.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.getOnParentVersion(), (Matcher)Is.is((Object)1));
        property = (JcrPropertyDefinition)nodeType.getDeclaredPropertyDefinitions()[1];
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)property.getRequiredType(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getValueConstraints().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getDefaultValues().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMultiple(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.getOnParentVersion(), (Matcher)Is.is((Object)1));
        nodeType = this.repoTypeManager.getNodeType(this.name("mgnl:group"));
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.isAbstract(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isQueryable(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.getPrimaryItemName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[0].getName(), (Matcher)Is.is((Object)"mgnl:content"));
        Assert.assertThat((Object)nodeType.getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)nodeType.getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)0));
        nodeType = this.repoTypeManager.getNodeType(this.name("mgnl:folder"));
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.isAbstract(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isQueryable(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.getPrimaryItemName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[0].getName(), (Matcher)Is.is((Object)"mix:referenceable"));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[1].getName(), (Matcher)Is.is((Object)"nt:folder"));
        Assert.assertThat((Object)nodeType.getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)nodeType.getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)2));
        childNode = (JcrNodeDefinition)nodeType.getDeclaredChildNodeDefinitions()[0];
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)childNode.getDefaultPrimaryType(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes()[0].getName(), (Matcher)Is.is((Object)"nt:base"));
        Assert.assertThat((Object)childNode.allowsSameNameSiblings(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)childNode.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.getOnParentVersion(), (Matcher)Is.is((Object)1));
        childNode = (JcrNodeDefinition)nodeType.getDeclaredChildNodeDefinitions()[1];
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"MetaData"));
        Assert.assertThat((Object)childNode.getDefaultPrimaryType().getName(), (Matcher)Is.is((Object)"mgnl:metaData"));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes()[0].getName(), (Matcher)Is.is((Object)"mgnl:metaData"));
        Assert.assertThat((Object)childNode.allowsSameNameSiblings(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isAutoCreated(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)childNode.isMandatory(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)childNode.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.getOnParentVersion(), (Matcher)Is.is((Object)1));
        property = (JcrPropertyDefinition)nodeType.getDeclaredPropertyDefinitions()[0];
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)property.getRequiredType(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getValueConstraints().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getDefaultValues().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMultiple(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)property.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.getOnParentVersion(), (Matcher)Is.is((Object)1));
        property = (JcrPropertyDefinition)nodeType.getDeclaredPropertyDefinitions()[1];
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)property.getRequiredType(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getValueConstraints().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getDefaultValues().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMultiple(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.getOnParentVersion(), (Matcher)Is.is((Object)1));
        nodeType = this.repoTypeManager.getNodeType(this.name("mgnl:user"));
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.isAbstract(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isQueryable(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.getPrimaryItemName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[0].getName(), (Matcher)Is.is((Object)"mgnl:content"));
        Assert.assertThat((Object)nodeType.getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)nodeType.getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)0));
        nodeType = this.repoTypeManager.getNodeType(this.name("mgnl:resource"));
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.isAbstract(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isQueryable(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.getPrimaryItemName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[0].getName(), (Matcher)Is.is((Object)"nt:resource"));
        Assert.assertThat((Object)nodeType.getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)nodeType.getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)1));
        property = (JcrPropertyDefinition)nodeType.getDeclaredPropertyDefinitions()[0];
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)property.getRequiredType(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getValueConstraints().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getDefaultValues().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMultiple(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.getOnParentVersion(), (Matcher)Is.is((Object)1));
        nodeType = this.repoTypeManager.getNodeType(this.name("mgnl:contentNode"));
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.isAbstract(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isQueryable(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.getPrimaryItemName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[0].getName(), (Matcher)Is.is((Object)"mix:referenceable"));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[1].getName(), (Matcher)Is.is((Object)"nt:hierarchyNode"));
        Assert.assertThat((Object)nodeType.getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)nodeType.getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)2));
        childNode = (JcrNodeDefinition)nodeType.getDeclaredChildNodeDefinitions()[0];
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)childNode.getDefaultPrimaryType(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes()[0].getName(), (Matcher)Is.is((Object)"nt:base"));
        Assert.assertThat((Object)childNode.allowsSameNameSiblings(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)childNode.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.getOnParentVersion(), (Matcher)Is.is((Object)1));
        childNode = (JcrNodeDefinition)nodeType.getDeclaredChildNodeDefinitions()[1];
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"MetaData"));
        Assert.assertThat((Object)childNode.getDefaultPrimaryType().getName(), (Matcher)Is.is((Object)"mgnl:metaData"));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes()[0].getName(), (Matcher)Is.is((Object)"mgnl:metaData"));
        Assert.assertThat((Object)childNode.allowsSameNameSiblings(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isAutoCreated(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)childNode.isMandatory(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)childNode.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.getOnParentVersion(), (Matcher)Is.is((Object)1));
        property = (JcrPropertyDefinition)nodeType.getDeclaredPropertyDefinitions()[0];
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)property.getRequiredType(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getValueConstraints().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getDefaultValues().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMultiple(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)property.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.getOnParentVersion(), (Matcher)Is.is((Object)1));
        property = (JcrPropertyDefinition)nodeType.getDeclaredPropertyDefinitions()[1];
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)property.getRequiredType(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getValueConstraints().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getDefaultValues().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMultiple(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.getOnParentVersion(), (Matcher)Is.is((Object)1));
        nodeType = this.repoTypeManager.getNodeType(this.name("mgnl:role"));
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.isAbstract(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isQueryable(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.getPrimaryItemName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[0].getName(), (Matcher)Is.is((Object)"mgnl:content"));
        Assert.assertThat((Object)nodeType.getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)nodeType.getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)0));
        nodeType = this.repoTypeManager.getNodeType(this.name("mgnl:reserve"));
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.isAbstract(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isQueryable(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.getPrimaryItemName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[0].getName(), (Matcher)Is.is((Object)"nt:hierarchyNode"));
        Assert.assertThat((Object)nodeType.getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)nodeType.getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)1));
        childNode = (JcrNodeDefinition)nodeType.getDeclaredChildNodeDefinitions()[0];
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)childNode.getDefaultPrimaryType(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes()[0].getName(), (Matcher)Is.is((Object)"nt:base"));
        Assert.assertThat((Object)childNode.allowsSameNameSiblings(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)childNode.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.getOnParentVersion(), (Matcher)Is.is((Object)1));
        property = (JcrPropertyDefinition)nodeType.getDeclaredPropertyDefinitions()[0];
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)property.getRequiredType(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getValueConstraints().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getDefaultValues().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMultiple(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.getOnParentVersion(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldLoadMagnoliaForumTypes() throws Exception {
        this.register("/xmlNodeTypeRegistration/magnolia_forum_nodetypes.xml");
    }

    @Test
    public void shouldLoadOwfeNodeTypes() throws Exception {
        this.register("/xmlNodeTypeRegistration/owfe_nodetypes.xml");
        JcrNodeType nodeType = this.repoTypeManager.getNodeType(this.name("workItem"));
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.isAbstract(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isQueryable(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.getPrimaryItemName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[0].getName(), (Matcher)Is.is((Object)"nt:hierarchyNode"));
        Assert.assertThat((Object)nodeType.getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)nodeType.getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)1));
        JcrNodeDefinition childNode = (JcrNodeDefinition)nodeType.getDeclaredChildNodeDefinitions()[0];
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)childNode.getDefaultPrimaryType(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes()[0].getName(), (Matcher)Is.is((Object)"nt:hierarchyNode"));
        Assert.assertThat((Object)childNode.allowsSameNameSiblings(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)childNode.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.getOnParentVersion(), (Matcher)Is.is((Object)2));
        JcrPropertyDefinition property = (JcrPropertyDefinition)nodeType.getDeclaredPropertyDefinitions()[0];
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)property.getRequiredType(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getValueConstraints().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getDefaultValues().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMultiple(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.getOnParentVersion(), (Matcher)Is.is((Object)1));
        nodeType = this.repoTypeManager.getNodeType(this.name("expression"));
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.isAbstract(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.isQueryable(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.getPrimaryItemName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[0].getName(), (Matcher)Is.is((Object)"nt:hierarchyNode"));
        Assert.assertThat((Object)nodeType.getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)nodeType.getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)1));
        childNode = (JcrNodeDefinition)nodeType.getDeclaredChildNodeDefinitions()[0];
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)childNode.getDefaultPrimaryType(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes()[0].getName(), (Matcher)Is.is((Object)"nt:hierarchyNode"));
        Assert.assertThat((Object)childNode.allowsSameNameSiblings(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)childNode.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.getOnParentVersion(), (Matcher)Is.is((Object)2));
        property = (JcrPropertyDefinition)nodeType.getDeclaredPropertyDefinitions()[0];
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)property.getRequiredType(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getValueConstraints().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.getDefaultValues().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)property.isAutoCreated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isMultiple(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.isProtected(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property.getOnParentVersion(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldLoadAllMagnoliaTypes() throws Exception {
        this.register("/xmlNodeTypeRegistration/magnolia_forum_nodetypes.xml", "/xmlNodeTypeRegistration/custom_nodetypes.xml", "/xmlNodeTypeRegistration/owfe_nodetypes.xml");
    }

    @Test(expected=IOException.class)
    public void shouldFailIfResourceFileCouldNotBeFoundOnClasspath() throws Exception {
        this.factory.read("this/resource/file/does/not/exist");
    }

    @Test(expected=IOException.class)
    public void shouldFailIfResourceFileCouldNotBeFoundAsRelativeFile() throws Exception {
        this.factory.read("/this/resource/file/does/not/exist");
    }

    @Test(expected=IOException.class)
    public void shouldFailIfResourceFileCouldNotBeFoundAsUrl() throws Exception {
        this.factory.read("file://this/resource/file/does/not/exist");
    }

    @Test
    public void shouldLoadNodeTypesFromResourceFileFoundOnClasspath() throws Exception {
        this.factory.read("/xmlNodeTypeRegistration/magnolia_forum_nodetypes.xml");
        Assert.assertThat((Object)this.factory.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldLoadNodeTypesFromResourceFileFoundWithRelativePathOnFileSystem() throws Exception {
        this.factory.read("src/test/resources//xmlNodeTypeRegistration/magnolia_forum_nodetypes.xml");
        Assert.assertThat((Object)this.factory.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldLoadNodeTypesFromResourceFileFoundWithAbsolutePathOnFileSystem() throws Exception {
        File file = new File("src/test/resources//xmlNodeTypeRegistration/magnolia_forum_nodetypes.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        this.factory.read(file.getAbsolutePath());
        Assert.assertThat((Object)this.factory.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldLoadNodeTypesFromUrl() throws Exception {
        File file = new File("src/test/resources//xmlNodeTypeRegistration/magnolia_forum_nodetypes.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        URL url = file.toURI().toURL();
        this.factory.read(url.toString());
        Assert.assertThat((Object)this.factory.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    protected List<JcrNodeType> register(String ... resourceNames) throws Exception {
        for (String resourceName : resourceNames) {
            this.factory.read(resourceName);
        }
        if (this.factory.getProblems().hasProblems()) {
            System.out.println("Problems reading node types:" + this.factory);
            for (Problem problem : this.factory.getProblems()) {
                System.out.println(" " + problem);
            }
        }
        Assert.assertThat((Object)this.factory.getProblems().hasProblems(), (Matcher)Is.is((Object)false));
        return this.repoTypeManager.registerNodeTypes(Arrays.asList(this.factory.getNodeTypeDefinitions()));
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }
}

