/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.jcr.JcrPropertyIterator;

public class JcrPropertyIteratorTest {
    private Map<Name, Property> properties;
    private ExecutionContext context;
    private PropertyIterator iter;

    @Before
    public void before() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new ExecutionContext();
        this.properties = new HashMap<Name, Property>();
        this.properties.put(this.name("prop1"), (Property)Mockito.mock(Property.class));
        this.properties.put(this.name("prop2"), (Property)Mockito.mock(Property.class));
        this.properties.put(this.name("prop3"), (Property)Mockito.mock(Property.class));
        this.properties.put(this.name("prop4"), (Property)Mockito.mock(Property.class));
        this.iter = new JcrPropertyIterator(this.properties.values());
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    @Test
    public void shouldProvidePropertyIterator() throws Exception {
        Assert.assertThat((Object)this.iter, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)this.iter.getSize(), (Matcher)Is.is((Object)4L));
        Assert.assertThat((Object)this.iter.getPosition(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)this.iter.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.iter.next(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)this.iter.getPosition(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.iter.hasNext(), (Matcher)Is.is((Object)true));
        this.iter.skip(2L);
        Assert.assertThat((Object)this.iter.getPosition(), (Matcher)Is.is((Object)3L));
        Assert.assertThat((Object)this.iter.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.iter.nextProperty(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)this.iter.getPosition(), (Matcher)Is.is((Object)4L));
        Assert.assertThat((Object)this.iter.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowPropertyIteratorRemove() throws Exception {
        new JcrPropertyIterator(this.properties.values()).remove();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowPropertyIteratorNegativeSkip() throws Exception {
        new JcrPropertyIterator(this.properties.values()).skip(-1L);
    }
}

