/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsArrayContaining;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JaasSecurityContext;
import org.modeshape.graph.MockSecurityContext;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.observe.MockObservable;
import org.modeshape.graph.observe.Observable;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.CndNodeTypeReader;
import org.modeshape.jcr.JaasTestUtil;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSecurityContextCredentials;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;

public class JcrRepositoryTest {
    private String sourceName;
    private ExecutionContext context;
    private JcrRepository repository;
    private InMemoryRepositorySource source;
    private Map<String, String> descriptors;
    private RepositoryConnectionFactory connectionFactory;
    private Credentials credentials;
    private Graph sourceGraph;
    private Graph systemGraph;
    private JcrSession session;

    @BeforeClass
    public static void beforeAll() {
        JaasTestUtil.initJaas("security/jaas.conf.xml");
    }

    @AfterClass
    public static void afterAll() {
        JaasTestUtil.releaseJaas();
    }

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.sourceName = "repository";
        this.source = new InMemoryRepositorySource();
        this.source.setName(this.sourceName);
        this.context = new ExecutionContext();
        this.credentials = new SimpleCredentials("superuser", "superuser".toCharArray());
        this.connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                return sourceName.equals(JcrRepositoryTest.this.source().getName()) ? JcrRepositoryTest.this.source().getConnection() : null;
            }
        };
        this.descriptors = new HashMap<String, String>();
        this.repository = new JcrRepository(this.context, this.connectionFactory, this.sourceName, (Observable)new MockObservable(), null, this.descriptors, null, null);
        this.sourceGraph = Graph.create((RepositorySource)this.source(), (ExecutionContext)this.context);
        this.systemGraph = this.repository.createSystemGraph(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() {
        if (this.session != null) {
            try {
                this.session.logout();
            }
            finally {
                this.session = null;
            }
        }
    }

    protected RepositorySource source() {
        return this.source;
    }

    @Test
    public void shouldFailIfWorkspacesSharingSystemBranchConstantIsFalse() {
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowNullDescriptors() throws Exception {
        new JcrRepository(this.context, this.connectionFactory, this.sourceName, (Observable)new MockObservable(), null, null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullExecutionContext() throws Exception {
        new JcrRepository(null, this.connectionFactory, this.sourceName, (Observable)new MockObservable(), null, this.descriptors, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullConnectionFactories() throws Exception {
        new JcrRepository(this.context, null, this.sourceName, (Observable)new MockObservable(), null, this.descriptors, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullObservable() throws Exception {
        new JcrRepository(this.context, this.connectionFactory, this.sourceName, null, null, null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullSourceName() throws Exception {
        new JcrRepository(this.context, this.connectionFactory, null, (Observable)new MockObservable(), null, this.descriptors, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNoDescriptorKey() {
        this.repository.getDescriptor(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyDescriptorKey() {
        this.repository.getDescriptor("");
    }

    @Test
    public void shouldProvideBuiltInDescriptorKeys() {
        this.testDescriptorKeys((Repository)this.repository);
    }

    @Test
    public void shouldProvideDescriptorValues() {
        this.testDescriptorValues((Repository)this.repository);
    }

    @Test
    public void shouldProvideBuiltInDescriptorsWhenNotSuppliedDescriptors() throws Exception {
        JcrRepository repository = new JcrRepository(this.context, this.connectionFactory, this.sourceName, (Observable)new MockObservable(), null, this.descriptors, null, null);
        this.testDescriptorKeys((Repository)repository);
        this.testDescriptorValues((Repository)repository);
    }

    @Test
    public void shouldProvideRepositoryWorkspaceNamesDescriptor() throws ValueFormatException {
        Set workspaceNames = this.repository.workspaceNames();
        HashSet<String> descriptorValues = new HashSet<String>();
        for (JcrValue value : this.repository.getDescriptorValues("custom.rep.workspace.names")) {
            descriptorValues.add(value.getString());
        }
        Assert.assertThat(descriptorValues, (Matcher)Is.is((Object)workspaceNames));
    }

    @Test
    public void shouldNotProvideRepositoryWorkspaceNamesDescriptorIfOptionSetToFalse() throws Exception {
        JcrConfiguration config = new JcrConfiguration();
        config.repositorySource("Store").usingClass(InMemoryRepositorySource.class);
        config.repository("JCR").setOption(JcrRepository.Option.EXPOSE_WORKSPACE_NAMES_IN_DESCRIPTOR, Boolean.FALSE.toString()).setSource("Store");
        JcrEngine engine = config.build();
        engine.start();
        Assert.assertThat((Object)engine.getRepository("JCR").getDescriptor("custom.rep.workspace.names"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        engine.shutdownAndAwaitTermination(3L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldProvideObserver() {
        Assert.assertThat((Object)this.repository.getObserver(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldProvideRepositoryObservable() {
        Assert.assertThat((Object)this.repository.getRepositoryObservable(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveDefaultOptionsWhenNotOverridden() throws Exception {
        JcrRepository repository = new JcrRepository(this.context, this.connectionFactory, this.sourceName, (Observable)new MockObservable(), null, this.descriptors, null, null);
        Assert.assertThat(repository.getOptions().get(JcrRepository.Option.PROJECT_NODE_TYPES), (Matcher)Is.is((Object)JcrRepository.DefaultOption.PROJECT_NODE_TYPES));
    }

    @Test
    public void shouldProvideUserSuppliedDescriptors() throws Exception {
        HashMap<String, String> descriptors = new HashMap<String, String>();
        descriptors.put("property", "value");
        JcrRepository repository = new JcrRepository(this.context, this.connectionFactory, this.sourceName, (Observable)new MockObservable(), null, descriptors, null, null);
        this.testDescriptorKeys((Repository)repository);
        this.testDescriptorValues((Repository)repository);
        Assert.assertThat((Object)repository.getDescriptor("property"), (Matcher)Is.is((Object)"value"));
    }

    @Test(expected=LoginException.class)
    public void shouldNotAllowLoginWithNoCredentialsWhenAnonymousAuthenticationIsNotEnabled() throws Exception {
        HashMap<JcrRepository.Option, String> options = new HashMap<JcrRepository.Option, String>();
        options.put(JcrRepository.Option.ANONYMOUS_USER_ROLES, "");
        this.repository = new JcrRepository(this.context, this.connectionFactory, this.sourceName, (Observable)new MockObservable(), null, this.descriptors, options, null);
        this.repository.login();
    }

    @Test
    public void shouldAllowLoginWithNoCredentialsWhenAnonymousAuthenticationIsEnabled() throws Exception {
        this.repository.login();
    }

    @Test
    public void shouldAllowLoginWithNoCredentialsInPrivilegedBlock() throws Exception {
        LoginContext login = new LoginContext("modeshape-jcr", (CallbackHandler)new JaasSecurityContext.UserPasswordCallbackHandler("superuser", "superuser".toCharArray()));
        login.login();
        Subject subject = login.getSubject();
        Session session = Subject.doAsPrivileged(subject, new PrivilegedExceptionAction<Session>(){

            @Override
            public Session run() throws Exception {
                return JcrRepositoryTest.this.repository.login();
            }
        }, AccessController.getContext());
        Assert.assertThat((Object)session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)session.getUserID(), (Matcher)Is.is((Object)"superuser"));
        login.logout();
    }

    @Test
    public void shouldAllowLoginWithNoCredentialsIfAnonAccessEnabled() throws Exception {
        HashMap<JcrRepository.Option, String> options = new HashMap<JcrRepository.Option, String>();
        options.put(JcrRepository.Option.ANONYMOUS_USER_ROLES, "readonly");
        JcrRepository repository = new JcrRepository(this.context, this.connectionFactory, this.sourceName, (Observable)new MockObservable(), null, this.descriptors, options, null);
        this.session = (JcrSession)repository.login();
        Assert.assertThat((Object)this.session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.session.getUserID(), (Matcher)Is.is((Object)"<anonymous>"));
    }

    @Test
    public void shouldAllowLoginWithProperCredentials() throws Exception {
        this.repository.login(this.credentials);
        this.repository.login((Credentials)new JcrSecurityContextCredentials((SecurityContext)new MockSecurityContext(null, Collections.singleton("admin"))));
    }

    @Test
    public void shouldAllowLoginWithNoWorkspaceName() throws Exception {
        Session session = this.repository.login(this.credentials, null);
        Assert.assertThat((Object)session, (Matcher)IsNull.notNullValue());
        session.logout();
        session = this.repository.login((Credentials)new JcrSecurityContextCredentials((SecurityContext)new MockSecurityContext(null, Collections.singleton("admin"))), (String)null);
        Assert.assertThat((Object)session, (Matcher)IsNull.notNullValue());
        session.logout();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowLoginIfCredentialsDoNotProvideJaasMethod() throws Exception {
        this.repository.login((Credentials)Mockito.mock(Credentials.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowLoginIfCredentialsReturnNoAccessControlContext() throws Exception {
        this.repository.login(new Credentials(){
            private static final long serialVersionUID = 1L;

            public AccessControlContext getAccessControlContext() {
                return null;
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowLoginIfCredentialsReturnNoLoginContext() throws Exception {
        this.repository.login(new Credentials(){
            private static final long serialVersionUID = 1L;

            public LoginContext getLoginContext() {
                return null;
            }
        });
    }

    @Test
    public void shouldHaveRootNode() throws Exception {
        this.session = this.createSession();
        AbstractJcrNode root = this.session.getRootNode();
        String uuid = root.getIdentifier();
        Assert.assertThat((Object)root.isNodeType("mix:referenceable"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)root.getUUID(), (Matcher)Is.is((Object)uuid));
        org.modeshape.graph.Node dnaRoot = this.sourceGraph.getNodeAt("/");
        UUID dnaRootUuid = dnaRoot.getLocation().getUuid();
        Assert.assertThat((Object)uuid, (Matcher)Is.is((Object)dnaRootUuid.toString()));
        NodeIterator iter = root.getNodes();
        Node system = iter.nextNode();
        Assert.assertThat((Object)system.getName(), (Matcher)Is.is((Object)"jcr:system"));
        Node childA = root.addNode("childA", "nt:unstructured");
        Assert.assertThat((Object)childA, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        iter = root.getNodes();
        Node system2 = iter.nextNode();
        Node childA2 = iter.nextNode();
        Assert.assertThat((Object)system2.getName(), (Matcher)Is.is((Object)"jcr:system"));
        Assert.assertThat((Object)childA2.getName(), (Matcher)Is.is((Object)"childA"));
    }

    @Test
    public void shouldHaveSystemBranch() throws Exception {
        this.session = this.createSession();
        AbstractJcrNode root = this.session.getRootNode();
        AbstractJcrNode system = (AbstractJcrNode)root.getNode("jcr:system");
        UUID uuid = system.location.getUuid();
        for (int i = 0; i != 3; ++i) {
            org.modeshape.graph.Node dnaSystem = this.systemGraph.getNodeAt("/jcr:system");
            UUID dnaSystemUuid = dnaSystem.getLocation().getUuid();
            Assert.assertThat((Object)uuid, (Matcher)Is.is((Object)dnaSystemUuid));
        }
    }

    @Test
    public void shouldHaveRegisteredThoseNamespacesNeedeByDna() throws Exception {
        this.session = this.createSession();
        Assert.assertThat((Object)this.session.getNamespaceURI("mode"), (Matcher)Is.is((Object)"http://www.modeshape.org/1.0"));
        Assert.assertThat((Object)this.session.getNamespaceURI("modeint"), (Matcher)Is.is((Object)"http://www.modeshape.org/internal/1.0"));
    }

    @Test
    public void shouldHaveRegisteredThoseNamespacesDefinedByTheJcrSpecification() throws Exception {
        this.session = this.createSession();
        Assert.assertThat((Object)this.session.getNamespaceURI("mode"), (Matcher)Is.is((Object)"http://www.modeshape.org/1.0"));
        Assert.assertThat((Object)this.session.getNamespaceURI("jcr"), (Matcher)Is.is((Object)"http://www.jcp.org/jcr/1.0"));
        Assert.assertThat((Object)this.session.getNamespaceURI("mix"), (Matcher)Is.is((Object)"http://www.jcp.org/jcr/mix/1.0"));
        Assert.assertThat((Object)this.session.getNamespaceURI("nt"), (Matcher)Is.is((Object)"http://www.jcp.org/jcr/nt/1.0"));
        Assert.assertThat((Object)this.session.getNamespaceURI(""), (Matcher)Is.is((Object)""));
    }

    @Test
    public void shouldHaveRegisteredThoseNamespacesDefinedByTheJcrApiJavaDoc() throws Exception {
        this.session = this.createSession();
        Assert.assertThat((Object)this.session.getNamespaceURI("sv"), (Matcher)Is.is((Object)"http://www.jcp.org/jcr/sv/1.0"));
        Assert.assertThat((Object)this.session.getNamespaceURI("xmlns"), (Matcher)Is.is((Object)"http://www.w3.org/2000/xmlns/"));
    }

    @Test
    public void shouldParseSourceNameOptionWithOnlySourceName() {
        this.assertSourceWorkspacePair("source name", "source name", null);
        this.assertSourceWorkspacePair(" \t source name \n ", "source name", null);
        this.assertSourceWorkspacePair(" \t source \\@ name \n ", "source @ name", null);
    }

    @Test
    public void shouldParseSourceNameOptionWithWorkspaceNameAndSourceName() {
        this.assertSourceWorkspacePair("workspace@source", "source", "workspace");
        this.assertSourceWorkspacePair(" \t workspace\t@ \t source \t \n", "source", "workspace");
        this.assertSourceWorkspacePair(" \t workspace\\@ name \t@ \t source\\@name \t \n", "source@name", "workspace@ name");
        this.assertSourceWorkspacePair("@ \t source \\@ name \n ", "source @ name", "");
        this.assertSourceWorkspacePair("   @ \t source \\@ name \n ", "source @ name", "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToParseSourceNameOptionThatHasZeroLengthSource() {
        new JcrRepository.SourceWorkspacePair("workspace@");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToParseSourceNameOptionThatHasBlankSource() {
        new JcrRepository.SourceWorkspacePair("workspace@  ");
    }

    @Test
    public void shouldParseSourceNameOptionThatHasBlankSourceAndWorkspace() {
        this.assertSourceWorkspacePair("@", "", "");
        this.assertSourceWorkspacePair(" @ ", "", "");
    }

    protected void assertSourceWorkspacePair(String value, String expectedSourceName, String expectedWorkspaceName) {
        JcrRepository.SourceWorkspacePair pair = new JcrRepository.SourceWorkspacePair(value);
        Assert.assertThat((Object)pair, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)pair.getSourceName(), (Matcher)Is.is((Object)expectedSourceName));
        Assert.assertThat((Object)pair.getWorkspaceName(), (Matcher)Is.is((Object)expectedWorkspaceName));
    }

    protected JcrSession createSession() throws Exception {
        LoginContext login = new LoginContext("modeshape-jcr", (CallbackHandler)new JaasSecurityContext.UserPasswordCallbackHandler("superuser", "superuser".toCharArray()));
        login.login();
        Subject subject = login.getSubject();
        JcrSession session = (JcrSession)Subject.doAsPrivileged(subject, new PrivilegedExceptionAction<Session>(){

            @Override
            public Session run() throws Exception {
                return JcrRepositoryTest.this.repository.login();
            }
        }, AccessController.getContext());
        return session;
    }

    protected JcrSession createSession(final String workspace) throws Exception {
        LoginContext login = new LoginContext("modeshape-jcr", (CallbackHandler)new JaasSecurityContext.UserPasswordCallbackHandler("superuser", "superuser".toCharArray()));
        login.login();
        Subject subject = login.getSubject();
        JcrSession session = (JcrSession)Subject.doAsPrivileged(subject, new PrivilegedExceptionAction<Session>(){

            @Override
            public Session run() throws Exception {
                return JcrRepositoryTest.this.repository.login(workspace);
            }
        }, AccessController.getContext());
        return session;
    }

    private void testDescriptorKeys(Repository repository) {
        String[] keys = repository.getDescriptorKeys();
        Assert.assertThat((Object)keys, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)(keys.length >= 15 ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)keys, (Matcher)IsArrayContaining.hasItemInArray((Object)"level.1.supported"));
        Assert.assertThat((Object)keys, (Matcher)IsArrayContaining.hasItemInArray((Object)"level.2.supported"));
        Assert.assertThat((Object)keys, (Matcher)IsArrayContaining.hasItemInArray((Object)"option.locking.supported"));
        Assert.assertThat((Object)keys, (Matcher)IsArrayContaining.hasItemInArray((Object)"option.observation.supported"));
        Assert.assertThat((Object)keys, (Matcher)IsArrayContaining.hasItemInArray((Object)"option.query.sql.supported"));
        Assert.assertThat((Object)keys, (Matcher)IsArrayContaining.hasItemInArray((Object)"option.transactions.supported"));
        Assert.assertThat((Object)keys, (Matcher)IsArrayContaining.hasItemInArray((Object)"option.versioning.supported"));
        Assert.assertThat((Object)keys, (Matcher)IsArrayContaining.hasItemInArray((Object)"query.xpath.doc.order"));
        Assert.assertThat((Object)keys, (Matcher)IsArrayContaining.hasItemInArray((Object)"query.xpath.pos.index"));
        Assert.assertThat((Object)keys, (Matcher)IsArrayContaining.hasItemInArray((Object)"jcr.repository.name"));
        Assert.assertThat((Object)keys, (Matcher)IsArrayContaining.hasItemInArray((Object)"jcr.repository.vendor"));
        Assert.assertThat((Object)keys, (Matcher)IsArrayContaining.hasItemInArray((Object)"jcr.repository.vendor.url"));
        Assert.assertThat((Object)keys, (Matcher)IsArrayContaining.hasItemInArray((Object)"jcr.repository.version"));
        Assert.assertThat((Object)keys, (Matcher)IsArrayContaining.hasItemInArray((Object)"jcr.specification.name"));
        Assert.assertThat((Object)keys, (Matcher)IsArrayContaining.hasItemInArray((Object)"jcr.specification.version"));
    }

    private void testDescriptorValues(Repository repository) {
        Assert.assertThat((Object)repository.getDescriptor("level.1.supported"), (Matcher)Is.is((Object)"true"));
        Assert.assertThat((Object)repository.getDescriptor("level.2.supported"), (Matcher)Is.is((Object)"true"));
        Assert.assertThat((Object)repository.getDescriptor("option.locking.supported"), (Matcher)Is.is((Object)"true"));
        Assert.assertThat((Object)repository.getDescriptor("option.observation.supported"), (Matcher)Is.is((Object)"true"));
        Assert.assertThat((Object)repository.getDescriptor("option.query.sql.supported"), (Matcher)Is.is((Object)"true"));
        Assert.assertThat((Object)repository.getDescriptor("option.transactions.supported"), (Matcher)Is.is((Object)"false"));
        Assert.assertThat((Object)repository.getDescriptor("option.versioning.supported"), (Matcher)Is.is((Object)"true"));
        Assert.assertThat((Object)repository.getDescriptor("query.xpath.doc.order"), (Matcher)Is.is((Object)"false"));
        Assert.assertThat((Object)repository.getDescriptor("query.xpath.pos.index"), (Matcher)Is.is((Object)"true"));
        Assert.assertThat((Object)repository.getDescriptor("jcr.repository.name"), (Matcher)Is.is((Object)"ModeShape JCR Repository"));
        Assert.assertThat((Object)repository.getDescriptor("jcr.repository.vendor"), (Matcher)Is.is((Object)"JBoss, a division of Red Hat"));
        Assert.assertThat((Object)repository.getDescriptor("jcr.repository.vendor.url"), (Matcher)Is.is((Object)"http://www.modeshape.org"));
        Assert.assertThat((Object)repository.getDescriptor("jcr.repository.version"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)repository.getDescriptor("jcr.specification.name"), (Matcher)Is.is((Object)JcrI18n.SPEC_NAME_DESC.text(new Object[0])));
        Assert.assertThat((Object)repository.getDescriptor("jcr.specification.version"), (Matcher)Is.is((Object)"2.0"));
    }

    @Ignore(value="GC behavior is non-deterministic from the application's POV - this test _will_ occasionally fail")
    @Test
    public void shouldAllowManySessionLoginsAndLogouts() throws Exception {
        Session session;
        HashMap<JcrRepository.Option, String> options = new HashMap<JcrRepository.Option, String>();
        options.put(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        JcrRepository repository = new JcrRepository(this.context, this.connectionFactory, this.sourceName, (Observable)new MockObservable(), null, this.descriptors, options, null);
        for (int i = 0; i < 10000; ++i) {
            session = repository.login();
            session.logout();
        }
        session = repository.login();
        session = null;
        System.gc();
        Thread.sleep(100L);
        Assert.assertThat((Object)repository.activeSessions().size(), (Matcher)Is.is((Object)0));
    }

    @Ignore(value="This test normally sleeps for 30 seconds")
    @Test
    public void shouldCleanUpLocksFromDeadSessions() throws Exception {
        HashMap<JcrRepository.Option, String> options = new HashMap<JcrRepository.Option, String>();
        options.put(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        JcrRepository repository = new JcrRepository(this.context, this.connectionFactory, this.sourceName, (Observable)new MockObservable(), null, this.descriptors, options, null);
        String lockedNodeName = "lockedNode";
        JcrSession locker = (JcrSession)repository.login();
        Node lockedNode = locker.getRootNode().addNode(lockedNodeName);
        lockedNode.addMixin("mix:lockable");
        locker.save();
        locker.getWorkspace().getLockManager().lock(lockedNode.getPath(), false, true, 1L, "me");
        Assert.assertThat((Object)lockedNode.isLocked(), (Matcher)Is.is((Object)true));
        Session reader = repository.login();
        Node readerNode = (Node)reader.getItem("/" + lockedNodeName);
        Assert.assertThat((Object)readerNode.isLocked(), (Matcher)Is.is((Object)true));
        repository.getRepositoryLockManager().cleanUpLocks();
        Assert.assertThat((Object)lockedNode.isLocked(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)readerNode.isLocked(), (Matcher)Is.is((Object)true));
        repository.activeSessions.remove(locker);
        Thread.sleep(60100L);
        repository.getRepositoryLockManager().cleanUpLocks();
        Assert.assertThat((Object)readerNode.isLocked(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldHaveAvailableWorkspacesMatchingThoseInSourceContainingJustDefaultWorkspace() throws Exception {
        this.source = new InMemoryRepositorySource();
        this.source.setName(this.sourceName);
        this.sourceGraph = Graph.create((RepositorySource)this.source(), (ExecutionContext)this.context);
        this.repository = new JcrRepository(this.context, this.connectionFactory, this.sourceName, (Observable)new MockObservable(), null, this.descriptors, null, null);
        this.session = this.createSession();
        Set<String> jcrWorkspaces = this.setOf(this.session.getWorkspace().getAccessibleWorkspaceNames());
        Set graphWorkspaces = this.sourceGraph.getWorkspaces();
        Assert.assertThat(jcrWorkspaces, (Matcher)Is.is((Object)graphWorkspaces));
    }

    @Test
    public void shouldHaveAvailableWorkspacesMatchingThoseInSourceContainingPredefinedWorkspaces() throws Exception {
        this.source = new InMemoryRepositorySource();
        this.source.setName(this.sourceName);
        this.source.setPredefinedWorkspaceNames(new String[]{"ws1", "ws2", "ws3"});
        this.source.setDefaultWorkspaceName("ws1");
        this.sourceGraph = Graph.create((RepositorySource)this.source(), (ExecutionContext)this.context);
        this.repository = new JcrRepository(this.context, this.connectionFactory, this.sourceName, (Observable)new MockObservable(), null, this.descriptors, null, null);
        this.session = this.createSession();
        Set<String> jcrWorkspaces = this.setOf(this.session.getWorkspace().getAccessibleWorkspaceNames());
        Set graphWorkspaces = this.sourceGraph.getWorkspaces();
        Assert.assertThat(jcrWorkspaces, (Matcher)Is.is((Object)graphWorkspaces));
    }

    protected <T> Set<T> setOf(T ... values) {
        return org.modeshape.common.collection.Collections.unmodifiableSet((Object[])values);
    }

    @Test
    public void shouldInitializeContentForNewlyCreatedWorkspacesIfDefined() throws Exception {
        String urlToResourceFile = this.getClass().getClassLoader().getResource("initialWorkspaceContent.xml").toExternalForm();
        String urlToCndFile = this.getClass().getClassLoader().getResource("cars.cnd").toExternalForm();
        Assert.assertThat((Object)this.source.getCapabilities().supportsCreatingWorkspaces(), (Matcher)Is.is((Object)true));
        this.descriptors.put("option.workspace.management.supported", "true");
        this.repository = new JcrRepository(this.context, this.connectionFactory, this.sourceName, (Observable)new MockObservable(), this.source.getCapabilities(), this.descriptors, null, urlToResourceFile);
        this.session = this.createSession();
        CndNodeTypeReader nodeTypeReader = new CndNodeTypeReader((Session)this.session);
        nodeTypeReader.read(urlToCndFile);
        NodeTypeDefinition[] defns = nodeTypeReader.getNodeTypeDefinitions();
        this.session.getWorkspace().getNodeTypeManager().registerNodeTypes(defns, true);
        this.session.logout();
        this.session = this.createSession();
        this.session.getWorkspace().createWorkspace("MyCarWorkspace");
        this.session.logout();
        this.session = this.createSession("MyCarWorkspace");
        AbstractJcrNode cars = this.session.getRootNode().getNode("Cars");
        AbstractJcrNode prius = this.session.getRootNode().getNode("Cars/Hybrid/Toyota Prius");
        AbstractJcrNode g37 = this.session.getRootNode().getNode("Cars/Sports/Infiniti G37");
        Assert.assertThat((Object)cars, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)prius, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)g37, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAllowCreatingWorkspaces() throws Exception {
        Assert.assertThat((Object)this.source.getCapabilities().supportsCreatingWorkspaces(), (Matcher)Is.is((Object)true));
        this.descriptors.put("option.workspace.management.supported", "true");
        this.repository = new JcrRepository(this.context, this.connectionFactory, this.sourceName, (Observable)new MockObservable(), this.source.getCapabilities(), this.descriptors, null, null);
        JcrSession session2 = null;
        JcrSession session3 = null;
        try {
            this.session = this.createSession();
            session2 = this.createSession();
            String newWorkspaceName = "MyCarWorkspace";
            this.session.getWorkspace().createWorkspace(newWorkspaceName);
            this.assertAccessibleWorkspace((Session)this.session, newWorkspaceName);
            this.assertAccessibleWorkspace((Session)session2, newWorkspaceName);
            this.session.logout();
            session3 = this.createSession();
            this.assertAccessibleWorkspace((Session)session2, newWorkspaceName);
            this.assertAccessibleWorkspace((Session)session3, newWorkspaceName);
            this.session = this.createSession(newWorkspaceName);
        }
        finally {
            try {
                if (session2 != null) {
                    session2.logout();
                }
            }
            finally {
                if (session3 != null) {
                    session3.logout();
                }
            }
        }
    }

    protected void assertAccessibleWorkspace(Session session, String workspaceName) throws Exception {
        this.assertContains(session.getWorkspace().getAccessibleWorkspaceNames(), workspaceName);
    }

    protected void assertContains(String[] actuals, String ... expected) {
        for (String expect : expected) {
            if (expect == null) continue;
            boolean found = false;
            for (String actual : actuals) {
                if (!expect.equals(actual)) continue;
                found = true;
                break;
            }
            Assert.assertThat((String)("Did not find '" + expect + "' in the actuals: " + actuals), (Object)found, (Matcher)Is.is((Object)true));
        }
    }
}

