/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.ItemNotFoundException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrTest;

public class JcrRootNodeTest
extends AbstractJcrTest {
    private AbstractJcrNode rootNode;

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.rootNode = this.cache.findJcrRootNode();
    }

    @Test(expected=ItemNotFoundException.class)
    public void shouldNotAllowAncestorDepthGreaterThanNodeDepth() throws Exception {
        this.rootNode.getAncestor(1);
    }

    @Test
    public void shouldHaveZeroDepth() throws Exception {
        Assert.assertThat((Object)this.rootNode.getDepth(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldIndicateIndexIsOne() throws Exception {
        Assert.assertThat((Object)this.rootNode.getIndex(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldHaveEmptyName() throws Exception {
        String name = this.rootNode.getName();
        Assert.assertThat((Object)name, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)name.length(), (Matcher)Is.is((Object)0));
    }

    @Test(expected=ItemNotFoundException.class)
    public void shouldHaveNoParent() throws Exception {
        this.rootNode.getParent();
    }

    @Test
    public void shouldProvidePath() throws Exception {
        Assert.assertThat((Object)this.rootNode.getPath(), (Matcher)Is.is((Object)"/"));
    }
}

