/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.graph.Graph;
import org.modeshape.jcr.AbstractSessionTest;
import org.modeshape.jcr.JaasTestUtil;

public class JcrWorkspaceTest
extends AbstractSessionTest {
    @BeforeClass
    public static void beforeAll() {
        JaasTestUtil.initJaas("security/jaas.conf.xml");
    }

    @AfterClass
    public static void afterAll() {
        JaasTestUtil.releaseJaas();
    }

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
    }

    @Override
    protected void initializeContent() {
        ((Graph)((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c").and()).create("/b").and();
        ((Graph.SetValuesTo)this.graph.set("booleanProperty").on("/a/b")).to(true);
        ((Graph.SetValuesTo)this.graph.set("jcr:primaryType").on("/a/b")).to("nt:unstructured");
        ((Graph.SetValuesTo)this.graph.set("stringProperty").on("/a/b/c")).to("value");
        ((Graph)this.graph.create("/jcr:system").and()).create("/jcr:system/mode:namespaces").ifAbsent().and();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCloneWithNullWorkspaceName() throws Exception {
        this.workspace.clone(null, "/src", "/dest", false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCopyFromNullPathToNullPath() throws Exception {
        this.workspace.copy(null, null);
    }

    @Ignore(value="QueryManager is not initialized correctly, preventing the 'copy' to work properly")
    @Test
    public void shouldCopyFromPathToAnotherPathInSameWorkspace() throws Exception {
        this.workspace.copy("/a/b", "/b/b-copy");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCopyFromOtherWorkspaceWithNullWorkspace() throws Exception {
        this.workspace.copy(null, null, null);
    }

    @Test
    public void shouldNotAllowGetAccessibleWorkspaceNames() throws Exception {
        String[] names = this.workspace.getAccessibleWorkspaceNames();
        Assert.assertThat((Object)names.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)names[0], (Matcher)Is.is((Object)this.workspaceName));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowImportContentHandlerWithNullPath() throws Exception {
        this.workspace.getImportContentHandler(null, 0);
    }

    @Test
    public void shouldGetImportContentHandlerWithValidPath() throws Exception {
        Assert.assertThat((Object)this.workspace.getImportContentHandler("/b", 0), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldProvideName() throws Exception {
        Assert.assertThat((Object)this.workspace.getName(), (Matcher)Is.is((Object)this.workspaceName));
    }

    @Test
    public void shouldHaveSameContextIdAsSession() {
        Assert.assertThat((Object)this.workspace.context().getId(), (Matcher)Is.is((Object)this.session.getExecutionContext().getId()));
    }

    @Test
    public void shouldProvideNamespaceRegistry() throws Exception {
        NamespaceRegistry registry = this.workspace.getNamespaceRegistry();
        Assert.assertThat((Object)registry, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)registry.getURI("jcr"), (Matcher)Is.is((Object)"http://www.jcp.org/jcr/1.0"));
    }

    @Test
    public void shouldGetNodeTypeManager() throws Exception {
        Assert.assertThat((Object)this.workspace.getNodeTypeManager(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldGetObservationManager() throws Exception {
        Assert.assertThat((Object)this.workspace.getObservationManager(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldProvideQueryManager() throws Exception {
        Assert.assertThat((Object)this.workspace.getQueryManager(), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void shouldCreateQuery() throws Exception {
        String statement = "SELECT * FROM [nt:unstructured]";
        QueryManager queryManager = this.workspace.getQueryManager();
        Query query = queryManager.createQuery(statement, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)query.getLanguage(), (Matcher)Is.is((Object)"JCR-SQL2"));
        Assert.assertThat((Object)query.getStatement(), (Matcher)Is.is((Object)statement));
    }

    @Test
    public void shouldStoreQueryAsNode() throws Exception {
        String statement = "SELECT * FROM [nt:unstructured]";
        QueryManager queryManager = this.workspace.getQueryManager();
        Query query = queryManager.createQuery(statement, "JCR-SQL2");
        Node node = query.storeAsNode("/storedQuery");
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"nt:query"));
        Assert.assertThat((Object)node.getProperty("jcr:language").getString(), (Matcher)Is.is((Object)"JCR-SQL2"));
        Assert.assertThat((Object)node.getProperty("jcr:statement").getString(), (Matcher)Is.is((Object)statement));
    }

    @Test
    public void shouldLoadStoredQuery() throws Exception {
        String statement = "SELECT * FROM [nt:unstructured]";
        QueryManager queryManager = this.workspace.getQueryManager();
        Query query = queryManager.createQuery(statement, "JCR-SQL2");
        Node node = query.storeAsNode("/storedQuery");
        Query loaded = queryManager.getQuery(node);
        Assert.assertThat((Object)loaded, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)loaded.getLanguage(), (Matcher)Is.is((Object)"JCR-SQL2"));
        Assert.assertThat((Object)loaded.getStatement(), (Matcher)Is.is((Object)statement));
        Assert.assertThat((Object)loaded.getStoredQueryPath(), (Matcher)Is.is((Object)node.getPath()));
    }

    @Test
    public void shouldProvideSession() throws Exception {
        Assert.assertThat((Object)this.workspace.getSession(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldAllowImportXml() throws Exception {
        String inputData = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><sv:node xmlns:jcr=\"http://www.jcp.org/jcr/1.0\" xmlns:nt=\"http://www.jcp.org/jcr/nt/1.0\" xmlns:sv=\"http://www.jcp.org/jcr/sv/1.0\" sv:name=\"workspaceTestNode\"><sv:property sv:name=\"jcr:primaryType\" sv:type=\"Name\"><sv:value>nt:unstructured</sv:value></sv:property></sv:node>";
        this.workspace.importXML("/", (InputStream)new ByteArrayInputStream(inputData.getBytes()), 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowMoveFromNullPath() throws Exception {
        this.workspace.move(null, null);
    }

    @Test
    public void shouldAllowMoveFromPathToAnotherPathInSameWorkspace() throws Exception {
        this.workspace.move("/a/b", "/b/b-copy");
    }
}

