/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.security.Principal;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.RepositoryStub;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.JaasTestUtil;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;

public class ModeShapeRepositoryStub
extends RepositoryStub {
    public static final String MODE_SHAPE_SKIP_IMPORT = "javax.jcr.tck.modeSkipImport";
    public static final String MODE_SHAPE_NODE_TYPE_PATH = "javax.jcr.tck.modeNodeTypePath";
    private static final String REPOSITORY_SOURCE_NAME = "Test Repository Source";
    private static String currentConfigurationName = "default";
    private static boolean reloadRepositoryInstance = false;
    private Properties configProps;
    private String repositoryConfigurationName;
    private JcrRepository repository;
    private JcrEngine engine;

    public ModeShapeRepositoryStub(Properties env) {
        super(env);
        this.configureRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureRepository() {
        this.repositoryConfigurationName = currentConfigurationName;
        JaasTestUtil.initJaas("security/jaas.conf.xml");
        JcrConfiguration configuration = new JcrConfiguration();
        try {
            this.configProps = new Properties();
            String propsFileName = "/tck/" + this.repositoryConfigurationName + "/repositoryOverlay.properties";
            InputStream propsStream = ((Object)((Object)this)).getClass().getResourceAsStream(propsFileName);
            this.configProps.load(propsStream);
            String configFileName = "/tck/" + this.repositoryConfigurationName + "/configRepository.xml";
            configuration.loadFrom(((Object)((Object)this)).getClass().getResourceAsStream(configFileName));
            if (this.engine != null) {
                try {
                    this.engine.shutdown();
                }
                finally {
                    this.engine = null;
                }
            }
            this.engine = configuration.build();
            this.engine.start();
            Problems problems = this.engine.getProblems();
            for (Problem problem : problems) {
                System.err.println(problem);
            }
            if (problems.hasErrors()) {
                throw new IllegalStateException("Problems starting JCR repository");
            }
            ExecutionContext executionContext = this.engine.getExecutionContext();
            executionContext.getNamespaceRegistry().register("modetest", "http://www.modeshape.org/test/1.0");
            this.repository = this.engine.getRepository(REPOSITORY_SOURCE_NAME);
            String skipImport = (String)this.configProps.get(MODE_SHAPE_SKIP_IMPORT);
            if (!Boolean.valueOf(skipImport).booleanValue()) {
                Graph graph = Graph.create((String)this.repository.getRepositorySourceName(), (RepositoryConnectionFactory)this.engine.getRepositoryConnectionFactory(), (ExecutionContext)executionContext);
                Path destinationPath = executionContext.getValueFactories().getPathFactory().createRootPath();
                InputStream xmlStream = ((Object)((Object)this)).getClass().getResourceAsStream("/tck/repositoryForTckTests.xml");
                graph.importXmlFrom(xmlStream).into(destinationPath);
                graph.createWorkspace().named("otherWorkspace");
                graph.useWorkspace("otherWorkspace");
                ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)graph.clone("/testroot").fromWorkspace("default")).as("testroot")).into("/")).failingIfAnyUuidsMatch();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Failed to initialize the repository with text content.", ex);
        }
    }

    public static void setCurrentConfigurationName(String newConfigName) {
        currentConfigurationName = newConfigName;
    }

    public static void reloadRepositoryInstance() {
        reloadRepositoryInstance = true;
    }

    public JcrRepository getRepository() {
        if (!currentConfigurationName.equals(this.repositoryConfigurationName) || reloadRepositoryInstance) {
            reloadRepositoryInstance = false;
            this.configureRepository();
        }
        return this.repository;
    }

    public String getProperty(String name) {
        String value = this.configProps.getProperty(name);
        if (value != null) {
            return value;
        }
        return super.getProperty(name);
    }

    public Principal getKnownPrincipal(Session session) throws RepositoryException {
        return null;
    }

    public Principal getUnknownPrincipal(Session session) throws RepositoryException, NotExecutableException {
        return null;
    }
}

