/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.xpath;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.TokenStream;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.Order;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.jcr.xpath.XPath;
import org.modeshape.jcr.xpath.XPathParser;
import org.modeshape.jcr.xpath.XPathQueryParser;

public class XPathParserTest {
    private TypeSystem typeSystem;
    private XPathParser parser;

    @Before
    public void beforeEach() {
        this.typeSystem = new ExecutionContext().getValueFactories().getTypeSystem();
        this.parser = new XPathParser(this.typeSystem);
    }

    @After
    public void afterEach() {
        this.parser = null;
    }

    @Test
    public void shouldParseXPathExpressions() {
        this.assertParsable("/jcr:root/a/b/c");
        this.assertParsable("/jcr:root/a/b/c[*]");
        this.assertParsable("/jcr:root/some[1]/element(nodes, my:type)[2]");
        this.assertParsable("//element(*,my:type)");
        this.assertParsable("//element(*,my:type)[@jcr:title='something' and @globalProperty='something else']");
        this.assertParsable("//element(*,my:type)[@jcr:title | @globalProperty]");
        this.assertParsable("//element(*,my:type)/(@jcr:title | @globalProperty)");
        this.assertParsable("//element(*, my:type) order by @my:title");
        this.assertParsable("//element(*, my:type) [jcr:contains(., 'jcr')] order by jcr:score() descending");
        this.assertParsable("//element(*, employee)[@secretary and @assistant]");
        this.assertParsable("//element(*, employee)[@secretary or @assistant]");
    }

    @Test
    public void shouldParseXPathExpressions2() {
        this.assertParsable("/jcr:root/a/b/c", (XPath.Component)this.pathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.nameTest("a"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.nameTest("b"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.nameTest("c"), new XPath.Component[0])}));
        this.assertParsable("/jcr:root/a/b/c[*]", (XPath.Component)this.pathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.nameTest("a"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.nameTest("b"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.nameTest("c"), new XPath.Component[]{this.wildcard()})}));
        this.assertParsable("/jcr:root/some[1]", (XPath.Component)this.pathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.nameTest("some"), new XPath.Component[]{this.literal("1")})}));
        this.assertParsable("/jcr:root/element(*)", (XPath.Component)this.pathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.element(this.wildcard(), this.wildcard()), new XPath.Component[0])}));
        this.assertParsable("/jcr:root/element(name)", (XPath.Component)this.pathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.element(this.nameTest("name"), this.wildcard()), new XPath.Component[0])}));
        this.assertParsable("/jcr:root/element(*, *)", (XPath.Component)this.pathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.element(this.wildcard(), this.wildcard()), new XPath.Component[0])}));
        this.assertParsable("/jcr:root/element(*, my:type)", (XPath.Component)this.pathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.element(this.wildcard(), this.nameTest("my", "type")), new XPath.Component[0])}));
        this.assertParsable("/jcr:root/element(ex:name, my:type)", (XPath.Component)this.pathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.element(this.nameTest("ex", "name"), this.nameTest("my", "type")), new XPath.Component[0])}));
        this.assertParsable("/jcr:root/element(name, my:type)", (XPath.Component)this.pathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.element(this.nameTest("name"), this.nameTest("my", "type")), new XPath.Component[0])}));
        this.assertParsable("/jcr:root/element(name, type)", (XPath.Component)this.pathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.element(this.nameTest("name"), this.nameTest("type")), new XPath.Component[0])}));
        this.assertParsable("/jcr:root/some[1]/element(nodes, my:type)[1]", (XPath.Component)this.pathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.nameTest("some"), new XPath.Component[]{this.literal("1")}), this.axisStep((XPath.NodeTest)this.element(this.nameTest("nodes"), this.nameTest("my", "type")), new XPath.Component[]{this.literal("1")})}));
        this.assertParsable("/jcr:root/some[1]/element(*, my:type)[1]", (XPath.Component)this.pathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.nameTest("some"), new XPath.Component[]{this.literal("1")}), this.axisStep((XPath.NodeTest)this.element(this.wildcard(), this.nameTest("my", "type")), new XPath.Component[]{this.literal("1")})}));
    }

    @Test
    public void shouldParseXPathExpressionWithOrderBy() {
        this.assertParsable("//element(*, my:type) order by @a1,@a2", (XPath.Component)this.pathExpr(this.orderBy(this.asc(this.nameTest("a1")), this.asc(this.nameTest("a2"))), new XPath.StepExpression[]{this.descendantOrSelf(), this.axisStep((XPath.NodeTest)this.element(this.wildcard(), this.nameTest("my", "type")), new XPath.Component[0])}));
        this.assertParsable("//element(*, my:type) order by @p:a1, @a2", (XPath.Component)this.pathExpr(this.orderBy(this.asc(this.nameTest("p", "a1")), this.asc(this.nameTest("a2"))), new XPath.StepExpression[]{this.descendantOrSelf(), this.axisStep((XPath.NodeTest)this.element(this.wildcard(), this.nameTest("my", "type")), new XPath.Component[0])}));
        this.assertParsable("/jcr:root/element(name, my:type) order by @p:a1", (XPath.Component)this.pathExpr(this.orderBy(this.asc(this.nameTest("p", "a1"))), new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.element(this.nameTest("name"), this.nameTest("my", "type")), new XPath.Component[0])}));
        this.assertParsable("/jcr:root order by @p:a1", (XPath.Component)this.pathExpr(this.orderBy(this.asc(this.nameTest("p", "a1"))), new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0])}));
    }

    @Ignore
    @Test
    public void shouldParseXPathExpressionsThatCombineSeparateExpressions() {
        this.assertParsable("/jcr:root/a/b/c union /jcr:root/c/d/e");
        this.assertParsable("/jcr:root/a/b/c union /jcr:root/c/d/e intersect /jcr:root/f/g/h");
    }

    @Test
    public void shouldFailToParseInvalidXPathExpressions() {
        this.assertNotParsable("//");
    }

    @Test
    public void shouldParsePathExpressionWithSpaceInPath() {
        Assert.assertThat((Object)this.parser.parsePathExpr(this.tokenize("/a/b/c_x0020_d")), (Matcher)Is.is((Object)this.pathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("a"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.nameTest("b"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.nameTest("c d"), new XPath.Component[0])})));
    }

    @Test
    public void shouldParsePathExpressionWithAbbreviatedDescendantOrSelfWithNameTestAfter() {
        Assert.assertThat((Object)this.parser.parsePathExpr(this.tokenize("//b:c")), (Matcher)Is.is((Object)this.pathExpr(new XPath.StepExpression[]{this.descendantOrSelf(), this.axisStep((XPath.NodeTest)this.nameTest("b", "c"), new XPath.Component[0])})));
    }

    @Test
    public void shouldParsePathExpressionWithAbbreviatedDescendantOrSelfWithRelativeNamePathPredicate() {
        Assert.assertThat((Object)this.parser.parsePathExpr(this.tokenize("//.[c]")), (Matcher)Is.is((Object)this.pathExpr(new XPath.StepExpression[]{this.descendantOrSelf(), this.filterStep((XPath.Component)this.contextItem(), new XPath.Component[]{this.nameTest("c")})})));
    }

    @Test
    public void shouldParsePathExpressionWithAbbreviatedDescendantOrSelfWithRelativeNumericLiteralPredicate() {
        Assert.assertThat((Object)this.parser.parsePathExpr(this.tokenize("//.[3]")), (Matcher)Is.is((Object)this.pathExpr(new XPath.StepExpression[]{this.descendantOrSelf(), this.filterStep((XPath.Component)this.contextItem(), new XPath.Component[]{this.literal("3")})})));
    }

    @Test
    public void shouldParsePathExpressionWithNameTestsAndWildcard() {
        Assert.assertThat((Object)this.parser.parsePathExpr(this.tokenize("/jcr:root/a/b/*")), (Matcher)Is.is((Object)this.pathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.nameTest("a"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.nameTest("b"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.wildcard(), new XPath.Component[0])})));
    }

    @Test
    public void shouldParsePathExpressionWithNameTestsAndWildcardAndPropertyExistence() {
        Assert.assertThat((Object)this.parser.parsePathExpr(this.tokenize("/jcr:root/a/b/*[@prop]")), (Matcher)Is.is((Object)this.pathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("jcr", "root"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.nameTest("a"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.nameTest("b"), new XPath.Component[0]), this.axisStep((XPath.NodeTest)this.wildcard(), new XPath.Component[]{this.attributeNameTest(this.nameTest("prop"))})})));
    }

    @Test
    public void shouldParseRelativePathExpressionWithAbbreviatedDescendantOrSelfWithNameTestAfter() {
        Assert.assertThat((Object)this.parser.parseRelativePathExpr(this.tokenize("a//b:c")), (Matcher)Is.is((Object)this.relativePathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("a"), new XPath.Component[0]), this.descendantOrSelf(), this.axisStep((XPath.NodeTest)this.nameTest("b", "c"), new XPath.Component[0])})));
    }

    @Test
    public void shouldParseRelativePathExpressionWithAbbreviatedDescendantOrSelfAtEnd() {
        Assert.assertThat((Object)this.parser.parseRelativePathExpr(this.tokenize("a//")), (Matcher)Is.is((Object)this.relativePathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("a"), new XPath.Component[0]), this.descendantOrSelf()})));
    }

    @Test
    public void shouldParseRelativePathExpressionWithAbbreviatedDescendantOrSelfWithRelativeNamePathPredicate() {
        Assert.assertThat((Object)this.parser.parseRelativePathExpr(this.tokenize("a//.[c]")), (Matcher)Is.is((Object)this.relativePathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("a"), new XPath.Component[0]), this.descendantOrSelf(), this.filterStep((XPath.Component)this.contextItem(), new XPath.Component[]{this.nameTest("c")})})));
    }

    @Test
    public void shouldParseRelativePathExpressionWithAbbreviatedDescendantOrSelfWithRelativeNumericLiteralPredicate() {
        Assert.assertThat((Object)this.parser.parseRelativePathExpr(this.tokenize("a//.[3]")), (Matcher)Is.is((Object)this.relativePathExpr(new XPath.StepExpression[]{this.axisStep((XPath.NodeTest)this.nameTest("a"), new XPath.Component[0]), this.descendantOrSelf(), this.filterStep((XPath.Component)this.contextItem(), new XPath.Component[]{this.literal("3")})})));
    }

    @Test
    public void shouldParseStepExpressionFromParenthesizedLiteral() {
        Assert.assertThat((Object)this.parser.parseStepExpr(this.tokenize("('foo')")), (Matcher)Is.is((Object)this.filterStep((XPath.Component)this.paren((XPath.Component)this.literal("foo")), new XPath.Component[0])));
    }

    @Test
    public void shouldParseStepExpressionFromQuotedStringLiteral() {
        Assert.assertThat((Object)this.parser.parseStepExpr(this.tokenize("'foo'")), (Matcher)Is.is((Object)this.filterStep((XPath.Component)this.literal("foo"), new XPath.Component[0])));
    }

    @Test
    public void shouldParseStepExpressionFromFunctionCallWithUnqualifiedName() {
        Assert.assertThat((Object)this.parser.parseStepExpr(this.tokenize("element2(*,*)")), (Matcher)Is.is((Object)this.filterStep((XPath.Component)this.functionCall(this.nameTest("element2"), new XPath.Component[]{this.wildcard(), this.wildcard()}), new XPath.Component[0])));
    }

    @Test
    public void shouldParseStepExpressionFromFunctionCallWithQualifiedName() {
        Assert.assertThat((Object)this.parser.parseStepExpr(this.tokenize("foo:bar(*)")), (Matcher)Is.is((Object)this.filterStep((XPath.Component)this.functionCall(this.nameTest("foo", "bar"), new XPath.Component[]{this.wildcard()}), new XPath.Component[0])));
    }

    @Test
    public void shouldParseStepExpressionFromQualifiedNameWithPredicate() {
        Assert.assertThat((Object)this.parser.parseStepExpr(this.tokenize("foo:bar[3]")), (Matcher)Is.is((Object)this.axisStep((XPath.NodeTest)this.nameTest("foo", "bar"), new XPath.Component[]{this.literal("3")})));
    }

    @Test
    public void shouldParseAxisStepFromAttributeWithNoPrefix() {
        Assert.assertThat((Object)this.parser.parseAxisStep(this.tokenize("@foo")), (Matcher)Is.is((Object)this.axisStep((XPath.NodeTest)this.attributeNameTest(this.nameTest("foo")), new XPath.Component[0])));
    }

    @Test
    public void shouldParseAxisStepFromAttributeWithPrefix() {
        Assert.assertThat((Object)this.parser.parseAxisStep(this.tokenize("@foo:bar")), (Matcher)Is.is((Object)this.axisStep((XPath.NodeTest)this.attributeNameTest(this.nameTest("foo", "bar")), new XPath.Component[0])));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseAxisStepFromInvalidAttributeName() {
        this.parser.parseAxisStep(this.tokenize("@3:invalidName"));
    }

    @Test
    public void shouldParseAxisStepFromNameWithNoPrefix() {
        Assert.assertThat((Object)this.parser.parseAxisStep(this.tokenize("foo")), (Matcher)Is.is((Object)this.axisStep((XPath.NodeTest)this.nameTest("foo"), new XPath.Component[0])));
    }

    @Test
    public void shouldParseAxisStepFromNameWithPrefix() {
        Assert.assertThat((Object)this.parser.parseAxisStep(this.tokenize("foo:bar")), (Matcher)Is.is((Object)this.axisStep((XPath.NodeTest)this.nameTest("foo", "bar"), new XPath.Component[0])));
    }

    @Test
    public void shouldReturnNullFromParseAxisStepIfInvalidName() {
        Assert.assertThat((Object)this.parser.parseAxisStep(this.tokenize("3:invalidName")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseAxisStepFromWildcard() {
        Assert.assertThat((Object)this.parser.parseAxisStep(this.tokenize("*")), (Matcher)Is.is((Object)this.axisStep((XPath.NodeTest)this.wildcard(), new XPath.Component[0])));
    }

    @Test
    public void shouldParseAxisStepFromWildcardPrefixAndNonWildcardLocalName() {
        Assert.assertThat((Object)this.parser.parseAxisStep(this.tokenize("*:foo")), (Matcher)Is.is((Object)this.axisStep((XPath.NodeTest)this.nameTest(null, "foo"), new XPath.Component[0])));
    }

    @Test
    public void shouldParseAxisStepFromWithPrefixAndWildcardLocalName() {
        Assert.assertThat((Object)this.parser.parseAxisStep(this.tokenize("foo:*")), (Matcher)Is.is((Object)this.axisStep((XPath.NodeTest)this.nameTest("foo", null), new XPath.Component[0])));
    }

    @Test
    public void shouldParseAxisStepFromWildcardPrefixAndNonWildcardLocalNameWithPredicates() {
        Assert.assertThat((Object)this.parser.parseAxisStep(this.tokenize("*:name[3]")), (Matcher)Is.is((Object)this.axisStep((XPath.NodeTest)this.nameTest(null, "name"), new XPath.Component[]{this.literal("3")})));
    }

    @Test
    public void shouldParseAxisStepFromWildcardLocalNameWithPredicates() {
        Assert.assertThat((Object)this.parser.parseAxisStep(this.tokenize("*[3]")), (Matcher)Is.is((Object)this.axisStep((XPath.NodeTest)this.wildcard(), new XPath.Component[]{this.literal("3")})));
    }

    @Test
    public void shouldParseAxisStepFromWildcardPrefixAndLocalNameWithPredicates() {
        Assert.assertThat((Object)this.parser.parseAxisStep(this.tokenize("*:*[3]")), (Matcher)Is.is((Object)this.axisStep((XPath.NodeTest)this.wildcard(), new XPath.Component[]{this.literal("3")})));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNonAbbreviatedSelfAxis() {
        this.parser.parseAxisStep(this.tokenize("self::x"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNonAbbreviatedChildAxis() {
        this.parser.parseAxisStep(this.tokenize("child::x"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNonAbbreviatedDescendantAxis() {
        this.parser.parseAxisStep(this.tokenize("descendant::x"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNonAbbreviatedDescendantOrSelfAxis() {
        this.parser.parseAxisStep(this.tokenize("descendant-or-self::x"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNonAbbreviatedFollowingAxis() {
        this.parser.parseAxisStep(this.tokenize("following::x"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNonAbbreviatedFollowingSiblingAxis() {
        this.parser.parseAxisStep(this.tokenize("following-sibling::x"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNonAbbreviatedNamespaceAxis() {
        this.parser.parseAxisStep(this.tokenize("namespace::x"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNonAbbreviatedParentAxis() {
        this.parser.parseAxisStep(this.tokenize("parent::x"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNonAbbreviatedAncestorAxis() {
        this.parser.parseAxisStep(this.tokenize("ancestor::x"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNonAbbreviatedAncestorOrSelfAxis() {
        this.parser.parseAxisStep(this.tokenize("ancestor-or-self::x"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNonAbbreviatedPrecedingAxis() {
        this.parser.parseAxisStep(this.tokenize("preceding::x"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNonAbbreviatedPrecedingSiblingAxis() {
        this.parser.parseAxisStep(this.tokenize("preceding-sibling::x"));
    }

    @Test
    public void shouldParsePredicatesWithAttributeEqualsStringLiteral() {
        Assert.assertThat((Object)this.parser.parsePredicates(this.tokenize("[@jcr:title='something']")), (Matcher)Is.is(this.predicates(new XPath.Component[]{this.comparison((XPath.Component)this.attributeNameTest(this.nameTest("jcr", "title")), Operator.EQUAL_TO, (XPath.Component)this.literal("something"))})));
    }

    @Test
    public void shouldParsePredicatesWithAttributeLessThanIntegerLiteral() {
        Assert.assertThat((Object)this.parser.parsePredicates(this.tokenize("[@ex:age<3]")), (Matcher)Is.is(this.predicates(new XPath.Component[]{this.comparison((XPath.Component)this.attributeNameTest(this.nameTest("ex", "age")), Operator.LESS_THAN, (XPath.Component)this.literal("3"))})));
    }

    @Test
    public void shouldParsePredicatesWithAttributeLikeStringLiteral() {
        Assert.assertThat((Object)this.parser.parsePredicates(this.tokenize("[jcr:like(@jcr:title,'%something%')]")), (Matcher)Is.is(this.predicates(new XPath.Component[]{this.functionCall(this.nameTest("jcr", "like"), new XPath.Component[]{this.attributeNameTest(this.nameTest("jcr", "title")), this.literal("%something%")})})));
    }

    @Test
    public void shouldParsePredicatesWithAndedExpressions() {
        Assert.assertThat((Object)this.parser.parsePredicates(this.tokenize("[@ex:age<3 and jcr:like(@jcr:title,'%something%')]")), (Matcher)Is.is(this.predicates(new XPath.Component[]{this.and((XPath.Component)this.comparison((XPath.Component)this.attributeNameTest(this.nameTest("ex", "age")), Operator.LESS_THAN, (XPath.Component)this.literal("3")), (XPath.Component)this.functionCall(this.nameTest("jcr", "like"), new XPath.Component[]{this.attributeNameTest(this.nameTest("jcr", "title")), this.literal("%something%")}))})));
    }

    @Test
    public void shouldParsePredicatesWithOredExpressions() {
        Assert.assertThat((Object)this.parser.parsePredicates(this.tokenize("[@ex:age<3 or jcr:like(@jcr:title,'%something%')]")), (Matcher)Is.is(this.predicates(new XPath.Component[]{this.or((XPath.Component)this.comparison((XPath.Component)this.attributeNameTest(this.nameTest("ex", "age")), Operator.LESS_THAN, (XPath.Component)this.literal("3")), (XPath.Component)this.functionCall(this.nameTest("jcr", "like"), new XPath.Component[]{this.attributeNameTest(this.nameTest("jcr", "title")), this.literal("%something%")}))})));
    }

    @Test
    public void shouldParsePredicatesWithMultipleSeparatePredicates() {
        Assert.assertThat((Object)this.parser.parsePredicates(this.tokenize("[@ex:age<3][jcr:like(@jcr:title,'%something%')]")), (Matcher)Is.is(this.predicates(new XPath.Component[]{this.comparison((XPath.Component)this.attributeNameTest(this.nameTest("ex", "age")), Operator.LESS_THAN, (XPath.Component)this.literal("3")), this.functionCall(this.nameTest("jcr", "like"), new XPath.Component[]{this.attributeNameTest(this.nameTest("jcr", "title")), this.literal("%something%")})})));
    }

    @Test
    public void shouldParsePredicatesWhenThereIsOnlyOnePredicate() {
        Assert.assertThat((Object)this.parser.parsePredicates(this.tokenize("[foo]")), (Matcher)Is.is(this.predicates(new XPath.Component[]{this.nameTest("foo")})));
    }

    @Test
    public void shouldParsePredicatesWhenThereAreMultiplePredicates() {
        Assert.assertThat((Object)this.parser.parsePredicates(this.tokenize("['foo']['bar']")), (Matcher)Is.is(this.predicates(new XPath.Component[]{this.literal("foo"), this.literal("bar")})));
        Assert.assertThat((Object)this.parser.parsePredicates(this.tokenize("[foo][bar]")), (Matcher)Is.is(this.predicates(new XPath.Component[]{this.nameTest("foo"), this.nameTest("bar")})));
    }

    @Test
    public void shouldParseContextItemExpr() {
        Assert.assertThat((Object)this.parser.parseContextItemExpr(this.tokenize(".")), (Matcher)Is.is((Object)new XPath.ContextItem()));
    }

    @Test
    public void shouldParseParenthesizedExpression() {
        Assert.assertThat((Object)this.parser.parseParenthesizedExpr(this.tokenize("('foo')")), (Matcher)Is.is((Object)this.paren((XPath.Component)this.literal("foo"))));
    }

    @Test
    public void shouldParseNumberLiteralContainingUnquotedIntegralValuesIntoCanonicalStringRepresentation() {
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("1")), (Matcher)Is.is((Object)this.literal("1")));
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("-1")), (Matcher)Is.is((Object)this.literal("-1")));
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("0")), (Matcher)Is.is((Object)this.literal("0")));
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("+1001")), (Matcher)Is.is((Object)this.literal("1001")));
    }

    @Test
    public void shouldParseNumberLiteralContainingUnquotedDecimalValuesIntoCanonicalStringRepresentation() {
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("1.2")), (Matcher)Is.is((Object)this.literal("1.2")));
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("-1.2")), (Matcher)Is.is((Object)this.literal("-1.2")));
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("0.2")), (Matcher)Is.is((Object)this.literal("0.2")));
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("+1001.2")), (Matcher)Is.is((Object)this.literal("1001.2")));
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("1.2e10")), (Matcher)Is.is((Object)this.literal("1.2E10")));
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("-1.2e10")), (Matcher)Is.is((Object)this.literal("-1.2E10")));
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("0.2e10")), (Matcher)Is.is((Object)this.literal("2.0E9")));
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("1.2e+10")), (Matcher)Is.is((Object)this.literal("1.2E10")));
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("-1.2e+10")), (Matcher)Is.is((Object)this.literal("-1.2E10")));
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("0.2e+10")), (Matcher)Is.is((Object)this.literal("2.0E9")));
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("1.2e-10")), (Matcher)Is.is((Object)this.literal("1.2E-10")));
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("-1.2e-10")), (Matcher)Is.is((Object)this.literal("-1.2E-10")));
        Assert.assertThat((Object)this.parser.parseNumericLiteral(this.tokenize("0.2e-10")), (Matcher)Is.is((Object)this.literal("2.0E-11")));
    }

    @Test
    public void shouldParseStringLiteral() {
        Assert.assertThat((Object)this.parser.parseStringLiteral(this.tokenize("one")), (Matcher)Is.is((Object)this.literal("one")));
        Assert.assertThat((Object)this.parser.parseStringLiteral(this.tokenize("'one'")), (Matcher)Is.is((Object)this.literal("one")));
        Assert.assertThat((Object)this.parser.parseStringLiteral(this.tokenize("'one word as a quote'")), (Matcher)Is.is((Object)this.literal("one word as a quote")));
    }

    @Test
    public void shouldParseFunctionCallWithZeroParameters() {
        XPath.FunctionCall func = this.parser.parseFunctionCall(this.tokenize("a()"));
        Assert.assertThat((Object)func, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)func.getName(), (Matcher)Is.is((Object)this.nameTest("a")));
        Assert.assertThat((Object)func.getParameters().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldParseFunctionCallWithOneQuotedStringLiteralParameter() {
        XPath.FunctionCall func = this.parser.parseFunctionCall(this.tokenize("a('foo')"));
        Assert.assertThat((Object)func, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)func.getName(), (Matcher)Is.is((Object)this.nameTest("a")));
        Assert.assertThat((Object)func.getParameters().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(func.getParameters().get(0), (Matcher)Is.is((Object)this.literal("foo")));
    }

    @Test
    public void shouldParseFunctionCallWithOneUnquotedStringLiteralParameter() {
        XPath.FunctionCall func = this.parser.parseFunctionCall(this.tokenize("a(foo)"));
        Assert.assertThat((Object)func, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)func.getName(), (Matcher)Is.is((Object)this.nameTest("a")));
        Assert.assertThat((Object)func.getParameters().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(func.getParameters().get(0), (Matcher)Is.is((Object)this.nameTest("foo")));
    }

    @Test
    public void shouldParseGeneralComp() {
        Assert.assertThat((Object)this.parser.parseGeneralComp(this.tokenize("!=")), (Matcher)Is.is((Object)Operator.NOT_EQUAL_TO));
        Assert.assertThat((Object)this.parser.parseGeneralComp(this.tokenize("=")), (Matcher)Is.is((Object)Operator.EQUAL_TO));
        Assert.assertThat((Object)this.parser.parseGeneralComp(this.tokenize("<")), (Matcher)Is.is((Object)Operator.LESS_THAN));
        Assert.assertThat((Object)this.parser.parseGeneralComp(this.tokenize("<=")), (Matcher)Is.is((Object)Operator.LESS_THAN_OR_EQUAL_TO));
        Assert.assertThat((Object)this.parser.parseGeneralComp(this.tokenize(">")), (Matcher)Is.is((Object)Operator.GREATER_THAN));
        Assert.assertThat((Object)this.parser.parseGeneralComp(this.tokenize(">=")), (Matcher)Is.is((Object)Operator.GREATER_THAN_OR_EQUAL_TO));
        Assert.assertThat((Object)this.parser.parseGeneralComp(this.tokenize("<5")), (Matcher)Is.is((Object)Operator.LESS_THAN));
        Assert.assertThat((Object)this.parser.parseGeneralComp(this.tokenize(">5")), (Matcher)Is.is((Object)Operator.GREATER_THAN));
    }

    @Test
    public void shouldReturnNullFromParseGeneralCompIfOperatorPatternIsNotFound() {
        Assert.assertThat((Object)this.parser.parseGeneralComp(this.tokenize("name")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.parser.parseGeneralComp(this.tokenize("+")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.parser.parseGeneralComp(this.tokenize("!+")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseName() {
        Assert.assertThat((Object)this.parser.parseNameTest(this.tokenize("*")), (Matcher)Is.is((Object)this.wildcard()));
        Assert.assertThat((Object)this.parser.parseNameTest(this.tokenize("*:*")), (Matcher)Is.is((Object)this.wildcard()));
        Assert.assertThat((Object)this.parser.parseNameTest(this.tokenize("*:name")), (Matcher)Is.is((Object)this.nameTest(null, "name")));
        Assert.assertThat((Object)this.parser.parseNameTest(this.tokenize("name:*")), (Matcher)Is.is((Object)this.nameTest("name", null)));
        Assert.assertThat((Object)this.parser.parseNameTest(this.tokenize("abc")), (Matcher)Is.is((Object)this.nameTest("abc")));
        Assert.assertThat((Object)this.parser.parseNameTest(this.tokenize("abc:def")), (Matcher)Is.is((Object)this.nameTest("abc", "def")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNameIfNotValidWildcardOrQName() {
        this.parser.parseNameTest(this.tokenize("3ABC:def"));
    }

    @Test
    public void shouldParseQName() {
        Assert.assertThat((Object)this.parser.parseQName(this.tokenize("abc")), (Matcher)Is.is((Object)this.nameTest("abc")));
        Assert.assertThat((Object)this.parser.parseQName(this.tokenize("abc:def")), (Matcher)Is.is((Object)this.nameTest("abc", "def")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseQNameIfStartsWithDigit() {
        this.parser.parseNCName(this.tokenize("3ABC:def"));
    }

    @Test
    public void shouldParseNCName() {
        Assert.assertThat((Object)this.parser.parseNCName(this.tokenize("ABCDEFGHIJKLMNOPQRSTUVWXYZ")), (Matcher)Is.is((Object)"ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
        Assert.assertThat((Object)this.parser.parseNCName(this.tokenize("abcdefghijklmnopqrstuvwxyz")), (Matcher)Is.is((Object)"abcdefghijklmnopqrstuvwxyz"));
        Assert.assertThat((Object)this.parser.parseNCName(this.tokenize("a0123456789")), (Matcher)Is.is((Object)"a0123456789"));
        Assert.assertThat((Object)this.parser.parseNCName(this.tokenize("a_-3b")), (Matcher)Is.is((Object)"a_-3b"));
        Assert.assertThat((Object)this.parser.parseNCName(this.tokenize("abc:def")), (Matcher)Is.is((Object)"abc"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNCNameIfStartsWithDigit() {
        this.parser.parseNCName(this.tokenize("3ABC"));
    }

    @Test
    public void shouldParseWildcard() {
        Assert.assertThat((Object)this.parser.parseWildcard(this.tokenize("*")), (Matcher)Is.is((Object)this.wildcard()));
        Assert.assertThat((Object)this.parser.parseWildcard(this.tokenize("*:*")), (Matcher)Is.is((Object)this.wildcard()));
        Assert.assertThat((Object)this.parser.parseWildcard(this.tokenize("*:name")), (Matcher)Is.is((Object)this.nameTest(null, "name")));
        Assert.assertThat((Object)this.parser.parseWildcard(this.tokenize("name:*")), (Matcher)Is.is((Object)this.nameTest("name", null)));
    }

    @Test
    public void shouldReturnNullFromParseWildcardIfNotWildcard() {
        Assert.assertThat((Object)this.parser.parseWildcard(this.tokenize("name")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.parser.parseWildcard(this.tokenize("name:foo")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseKindTest() {
        Assert.assertThat((Object)this.parser.parseKindTest(this.tokenize("node()")), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(XPath.AnyKindTest.class)));
        Assert.assertThat((Object)this.parser.parseKindTest(this.tokenize("comment()")), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(XPath.CommentTest.class)));
        Assert.assertThat((Object)this.parser.parseKindTest(this.tokenize("text()")), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(XPath.TextTest.class)));
        Assert.assertThat((Object)this.parser.parseKindTest(this.tokenize("document-node(element(foo:bar))")), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(XPath.DocumentTest.class)));
        Assert.assertThat((Object)this.parser.parseKindTest(this.tokenize("element(foo:bar)")), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(XPath.ElementTest.class)));
        Assert.assertThat((Object)this.parser.parseKindTest(this.tokenize("schema-element(foo:bar)")), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(XPath.SchemaElementTest.class)));
        Assert.assertThat((Object)this.parser.parseKindTest(this.tokenize("attribute(foo:bar)")), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(XPath.AttributeTest.class)));
        Assert.assertThat((Object)this.parser.parseKindTest(this.tokenize("schema-attribute(foo:bar)")), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(XPath.SchemaAttributeTest.class)));
    }

    @Test
    public void shouldParseAnyKindTest() {
        Assert.assertThat((Object)this.parser.parseAnyKindTest(this.tokenize("node()")), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(XPath.AnyKindTest.class)));
    }

    @Test
    public void shouldReturnNullFromParseAnyKindTestIfNotFollowedByOpenAndCloseParenthesis() {
        Assert.assertThat((Object)this.parser.parseAnyKindTest(this.tokenize("node x )")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.parser.parseAnyKindTest(this.tokenize("node(x )")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.parser.parseAnyKindTest(this.tokenize("node(x")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseCommentTest() {
        Assert.assertThat((Object)this.parser.parseCommentTest(this.tokenize("comment()")), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(XPath.CommentTest.class)));
    }

    @Test
    public void shouldReturnNullFromParseCommentTestIfNotFollowedByOpenAndCloseParenthesis() {
        Assert.assertThat((Object)this.parser.parseCommentTest(this.tokenize("comment x )")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.parser.parseCommentTest(this.tokenize("comment(x )")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.parser.parseCommentTest(this.tokenize("comment(x")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseTextTest() {
        Assert.assertThat((Object)this.parser.parseTextTest(this.tokenize("text()")), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(XPath.TextTest.class)));
    }

    @Test
    public void shouldReturnNullFromParseTextTestIfNotFollowedByOpenAndCloseParenthesis() {
        Assert.assertThat((Object)this.parser.parseTextTest(this.tokenize("text x )")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.parser.parseTextTest(this.tokenize("text(x )")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.parser.parseTextTest(this.tokenize("text(x")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseDocumentTest() {
        XPath.DocumentTest result = this.parser.parseDocumentTest(this.tokenize("document-node(element(foo:bar))"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getElementTest().getElementName(), (Matcher)Is.is((Object)this.nameTest("foo", "bar")));
        Assert.assertThat((Object)result.getElementTest().getTypeName(), (Matcher)Is.is((Object)this.wildcard()));
        Assert.assertThat((Object)result.getSchemaElementTest(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        result = this.parser.parseDocumentTest(this.tokenize("document-node(schema-element(foo))"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getSchemaElementTest().getElementDeclarationName(), (Matcher)Is.is((Object)this.nameTest("foo")));
        Assert.assertThat((Object)result.getElementTest(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldReturnNullFromParseDocumentTestIfOpenParenthesisIsNotIncluded() {
        Assert.assertThat((Object)this.parser.parseDocumentTest(this.tokenize("document-node foo")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.parser.parseDocumentTest(this.tokenize("document-node foo")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDocumentTestIfDocumentNodeDoesNotContainElementOrSchemaElement() {
        this.parser.parseDocumentTest(this.tokenize("document-node(foo)"));
    }

    @Test
    public void shouldParseElementTest() {
        XPath.ElementTest result = this.parser.parseElementTest(this.tokenize("element(foo)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getElementName(), (Matcher)Is.is((Object)this.nameTest("foo")));
        Assert.assertThat((Object)result.getTypeName(), (Matcher)Is.is((Object)this.wildcard()));
        result = this.parser.parseElementTest(this.tokenize("element(foo:bar)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getElementName(), (Matcher)Is.is((Object)this.nameTest("foo", "bar")));
        Assert.assertThat((Object)result.getTypeName(), (Matcher)Is.is((Object)this.wildcard()));
        result = this.parser.parseElementTest(this.tokenize("element(foo:bar,baz)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getElementName(), (Matcher)Is.is((Object)this.nameTest("foo", "bar")));
        Assert.assertThat((Object)result.getTypeName(), (Matcher)Is.is((Object)this.nameTest("baz")));
        result = this.parser.parseElementTest(this.tokenize("element(foo:bar,baz:bam)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getElementName(), (Matcher)Is.is((Object)this.nameTest("foo", "bar")));
        Assert.assertThat((Object)result.getTypeName(), (Matcher)Is.is((Object)this.nameTest("baz", "bam")));
        result = this.parser.parseElementTest(this.tokenize("element(foo:bar,*)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getElementName(), (Matcher)Is.is((Object)this.nameTest("foo", "bar")));
        Assert.assertThat((Object)result.getTypeName(), (Matcher)Is.is((Object)this.wildcard()));
        result = this.parser.parseElementTest(this.tokenize("element(*,foo:bar)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getElementName(), (Matcher)Is.is((Object)this.wildcard()));
        Assert.assertThat((Object)result.getTypeName(), (Matcher)Is.is((Object)this.nameTest("foo", "bar")));
        result = this.parser.parseElementTest(this.tokenize("element(*,*)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getElementName(), (Matcher)Is.is((Object)this.wildcard()));
        Assert.assertThat((Object)result.getTypeName(), (Matcher)Is.is((Object)this.wildcard()));
    }

    @Test
    public void shouldReturnNullFromParseElementTestIfOpenParenthesisIsNotIncluded() {
        XPath.ElementTest result = this.parser.parseElementTest(this.tokenize("attribute foo"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseSchemaElementTest() {
        XPath.SchemaElementTest result = this.parser.parseSchemaElementTest(this.tokenize("schema-element(foo)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getElementDeclarationName(), (Matcher)Is.is((Object)this.nameTest("foo")));
        result = this.parser.parseSchemaElementTest(this.tokenize("schema-element(foo:bar)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getElementDeclarationName(), (Matcher)Is.is((Object)this.nameTest("foo", "bar")));
        result = this.parser.parseSchemaElementTest(this.tokenize("schema-element(*)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getElementDeclarationName(), (Matcher)Is.is((Object)this.wildcard()));
    }

    @Test
    public void shouldReturnNullFromParseSchemaElementTestIfOpenParenthesisIsNotIncluded() {
        XPath.SchemaElementTest result = this.parser.parseSchemaElementTest(this.tokenize("schema-element foo"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseAttributeTest() {
        XPath.AttributeTest result = this.parser.parseAttributeTest(this.tokenize("attribute(foo)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)Is.is((Object)this.nameTest("foo")));
        Assert.assertThat((Object)result.getTypeName(), (Matcher)Is.is((Object)this.wildcard()));
        result = this.parser.parseAttributeTest(this.tokenize("attribute(foo:bar)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)Is.is((Object)this.nameTest("foo", "bar")));
        Assert.assertThat((Object)result.getTypeName(), (Matcher)Is.is((Object)this.wildcard()));
        result = this.parser.parseAttributeTest(this.tokenize("attribute(foo:bar,baz)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)Is.is((Object)this.nameTest("foo", "bar")));
        Assert.assertThat((Object)result.getTypeName(), (Matcher)Is.is((Object)this.nameTest("baz")));
        result = this.parser.parseAttributeTest(this.tokenize("attribute(foo:bar,baz:bar)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)Is.is((Object)this.nameTest("foo", "bar")));
        Assert.assertThat((Object)result.getTypeName(), (Matcher)Is.is((Object)this.nameTest("baz", "bar")));
        result = this.parser.parseAttributeTest(this.tokenize("attribute(*,baz:bar)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)Is.is((Object)this.wildcard()));
        Assert.assertThat((Object)result.getTypeName(), (Matcher)Is.is((Object)this.nameTest("baz", "bar")));
        result = this.parser.parseAttributeTest(this.tokenize("attribute(foo:bar,*)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)Is.is((Object)this.nameTest("foo", "bar")));
        Assert.assertThat((Object)result.getTypeName(), (Matcher)Is.is((Object)this.wildcard()));
    }

    @Test
    public void shouldReturnNullFromParseAttributeTestIfOpenParenthesisIsNotIncluded() {
        XPath.AttributeTest result = this.parser.parseAttributeTest(this.tokenize("attribute foo"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseSchemaAttributeTest() {
        XPath.SchemaAttributeTest result = this.parser.parseSchemaAttributeTest(this.tokenize("schema-attribute(foo)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getAttributeDeclarationName(), (Matcher)Is.is((Object)this.nameTest("foo")));
        result = this.parser.parseSchemaAttributeTest(this.tokenize("schema-attribute(foo:bar)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getAttributeDeclarationName(), (Matcher)Is.is((Object)this.nameTest("foo", "bar")));
        result = this.parser.parseSchemaAttributeTest(this.tokenize("schema-attribute(*)"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getAttributeDeclarationName(), (Matcher)Is.is((Object)this.wildcard()));
    }

    @Test
    public void shouldReturnNullFromParseSchemaAttributeTestIfOpenParenthesisIsNotIncluded() {
        XPath.SchemaAttributeTest result = this.parser.parseSchemaAttributeTest(this.tokenize("schema-attribute foo"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseOrderByOneAttributeNameClause() {
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @a1")), (Matcher)Is.is((Object)this.orderBy(this.asc(this.nameTest("a1")))));
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @a1 ascending")), (Matcher)Is.is((Object)this.orderBy(this.asc(this.nameTest("a1")))));
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @a1 descending")), (Matcher)Is.is((Object)this.orderBy(this.desc(this.nameTest("a1")))));
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @pre:a1")), (Matcher)Is.is((Object)this.orderBy(this.asc(this.nameTest("pre", "a1")))));
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @pre:a1 ascending")), (Matcher)Is.is((Object)this.orderBy(this.asc(this.nameTest("pre", "a1")))));
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @pre:a1 descending")), (Matcher)Is.is((Object)this.orderBy(this.desc(this.nameTest("pre", "a1")))));
    }

    @Test
    public void shouldParseOrderByMultipleAttributeNameClauses() {
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @a1,@a2")), (Matcher)Is.is((Object)this.orderBy(this.asc(this.nameTest("a1")), this.asc(this.nameTest("a2")))));
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @a1 ascending , @a2 ascending")), (Matcher)Is.is((Object)this.orderBy(this.asc(this.nameTest("a1")), this.asc(this.nameTest("a2")))));
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @a1 descending, @a2 ascending")), (Matcher)Is.is((Object)this.orderBy(this.desc(this.nameTest("a1")), this.asc(this.nameTest("a2")))));
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @a1 ascending , @a2 descending")), (Matcher)Is.is((Object)this.orderBy(this.asc(this.nameTest("a1")), this.desc(this.nameTest("a2")))));
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @a1 descending, @a2 descending")), (Matcher)Is.is((Object)this.orderBy(this.desc(this.nameTest("a1")), this.desc(this.nameTest("a2")))));
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @pre:a1, @pre:a2")), (Matcher)Is.is((Object)this.orderBy(this.asc(this.nameTest("pre", "a1")), this.asc(this.nameTest("pre", "a2")))));
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @a1 ascending, @pre:a2 ascending")), (Matcher)Is.is((Object)this.orderBy(this.asc(this.nameTest("a1")), this.asc(this.nameTest("pre", "a2")))));
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @a1 descending, @pre:a2 ascending")), (Matcher)Is.is((Object)this.orderBy(this.desc(this.nameTest("a1")), this.asc(this.nameTest("pre", "a2")))));
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @a1 ascending, @pre:a2 descending")), (Matcher)Is.is((Object)this.orderBy(this.asc(this.nameTest("a1")), this.desc(this.nameTest("pre", "a2")))));
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokenize("order by @a1 descending, @pre:a2 descending")), (Matcher)Is.is((Object)this.orderBy(this.desc(this.nameTest("a1")), this.desc(this.nameTest("pre", "a2")))));
    }

    protected XPath.OrderBy orderBy(XPath.OrderBySpec ... specs) {
        return new XPath.OrderBy(Arrays.asList(specs));
    }

    protected XPath.OrderBySpec asc(XPath.FunctionCall scoreFunction) {
        return new XPath.OrderBySpec(Order.ASCENDING, scoreFunction);
    }

    protected XPath.OrderBySpec desc(XPath.FunctionCall scoreFunction) {
        return new XPath.OrderBySpec(Order.DESCENDING, scoreFunction);
    }

    protected XPath.OrderBySpec asc(XPath.NameTest attributeName) {
        return new XPath.OrderBySpec(Order.ASCENDING, attributeName);
    }

    protected XPath.OrderBySpec desc(XPath.NameTest attributeName) {
        return new XPath.OrderBySpec(Order.DESCENDING, attributeName);
    }

    protected TokenStream tokenize(String xpath) {
        XPathParser.XPathTokenizer tokenizer = new XPathParser.XPathTokenizer(false);
        return new TokenStream(xpath, (TokenStream.Tokenizer)tokenizer, true).start();
    }

    protected XPath.DescendantOrSelf descendantOrSelf() {
        return new XPath.DescendantOrSelf();
    }

    protected XPath.AxisStep axisStep(XPath.NodeTest nodeTest, XPath.Component ... predicates) {
        return new XPath.AxisStep(nodeTest, this.predicates(predicates));
    }

    protected XPath.FilterStep filterStep(XPath.Component primaryExpression, XPath.Component ... predicates) {
        return new XPath.FilterStep(primaryExpression, this.predicates(predicates));
    }

    protected XPath.PathExpression pathExpr(XPath.StepExpression ... steps) {
        return this.pathExpr(Arrays.asList(steps));
    }

    protected XPath.PathExpression pathExpr(List<XPath.StepExpression> steps) {
        return new XPath.PathExpression(false, steps, null);
    }

    protected XPath.PathExpression pathExpr(List<XPath.StepExpression> steps, XPath.OrderBy orderBy) {
        return new XPath.PathExpression(false, steps, orderBy);
    }

    protected XPath.PathExpression pathExpr(XPath.OrderBy orderBy, XPath.StepExpression ... steps) {
        return this.pathExpr(Arrays.asList(steps), orderBy);
    }

    protected XPath.PathExpression relativePathExpr(XPath.StepExpression ... steps) {
        return this.relativePathExpr(Arrays.asList(steps));
    }

    protected XPath.PathExpression relativePathExpr(List<XPath.StepExpression> steps) {
        return new XPath.PathExpression(true, steps, null);
    }

    protected XPath.PathExpression relativePathExpr(List<XPath.StepExpression> steps, XPath.OrderBy orderBy) {
        return new XPath.PathExpression(true, steps, orderBy);
    }

    protected XPath.Literal literal(String value) {
        return new XPath.Literal(value);
    }

    protected XPath.ContextItem contextItem() {
        return new XPath.ContextItem();
    }

    protected XPath.And and(XPath.Component left, XPath.Component right) {
        return new XPath.And(left, right);
    }

    protected XPath.Or or(XPath.Component left, XPath.Component right) {
        return new XPath.Or(left, right);
    }

    protected XPath.Comparison comparison(XPath.Component left, Operator operator, XPath.Component right) {
        return new XPath.Comparison(left, operator, right);
    }

    protected List<XPath.Component> predicates(XPath.Component ... predicates) {
        return Arrays.asList(predicates);
    }

    protected XPath.ParenthesizedExpression paren(XPath.Component value) {
        return new XPath.ParenthesizedExpression(value);
    }

    protected XPath.AttributeNameTest attributeNameTest(XPath.NameTest nameTest) {
        return new XPath.AttributeNameTest(nameTest);
    }

    protected XPath.AttributeTest attribute(XPath.NameTest name) {
        return new XPath.AttributeTest(name, null);
    }

    protected XPath.AttributeTest attribute(XPath.NameTest name, XPath.NameTest type) {
        return new XPath.AttributeTest(name, type);
    }

    protected XPath.ElementTest element(XPath.NameTest name) {
        return new XPath.ElementTest(name, null);
    }

    protected XPath.ElementTest element(XPath.NameTest name, XPath.NameTest type) {
        return new XPath.ElementTest(name, type);
    }

    protected XPath.FunctionCall functionCall(XPath.NameTest name, XPath.Component ... parameters) {
        return new XPath.FunctionCall(name, Arrays.asList(parameters));
    }

    protected XPath.NameTest wildcard() {
        return new XPath.NameTest(null, null);
    }

    protected XPath.NameTest nameTest(String localPart) {
        return new XPath.NameTest(null, localPart);
    }

    protected XPath.NameTest nameTest(String prefix, String local) {
        return new XPath.NameTest(prefix, local);
    }

    protected void assertParsable(String xpath) {
        new XPathQueryParser().parseQuery(xpath, this.typeSystem);
    }

    protected void assertParsable(String xpath, XPath.Component component) {
        XPath.Component actual = this.parser.parseExpr(this.tokenize(xpath));
        if (component != null) {
            Assert.assertThat((Object)actual, (Matcher)Is.is((Object)component));
        } else {
            Assert.assertThat((Object)actual, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
    }

    protected void assertNotParsable(String xpath) {
        try {
            new XPathQueryParser().parseQuery(xpath, this.typeSystem);
            Assert.fail((String)("Expected an invalid XPath:  " + xpath));
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
    }
}

