/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.CndNodeTypeReader;
import org.modeshape.jcr.JaasTestUtil;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.nodetype.InvalidNodeTypeDefinitionException;
import org.modeshape.jcr.query.JcrQueryResult;
import org.modeshape.repository.ModeShapeConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrQueryManagerTest {
    private static JcrConfiguration configuration;
    private static JcrEngine engine;
    private static JcrRepository repository;
    private Session session;
    private boolean print;

    protected static URI resourceUri(String name) throws URISyntaxException {
        return JcrQueryManagerTest.resourceUrl(name).toURI();
    }

    protected static URL resourceUrl(String name) {
        return JcrQueryManagerTest.class.getClassLoader().getResource(name);
    }

    protected static InputStream resourceStream(String name) {
        return JcrQueryManagerTest.class.getClassLoader().getResourceAsStream(name);
    }

    protected static String[] carColumnNames() {
        return new String[]{"car:mpgCity", "car:lengthInInches", "car:maker", "car:userRating", "car:engine", "car:mpgHighway", "car:valueRating", "jcr:primaryType", "car:wheelbaseInInches", "car:year", "car:model", "car:msrp", "jcr:created", "jcr:createdBy", "jcr:name", "jcr:path", "jcr:score", "mode:depth", "mode:localName"};
    }

    protected static String[] minimumColumnNames() {
        return new String[]{"jcr:primaryType", "jcr:name", "jcr:path", "jcr:score", "mode:depth", "mode:localName"};
    }

    protected static String[] searchColumnNames() {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BeforeClass
    public static void beforeAll() throws Exception {
        try {
            configuration = new JcrConfiguration();
            ((ModeShapeConfiguration.RepositorySourceDefinition)configuration.repositorySource("car-source").usingClass(InMemoryRepositorySource.class)).setDescription("The automobile content");
            configuration.repository("cars").setSource("car-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrQueryManagerTest.resourceUrl("cars.cnd")).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "readonly,readwrite,admin").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr");
            engine = configuration.build();
            engine.start();
            JaasTestUtil.initJaas("security/jaas.conf.xml");
            try {
                repository = engine.getRepository("cars");
            }
            catch (RuntimeException t) {
                t.printStackTrace();
                throw t;
            }
            catch (Exception t) {
                t.printStackTrace();
                throw t;
            }
            Session session = repository.login();
            try {
                block12: {
                    InputStream stream = JcrQueryManagerTest.resourceStream("io/cars-system-view.xml");
                    try {
                        try {
                            session.getWorkspace().importXML("/", stream, 0);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            Object var4_7 = null;
                            stream.close();
                            break block12;
                        }
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        stream.close();
                        throw throwable;
                    }
                    stream.close();
                }
                JcrQueryManagerTest.registerNodeTypes(session, "fincayra.cnd");
                JcrQueryManagerTest.registerNodeTypes(session, "magnolia.cnd");
                Node other = session.getRootNode().addNode("Other", "nt:unstructured");
                other.addNode("NodeA", "nt:unstructured").setProperty("something", "value3 quick brown fox");
                other.addNode("NodeA", "nt:unstructured").setProperty("something", "value2 quick brown cat");
                other.addNode("NodeA", "nt:unstructured").setProperty("something", "value1 quick black dog");
                session.getRootNode().addNode("NodeB", "nt:unstructured").setProperty("myUrl", "http://www.acme.com/foo/bar");
                session.save();
                session.getWorkspace().getQueryManager().createQuery("//element(*,nt:unstructured)", "xpath");
                session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [nt:base]", "JCR-SQL2");
                Object var6_12 = null;
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                session.logout();
                throw throwable;
            }
            session.logout();
            repository.getRepositoryTypeManager().getRepositorySchemata();
            return;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void afterAll() throws Exception {
        try {
            engine.shutdown();
            engine.awaitTermination(3L, TimeUnit.SECONDS);
            engine = null;
            configuration = null;
            Object var1 = null;
        }
        catch (Throwable throwable) {
            Object var1_1 = null;
            JaasTestUtil.releaseJaas();
            throw throwable;
        }
        JaasTestUtil.releaseJaas();
    }

    @Before
    public void beforeEach() throws Exception {
        this.print = false;
        this.session = repository.login();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            try {
                this.session.logout();
                Object var2_1 = null;
                this.session = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.session = null;
                throw throwable;
            }
        }
    }

    protected static void registerNodeTypes(Session session, String pathToClasspathResource) throws RepositoryException, IOException {
        CndNodeTypeReader cndReader = new CndNodeTypeReader(session);
        cndReader.read(pathToClasspathResource);
        session.getWorkspace().getNodeTypeManager().registerNodeTypes(cndReader.getNodeTypeDefinitions(), true);
    }

    protected Name name(String name) {
        return (Name)engine.getExecutionContext().getValueFactories().getNameFactory().create(name);
    }

    protected Path.Segment segment(String segment) {
        return engine.getExecutionContext().getValueFactories().getPathFactory().createSegment(segment);
    }

    protected List<Path.Segment> segments(String ... segments) {
        ArrayList<Path.Segment> result = new ArrayList<Path.Segment>();
        for (String segment : segments) {
            result.add(this.segment(segment));
        }
        return result;
    }

    protected void assertResults(Query query, QueryResult result, long numberOfResults) throws RepositoryException {
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        if (this.print) {
            System.out.println();
            System.out.println(query);
            System.out.println(" plan -> " + ((JcrQueryResult)result).getPlan());
            System.out.println(result);
        }
        Assert.assertThat((Object)result.getNodes().getSize(), (Matcher)Is.is((Object)numberOfResults));
        Assert.assertThat((Object)result.getRows().getSize(), (Matcher)Is.is((Object)numberOfResults));
    }

    protected void assertResultsHaveColumns(QueryResult result, String ... columnNames) throws RepositoryException {
        HashSet<String> expectedNames = new HashSet<String>();
        for (String name : columnNames) {
            expectedNames.add(name);
        }
        HashSet<String> actualNames = new HashSet<String>();
        for (String name : result.getColumnNames()) {
            actualNames.add(name);
        }
        Assert.assertThat(actualNames, (Matcher)Is.is(expectedNames));
    }

    protected void assertResultsHaveRows(QueryResult result, String columnName, String ... rowValuesAsStrings) throws RepositoryException {
        RowIterator iter = result.getRows();
        int i = 0;
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            Assert.assertThat((Object)row.getValue(columnName).getString(), (Matcher)Is.is((Object)rowValuesAsStrings[i++]));
        }
    }

    protected RowResult assertRow(QueryResult result, int rowNumber) throws RepositoryException {
        RowIterator rowIter = result.getRows();
        Row row = null;
        for (int i = 0; i != rowNumber; ++i) {
            row = rowIter.nextRow();
        }
        Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        return new RowResult(row);
    }

    @Test
    public void shouldStartUp() {
        Assert.assertThat((Object)engine.getRepositoryService(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveLoadedContent() throws RepositoryException {
        Node node = this.session.getRootNode().getNode("Cars");
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.hasNode("Sports"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.hasNode("Utility"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.hasNode("Hybrid"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.hasNode("Hybrid/Toyota Prius"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"nt:unstructured"));
    }

    @Test
    public void shouldReturnQueryManagerFromWorkspace() throws RepositoryException {
        Assert.assertThat((Object)this.session.getWorkspace().getQueryManager(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryToFindAllNodes() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [nt:base]", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 24L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.minimumColumnNames());
    }

    @Test
    @FixFor(value={"MODE-1055"})
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryToFindAllNodesWithCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [nt:base] WHERE [car:year] < 2009", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 13L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.minimumColumnNames());
    }

    @Test
    @FixFor(value={"MODE-1055"})
    public void shouldReturnNullValuesForNonExistantPropertiesInSelectClauseOfJcrSql2Query() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT bogus, laughable, [car:year] FROM [nt:base] WHERE [car:year] < 2009", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 13L);
        this.assertResultsHaveColumns(result, "bogus", "laughable", "car:year");
        RowIterator rows = result.getRows();
        while (rows.hasNext()) {
            Row row = rows.nextRow();
            Assert.assertThat((Object)row.getValue("bogus"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
            Assert.assertThat((Object)row.getValue("laughable"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
            Assert.assertThat((Object)row.getValue("car:year"), (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
        }
    }

    @Test
    @FixFor(value={"MODE-1055"})
    public void shouldNotMatchNodesWhenQueryUsesNonExistantPropertyInCriteriaInSelectClauseOfJcrSql2Query() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT bogus, laughable, [car:year] FROM [nt:base] WHERE argle < 2009", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 0L);
        this.assertResultsHaveColumns(result, "bogus", "laughable", "car:year");
    }

    @Test
    @FixFor(value={"MODE-1055"})
    public void shouldNotOrderByNonExistantPropertyInCriteriaInSelectClauseOfJcrSql2Query() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT bogus, laughable, [car:year] FROM [nt:base] ORDER BY argle", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 24L);
        this.assertResultsHaveColumns(result, "bogus", "laughable", "argle", "car:year");
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryToFindAllCarNodes() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [car:Car]", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 13L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.carColumnNames());
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryToFindAllCarNodesOrderedByYear() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [car:Car] ORDER BY [car:year]", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 13L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.carColumnNames());
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryToFindAllCarNodesOrderedByMsrp() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [car:Car] ORDER BY [car:msrp] DESC", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 13L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.carColumnNames());
        this.assertRow(result, 1).has("car:model", "LR3").and("car:msrp", "$48,525").and("car:mpgCity", 12L);
        this.assertRow(result, 2).has("car:model", "IS350").and("car:msrp", "$36,305").and("car:mpgCity", 18L);
        this.assertRow(result, 10).has("car:model", "DB9").and("car:msrp", "$171,600").and("car:mpgCity", 12L);
    }

    @Test
    @FixFor(value={"MODE-1057"})
    public void shouldAllowEqualityCriteriaOnPropertyDefinedWithNumericPropertyDefinition() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT [car:maker], [car:model], [car:year], [car:userRating] FROM [car:Car] AS car WHERE [car:userRating] = 4", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 4L);
        this.assertResultsHaveColumns(result, "car:maker", "car:model", "car:year", "car:userRating");
    }

    @Test
    @FixFor(value={"MODE-1057"})
    public void shouldAllowLikeCriteriaOnPropertyDefinedWithNumericPropertyDefinition() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT [car:maker], [car:model], [car:year], [car:userRating] FROM [car:Car] AS car WHERE [car:userRating] LIKE 4", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 4L);
        this.assertResultsHaveColumns(result, "car:maker", "car:model", "car:year", "car:userRating");
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryToFindAllCarsUnderHybrid() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT car.[car:maker], car.[car:model], car.[car:year], car.[car:msrp] FROM [car:Car] AS car WHERE PATH(car) LIKE '%/Hybrid/%'", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 3L);
        this.assertResultsHaveColumns(result, "car:maker", "car:model", "car:year", "car:msrp");
        this.assertRow(result, 1).has("car:model", "Altima").and("car:msrp", "$18,260").and("car:year", 2008L);
        this.assertRow(result, 2).has("car:model", "Prius").and("car:msrp", "$21,500").and("car:year", 2008L);
        this.assertRow(result, 3).has("car:model", "Highlander").and("car:msrp", "$34,200").and("car:year", 2008L);
    }

    @Ignore
    @Test
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryUsingJoinToFindAllCarsUnderHybrid() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT car.[car:maker], car.[car:model], car.[car:year], car.[car:msrp] FROM [car:Car] AS car JOIN [nt:unstructured] AS hybrid ON ISCHILDNODE(car,hybrid) WHERE NAME(hybrid) = 'Hybrid'", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 12L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.carColumnNames());
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryToFindAllUnstructuredNodes() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [nt:unstructured]", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 23L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.minimumColumnNames());
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryWithChildNodeJoin() throws RepositoryException {
        String sql = "SELECT car.* from [car:Car] as car JOIN [nt:unstructured] as category ON ISCHILDNODE(car,category) WHERE NAME(category) LIKE 'Utility'";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 5L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.carColumnNames());
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryWithChildNodeJoinAndColumnsFromBothSidesOfJoin() throws RepositoryException {
        String sql = "SELECT car.*, category.[jcr:primaryType] from [car:Car] as car JOIN [nt:unstructured] as category ON ISCHILDNODE(car,category) WHERE NAME(category) LIKE 'Utility'";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 5L);
        String[] expectedColumnNames = new String[]{"car:mpgCity", "car:lengthInInches", "car:maker", "car:userRating", "car:engine", "car:mpgHighway", "car:valueRating", "car.jcr:primaryType", "car:wheelbaseInInches", "car:year", "car:model", "car:msrp", "jcr:created", "jcr:createdBy", "category.jcr:primaryType", "jcr:name", "jcr:path", "jcr:score", "mode:depth", "mode:localName"};
        this.assertResultsHaveColumns(result, expectedColumnNames);
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryWithDescendantNodeJoinWithoutCriteria() throws RepositoryException {
        String sql = "SELECT * FROM [car:Car] as car JOIN [nt:unstructured] as all ON ISDESCENDANTNODE(car,all)";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 26L);
        String[] expectedColumnNames = new String[]{"car:mpgCity", "car:lengthInInches", "car:maker", "car:userRating", "car:engine", "car:mpgHighway", "car:valueRating", "car.jcr:primaryType", "car:wheelbaseInInches", "car:year", "car:model", "car:msrp", "jcr:created", "jcr:createdBy", "all.jcr:primaryType", "car.jcr:name", "car.jcr:path", "car.jcr:score", "car.mode:depth", "car.mode:localName", "all.jcr:name", "all.jcr:path", "all.jcr:score", "all.mode:depth", "all.mode:localName"};
        this.assertResultsHaveColumns(result, expectedColumnNames);
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryWithDescendantNodeJoinWithDepthCriteria() throws RepositoryException {
        String sql = "SELECT * FROM [car:Car] as car JOIN [nt:unstructured] as category ON ISDESCENDANTNODE(car,category) WHERE DEPTH(category) = 2";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 13L);
        String[] expectedColumnNames = new String[]{"car:mpgCity", "car:lengthInInches", "car:maker", "car:userRating", "car:engine", "car:mpgHighway", "car:valueRating", "car.jcr:primaryType", "car:wheelbaseInInches", "car:year", "car:model", "car:msrp", "jcr:created", "jcr:createdBy", "category.jcr:primaryType", "car.jcr:name", "car.jcr:path", "car.jcr:score", "car.mode:depth", "car.mode:localName", "category.jcr:name", "category.jcr:path", "category.jcr:score", "category.mode:depth", "category.mode:localName"};
        this.assertResultsHaveColumns(result, expectedColumnNames);
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryWithDescendantNodeJoin() throws RepositoryException {
        String sql = "SELECT car.* from [car:Car] as car JOIN [nt:unstructured] as category ON ISDESCENDANTNODE(car,category) WHERE NAME(category) LIKE 'Utility'";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 5L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.carColumnNames());
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryWithDescendantNodeJoinAndColumnsFromBothSidesOfJoin() throws RepositoryException {
        String sql = "SELECT car.*, category.[jcr:primaryType] from [car:Car] as car JOIN [nt:unstructured] as category ON ISDESCENDANTNODE(car,category) WHERE NAME(category) LIKE 'Utility'";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 5L);
        String[] expectedColumnNames = new String[]{"car:mpgCity", "car:lengthInInches", "car:maker", "car:userRating", "car:engine", "car:mpgHighway", "car:valueRating", "car.jcr:primaryType", "car:wheelbaseInInches", "car:year", "car:model", "car:msrp", "jcr:created", "jcr:createdBy", "category.jcr:primaryType", "jcr:name", "jcr:path", "jcr:score", "mode:depth", "mode:localName"};
        this.assertResultsHaveColumns(result, expectedColumnNames);
    }

    @Test
    @FixFor(value={"MODE-829"})
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryWithDescendantNodeJoinUsingNtBase() throws RepositoryException {
        String sql = "SELECT * FROM [nt:base] AS category JOIN [nt:base] AS cars ON ISDESCENDANTNODE(cars,category) WHERE ISCHILDNODE(category,'/Cars')";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 13L);
        String[] expectedColumns = new String[]{"category.jcr:primaryType", "cars.jcr:primaryType", "cars.jcr:name", "cars.jcr:path", "cars.jcr:score", "cars.mode:depth", "cars.mode:localName", "category.jcr:name", "category.jcr:path", "category.jcr:score", "category.mode:depth", "category.mode:localName"};
        this.assertResultsHaveColumns(result, expectedColumns);
    }

    @Test
    @FixFor(value={"MODE-829"})
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryWithDescendantNodeJoinUsingNtBaseAndNameConstraint() throws RepositoryException {
        String sql = "SELECT * FROM [nt:base] AS category JOIN [nt:base] AS cars ON ISDESCENDANTNODE(cars,category) WHERE ISCHILDNODE(category,'/Cars') AND NAME(cars) LIKE 'Toyota%'";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 3L);
        String[] expectedColumns = new String[]{"category.jcr:primaryType", "cars.jcr:primaryType", "cars.jcr:name", "cars.jcr:path", "cars.jcr:score", "cars.mode:depth", "cars.mode:localName", "category.jcr:name", "category.jcr:path", "category.jcr:score", "category.mode:depth", "category.mode:localName"};
        this.assertResultsHaveColumns(result, expectedColumns);
    }

    @Test
    @FixFor(value={"MODE-829"})
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryWithDescendantNodeJoinUsingNonExistantNameColumnOnTypeWithResidualProperties() throws RepositoryException {
        String sql = "SELECT * FROM [nt:unstructured] AS category JOIN [nt:unstructured] AS cars ON ISDESCENDANTNODE(cars,category) WHERE ISCHILDNODE(category,'/Cars') AND cars.name = 'd2'";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 0L);
        String[] expectedColumns = new String[]{"category.jcr:primaryType", "cars.jcr:primaryType", "cars.jcr:name", "cars.jcr:path", "cars.jcr:score", "cars.mode:depth", "cars.mode:localName", "category.jcr:name", "category.jcr:path", "category.jcr:score", "category.mode:depth", "category.mode:localName"};
        this.assertResultsHaveColumns(result, expectedColumns);
    }

    @Test
    @FixFor(value={"MODE-829"})
    public void shouldReturnNoResultsForJcrSql2QueryWithDescendantNodeJoinUsingNonExistantNameColumnOnTypeWithNoResidualProperties() throws RepositoryException {
        String sql = "SELECT * FROM [nt:base] AS category JOIN [nt:base] AS cars ON ISDESCENDANTNODE(cars,category) WHERE ISCHILDNODE(category,'/Cars') AND cars.name = 'd2'";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 0L);
        this.assertResultsHaveColumns(result, "cars.mode:depth", "cars.mode:localName", "category.jcr:primaryType", "category.jcr:score", "cars.jcr:score", "category.jcr:path", "cars.jcr:primaryType", "category.mode:localName", "cars.jcr:path", "category.mode:depth", "cars.jcr:name", "category.jcr:name");
    }

    @Test
    @FixFor(value={"MODE-869"})
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryWithSubqueryInCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [car:Car] WHERE [car:maker] IN (SELECT [car:maker] FROM [car:Car] WHERE [car:year] >= 2008)", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 13L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.carColumnNames());
    }

    @Test
    @FixFor(value={"MODE-869"})
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryWithSubqueryInCriteria2() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [car:Car] WHERE [car:maker] IN (SELECT [car:maker] FROM [car:Car] WHERE PATH() LIKE '%/Hybrid/%')", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 4L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.carColumnNames());
    }

    @Test
    @FixFor(value={"MODE-909"})
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryWithOrderBy() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT [jcr:primaryType] from [nt:base] ORDER BY [jcr:primaryType]", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 24L);
        this.assertResultsHaveColumns(result, "jcr:primaryType");
        RowIterator iter = result.getRows();
        String primaryType = "";
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            String nextPrimaryType = row.getValues()[0].getString();
            Assert.assertThat((Object)(nextPrimaryType.compareTo(primaryType) >= 0 ? 1 : 0), (Matcher)Is.is((Object)true));
            primaryType = nextPrimaryType;
        }
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedPathInSelectOfJcrSql2Query() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("select [jcr:primaryType], [jcr:path] FROM [nt:base]", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 24L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path");
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedPathInSelectAndCriteriaOfJcrSql2Query() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("select [jcr:primaryType], [jcr:path] FROM [nt:base] WHERE [jcr:path] LIKE '/Cars/%'", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 17L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path");
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedPathInSelectAndUnqualifiedNameInCriteriaOfJcrSql2Query() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("select [jcr:primaryType], [jcr:path] FROM [nt:base] WHERE [jcr:name] LIKE '%3%'", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 4L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path");
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedPathInSelectAndUnqualifiedLocalNameInCriteriaOfJcrSql2Query() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("select [jcr:primaryType], [jcr:path] FROM [nt:base] WHERE [mode:localName] LIKE '%3%'", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 4L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path");
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithJcrPathInJoinCriteriaOfJcrSql2Query() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("select base.[jcr:primaryType], base.[jcr:path], car.[car:year] FROM [nt:base] AS base JOIN [car:Car] AS car ON car.[jcr:path] = base.[jcr:path]", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 13L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "car:year");
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldNotIncludePseudoColumnsInSelectStarOfJcrSql2Query() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("select * FROM [nt:base]", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 24L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.minimumColumnNames());
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    @FixFor(value={"MODE-1020"})
    public void shouldFindAllPublishAreas() throws Exception {
        String sql = "SELECT [jcr:path], [jcr:title], [jcr:description] FROM [mode:publishArea]";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 0L);
        this.assertResultsHaveColumns(result, "jcr:path", "jcr:title", "jcr:description");
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    @FixFor(value={"MODE-1052"})
    public void shouldProperlyUseNotWithPathConstraints() throws Exception {
        String sql = "SELECT [jcr:path] FROM [nt:base] WHERE ISCHILDNODE([nt:base],'/Cars') ORDER BY [jcr:path]";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 4L);
        this.assertResultsHaveColumns(result, "jcr:path");
        this.assertResultsHaveRows(result, "jcr:path", "/Cars/Hybrid", "/Cars/Luxury", "/Cars/Sports", "/Cars/Utility");
        sql = "SELECT [jcr:path] FROM [nt:base] ORDER BY [jcr:path]";
        query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 24L);
        sql = "SELECT [jcr:path] FROM [nt:base] WHERE NOT(ISCHILDNODE([nt:base],'/Cars')) ORDER BY [jcr:path]";
        query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 20L);
        this.assertResultsHaveColumns(result, "jcr:path");
        this.assertResultsHaveRows(result, "jcr:path", "/", "/Cars", "/Cars/Hybrid/Nissan Altima", "/Cars/Hybrid/Toyota Highlander", "/Cars/Hybrid/Toyota Prius", "/Cars/Luxury/Bentley Continental", "/Cars/Luxury/Cadillac DTS", "/Cars/Luxury/Lexus IS350", "/Cars/Sports/Aston Martin DB9", "/Cars/Sports/Infiniti G37", "/Cars/Utility/Ford F-150", "/Cars/Utility/Hummer H3", "/Cars/Utility/Land Rover LR2", "/Cars/Utility/Land Rover LR3", "/Cars/Utility/Toyota Land Cruiser", "/NodeB", "/Other", "/Other/NodeA", "/Other/NodeA[2]", "/Other/NodeA[3]");
    }

    @Test
    @FixFor(value={"MODE-1110"})
    public void shouldExecuteQueryWithThreeInnerJoinsAndCriteriaOnDifferentSelectors() throws Exception {
        String sql = "SELECT * from [nt:base] as myfirstnodetypes INNER JOIN [nt:base] as mysecondnodetypes         ON ISDESCENDANTNODE(myfirstnodetypes, mysecondnodetypes) INNER JOIN [nt:base] as mythirdnodetypes         ON ISDESCENDANTNODE (mysecondnodetypes, mythirdnodetypes)  WHERE ISDESCENDANTNODE( mythirdnodetypes, '/') OR myfirstnodetypes.[jcr:primaryType] IS NOT NULL";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 46L);
        this.assertResultsHaveColumns(result, "myfirstnodetypes.jcr:path", "mythirdnodetypes.mode:depth", "mysecondnodetypes.mode:depth", "mythirdnodetypes.jcr:path", "mysecondnodetypes.jcr:path", "mythirdnodetypes.jcr:score", "myfirstnodetypes.jcr:score", "mythirdnodetypes.jcr:name", "mysecondnodetypes.jcr:score", "mythirdnodetypes.mode:localName", "myfirstnodetypes.jcr:primaryType", "mysecondnodetypes.jcr:primaryType", "mysecondnodetypes.jcr:name", "myfirstnodetypes.jcr:name", "mythirdnodetypes.jcr:primaryType", "myfirstnodetypes.mode:localName", "myfirstnodetypes.mode:depth", "mysecondnodetypes.mode:localName");
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    @FixFor(value={"MODE-905"})
    public void shouldBeAbleToCreateAndExecuteFullTextSearchQuery() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("land", "Search");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 3L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.searchColumnNames());
    }

    @Test
    @FixFor(value={"MODE-905"})
    public void shouldBeAbleToCreateAndExecuteFullTextSearchQueryWithName() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("highlander", "Search");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.searchColumnNames());
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryWithOrderByClause() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT car:model FROM car:Car WHERE car:model IS NOT NULL ORDER BY car:model ASC", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 13L);
        this.assertResultsHaveColumns(result, "jcr:path", "jcr:score", "car:model");
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryWithOrderByPathClause() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT car:model FROM car:Car WHERE car:model IS NOT NULL ORDER BY PATH() ASC", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 13L);
        this.assertResultsHaveColumns(result, "jcr:path", "jcr:score", "car:model");
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryWithPathCriteriaAndOrderByClause() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT car:model FROM car:Car WHERE jcr:path LIKE '/Cars/%' ORDER BY car:model ASC", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 13L);
        this.assertResultsHaveColumns(result, "jcr:path", "jcr:score", "car:model");
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryWithChildAxisCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM nt:base WHERE jcr:path LIKE '/Cars/%' AND NOT jcr:path LIKE '/Cars/%/%'", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 4L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.minimumColumnNames());
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryWithContainsCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM nt:base WHERE jcr:path LIKE '/Cars/%' AND NOT jcr:path LIKE '/Cars/%/%'", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 4L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.minimumColumnNames());
    }

    @Test
    @FixFor(value={"MODE-791"})
    public void shouldReturnNodesWithPropertyConstrainedByTimestamp() throws Exception {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT car:model, car:maker FROM car:Car WHERE jcr:path LIKE '/Cars/%' AND (car:msrp LIKE '$3%' OR car:msrp LIKE '$2') AND (car:year LIKE '2008' OR car:year LIKE '2009') AND car:valueRating > '1' AND jcr:created > TIMESTAMP '1974-07-10T00:00:00.000-05:00' AND jcr:created < TIMESTAMP '3074-07-10T00:00:00.000-05:00'", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 5L);
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            Assert.assertThat((Object)iter.nextNode().hasProperty("car:model"), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedPathInSelectOfJcrSqlQuery() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("select jcr:primaryType, jcr:path FROM nt:base", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 24L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedPathInSelectAndCriteriaOfJcrSqlQuery() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("select jcr:primaryType, jcr:path FROM nt:base WHERE jcr:path LIKE '/Cars/%'", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 17L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedPathInSelectAndUnqualifiedNameInCriteriaOfJcrSqlQuery() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("select jcr:primaryType, jcr:path FROM nt:base WHERE jcr:name LIKE '%3%'", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 4L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithUnqualifiedPathInSelectAndUnqualifiedLocalNameInCriteriaOfJcrSqlQuery() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("select jcr:primaryType, jcr:path FROM nt:base WHERE mode:localName LIKE '%3%'", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 4L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldParseQueryWithJcrPathInJoinCriteriaOfJcrSqlQuery() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("select nt:base.jcr:primaryType, nt:base.jcr:path, car:Car.car:year FROM nt:base, car:Car WHERE car:Car.jcr:path = nt:base.jcr:path", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 13L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "car:year", "jcr:path", "jcr:score");
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    @FixFor(value={"MODE-934"})
    public void shouldNotIncludePseudoColumnsInSelectStarOfJcrSqlQuery() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("select * FROM nt:base", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 24L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.minimumColumnNames());
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    public void shouldBeAbleToCreateXPathQuery() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,car:Car)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, query.execute(), 13L);
        query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,nt:unstructured)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, query.execute(), 23L);
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllNodes() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,nt:base)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 24L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.minimumColumnNames());
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllNodesOrderingByPath() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,nt:base) order by @jcr:path", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 24L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.minimumColumnNames());
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllNodesOrderingByAttribute() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,car:Car) order by @car:maker", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 13L);
        this.assertResultsHaveColumns(result, "car:maker", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllUnstructuredNodes() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,nt:unstructured)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 23L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.minimumColumnNames());
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllUnstructuredNodesOrderedByPropertyValue() throws RepositoryException {
        QueryManager manager = this.session.getWorkspace().getQueryManager();
        Query query = manager.createQuery("//element(*,nt:unstructured) order by @jcr:primaryType", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 23L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
        query = manager.createQuery("//element(*,car:Car) order by @car:year", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        result = query.execute();
        this.assertResults(query, result, 13L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "car:year", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderNode() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars/Hybrid/*", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 3L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderNodeAndWithProperty() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars/Hybrid/*[@car:year]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 3L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderNodeAndWithPropertyOrderedByProperty() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars/Hybrid/*[@car:year] order by @car:year ascending", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 3L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "car:year", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderPath() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars//*", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 17L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesWithAllSnsIndexesUnderPath() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root//NodeA", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 3L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderPathAndWithProperty() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars//*[@car:year]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 13L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderPathAndWithPropertyOrderedByProperty() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars//*[@car:year] order by @car:year ascending", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 13L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "car:year", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllUnstructuredNodesOrderedByScore() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,nt:unstructured) order by jcr:score()", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 23L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.minimumColumnNames());
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindSameNameSiblingsByIndex() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Other/NodeA", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 3L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
        query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Other/NodeA[2]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        result = query.execute();
        this.assertResults(query, result, 1L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getNodes().nextNode().getIndex(), (Matcher)Is.is((Object)2));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllCarNodes() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,car:Car)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 13L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score", "jcr:created", "jcr:createdBy", "jcr:name", "mode:localName", "mode:depth", "car:mpgCity", "car:userRating", "car:mpgHighway", "car:engine", "car:model", "car:year", "car:maker", "car:lengthInInches", "car:valueRating", "car:wheelbaseInInches", "car:msrp");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindRootNode() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindChildOfRootNode() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindChildOfRootNodeWithTypeCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars[@jcr:primaryType]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodeWithPathAndAttrbuteCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars/Sports/Infiniti_x0020_G37[@car:year='2008']", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodeWithAttrbuteCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//Infiniti_x0020_G37[@car:year='2008']", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodeWithPathUnderRootAndAttrbuteCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/NodeB[@myUrl='http://www.acme.com/foo/bar']", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAnywhereNodeWithNameAndAttrbuteCriteriaMatchingUrl() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//NodeB[@myUrl='http://www.acme.com/foo/bar']", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodeWithNameMatch() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//NodeB", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowUnregisteringUsedPrimaryType() throws Exception {
        Session adminSession = null;
        try {
            adminSession = repository.login((Credentials)new SimpleCredentials("superuser", "superuser".toCharArray()));
            adminSession.setNamespacePrefix("cars", "http://www.modeshape.org/examples/cars/1.0");
            JcrNodeTypeManager nodeTypeManager = (JcrNodeTypeManager)adminSession.getWorkspace().getNodeTypeManager();
            nodeTypeManager.unregisterNodeTypes(Collections.singletonList("cars:Car"));
            Object var4_3 = null;
            if (adminSession == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (adminSession == null) throw throwable;
            adminSession.logout();
            throw throwable;
        }
        adminSession.logout();
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithContainsCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//*[jcr:contains(., 'liter')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 2L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithComplexContainsCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//*[jcr:contains(., '\"liter V 12\"')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithComplexContainsCriteriaWithHyphen() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//*[jcr:contains(., '\"5-speed\"')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithComplexContainsCriteriaWithHyphenAndNumberAndWildcard() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//*[jcr:contains(., '\"5-s*\"')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithComplexContainsCriteriaWithNoHyphenAndNoWildcard() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//*[jcr:contains(., '\"heavy duty\"')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithComplexContainsCriteriaWithHyphenAndNoWildcard() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//*[jcr:contains(., '\"heavy-duty\"')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithComplexContainsCriteriaWithNoHyphenAndWildcard() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//*[jcr:contains(., '\"heavy du*\"')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithComplexContainsCriteriaWithHyphenAndWildcard() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//*[jcr:contains(., '\"heavy-du*\"')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithComplexContainsCriteriaWithHyphenAndLeadingWildcard() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//*[jcr:contains(., '\"*-speed\"')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 2L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    @FixFor(value={"MODE-790"})
    public void shouldBeAbleToExecuteXPathQueryWithCompoundCriteria() throws Exception {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars//element(*,car:Car)[@car:year='2008' and jcr:contains(., '\"liter V 12\"')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score", "jcr:created", "jcr:createdBy", "jcr:name", "mode:localName", "mode:depth", "car:mpgCity", "car:userRating", "car:mpgHighway", "car:engine", "car:model", "car:year", "car:maker", "car:lengthInInches", "car:valueRating", "car:wheelbaseInInches", "car:msrp");
        query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars//element(*,car:Car)[@car:year='2007' and jcr:contains(., '\"liter V 12\"')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 0L);
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithElementTestForChildrenOfRoot() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/element()", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 3L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithElementTestForAllNodesBelowRoot() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//element()", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 24L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithElementTestForChildOfRootWithName() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/element(Cars)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithElementTestForSingleNodeBelowRootWithName() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//element(Utility)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithElementTestForChildrenOfRootWithName() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Other/element(NodeA)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 3L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithElementTestForMultipleNodesBelowRootWithName() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//element(NodeA)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 3L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithRangeCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Other/*[@something <= 'value2' and @something > 'value1']", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithNewlyRegisteredNamespace() throws RepositoryException {
        this.session.getWorkspace().getNamespaceRegistry().registerNamespace("newPrefix", "newUri");
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//*[@newPrefix:someColumn = 'someValue']", "xpath");
        query.execute();
    }

    @Test
    public void shouldNotReturnNodesWithNoPropertyForPropertyCriterion() throws Exception {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars//*[@car:wheelbaseInInches]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            Assert.assertThat((Object)iter.nextNode().hasProperty("car:wheelbaseInInches"), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldNotReturnNodesWithNoPropertyForLikeCriterion() throws Exception {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars//*[jcr:like(@car:wheelbaseInInches, '%')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            Assert.assertThat((Object)iter.nextNode().hasProperty("car:wheelbaseInInches"), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    @FixFor(value={"MODE-1144"})
    public void shouldParseMagnoliaXPathQuery() throws Exception {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//*[@jcr:primaryType='mgnl:content']//*[jcr:contains(., 'paragraph')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            Assert.assertThat((Object)iter.nextNode().hasProperty("car:wheelbaseInInches"), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    @FixFor(value={"MODE-1145"})
    public void shouldParseFincayraQuery() throws Exception {
        String sql = "SELECT post.\"jcr:uuid\", post.\"text\", post.\"user\" FROM [fincayra.Post] AS post JOIN [fincayra.User] AS u ON post.\"user\"=u.\"jcr:uuid\" WHERE u.email='test1@innobuilt.com'";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            Assert.assertThat((Object)iter.nextNode().hasProperty("jcr:uuid"), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)iter.nextNode().hasProperty("text"), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)iter.nextNode().hasProperty("user"), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    @FixFor(value={"MODE-1145"})
    public void shouldParseFincayraQuery2() throws Exception {
        String sql = "SELECT post.\"jcr:uuid\", post.\"text\", post.\"user\" FROM [fincayra.UnstrPost] AS post JOIN [fincayra.UnstrUser] AS u ON post.\"user\"=u.\"jcr:uuid\" WHERE u.email='test1@innobuilt.com'";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            Assert.assertThat((Object)iter.nextNode().hasProperty("jcr:uuid"), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)iter.nextNode().hasProperty("text"), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)iter.nextNode().hasProperty("user"), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    @FixFor(value={"MODE-1145"})
    public void shouldParseQueryWithResidualPropertyInSelectAndCriteria() throws Exception {
        String sql = "SELECT [jcr:path], something FROM [nt:unstructured] AS u WHERE something LIKE 'value%'";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result.getRows().getSize(), (Matcher)Is.is((Object)3L));
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            Assert.assertThat((Object)iter.nextNode().hasProperty("something"), (Matcher)Is.is((Object)true));
        }
    }

    public class RowResult {
        private final Row row;

        public RowResult(Row row) {
            this.row = row;
        }

        public RowResult has(String columnName, String value) throws RepositoryException {
            Assert.assertThat((Object)this.row.getValue(columnName).getString(), (Matcher)Is.is((Object)value));
            return this;
        }

        public RowResult has(String columnName, long value) throws RepositoryException {
            Assert.assertThat((Object)this.row.getValue(columnName).getLong(), (Matcher)Is.is((Object)value));
            return this;
        }

        public RowResult and(String columnName, String value) throws RepositoryException {
            return this.has(columnName, value);
        }

        public RowResult and(String columnName, long value) throws RepositoryException {
            return this.has(columnName, value);
        }
    }
}

