/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NodeType;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JaasSecurityContext;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.AbstractSessionTest;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValueFactory;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.ModeShapeLexicon;

public class JcrSessionTest
extends AbstractSessionTest {
    private static final String MULTI_LINE_VALUE = "Line\t1\nLine 2\rLine 3\r\nLine 4";

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
    }

    protected void initializeContent() {
        ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c").and();
        ((Graph.SetValuesTo)this.graph.set("booleanProperty").on("/a/b")).to(true);
        ((Graph.SetValuesTo)this.graph.set("stringProperty").on("/a/b/c")).to("value");
        ((Graph.SetValuesTo)this.graph.set("jcr:mixinTypes").on("/a")).to("mix:lockable");
        ((Graph.SetValuesTo)this.graph.set("jcr:mixinTypes").on("/a/b")).to("mix:referenceable");
        ((Graph.SetValuesTo)this.graph.set("multiLineProperty").on("/a/b/c")).to(MULTI_LINE_VALUE);
        ((Graph)this.graph.create("/jcr:system").and()).create("/jcr:system/mode:namespaces").and();
    }

    @After
    public void after() throws Exception {
        if (this.session.isLive()) {
            this.session.logout();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowAddLockToken() throws Exception {
        this.session.addLockToken(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCheckPermissionWithNoPath() throws Exception {
        this.session.checkPermission((String)null, "read");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCheckPermissionWithEmptyPath() throws Exception {
        this.session.checkPermission("", "read");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCheckPermissionWithNoActions() throws Exception {
        this.session.checkPermission("/", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCheckPermissionWithEmptyActions() throws Exception {
        this.session.checkPermission("/", "");
    }

    @Test
    public void shouldReturnNullValueForNullAttributeName() throws Exception {
        Assert.assertThat((Object)this.session.getAttribute(null), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldReturnNullValueForEmptyOrBlankAttributeName() throws Exception {
        Assert.assertThat((Object)this.session.getAttribute(""), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)this.session.getAttribute("  "), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldReturnNullValueForNonExistantAttributeName() throws Exception {
        Assert.assertThat((Object)this.session.getAttribute("something else entirely"), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldReturnPropertyAttributeValueGivenNameOfExistingAttribute() throws Exception {
        Assert.assertThat((Object)this.session.getAttribute("attribute1"), (Matcher)Is.is((Object)"value1"));
    }

    @Test
    public void shouldProvideAttributeNames() throws Exception {
        String[] names = this.session.getAttributeNames();
        Assert.assertThat((Object)names, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)names.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)names[0], (Matcher)Is.is((Object)"attribute1"));
    }

    @Test
    public void shouldProvideEmptyAttributeNames() throws Exception {
        this.sessionAttributes = new HashMap();
        this.workspace = new JcrWorkspace(this.repository, this.workspaceName, this.context, this.sessionAttributes);
        this.session = (JcrSession)this.workspace.getSession();
        String[] names = this.session.getAttributeNames();
        Assert.assertThat((Object)names, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)names.length, (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldProvideAccessToRepository() throws Exception {
        Assert.assertThat((Object)this.session.getRepository(), (Matcher)Is.is((Object)this.repository));
    }

    @Test
    public void shouldProvideAccessToWorkspace() throws Exception {
        Assert.assertThat((Object)this.session.getWorkspace(), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void shouldIndicateLiveBeforeLogout() throws Exception {
        Assert.assertThat((Object)this.session.isLive(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowLogout() throws Exception {
        this.session.logout();
    }

    @Test
    public void shouldIndicateNotLiveAfterLogout() throws Exception {
        this.session.logout();
        Assert.assertThat((Object)this.session.isLive(), (Matcher)Is.is((Object)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldProvideUserId() throws Exception {
        Assert.assertThat((Object)this.session.getUserID(), (Matcher)IsNull.notNullValue());
        Principal principal = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)principal.getName()).thenReturn((Object)"name");
        Subject subject = new Subject(false, Collections.singleton(principal), Collections.EMPTY_SET, Collections.EMPTY_SET);
        LoginContext loginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)loginContext.getSubject()).thenReturn((Object)subject);
        NamespaceRegistry globalRegistry = this.context.getNamespaceRegistry();
        ExecutionContext sessionContext = this.context.with((SecurityContext)new JaasSecurityContext(loginContext));
        JcrSession session = new JcrSession(this.repository, this.workspace, sessionContext, globalRegistry, this.sessionAttributes);
        try {
            Assert.assertThat((Object)session.getUserID(), (Matcher)Is.is((Object)"name"));
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            session.logout();
            throw throwable;
        }
        session.logout();
    }

    @Test
    public void shouldProvideRootNode() throws Exception {
        AbstractJcrNode root = this.session.getRootNode();
        Assert.assertThat((Object)root, (Matcher)IsNull.notNullValue());
        String uuid = root.getIdentifier();
        Assert.assertThat((Object)root.isNodeType("mix:referenceable"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)root.getUUID(), (Matcher)Is.is((Object)uuid));
        Assert.assertThat((Object)uuid, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void shouldProvideChildrenByPath() throws Exception {
        Item item = this.session.getItem("/a");
        Assert.assertThat((Object)item, (Matcher)IsInstanceOf.instanceOf(Node.class));
        item = this.session.getItem("/a/b");
        Assert.assertThat((Object)item, (Matcher)IsInstanceOf.instanceOf(Node.class));
        item = this.session.getItem("/a/b/booleanProperty");
        Assert.assertThat((Object)item, (Matcher)IsInstanceOf.instanceOf(Property.class));
    }

    @Test
    public void shouldGetItemByIdentifierPath() throws Exception {
        Item item = this.session.getItem(this.identifierPathFor("/a"));
        Assert.assertThat((Object)item, (Matcher)IsInstanceOf.instanceOf(Node.class));
        Assert.assertThat((Object)item.getPath(), (Matcher)Is.is((Object)"/a"));
        item = this.session.getItem(this.identifierPathFor("/a/b"));
        Assert.assertThat((Object)item, (Matcher)IsInstanceOf.instanceOf(Node.class));
        Assert.assertThat((Object)item.getPath(), (Matcher)Is.is((Object)"/a/b"));
        item = this.session.getItem(this.identifierPathFor("/"));
        Assert.assertThat((Object)item, (Matcher)IsInstanceOf.instanceOf(Node.class));
        Assert.assertThat((Object)item.getPath(), (Matcher)Is.is((Object)"/"));
    }

    @Test
    public void shouldGetNodeByIdentifierPath() throws Exception {
        AbstractJcrNode node = this.session.getNode(this.identifierPathFor("/a"));
        Assert.assertThat((Object)node.getPath(), (Matcher)Is.is((Object)"/a"));
        node = this.session.getNode(this.identifierPathFor("/a/b"));
        Assert.assertThat((Object)node.getPath(), (Matcher)Is.is((Object)"/a/b"));
        node = this.session.getNode(this.identifierPathFor("/"));
        Assert.assertThat((Object)node.getPath(), (Matcher)Is.is((Object)"/"));
    }

    @Test
    public void shouldCorrectlyDetermineIfItemExistsUsingPath() throws Exception {
        Assert.assertThat((Object)this.session.itemExists("/"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.session.itemExists("/a"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.session.itemExists("/a/b"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCorrectlyDetermineIfItemExistsUsingIdentifierPath() throws Exception {
        Assert.assertThat((Object)this.session.itemExists(this.identifierPathFor("/")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.session.itemExists(this.identifierPathFor("/a")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.session.itemExists(this.identifierPathFor("/a/b")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldProvidePropertiesByPath() throws Exception {
        Item item = this.session.getItem("/a/b/booleanProperty");
        Assert.assertThat((Object)item, (Matcher)IsInstanceOf.instanceOf(Property.class));
        AbstractJcrProperty property = this.session.getProperty("/a/b/booleanProperty");
        Assert.assertThat((Object)property, (Matcher)IsInstanceOf.instanceOf(Property.class));
    }

    @Test
    public void shouldProvideNodesByPath() throws Exception {
        AbstractJcrNode node = this.session.getNode("/a");
        Assert.assertThat((Object)node, (Matcher)IsInstanceOf.instanceOf(Node.class));
        node = this.session.getNode("/a/b");
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldNotReturnPropertyAsNode() throws Exception {
        Assert.assertThat((Object)this.session.nodeExists("/a/b/booleanProperty"), (Matcher)Is.is((Object)false));
        this.session.getNode("/a/b/booleanProperty");
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldNotReturnNonExistantNode() throws Exception {
        Assert.assertThat((Object)this.session.nodeExists("/a/b/argleBargle"), (Matcher)Is.is((Object)false));
        this.session.getNode("/a/b/argleBargle");
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldNotReturnNodeAsProperty() throws Exception {
        Assert.assertThat((Object)this.session.propertyExists("/a/b"), (Matcher)Is.is((Object)false));
        this.session.getProperty("/a/b");
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldNotReturnNonExistantProperty() throws Exception {
        Assert.assertThat((Object)this.session.propertyExists("/a/b/argleBargle"), (Matcher)Is.is((Object)false));
        this.session.getProperty("/a/b/argleBargle");
    }

    @Test
    public void shouldProvideValueFactory() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream("something".getBytes());
        JcrValueFactory factory = this.session.getValueFactory();
        Binary binary = factory.createBinary((InputStream)new ByteArrayInputStream("something".getBytes()));
        Assert.assertThat((Object)factory, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)factory.createValue(false), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)factory.createValue(Calendar.getInstance()), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)factory.createValue(0.0), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)factory.createValue(binary), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)factory.createValue((InputStream)stream), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)factory.createValue(0L), (Matcher)IsNull.notNullValue());
        Node node = (Node)Mockito.mock(Node.class);
        String uuid = UUID.randomUUID().toString();
        Mockito.when((Object)node.getUUID()).thenReturn((Object)uuid);
        Mockito.when((Object)node.getIdentifier()).thenReturn((Object)uuid);
        Mockito.when((Object)node.isNodeType("mix:referenceable")).thenReturn((Object)true);
        Assert.assertThat((Object)factory.createValue(node), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)factory.createValue(""), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)factory.createValue("", 2), (Matcher)IsNull.notNullValue());
    }

    @Test(expected=RepositoryException.class)
    public void shouldNotCreateValueForNonReferenceableNode() throws Exception {
        JcrValueFactory factory = this.session.getValueFactory();
        Node node = (Node)Mockito.mock(Node.class);
        String uuid = UUID.randomUUID().toString();
        Mockito.when((Object)node.getUUID()).thenReturn((Object)uuid);
        Mockito.when((Object)node.getIdentifier()).thenReturn((Object)uuid);
        Mockito.when((Object)node.isNodeType("mix:referenceable")).thenReturn((Object)false);
        factory.createValue(node);
    }

    @Test
    public void shouldNotHavePendingChanges() throws Exception {
        Assert.assertThat((Object)this.session.hasPendingChanges(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldProvideItemExists() throws Exception {
        Assert.assertThat((Object)this.session.itemExists("/a/b"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.session.itemExists("/a/c"), (Matcher)Is.is((Object)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowItemExistsWithNoPath() throws Exception {
        this.session.itemExists(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowItemExistsWithEmptyPath() throws Exception {
        this.session.itemExists("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNoNamespaceUri() throws Exception {
        this.session.getNamespacePrefix(null);
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotProvidePrefixForUnknownUri() throws Exception {
        this.session.getNamespacePrefix("bogus");
    }

    @Test
    public void shouldProvideNamespacePrefix() throws Exception {
        Assert.assertThat((Object)this.session.getNamespacePrefix("http://www.modeshape.org/1.0"), (Matcher)Is.is((Object)"mode"));
        Assert.assertThat((Object)this.session.getNamespacePrefix("http://www.jcp.org/jcr/1.0"), (Matcher)Is.is((Object)"jcr"));
        Assert.assertThat((Object)this.session.getNamespacePrefix("http://www.jcp.org/jcr/mix/1.0"), (Matcher)Is.is((Object)"mix"));
        Assert.assertThat((Object)this.session.getNamespacePrefix("http://www.jcp.org/jcr/nt/1.0"), (Matcher)Is.is((Object)"nt"));
        Assert.assertThat((Object)this.session.getNamespacePrefix("http://www.jcp.org/jcr/sv/1.0"), (Matcher)Is.is((Object)"sv"));
    }

    @Test
    public void shouldProvideNamespacePrefixes() throws Exception {
        String[] prefixes = this.session.getNamespacePrefixes();
        Assert.assertThat((Object)prefixes, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)prefixes.length, (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNoNamespacePrefix() throws Exception {
        this.session.getNamespaceURI(null);
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotProvideUriForUnknownPrefix() throws Exception {
        this.session.getNamespaceURI("bogus");
    }

    @Test
    public void shouldProvideNamespaceUri() throws Exception {
        Assert.assertThat((Object)this.session.getNamespaceURI("mode"), (Matcher)Is.is((Object)"http://www.modeshape.org/1.0"));
        Assert.assertThat((Object)this.session.getNamespaceURI("jcr"), (Matcher)Is.is((Object)"http://www.jcp.org/jcr/1.0"));
        Assert.assertThat((Object)this.session.getNamespaceURI("mix"), (Matcher)Is.is((Object)"http://www.jcp.org/jcr/mix/1.0"));
        Assert.assertThat((Object)this.session.getNamespaceURI("nt"), (Matcher)Is.is((Object)"http://www.jcp.org/jcr/nt/1.0"));
        Assert.assertThat((Object)this.session.getNamespaceURI("sv"), (Matcher)Is.is((Object)"http://www.jcp.org/jcr/sv/1.0"));
    }

    @Test
    public void rootNodeShouldHaveProperType() throws Exception {
        AbstractJcrNode rootNode = this.session.getRootNode();
        NodeType rootNodePrimaryType = rootNode.getPrimaryNodeType();
        JcrNodeType dnaRootType = this.session.nodeTypeManager().getNodeType(ModeShapeLexicon.ROOT);
        Assert.assertThat((Object)rootNodePrimaryType.getName(), (Matcher)Is.is((Object)dnaRootType.getName()));
    }

    @Test
    public void rootNodeShouldBeReferenceable() throws RepositoryException {
        AbstractJcrNode rootNode = this.session.getRootNode();
        Assert.assertTrue((boolean)rootNode.getPrimaryNodeType().isNodeType(JcrMixLexicon.REFERENCEABLE.getString(this.context.getNamespaceRegistry())));
    }

    @Test
    public void shouldExportMultiLinePropertiesInSystemView() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.session.exportSystemView("/a/b/c", (OutputStream)os, false, true);
        String fileContents = ((Object)os).toString();
        Assert.assertTrue((boolean)fileContents.contains(MULTI_LINE_VALUE));
    }

    @Test
    public void shouldUseJcrCardinalityPerPropertyDefinition() throws Exception {
        Path pathToNode = (Path)this.context.getValueFactories().getPathFactory().create("/a/b");
        AbstractJcrNode carsNode = this.session.getNode(pathToNode);
        String mixinTypesName = JcrLexicon.MIXIN_TYPES.getString(this.session.getExecutionContext().getNamespaceRegistry());
        Property mixinTypes = carsNode.getProperty(mixinTypesName);
        Assert.assertThat((Object)((AbstractJcrProperty)mixinTypes).property().isMultiple(), (Matcher)Is.is((Object)false));
        mixinTypes.getValues();
    }

    @Test
    public void shouldProvideIdentifierEvenIfNotReferenceable() throws Exception {
        AbstractJcrNode node = this.session.getRootNode().getNode("a").getNode("b").getNode("c");
        Assert.assertThat((Object)node.getIdentifier(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldProvideIdentifierEvenIfNoMixinTypes() throws Exception {
        AbstractJcrNode node = this.session.getRootNode().getNode("a").getNode("b").getNode("c");
        Assert.assertThat((Object)node.getIdentifier(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test(expected=UnsupportedRepositoryOperationException.class)
    public void shouldNotProvideUuidIfNotReferenceable() throws Exception {
        AbstractJcrNode node = this.session.getRootNode().getNode("a").getNode("b").getNode("c");
        node.getUUID();
    }

    @Test(expected=UnsupportedRepositoryOperationException.class)
    public void shouldNotProvideUuidIfNoMixinTypes() throws Exception {
        AbstractJcrNode node = this.session.getRootNode().getNode("a").getNode("b").getNode("c");
        node.getUUID();
    }

    @Test
    public void shouldMoveToNewName() throws Exception {
        this.session.move("/a/b/c", "/a/b/d");
        this.session.getRootNode().getNode("a").getNode("b").getNode("d");
        try {
            this.session.getRootNode().getNode("a").getNode("b").getNode("c");
            Assert.fail((String)"Node still exists at /a/b/c after move");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void shouldAddCreatedPropertyForHierarchyNodes() throws Exception {
        Node folderNode = this.session.getRootNode().addNode("folderNode", "nt:folder");
        Assert.assertThat((Object)folderNode.hasProperty("jcr:created"), (Matcher)Is.is((Object)true));
        Node fileNode = folderNode.addNode("fileNode", "nt:file");
        Assert.assertThat((Object)fileNode.hasProperty("jcr:created"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldHaveCapabilityToPerformValidAddNode() throws Exception {
        Assert.assertTrue((boolean)this.session.hasCapability("addNode", (Object)this.session.getRootNode(), (Object[])new String[]{"someNewNode"}));
        Assert.assertTrue((boolean)this.session.hasCapability("addNode", (Object)this.session.getRootNode(), (Object[])new String[]{"someNewNode", "nt:unstructured"}));
    }

    @Test
    public void shouldNotHaveCapabilityToPerformInvalidAddNode() throws Exception {
        Assert.assertTrue((!this.session.hasCapability("addNode", (Object)this.session.getRootNode(), (Object[])new String[]{"someNewNode[2]"}) ? 1 : 0) != 0);
        Assert.assertTrue((!this.session.hasCapability("addNode", (Object)this.session.getRootNode(), (Object[])new String[]{"someNewNode", "nt:invalidType"}) ? 1 : 0) != 0);
    }
}

