/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.UuidAlreadyExistsException;
import org.modeshape.graph.connector.base.BaseTransaction;
import org.modeshape.graph.connector.base.PathNode;
import org.modeshape.graph.connector.base.PathWorkspace;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.FullTextSearchRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class PathTransaction<NodeType extends PathNode, WorkspaceType extends PathWorkspace<NodeType>>
extends BaseTransaction<NodeType, WorkspaceType> {
    private Map<String, WorkspaceChanges> changesByWorkspaceName;

    protected PathTransaction(Repository<NodeType, WorkspaceType> repository, UUID rootNodeUuid) {
        super(repository.getContext(), repository, rootNodeUuid);
    }

    protected WorkspaceChanges getChangesFor(WorkspaceType workspace, boolean createIfMissing) {
        if (this.changesByWorkspaceName == null) {
            if (!createIfMissing) {
                return null;
            }
            WorkspaceChanges changes = new WorkspaceChanges(this, workspace);
            this.changesByWorkspaceName = new HashMap<String, WorkspaceChanges>();
            this.changesByWorkspaceName.put(((PathWorkspace)workspace).getName(), changes);
            return changes;
        }
        WorkspaceChanges changes = this.changesByWorkspaceName.get(((PathWorkspace)workspace).getName());
        if (changes == null && createIfMissing) {
            changes = new WorkspaceChanges(this, workspace);
            this.changesByWorkspaceName.put(((PathWorkspace)workspace).getName(), changes);
        }
        return changes;
    }

    @Override
    public NodeType getNode(WorkspaceType workspace, Location location) {
        WorkspaceChanges changes;
        assert (location != null);
        UUID uuid = location.getUuid();
        if (this.getRepository().getRootNodeUuid().equals(uuid)) {
            Path rootPath = this.pathFactory.createRootPath();
            changes = this.getChangesFor(workspace, false);
            NodeType node = null;
            if (changes != null) {
                assert (!changes.isRemoved(rootPath));
                node = changes.getChangedOrAdded(rootPath);
                if (node != null) {
                    return node;
                }
            }
            if ((node = (NodeType)((PathWorkspace)workspace).getNode(rootPath)) != null) {
                return node;
            }
        }
        if (location.hasPath()) {
            Object node;
            Object lowestNode;
            Path path = location.getPath();
            changes = this.getChangesFor(workspace, false);
            Object v0 = lowestNode = changes == null ? null : changes.getLowestChangedNodeFor(path);
            if (lowestNode == null && (node = ((PathWorkspace)workspace).getNode(path)) != null) {
                return node;
            }
            return (NodeType)((PathNode)this.getNode(workspace, location.getPath(), location));
        }
        Path lowestExisting = this.pathFactory.createRootPath();
        throw new PathNotFoundException(location, lowestExisting, GraphI18n.nodeDoesNotExist.text(this.readable(location)));
    }

    @Override
    public Location verifyNodeExists(WorkspaceType workspace, Location location) {
        assert (location != null);
        UUID uuid = location.getUuid();
        if (this.getRepository().getRootNodeUuid().equals(uuid)) {
            return this.getRootLocation();
        }
        if (location.hasPath()) {
            Object lowestNode;
            Path path = location.getPath();
            WorkspaceChanges changes = this.getChangesFor(workspace, false);
            Object v0 = lowestNode = changes == null ? null : changes.getLowestChangedNodeFor(path);
            if (lowestNode == null) {
                return ((PathWorkspace)workspace).verifyNodeExists(path);
            }
            PathNode node = (PathNode)this.getNode(workspace, location.getPath(), location);
            return this.locationFor(node);
        }
        Path lowestExisting = this.pathFactory.createRootPath();
        throw new PathNotFoundException(location, lowestExisting, GraphI18n.nodeDoesNotExist.text(this.readable(location)));
    }

    protected NodeType findNode(WorkspaceType workspace, Path path) {
        WorkspaceChanges changes = this.getChangesFor(workspace, false);
        NodeType node = null;
        if (changes != null) {
            if (changes.isRemoved(path)) {
                return null;
            }
            node = changes.getChangedOrAdded(path);
            if (node != null) {
                return node;
            }
        }
        node = ((PathWorkspace)workspace).getNode(path);
        return node;
    }

    protected void destroyNode(WorkspaceType workspace, NodeType node) {
        WorkspaceChanges changes = this.getChangesFor(workspace, true);
        this.destroyNode(changes, workspace, node);
    }

    private void destroyNode(WorkspaceChanges changes, WorkspaceType workspace, NodeType node) {
        changes.removed(this.pathTo(node));
    }

    private Location locationFor(NodeType node) {
        return Location.create(this.pathTo(node));
    }

    protected Path pathTo(NodeType node) {
        if (((PathNode)node).getParent() == null) {
            return this.pathFactory.createRootPath();
        }
        return this.pathFactory.create(((PathNode)node).getParent(), ((PathNode)node).getName());
    }

    @Override
    public Path pathFor(WorkspaceType workspace, NodeType node) {
        return this.pathTo(node);
    }

    @Override
    public NodeType addChild(WorkspaceType workspace, NodeType parent, Name name, int index, UUID uuid, Iterable<Property> properties) {
        WorkspaceChanges changes = this.getChangesFor(workspace, true);
        if (!((PathNode)parent).hasChanges()) {
            parent = this.getNode(workspace, this.locationFor(parent));
        }
        PathNode oldParent = ((PathNode)parent).clone();
        NodeType newNode = null;
        if (index < 0) {
            int snsIndex = 1;
            for (PathNode child : this.getChildren(workspace, parent)) {
                if (!child.getName().getName().equals(name)) continue;
                ++snsIndex;
            }
            Path.Segment childSegment = this.pathFactory.createSegment(name, snsIndex);
            newNode = this.createNode(childSegment, this.pathTo(parent), properties);
            parent = ((PathNode)parent).withChild(childSegment);
        } else {
            int snsIndex = 0;
            List<NodeType> children = this.getChildren(workspace, parent);
            if (index < children.size()) {
                ListIterator<NodeType> existingSiblings = children.listIterator(index);
                while (existingSiblings.hasNext()) {
                    PathNode existingSibling = (PathNode)existingSiblings.next();
                    Path.Segment existingSegment = existingSibling.getName();
                    if (!existingSegment.getName().equals(name)) continue;
                    int existingIndex = existingSegment.getIndex();
                    if (snsIndex == 0) {
                        snsIndex = existingIndex;
                    }
                    PathNode oldSibling = existingSibling.clone();
                    existingSibling = existingSibling.withName(this.pathFactory.createSegment(name, existingIndex + 1));
                    changes.changed(oldSibling, existingSibling);
                }
            }
            Path.Segment childSegment = this.pathFactory.createSegment(name, snsIndex + 1);
            newNode = this.createNode(childSegment, this.pathTo(parent), properties);
            parent = ((PathNode)parent).withChild(index, childSegment);
        }
        changes.created(newNode);
        changes.changed(oldParent, parent);
        return newNode;
    }

    @Override
    public Location addChild(WorkspaceType workspace, NodeType parent, NodeType originalChild, NodeType beforeOtherChild, Name desiredName) {
        if (!((PathNode)parent).hasChanges()) {
            parent = this.findNode(workspace, this.pathTo(parent));
        }
        Path.Segment newChildSegment = ((PathNode)originalChild).getName();
        Name newChildName = newChildSegment.getName();
        int snsIndex = newChildSegment.getIndex();
        Object oldParent = this.getParent(workspace, originalChild);
        WorkspaceChanges changes = this.getChangesFor(workspace, true);
        if (oldParent != null) {
            int oldIndex = ((PathNode)oldParent).getChildren().indexOf(newChildSegment);
            PathNode priorParent = ((PathNode)oldParent).clone();
            if (((PathNode)oldParent).equals(parent)) {
                oldParent = ((PathNode)oldParent).withoutChild(newChildSegment);
                changes.changed(priorParent, oldParent);
                parent = oldParent;
            } else {
                oldParent = ((PathNode)oldParent).withoutChild(newChildSegment);
                changes.changed(priorParent, oldParent);
            }
            List<NodeType> siblings = this.getChildren(workspace, oldParent);
            if (oldIndex < siblings.size()) {
                ListIterator<NodeType> iter = siblings.listIterator(oldIndex);
                while (iter.hasNext()) {
                    PathNode sibling = (PathNode)iter.next();
                    if (!sibling.getName().getName().equals(newChildName)) continue;
                    PathNode oldSibling = sibling.clone();
                    sibling = sibling.withName(this.pathFactory.createSegment(newChildName, snsIndex++));
                    changes.changed(oldSibling, sibling);
                }
            }
        }
        int index = ((PathNode)parent).getChildren().size();
        if (beforeOtherChild != null) {
            if (!((PathNode)beforeOtherChild).getParent().equals(this.pathTo(parent))) {
                throw new RepositorySourceException(null);
            }
            Path.Segment otherChild = ((PathNode)beforeOtherChild).getName();
            index = ((PathNode)parent).getChildren().indexOf(otherChild);
        }
        newChildName = desiredName != null ? desiredName : newChildName;
        ListIterator<NodeType> existingSiblings = this.getChildren(workspace, parent).listIterator();
        int i = 0;
        snsIndex = 1;
        Path.Segment childName = null;
        while (existingSiblings.hasNext()) {
            PathNode existingSibling = (PathNode)existingSiblings.next();
            Path.Segment existingSegment = existingSibling.getName();
            if (i < index) {
                if (existingSegment.getName().equals(newChildName)) {
                    ++snsIndex;
                }
            } else {
                if (i == index) {
                    childName = this.pathFactory.createSegment(newChildName, snsIndex);
                }
                if (existingSegment.getName().equals(newChildName)) {
                    PathNode oldSibling = existingSibling.clone();
                    existingSibling = existingSibling.withName(this.pathFactory.createSegment(newChildName, ++snsIndex));
                    changes.changed(oldSibling, existingSibling);
                }
            }
            ++i;
        }
        if (childName == null) {
            childName = this.pathFactory.createSegment(newChildName, snsIndex);
        }
        PathNode copyOfOriginalChild = ((PathNode)originalChild).clone();
        PathNode newChild = copyOfOriginalChild.withName(childName).withParent(this.pathTo(parent));
        parent = ((PathNode)parent).withChild(index, newChild.getName());
        changes.moved(originalChild, newChild, parent);
        return this.locationFor(newChild);
    }

    protected abstract NodeType createNode(Path.Segment var1, Path var2, Iterable<Property> var3);

    @Override
    public NodeType getChild(WorkspaceType workspace, NodeType parent, Path.Segment childSegment) {
        List<Path.Segment> children = ((PathNode)parent).getChildren();
        for (Path.Segment child : children) {
            if (!child.equals(childSegment)) continue;
            Path childPath = this.pathFactory.create(this.pathTo(parent), child);
            WorkspaceChanges changes = this.getChangesFor(workspace, true);
            Object changed = changes.getChangedOrAdded(childPath);
            if (changed != null) {
                return changed;
            }
            Path persistentPath = changes.persistentPathFor(childPath);
            Object childNode = ((PathWorkspace)workspace).getNode(persistentPath);
            if (persistentPath.equals(childPath)) {
                return childNode;
            }
            return (NodeType)((PathNode)childNode).withParent(childPath.getParent()).withName(childPath.getLastSegment());
        }
        return null;
    }

    @Override
    public List<NodeType> getChildren(WorkspaceType workspace, NodeType node) {
        List<Path.Segment> childSegments = ((PathNode)node).getChildren();
        if (childSegments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NodeType> children = new ArrayList<NodeType>(childSegments.size());
        for (Path.Segment childSegment : childSegments) {
            children.add(this.getNode(workspace, Location.create(this.pathFactory.create(this.pathTo(node), childSegment))));
        }
        return children;
    }

    @Override
    public List<Location> getChildrenLocations(WorkspaceType workspace, NodeType node) {
        List<Path.Segment> childSegments = ((PathNode)node).getChildren();
        if (childSegments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Location> children = new ArrayList<Location>(childSegments.size());
        Path nodePath = this.pathTo(node);
        for (Path.Segment childSegment : childSegments) {
            children.add(Location.create(this.pathFactory.create(nodePath, childSegment)));
        }
        return children;
    }

    @Override
    public NodeType getParent(WorkspaceType workspace, NodeType node) {
        Path parentPath = ((PathNode)node).getParent();
        if (parentPath == null) {
            return null;
        }
        return this.getNode(workspace, Location.create(parentPath));
    }

    @Override
    public void removeAllChildren(WorkspaceType workspace, NodeType node) {
        for (PathNode child : this.getChildren(workspace, node)) {
            this.destroyNode(workspace, child);
        }
        PathNode oldNode = ((PathNode)node).clone();
        node = ((PathNode)node).withoutChildren();
        this.getChangesFor(workspace, true).changed(oldNode, node);
    }

    @Override
    public Location removeNode(WorkspaceType workspace, NodeType node) {
        Object parent = this.getParent(workspace, node);
        if (parent == null) {
            WorkspaceChanges changes = this.getChangesFor(workspace, true);
            changes.removeAll(null);
            return Location.create(this.pathFactory.createRootPath(), this.rootNodeUuid);
        }
        Location result = this.locationFor(node);
        int index = ((PathNode)parent).getChildren().indexOf(((PathNode)node).getName());
        assert (index != -1);
        Name name = ((PathNode)node).getName().getName();
        int snsIndex = ((PathNode)node).getName().getIndex();
        WorkspaceChanges changes = this.getChangesFor(workspace, true);
        PathNode oldParent = ((PathNode)parent).clone();
        parent = ((PathNode)parent).withoutChild(((PathNode)node).getName());
        changes.changed(oldParent, parent);
        List<NodeType> siblings = this.getChildren(workspace, parent);
        if (index < siblings.size()) {
            ListIterator<NodeType> iter = siblings.listIterator(index);
            while (iter.hasNext()) {
                PathNode sibling = (PathNode)iter.next();
                if (!sibling.getName().getName().equals(name)) continue;
                PathNode oldSibling = sibling.clone();
                sibling = sibling.withName(this.pathFactory.createSegment(name, snsIndex++));
                changes.changed(oldSibling, sibling);
            }
        }
        this.destroyNode(changes, workspace, node);
        return result;
    }

    @Override
    public NodeType removeProperty(WorkspaceType workspace, NodeType node, Name propertyName) {
        PathNode oldCopy = ((PathNode)node).clone();
        PathNode copy = ((PathNode)node).withoutProperty(propertyName);
        if (copy != node) {
            WorkspaceChanges changes = this.getChangesFor(workspace, true);
            changes.changed(oldCopy, copy);
        }
        return (NodeType)copy;
    }

    @Override
    public NodeType setProperties(WorkspaceType workspace, NodeType node, Iterable<Property> propertiesToSet, Iterable<Name> propertiesToRemove, boolean removeAllExisting) {
        PathNode oldCopy = ((PathNode)node).clone();
        PathNode copy = ((PathNode)node).withProperties(propertiesToSet, propertiesToRemove, removeAllExisting);
        if (copy != node) {
            WorkspaceChanges changes = this.getChangesFor(workspace, true);
            changes.changed(oldCopy, copy);
        }
        return (NodeType)copy;
    }

    @Override
    public NodeType copyNode(WorkspaceType originalWorkspace, NodeType original, WorkspaceType newWorkspace, NodeType newParent, Name desiredName, boolean recursive) {
        if (desiredName == null) {
            desiredName = ((PathNode)original).getName().getName();
        }
        Object copy = this.addChild(newWorkspace, newParent, desiredName, -1, null, ((PathNode)original).getProperties().values());
        if (recursive) {
            WorkspaceChanges changes = this.getChangesFor(newWorkspace, true);
            for (PathNode originalChild : this.getChildren(originalWorkspace, original)) {
                PathNode newChild = this.copyBranch(originalWorkspace, originalChild, changes, newWorkspace, copy);
                copy = ((PathNode)copy).withChild(newChild.getName());
            }
        }
        return copy;
    }

    protected void print(WorkspaceType workspace, NodeType node, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtil.createString(' ', level * 2));
        sb.append(this.readable(((PathNode)node).getName())).append(" (").append(((PathNode)node).getUuid()).append(") {");
        boolean first = true;
        for (Property property : ((PathNode)node).getProperties().values()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(this.readable(property.getName())).append('=');
            if (property.isMultiple()) {
                sb.append(property.getValuesAsArray());
                continue;
            }
            sb.append(this.readable(property.getFirstValue()));
        }
        sb.append('}');
        System.out.println(sb);
        for (PathNode child : this.getChildren(workspace, node)) {
            this.print(workspace, child, level + 1);
        }
    }

    @Override
    public NodeType cloneNode(WorkspaceType originalWorkspace, NodeType original, WorkspaceType newWorkspace, NodeType newParent, Name desiredName, Path.Segment desiredSegment, boolean removeExisting, Set<Location> removedExistingNodes) throws UuidAlreadyExistsException {
        return this.copyNode(originalWorkspace, original, newWorkspace, newParent, desiredName, true);
    }

    protected NodeType copyBranch(WorkspaceType originalWorkspace, NodeType original, WorkspaceChanges newWorkspaceChanges, WorkspaceType newWorkspace, NodeType newParent) {
        Object copy = this.createNode(((PathNode)original).getName(), this.pathTo(newParent), ((PathNode)original).getProperties().values());
        newWorkspaceChanges.created(copy);
        for (PathNode originalChild : this.getChildren(originalWorkspace, original)) {
            PathNode newChild = this.copyBranch(originalWorkspace, originalChild, newWorkspaceChanges, newWorkspace, copy);
            copy = ((PathNode)copy).withChild(newChild.getName());
        }
        return copy;
    }

    @Override
    public QueryResults query(WorkspaceType workspace, AccessQueryRequest accessQuery) {
        return null;
    }

    @Override
    public QueryResults search(WorkspaceType workspace, FullTextSearchRequest search) {
        return null;
    }

    protected void validateNode(WorkspaceType workspace, NodeType node) {
    }

    @Override
    public void commit() {
        super.commit();
        if (this.changesByWorkspaceName != null) {
            for (WorkspaceChanges changes : this.changesByWorkspaceName.values()) {
                changes.commit();
            }
            this.changesByWorkspaceName.clear();
        }
    }

    @Override
    public void rollback() {
        super.rollback();
        if (this.changesByWorkspaceName != null) {
            this.changesByWorkspaceName.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class WorkspaceChanges {
        private final WorkspaceType workspace;
        private final TreeMap<Path, NodeType> changedOrAddedNodes = new TreeMap();
        private final TreeMap<Path, Path> movedNodes = new TreeMap();
        private final Set<Path> removedNodes = new HashSet<Path>();
        private final List<PathWorkspace.ChangeCommand<NodeType>> commands = new LinkedList();
        final /* synthetic */ PathTransaction this$0;

        protected WorkspaceChanges(WorkspaceType workspace) {
            this.this$0 = var1_1;
            this.workspace = workspace;
        }

        public WorkspaceType getWorkspace() {
            return this.workspace;
        }

        public void removeAll(NodeType newRootNode) {
            this.changedOrAddedNodes.clear();
            this.removedNodes.clear();
            this.commands.add(((PathWorkspace)this.workspace).createRemoveCommand(this.this$0.pathFactory.createRootPath()));
        }

        public boolean isRemoved(Path path) {
            return this.removedNodes.contains(path);
        }

        public NodeType getLowestChangedNodeFor(Path path) {
            for (Path newPath : this.changedOrAddedNodes.descendingKeySet()) {
                if (!path.isAtOrBelow(newPath)) continue;
                return (PathNode)this.changedOrAddedNodes.get(newPath);
            }
            return null;
        }

        public Path persistentPathFor(Path path) {
            for (Path newPath : this.movedNodes.descendingKeySet()) {
                if (!path.isAtOrBelow(newPath)) continue;
                return path.relativeTo(newPath).resolveAgainst(this.movedNodes.get(newPath));
            }
            return path;
        }

        public NodeType getChangedOrAdded(Path path) {
            return (PathNode)this.changedOrAddedNodes.get(path);
        }

        public void removed(Path path) {
            this.removedNodes.add(path);
            this.changedOrAddedNodes.remove(path);
            this.commands.add(((PathWorkspace)this.workspace).createRemoveCommand(path));
        }

        public void created(NodeType node) {
            this.this$0.validateNode(this.workspace, node);
            Path path = this.this$0.pathTo(node);
            this.removedNodes.remove(path);
            this.changedOrAddedNodes.put(path, node);
            this.commands.add(((PathWorkspace)this.workspace).createPutCommand(null, node));
        }

        public void changed(NodeType from, NodeType to) {
            this.this$0.validateNode(this.workspace, to);
            Path path = this.this$0.pathTo(to);
            assert (!this.removedNodes.contains(path));
            this.changedOrAddedNodes.put(path, to);
            this.commands.add(((PathWorkspace)this.workspace).createPutCommand(from, to));
        }

        public void moved(NodeType node, NodeType newNode, NodeType newParent) {
            this.this$0.validateNode(this.workspace, newNode);
            Path path = this.this$0.pathTo(node);
            Path newPath = this.this$0.pathTo(newNode);
            this.changedOrAddedNodes.put(newPath, newNode);
            this.changedOrAddedNodes.put(this.this$0.pathTo(newParent), newParent);
            this.movedNodes.put(this.this$0.pathTo(newNode), path);
            this.commands.add(((PathWorkspace)this.workspace).createMoveCommand(node, newNode));
        }

        public void commit() {
            ((PathWorkspace)this.workspace).commit(this.commands);
        }

        public String toString() {
            return this.changedOrAddedNodes.keySet().toString() + "\n\t" + this.movedNodes.toString();
        }
    }
}

