/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.federation.FederatedRepository;
import org.modeshape.graph.connector.federation.FederatedRequest;
import org.modeshape.graph.connector.federation.FederatedWorkspace;
import org.modeshape.graph.connector.federation.PlaceholderNode;
import org.modeshape.graph.connector.federation.ProjectedNode;
import org.modeshape.graph.connector.federation.ProxyNode;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CompositeRequestChannel;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DeleteChildrenRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.InvalidRequestException;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.request.LockBranchRequest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadBranchRequest;
import org.modeshape.graph.request.ReadNextBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.ReadPropertyRequest;
import org.modeshape.graph.request.RemovePropertyRequest;
import org.modeshape.graph.request.RenameNodeRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.SetPropertyRequest;
import org.modeshape.graph.request.UnlockBranchRequest;
import org.modeshape.graph.request.UnsupportedRequestException;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.UpdateValuesRequest;
import org.modeshape.graph.request.VerifyNodeExistsRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.modeshape.graph.request.processor.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
class ForkRequestProcessor
extends RequestProcessor {
    private final FederatedRepository repository;
    private final ExecutorService executor;
    private final RepositoryConnectionFactory connectionFactory;
    private final Map<String, CompositeRequestChannel> channelBySourceName = new HashMap<String, CompositeRequestChannel>();
    private final Queue<FederatedRequest> federatedRequestQueue;

    public ForkRequestProcessor(FederatedRepository repository, ExecutionContext context, DateTime now, Queue<FederatedRequest> federatedRequestQueue) {
        super(repository.getSourceName(), context, null, now);
        this.repository = repository;
        this.executor = this.repository.getExecutor();
        this.connectionFactory = this.repository.getConnectionFactory();
        this.federatedRequestQueue = federatedRequestQueue;
        assert (this.executor != null);
        assert (this.connectionFactory != null);
        assert (this.federatedRequestQueue != null);
    }

    protected void submit(Request request, String sourceName) {
        assert (request != null);
        CompositeRequestChannel channel = this.channelBySourceName.get(sourceName);
        if (channel == null) {
            channel = new CompositeRequestChannel(sourceName);
            this.channelBySourceName.put(sourceName, channel);
            channel.start(this.executor, this.getExecutionContext(), this.connectionFactory);
        }
        channel.add(request);
    }

    protected void submitAndAwait(Request request, String sourceName) throws InterruptedException {
        assert (request != null);
        CompositeRequestChannel channel = this.channelBySourceName.get(sourceName);
        if (channel == null) {
            channel = new CompositeRequestChannel(sourceName);
            this.channelBySourceName.put(sourceName, channel);
            channel.start(this.executor, this.getExecutionContext(), this.connectionFactory);
        }
        channel.addAndAwait(request);
    }

    protected void submit(Request request, String sourceName, CountDownLatch latch) {
        assert (request != null);
        CompositeRequestChannel channel = this.channelBySourceName.get(sourceName);
        if (channel == null) {
            channel = new CompositeRequestChannel(sourceName);
            this.channelBySourceName.put(sourceName, channel);
            channel.start(this.executor, this.getExecutionContext(), this.connectionFactory);
        }
        channel.add(request, latch);
    }

    public void await() throws ExecutionException, InterruptedException, CancellationException {
        for (CompositeRequestChannel channel : this.channelBySourceName.values()) {
            channel.await();
        }
    }

    protected final FederatedWorkspace getWorkspace(Request request, String workspaceName) {
        try {
            return this.repository.getWorkspace(workspaceName);
        }
        catch (InvalidWorkspaceException e) {
            request.setError(e);
        }
        catch (Throwable e) {
            request.setError(e);
        }
        return null;
    }

    protected final String readable(Location location) {
        return location.getString(this.getExecutionContext().getNamespaceRegistry());
    }

    protected final String readable(Name name) {
        return name.getString(this.getExecutionContext().getNamespaceRegistry());
    }

    protected final ProjectedNode project(Location location, String workspaceName, Request request, boolean requiresUpdate) {
        FederatedWorkspace workspace = this.getWorkspace(request, workspaceName);
        if (workspace == null) {
            return null;
        }
        ProjectedNode projectedNode = workspace.project(this.getExecutionContext(), location, requiresUpdate);
        if (projectedNode == null) {
            I18n msg = GraphI18n.locationCannotBeProjectedIntoWorkspaceAndSource;
            Path root = this.getExecutionContext().getValueFactories().getPathFactory().createRootPath();
            request.setError(new PathNotFoundException(location, root, msg.text(this.readable(location), workspace.getName(), this.repository.getSourceName())));
        }
        return projectedNode;
    }

    protected void submit(FederatedRequest request) {
        request.freeze();
        if (request.hasIncompleteRequests()) {
            for (FederatedRequest.ProjectedRequest projected = request.getFirstProjectedRequest(); projected != null; projected = projected.next()) {
                if (projected.isComplete()) continue;
                this.submit(projected.getRequest(), projected.getProjection().getSourceName(), request.getLatch());
            }
        }
        this.federatedRequestQueue.add(request);
    }

    @Override
    protected void completeRequest(Request request) {
    }

    @Override
    public void process(VerifyNodeExistsRequest request) {
        FederatedRequest federatedRequest = new FederatedRequest(request);
        for (ProjectedNode projectedNode = this.project(request.at(), request.inWorkspace(), request, false); projectedNode != null; projectedNode = projectedNode.next()) {
            if (projectedNode.isPlaceholder()) {
                PlaceholderNode placeholder = projectedNode.asPlaceholder();
                VerifyNodeExistsRequest placeholderRequest = new VerifyNodeExistsRequest(request.at(), request.inWorkspace());
                placeholderRequest.setActualLocationOfNode(placeholder.location());
                federatedRequest.add(placeholderRequest, true, true, null);
                continue;
            }
            if (!projectedNode.isProxy()) continue;
            ProxyNode proxy = projectedNode.asProxy();
            VerifyNodeExistsRequest pushDownRequest = new VerifyNodeExistsRequest(proxy.location(), proxy.workspaceName());
            federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
        }
        this.submit(federatedRequest);
    }

    @Override
    public void process(ReadNodeRequest request) {
        FederatedRequest federatedRequest = new FederatedRequest(request);
        for (ProjectedNode projectedNode = this.project(request.at(), request.inWorkspace(), request, false); projectedNode != null; projectedNode = projectedNode.next()) {
            if (projectedNode.isPlaceholder()) {
                PlaceholderNode placeholder = projectedNode.asPlaceholder();
                LinkedList<Location> children = new LinkedList<Location>();
                boolean firstRequest = true;
                for (ProjectedNode child : placeholder.children()) {
                    if (child.isPlaceholder()) {
                        children.add(child.location());
                        continue;
                    }
                    while (child != null && child.isProxy()) {
                        if (!children.isEmpty()) {
                            ReadNodeRequest placeholderRequest = new ReadNodeRequest(placeholder.location(), request.inWorkspace());
                            placeholderRequest.addChildren(children);
                            if (firstRequest) {
                                firstRequest = false;
                                placeholderRequest.addProperties(placeholder.properties().values());
                            }
                            placeholderRequest.setActualLocationOfNode(placeholder.location());
                            federatedRequest.add(placeholderRequest, true, true, null);
                            children = new LinkedList();
                        }
                        ProxyNode proxy = child.asProxy();
                        VerifyNodeExistsRequest verifyRequest = new VerifyNodeExistsRequest(proxy.location(), proxy.workspaceName());
                        federatedRequest.add(verifyRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                        child = child.next();
                    }
                }
                if (children.isEmpty() && !firstRequest) continue;
                ReadNodeRequest placeholderRequest = new ReadNodeRequest(placeholder.location(), request.inWorkspace());
                placeholderRequest.addChildren(children);
                if (firstRequest) {
                    firstRequest = false;
                    placeholderRequest.addProperties(placeholder.properties().values());
                }
                placeholderRequest.setActualLocationOfNode(placeholder.location());
                federatedRequest.add(placeholderRequest, true, true, null);
                continue;
            }
            if (!projectedNode.isProxy()) continue;
            ProxyNode proxy = projectedNode.asProxy();
            ReadNodeRequest pushDownRequest = new ReadNodeRequest(proxy.location(), proxy.workspaceName());
            federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
        }
        this.submit(federatedRequest);
    }

    @Override
    public void process(ReadAllChildrenRequest request) {
        FederatedRequest federatedRequest = new FederatedRequest(request);
        for (ProjectedNode projectedNode = this.project(request.of(), request.inWorkspace(), request, false); projectedNode != null; projectedNode = projectedNode.next()) {
            if (projectedNode.isPlaceholder()) {
                PlaceholderNode placeholder = projectedNode.asPlaceholder();
                LinkedList<Location> children = new LinkedList<Location>();
                boolean firstRequest = true;
                for (ProjectedNode child : placeholder.children()) {
                    if (child.isPlaceholder()) {
                        children.add(child.location());
                        continue;
                    }
                    while (child != null && child.isProxy()) {
                        if (!children.isEmpty()) {
                            ReadAllChildrenRequest placeholderRequest = new ReadAllChildrenRequest(placeholder.location(), request.inWorkspace());
                            placeholderRequest.addChildren(children);
                            if (firstRequest) {
                                firstRequest = false;
                            }
                            placeholderRequest.setActualLocationOfNode(placeholder.location());
                            federatedRequest.add(placeholderRequest, true, true, null);
                            children = new LinkedList();
                        }
                        ProxyNode proxy = child.asProxy();
                        VerifyNodeExistsRequest verifyRequest = new VerifyNodeExistsRequest(proxy.location(), proxy.workspaceName());
                        federatedRequest.add(verifyRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                        child = child.next();
                    }
                }
                if (children.isEmpty() && !firstRequest) continue;
                ReadAllChildrenRequest placeholderRequest = new ReadAllChildrenRequest(placeholder.location(), request.inWorkspace());
                placeholderRequest.addChildren(children);
                if (firstRequest) {
                    firstRequest = false;
                }
                placeholderRequest.setActualLocationOfNode(placeholder.location());
                federatedRequest.add(placeholderRequest, true, true, null);
                continue;
            }
            if (!projectedNode.isProxy()) continue;
            ProxyNode proxy = projectedNode.asProxy();
            ReadAllChildrenRequest pushDownRequest = new ReadAllChildrenRequest(proxy.location(), proxy.workspaceName());
            federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
        }
        this.submit(federatedRequest);
    }

    @Override
    public void process(ReadBlockOfChildrenRequest request) {
        super.process(request);
    }

    @Override
    public void process(ReadNextBlockOfChildrenRequest request) {
        super.process(request);
    }

    @Override
    public void process(ReadAllPropertiesRequest request) {
        FederatedRequest federatedRequest = new FederatedRequest(request);
        for (ProjectedNode projectedNode = this.project(request.at(), request.inWorkspace(), request, false); projectedNode != null; projectedNode = projectedNode.next()) {
            if (projectedNode.isPlaceholder()) {
                PlaceholderNode placeholder = projectedNode.asPlaceholder();
                ReadAllPropertiesRequest placeholderRequest = new ReadAllPropertiesRequest(placeholder.location(), request.inWorkspace());
                placeholderRequest.addProperties(placeholder.properties().values());
                placeholderRequest.setActualLocationOfNode(placeholder.location());
                federatedRequest.add(placeholderRequest, true, true, null);
                continue;
            }
            if (!projectedNode.isProxy()) continue;
            ProxyNode proxy = projectedNode.asProxy();
            ReadAllPropertiesRequest pushDownRequest = new ReadAllPropertiesRequest(proxy.location(), proxy.workspaceName());
            federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
        }
        this.submit(federatedRequest);
    }

    @Override
    public void process(ReadPropertyRequest request) {
        FederatedRequest federatedRequest = new FederatedRequest(request);
        for (ProjectedNode projectedNode = this.project(request.on(), request.inWorkspace(), request, false); projectedNode != null; projectedNode = projectedNode.next()) {
            if (projectedNode.isPlaceholder()) {
                PlaceholderNode placeholder = projectedNode.asPlaceholder();
                ReadPropertyRequest placeholderRequest = new ReadPropertyRequest(placeholder.location(), request.inWorkspace(), request.named());
                Property property = placeholder.properties().get(request.named());
                placeholderRequest.setProperty(property);
                placeholderRequest.setActualLocationOfNode(placeholder.location());
                federatedRequest.add(placeholderRequest, true, true, null);
                continue;
            }
            if (!projectedNode.isProxy()) continue;
            ProxyNode proxy = projectedNode.asProxy();
            ReadPropertyRequest pushDownRequest = new ReadPropertyRequest(proxy.location(), proxy.workspaceName(), request.named());
            federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
        }
        this.submit(federatedRequest);
    }

    @Override
    public void process(ReadBranchRequest request) {
        ProjectedNode projectedNode = this.project(request.at(), request.inWorkspace(), request, false);
        FederatedRequest federatedRequest = new FederatedRequest(request);
        if (projectedNode != null) {
            FederatedWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
            if (request.maximumDepth() > 0) {
                this.processBranch(federatedRequest, projectedNode, workspace, request.maximumDepth());
            }
        }
        this.submit(federatedRequest);
    }

    protected void processBranch(FederatedRequest federatedRequest, ProjectedNode projectedNode, FederatedWorkspace workspace, int maxDepth) {
        assert (maxDepth > 0);
        while (projectedNode != null) {
            if (projectedNode.isPlaceholder()) {
                PlaceholderNode placeholder = projectedNode.asPlaceholder();
                ReadNodeRequest placeholderRequest = new ReadNodeRequest(placeholder.location(), workspace.getName());
                ArrayList<Location> children = new ArrayList<Location>(placeholder.children().size());
                for (ProjectedNode child : placeholder.children()) {
                    if (child instanceof ProxyNode) {
                        ProxyNode proxy = (ProxyNode)child;
                        children.add(proxy.federatedLocation());
                        proxy.federatedLocation();
                        continue;
                    }
                    assert (child instanceof PlaceholderNode);
                    children.add(child.location());
                }
                placeholderRequest.addChildren(children);
                placeholderRequest.addProperties(placeholder.properties().values());
                placeholderRequest.setActualLocationOfNode(placeholder.location());
                federatedRequest.add(placeholderRequest, true, true, null);
                if (maxDepth > 1) {
                    for (ProjectedNode child : placeholder.children()) {
                        this.processBranch(federatedRequest, child, workspace, maxDepth - 1);
                    }
                }
            } else if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                ReadBranchRequest pushDownRequest = new ReadBranchRequest(proxy.location(), proxy.workspaceName(), maxDepth);
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
            }
            projectedNode = projectedNode.next();
        }
    }

    @Override
    public void process(CreateNodeRequest request) {
        ProjectedNode projectedNode;
        FederatedRequest federatedRequest = new FederatedRequest(request);
        if (projectedNode == null) {
            this.submit(federatedRequest);
            return;
        }
        PlaceholderNode placeholder = null;
        for (projectedNode = this.project(request.under(), request.inWorkspace(), request, true); projectedNode != null; projectedNode = projectedNode.next()) {
            if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                CreateNodeRequest pushDownRequest = new CreateNodeRequest(proxy.location(), proxy.workspaceName(), request.named(), request.conflictBehavior(), request.properties());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                this.submit(federatedRequest);
                return;
            }
            assert (projectedNode.isPlaceholder());
            if (placeholder != null) continue;
            placeholder = projectedNode.asPlaceholder();
        }
        if (placeholder != null) {
            switch (request.conflictBehavior()) {
                case UPDATE: 
                case DO_NOT_REPLACE: {
                    PathFactory pathFactory;
                    Path childPath;
                    Location childLocation;
                    Location parent = request.under();
                    if (!parent.hasPath() || (projectedNode = this.project(childLocation = Location.create(childPath = (pathFactory = this.getExecutionContext().getValueFactories().getPathFactory()).create(parent.getPath(), request.named())), request.inWorkspace(), request, true)) == null) break;
                    if (projectedNode.isProxy()) {
                        ProxyNode proxy = projectedNode.asProxy();
                        ReadNodeRequest pushDownRequest = new ReadNodeRequest(proxy.location(), proxy.workspaceName());
                        federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                        this.submit(federatedRequest);
                        return;
                    }
                    assert (projectedNode.isPlaceholder());
                    request.setActualLocationOfNode(projectedNode.location());
                    return;
                }
            }
        }
        String msg = GraphI18n.unableToCreateNodeUnderPlaceholder.text(this.readable(request.named()), this.readable(request.under()), request.inWorkspace(), this.getSourceName());
        request.setError(new UnsupportedRequestException(msg));
    }

    @Override
    public void process(RemovePropertyRequest request) {
        ProjectedNode projectedNode;
        FederatedRequest federatedRequest = new FederatedRequest(request);
        if (projectedNode == null) {
            this.submit(federatedRequest);
            return;
        }
        for (projectedNode = this.project(request.from(), request.inWorkspace(), request, true); projectedNode != null; projectedNode = projectedNode.next()) {
            if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                RemovePropertyRequest pushDownRequest = new RemovePropertyRequest(proxy.location(), proxy.workspaceName(), request.propertyName());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                this.submit(federatedRequest);
                return;
            }
            assert (projectedNode.isPlaceholder());
        }
        String msg = GraphI18n.unableToUpdatePlaceholder.text(this.readable(request.from()), request.inWorkspace(), this.getSourceName());
        request.setError(new UnsupportedRequestException(msg));
    }

    @Override
    public void process(UpdatePropertiesRequest request) {
        ProjectedNode projectedNode;
        FederatedRequest federatedRequest = new FederatedRequest(request);
        if (projectedNode == null) {
            this.submit(federatedRequest);
            return;
        }
        for (projectedNode = this.project(request.on(), request.inWorkspace(), request, true); projectedNode != null; projectedNode = projectedNode.next()) {
            if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                UpdatePropertiesRequest pushDownRequest = new UpdatePropertiesRequest(proxy.location(), proxy.workspaceName(), request.properties());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                this.submit(federatedRequest);
                return;
            }
            assert (projectedNode.isPlaceholder());
        }
        String msg = GraphI18n.unableToUpdatePlaceholder.text(this.readable(request.on()), request.inWorkspace(), this.getSourceName());
        request.setError(new UnsupportedRequestException(msg));
    }

    @Override
    public void process(UpdateValuesRequest request) {
        ProjectedNode projectedNode;
        FederatedRequest federatedRequest = new FederatedRequest(request);
        if (projectedNode == null) {
            this.submit(federatedRequest);
            return;
        }
        for (projectedNode = this.project(request.on(), request.inWorkspace(), request, true); projectedNode != null; projectedNode = projectedNode.next()) {
            if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                UpdateValuesRequest pushDownRequest = new UpdateValuesRequest(proxy.workspaceName(), proxy.location(), request.property(), request.addedValues(), request.removedValues());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                this.submit(federatedRequest);
                return;
            }
            assert (projectedNode.isPlaceholder());
        }
        String msg = GraphI18n.unableToUpdatePlaceholder.text(this.readable(request.on()), request.inWorkspace(), this.getSourceName());
        request.setError(new UnsupportedRequestException(msg));
    }

    @Override
    public void process(SetPropertyRequest request) {
        ProjectedNode projectedNode;
        FederatedRequest federatedRequest = new FederatedRequest(request);
        if (projectedNode == null) {
            this.submit(federatedRequest);
            return;
        }
        for (projectedNode = this.project(request.on(), request.inWorkspace(), request, true); projectedNode != null; projectedNode = projectedNode.next()) {
            if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                SetPropertyRequest pushDownRequest = new SetPropertyRequest(proxy.location(), proxy.workspaceName(), request.property());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                this.submit(federatedRequest);
                return;
            }
            assert (projectedNode.isPlaceholder());
        }
        String msg = GraphI18n.unableToUpdatePlaceholder.text(this.readable(request.on()), request.inWorkspace(), this.getSourceName());
        request.setError(new UnsupportedRequestException(msg));
    }

    @Override
    public void process(DeleteChildrenRequest request) {
        ProjectedNode projectedNode = this.project(request.at(), request.inWorkspace(), request, true);
        FederatedRequest federatedRequest = new FederatedRequest(request);
        if (projectedNode == null) {
            this.submit(federatedRequest);
            return;
        }
        FederatedWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        boolean submit = this.deleteBranch(federatedRequest, projectedNode, workspace, this.getExecutionContext(), false);
        if (submit) {
            this.submit(federatedRequest);
        } else {
            String msg = GraphI18n.unableToDeletePlaceholder.text(this.readable(request.at()), request.inWorkspace(), this.getSourceName());
            request.setError(new UnsupportedRequestException(msg));
        }
    }

    @Override
    public void process(DeleteBranchRequest request) {
        ProjectedNode projectedNode = this.project(request.at(), request.inWorkspace(), request, true);
        FederatedRequest federatedRequest = new FederatedRequest(request);
        if (projectedNode == null) {
            this.submit(federatedRequest);
            return;
        }
        FederatedWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        boolean submit = this.deleteBranch(federatedRequest, projectedNode, workspace, this.getExecutionContext(), true);
        if (submit) {
            this.submit(federatedRequest);
        } else {
            String msg = GraphI18n.unableToDeletePlaceholder.text(this.readable(request.at()), request.inWorkspace(), this.getSourceName());
            request.setError(new UnsupportedRequestException(msg));
        }
    }

    protected boolean deleteBranch(FederatedRequest federatedRequest, ProjectedNode projectedNode, FederatedWorkspace workspace, ExecutionContext context, boolean includeParent) {
        boolean submit = false;
        while (projectedNode != null) {
            if (projectedNode.isProxy()) {
                ChangeRequest pushDownRequest;
                ProxyNode proxy = projectedNode.asProxy();
                if (proxy.isTopLevelNode() || !includeParent) {
                    pushDownRequest = new DeleteChildrenRequest(proxy.location(), proxy.workspaceName());
                    federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                } else {
                    pushDownRequest = new DeleteBranchRequest(proxy.location(), proxy.workspaceName());
                    federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                }
                submit = true;
            } else if (projectedNode.isPlaceholder()) {
                PlaceholderNode placeholder = projectedNode.asPlaceholder();
                if (includeParent) {
                    DeleteBranchRequest delete = new DeleteBranchRequest(placeholder.location(), workspace.getName());
                    delete.setActualLocationOfNode(placeholder.location());
                    federatedRequest.add(delete, true, true, null);
                }
                Iterator<ProjectedNode> i$ = placeholder.children().iterator();
                while (i$.hasNext()) {
                    for (ProjectedNode child = i$.next(); child != null && child.isProxy(); child = child.next()) {
                        submit = this.deleteBranch(federatedRequest, child.asProxy(), workspace, context, true);
                    }
                }
            }
            projectedNode = projectedNode.next();
        }
        return submit;
    }

    @Override
    public void process(CopyBranchRequest request) {
        ProxyNode intoProxy;
        ProxyNode fromProxy;
        ProjectedNode projectedFromNode = this.project(request.from(), request.fromWorkspace(), request, false);
        if (projectedFromNode == null) {
            this.submit(new FederatedRequest(request));
            return;
        }
        ProjectedNode projectedIntoNode = this.project(request.into(), request.intoWorkspace(), request, true);
        if (projectedIntoNode == null) {
            this.submit(new FederatedRequest(request));
            return;
        }
        while (projectedFromNode != null) {
            if (projectedFromNode.isProxy()) {
                fromProxy = projectedFromNode.asProxy();
                while (projectedIntoNode != null) {
                    if (projectedIntoNode.isProxy()) {
                        intoProxy = projectedIntoNode.asProxy();
                        if (fromProxy.projection().getSourceName().equals(intoProxy.projection().getSourceName())) break;
                    }
                    projectedIntoNode = projectedIntoNode.next();
                }
                if (projectedIntoNode != null) break;
            }
            projectedFromNode = projectedFromNode.next();
        }
        if (projectedFromNode == null || projectedIntoNode == null) {
            String msg = GraphI18n.copyLimitedToBeWithinSingleSource.text(this.readable(request.from()), request.fromWorkspace(), this.readable(request.into()), request.intoWorkspace(), this.getSourceName());
            request.setError(new UnsupportedRequestException(msg));
            return;
        }
        fromProxy = projectedFromNode.asProxy();
        intoProxy = projectedIntoNode.asProxy();
        assert (fromProxy.projection().getSourceName().equals(intoProxy.projection().getSourceName()));
        boolean sameLocation = fromProxy.isSameLocationAsOriginal() && intoProxy.isSameLocationAsOriginal();
        CopyBranchRequest pushDown = new CopyBranchRequest(fromProxy.location(), fromProxy.workspaceName(), intoProxy.location(), intoProxy.workspaceName(), request.desiredName(), request.nodeConflictBehavior());
        FederatedRequest federatedRequest = new FederatedRequest(request);
        federatedRequest.add(pushDown, sameLocation, false, fromProxy.projection(), intoProxy.projection());
        this.submit(federatedRequest);
    }

    @Override
    public void process(CloneBranchRequest request) {
        ProxyNode intoProxy;
        ProxyNode fromProxy;
        ProjectedNode projectedFromNode = this.project(request.from(), request.fromWorkspace(), request, false);
        if (projectedFromNode == null) {
            this.submit(new FederatedRequest(request));
            return;
        }
        ProjectedNode projectedIntoNode = this.project(request.into(), request.intoWorkspace(), request, true);
        if (projectedIntoNode == null) {
            this.submit(new FederatedRequest(request));
            return;
        }
        while (projectedFromNode != null) {
            if (projectedFromNode.isProxy()) {
                fromProxy = projectedFromNode.asProxy();
                while (projectedIntoNode != null) {
                    if (projectedIntoNode.isProxy()) {
                        intoProxy = projectedIntoNode.asProxy();
                        if (fromProxy.projection().getSourceName().equals(intoProxy.projection().getSourceName())) break;
                    }
                    projectedIntoNode = projectedIntoNode.next();
                }
                if (projectedIntoNode != null) break;
            }
            projectedFromNode = projectedFromNode.next();
        }
        if (projectedFromNode == null || projectedIntoNode == null) {
            String msg = GraphI18n.cloneLimitedToBeWithinSingleSource.text(this.readable(request.from()), request.fromWorkspace(), this.readable(request.into()), request.intoWorkspace(), this.getSourceName());
            request.setError(new UnsupportedRequestException(msg));
            return;
        }
        fromProxy = projectedFromNode.asProxy();
        intoProxy = projectedIntoNode.asProxy();
        assert (fromProxy.projection().getSourceName().equals(intoProxy.projection().getSourceName()));
        boolean sameLocation = fromProxy.isSameLocationAsOriginal() && intoProxy.isSameLocationAsOriginal();
        CloneBranchRequest pushDown = new CloneBranchRequest(fromProxy.location(), fromProxy.workspaceName(), intoProxy.location(), intoProxy.workspaceName(), request.desiredName(), request.desiredSegment(), request.removeExisting());
        FederatedRequest federatedRequest = new FederatedRequest(request);
        federatedRequest.add(pushDown, sameLocation, false, fromProxy.projection(), intoProxy.projection());
        this.submit(federatedRequest);
    }

    @Override
    public void process(MoveBranchRequest request) {
        ProjectedNode projectedFromNode = this.project(request.from(), request.inWorkspace(), request, true);
        if (projectedFromNode == null) {
            this.submit(new FederatedRequest(request));
            return;
        }
        ProjectedNode projectedBeforeNode = request.before() != null ? this.project(request.before(), request.inWorkspace(), request, true) : null;
        boolean sameLocation = true;
        if (request.into() != null) {
            ProxyNode beforeProxy;
            ProxyNode intoProxy;
            ProxyNode fromProxy;
            ProjectedNode projectedIntoNode = this.project(request.into(), request.inWorkspace(), request, true);
            if (projectedIntoNode == null) {
                return;
            }
            while (projectedFromNode != null) {
                if (projectedFromNode.isProxy()) {
                    fromProxy = projectedFromNode.asProxy();
                    while (projectedIntoNode != null) {
                        if (projectedIntoNode.isProxy()) {
                            intoProxy = projectedIntoNode.asProxy();
                            if (fromProxy.projection().getSourceName().equals(intoProxy.projection().getSourceName())) break;
                        }
                        projectedIntoNode = projectedIntoNode.next();
                    }
                    if (projectedIntoNode != null) break;
                }
                projectedFromNode = projectedFromNode.next();
            }
            if (projectedFromNode == null || projectedIntoNode == null) {
                String msg = GraphI18n.moveLimitedToBeWithinSingleSource.text(this.readable(request.from()), request.inWorkspace(), this.readable(request.into()), request.inWorkspace(), this.getSourceName());
                request.setError(new UnsupportedRequestException(msg));
                return;
            }
            fromProxy = projectedFromNode.asProxy();
            intoProxy = projectedIntoNode.asProxy();
            ProxyNode proxyNode = beforeProxy = request.before() != null ? projectedBeforeNode.asProxy() : null;
            assert (fromProxy.projection().getSourceName().equals(intoProxy.projection().getSourceName()));
            sameLocation = fromProxy.isSameLocationAsOriginal() && intoProxy.isSameLocationAsOriginal();
            Location beforeProxyLocation = beforeProxy != null ? beforeProxy.location() : null;
            MoveBranchRequest pushDown = new MoveBranchRequest(fromProxy.location(), intoProxy.location(), beforeProxyLocation, intoProxy.workspaceName(), request.desiredName(), request.conflictBehavior());
            FederatedRequest federatedRequest = new FederatedRequest(request);
            federatedRequest.add(pushDown, sameLocation, false, fromProxy.projection(), intoProxy.projection());
            this.submit(federatedRequest);
        } else {
            ProxyNode fromProxy = projectedFromNode.asProxy();
            ProxyNode beforeProxy = request.before() != null ? projectedBeforeNode.asProxy() : null;
            Location beforeProxyLocation = beforeProxy != null ? beforeProxy.location() : null;
            MoveBranchRequest pushDown = new MoveBranchRequest(fromProxy.location(), null, beforeProxyLocation, fromProxy.workspaceName(), request.desiredName(), request.conflictBehavior());
            FederatedRequest federatedRequest = new FederatedRequest(request);
            federatedRequest.add(pushDown, sameLocation, false, fromProxy.projection());
            this.submit(federatedRequest);
        }
    }

    @Override
    public void process(RenameNodeRequest request) {
        ProjectedNode projectedNode;
        FederatedRequest federatedRequest = new FederatedRequest(request);
        if (projectedNode == null) {
            this.submit(federatedRequest);
            return;
        }
        for (projectedNode = this.project(request.at(), request.inWorkspace(), request, true); projectedNode != null; projectedNode = projectedNode.next()) {
            if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                RenameNodeRequest pushDownRequest = new RenameNodeRequest(proxy.location(), proxy.workspaceName(), request.toName());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                this.submit(federatedRequest);
                return;
            }
            assert (projectedNode.isPlaceholder());
        }
        String msg = GraphI18n.unableToUpdatePlaceholder.text(this.readable(request.at()), request.inWorkspace(), this.getSourceName());
        request.setError(new UnsupportedRequestException(msg));
    }

    @Override
    public void process(LockBranchRequest request) {
        ProjectedNode projectedNode;
        FederatedRequest federatedRequest = new FederatedRequest(request);
        if (projectedNode == null) {
            this.submit(federatedRequest);
            return;
        }
        for (projectedNode = this.project(request.at(), request.inWorkspace(), request, true); projectedNode != null; projectedNode = projectedNode.next()) {
            if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                LockBranchRequest pushDownRequest = new LockBranchRequest(proxy.location(), proxy.workspaceName(), request.lockScope(), request.lockTimeoutInMillis());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                this.submit(federatedRequest);
                return;
            }
            assert (projectedNode.isPlaceholder());
        }
        String msg = GraphI18n.unableToUpdatePlaceholder.text(this.readable(request.at()), request.inWorkspace(), this.getSourceName());
        request.setError(new UnsupportedRequestException(msg));
    }

    @Override
    public void process(UnlockBranchRequest request) {
        ProjectedNode projectedNode;
        FederatedRequest federatedRequest = new FederatedRequest(request);
        if (projectedNode == null) {
            this.submit(federatedRequest);
            return;
        }
        for (projectedNode = this.project(request.at(), request.inWorkspace(), request, true); projectedNode != null; projectedNode = projectedNode.next()) {
            if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                UnlockBranchRequest pushDownRequest = new UnlockBranchRequest(proxy.location(), proxy.workspaceName());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                this.submit(federatedRequest);
                return;
            }
            assert (projectedNode.isPlaceholder());
        }
        String msg = GraphI18n.unableToUpdatePlaceholder.text(this.readable(request.at()), request.inWorkspace(), this.getSourceName());
        request.setError(new UnsupportedRequestException(msg));
    }

    @Override
    public void process(VerifyWorkspaceRequest request) {
        FederatedWorkspace workspace = this.getWorkspace(request, request.workspaceName());
        if (workspace != null) {
            request.setActualWorkspaceName(workspace.getName());
            Location root = Location.create(this.getExecutionContext().getValueFactories().getPathFactory().createRootPath());
            FederatedRequest federatedRequest = new FederatedRequest(request);
            for (ProjectedNode projectedNode = this.project(root, workspace.getName(), request, false); projectedNode != null; projectedNode = projectedNode.next()) {
                if (projectedNode.isPlaceholder()) {
                    PlaceholderNode placeholder = projectedNode.asPlaceholder();
                    VerifyNodeExistsRequest placeholderRequest = new VerifyNodeExistsRequest(root, workspace.getName());
                    placeholderRequest.setActualLocationOfNode(placeholder.location());
                    federatedRequest.add(placeholderRequest, true, true, null);
                    continue;
                }
                if (!projectedNode.isProxy()) continue;
                ProxyNode proxy = projectedNode.asProxy();
                VerifyNodeExistsRequest pushDownRequest = new VerifyNodeExistsRequest(proxy.location(), proxy.workspaceName());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
            }
            this.submit(federatedRequest);
        }
    }

    @Override
    public void process(GetWorkspacesRequest request) {
        request.setAvailableWorkspaceNames(this.repository.getWorkspaceNames());
    }

    @Override
    public void process(CreateWorkspaceRequest request) {
        String msg = GraphI18n.federatedSourceDoesNotSupportCreatingWorkspaces.text(this.getSourceName());
        request.setError(new InvalidRequestException(msg));
    }

    @Override
    public void process(CloneWorkspaceRequest request) {
        String msg = GraphI18n.federatedSourceDoesNotSupportCloningWorkspaces.text(this.getSourceName());
        request.setError(new InvalidRequestException(msg));
    }

    @Override
    public void process(DestroyWorkspaceRequest request) {
        String msg = GraphI18n.federatedSourceDoesNotSupportDestroyingWorkspaces.text(this.getSourceName());
        request.setError(new InvalidRequestException(msg));
    }

    @Override
    public void process(AccessQueryRequest request) {
        this.processUnknownRequest(request);
    }

    @Override
    public void process(FullTextSearchRequest request) {
        this.processUnknownRequest(request);
    }

    @Override
    public void close() {
        super.close();
        for (CompositeRequestChannel channel : this.channelBySourceName.values()) {
            channel.close();
        }
    }

    protected void cancel(boolean mayInterruptIfRunning) {
        for (CompositeRequestChannel channel : this.channelBySourceName.values()) {
            channel.cancel(mayInterruptIfRunning);
        }
    }
}

