/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collection;
import java.util.HashSet;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.LinkedListMultimap;
import org.modeshape.common.collection.Multimap;
import org.modeshape.graph.property.Name;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrPropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class DefinitionCache {
    private final Multimap<Name, JcrNodeDefinition> childNodeDefinitionsThatAllowSns = LinkedListMultimap.create();
    private final Multimap<Name, JcrNodeDefinition> childNodeDefinitionsThatAllowNoSns = LinkedListMultimap.create();
    private final Multimap<Name, JcrPropertyDefinition> multiValuedPropertyDefinitions = LinkedListMultimap.create();
    private final Multimap<Name, JcrPropertyDefinition> singleValuedPropertyDefinitions = LinkedListMultimap.create();
    private final Multimap<Name, JcrNodeDefinition> allChildNodeDefinitions = LinkedListMultimap.create();
    private final Multimap<Name, JcrPropertyDefinition> allPropertyDefinitions = LinkedListMultimap.create();

    DefinitionCache(JcrNodeType nodeType) {
        this.addDefinitionsForTypeAndAllSupertypes(nodeType);
    }

    DefinitionCache(JcrNodeType primaryType, Iterable<JcrNodeType> mixinTypes) {
        this.addDefinitionsForTypeAndAllSupertypes(primaryType);
        if (mixinTypes != null) {
            for (JcrNodeType mixinType : mixinTypes) {
                this.addDefinitionsForTypeAndAllSupertypes(mixinType);
            }
        }
    }

    private final void addDefinitionsForTypeAndAllSupertypes(JcrNodeType nodeType) {
        for (JcrNodeType superSuperType : nodeType.getTypeAndSupertypes()) {
            this.addDefinitions(superSuperType);
        }
    }

    private final void addDefinitions(JcrNodeType nodeType) {
        Name name;
        HashSet<Name> namesFromThisType = new HashSet<Name>();
        for (JcrNodeDefinition jcrNodeDefinition : nodeType.childNodeDefinitions()) {
            name = jcrNodeDefinition.getInternalName();
            if (this.allChildNodeDefinitions.containsKey(name) && !namesFromThisType.contains(name) && !JcrNodeType.RESIDUAL_NAME.equals(name)) continue;
            if (jcrNodeDefinition.allowsSameNameSiblings()) {
                this.childNodeDefinitionsThatAllowSns.put(name, jcrNodeDefinition);
            } else {
                this.childNodeDefinitionsThatAllowNoSns.put(name, jcrNodeDefinition);
            }
            this.allChildNodeDefinitions.put(name, jcrNodeDefinition);
            namesFromThisType.add(name);
        }
        namesFromThisType.clear();
        for (JcrPropertyDefinition jcrPropertyDefinition : nodeType.propertyDefinitions()) {
            name = jcrPropertyDefinition.getInternalName();
            if (this.allPropertyDefinitions.containsKey(name) && !namesFromThisType.contains(name) && !JcrNodeType.RESIDUAL_NAME.equals(name)) continue;
            if (jcrPropertyDefinition.isMultiple()) {
                this.multiValuedPropertyDefinitions.put(name, jcrPropertyDefinition);
            } else {
                this.singleValuedPropertyDefinitions.put(name, jcrPropertyDefinition);
            }
            namesFromThisType.add(name);
            this.allPropertyDefinitions.put(name, jcrPropertyDefinition);
        }
    }

    public Collection<JcrPropertyDefinition> allSingleValuePropertyDefinitions(Name propertyName) {
        return this.singleValuedPropertyDefinitions.get(propertyName);
    }

    public Collection<JcrPropertyDefinition> allMultiValuePropertyDefinitions(Name propertyName) {
        return this.multiValuedPropertyDefinitions.get(propertyName);
    }

    public Collection<JcrPropertyDefinition> allPropertyDefinitions(Name propertyName) {
        return this.allPropertyDefinitions.get(propertyName);
    }

    public Collection<JcrPropertyDefinition> allPropertyDefinitions() {
        return this.allPropertyDefinitions.values();
    }

    public Collection<JcrNodeDefinition> allChildNodeDefinitionsWithNoSns(Name childName) {
        return this.childNodeDefinitionsThatAllowNoSns.get(childName);
    }

    public Collection<JcrNodeDefinition> allChildNodeDefinitionsWithSns(Name childName) {
        return this.childNodeDefinitionsThatAllowSns.get(childName);
    }

    public Collection<JcrNodeDefinition> allChildNodeDefinitions(Name childName) {
        return this.allChildNodeDefinitions.get(childName);
    }

    public Collection<JcrNodeDefinition> allChildNodeDefinitions(Name childName, boolean requireSns) {
        if (requireSns) {
            return this.childNodeDefinitionsThatAllowSns.get(childName);
        }
        return this.allChildNodeDefinitions.get(childName);
    }

    public Collection<JcrNodeDefinition> allChildNodeDefinitions() {
        return this.allChildNodeDefinitions.values();
    }
}

