/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.Reflection;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.NetChangeObserver;
import org.modeshape.graph.observe.ObservationBus;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.request.CollectGarbageRequest;
import org.modeshape.repository.ModeShapeConfigurationException;
import org.modeshape.repository.ModeShapeLexicon;
import org.modeshape.repository.RepositoryI18n;
import org.modeshape.repository.RepositoryLibrary;
import org.modeshape.repository.service.AbstractServiceAdministrator;
import org.modeshape.repository.service.AdministeredService;
import org.modeshape.repository.service.ServiceAdministrator;

@ThreadSafe
public class RepositoryService
implements AdministeredService,
Observer {
    public static final int MAXIMUM_NUMBER_OF_PASSES_PER_GC_RUN = 10;
    private final ExecutionContext context;
    private final RepositoryLibrary sources;
    private final String configurationSourceName;
    private final String configurationWorkspaceName;
    private final Path pathToConfigurationRoot;
    private final Path pathToSources;
    private final ConfigurationChangeObserver configurationChangeObserver;
    private final Administrator administrator = new Administrator();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Problems problems;

    public RepositoryService(RepositorySource configurationSource, String configurationWorkspaceName, Path pathToConfigurationRoot, ExecutionContext context, ObservationBus observationBus, Problems problems) {
        CheckArg.isNotNull(configurationSource, "configurationSource");
        CheckArg.isNotNull(context, "context");
        CheckArg.isNotNull(observationBus, "observationBus");
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        if (pathToConfigurationRoot == null) {
            pathToConfigurationRoot = (Path)pathFactory.create("/dna:system");
        }
        if (problems == null) {
            problems = new SimpleProblems();
        }
        this.pathToSources = pathFactory.create(pathToConfigurationRoot, ModeShapeLexicon.SOURCES);
        this.sources = new RepositoryLibrary(configurationSource, configurationWorkspaceName, this.pathToSources, context, observationBus);
        this.sources.addSource(configurationSource);
        this.pathToConfigurationRoot = pathToConfigurationRoot;
        this.configurationSourceName = configurationSource.getName();
        this.configurationWorkspaceName = configurationWorkspaceName;
        this.context = context;
        this.problems = problems;
        this.configurationChangeObserver = new ConfigurationChangeObserver();
    }

    @Override
    public final ServiceAdministrator getAdministrator() {
        return this.administrator;
    }

    public final String getConfigurationSourceName() {
        return this.configurationSourceName;
    }

    public final String getConfigurationWorkspaceName() {
        return this.configurationWorkspaceName;
    }

    public final RepositoryLibrary getRepositoryLibrary() {
        return this.sources;
    }

    protected final Path getPathToConfigurationRoot() {
        return this.pathToConfigurationRoot;
    }

    protected Path getPathToSources() {
        return this.pathToSources;
    }

    public final ExecutionContext getExecutionEnvironment() {
        return this.context;
    }

    public String getJndiName() {
        return null;
    }

    protected synchronized void startService() {
        if (!this.started.get()) {
            Graph graph = Graph.create(this.getConfigurationSourceName(), this.sources, this.context);
            Path pathToSourcesNode = this.context.getValueFactories().getPathFactory().create(this.pathToConfigurationRoot, ModeShapeLexicon.SOURCES);
            try {
                String workspaceName = this.getConfigurationWorkspaceName();
                if (workspaceName != null) {
                    graph.useWorkspace(workspaceName);
                }
                Subgraph sourcesGraph = graph.getSubgraphOfDepth(Integer.MAX_VALUE).at(pathToSourcesNode);
                for (Location location : sourcesGraph.getRoot().getChildren()) {
                    this.sources.addSource(this.createRepositorySource(sourcesGraph, location, this.problems));
                }
            }
            catch (PathNotFoundException e) {
            }
            catch (Throwable err) {
                throw new ModeShapeConfigurationException(RepositoryI18n.errorStartingRepositoryService.text(new Object[0]), err);
            }
            this.started.set(true);
        }
    }

    protected synchronized void shutdownService() {
        this.sources.getAdministrator().shutdown();
    }

    protected RepositorySource createRepositorySource(Subgraph subgraph, Location location, Problems problems) {
        return (RepositorySource)this.createInstanceFromProperties(subgraph, location, problems, true);
    }

    protected Object createInstanceFromProperties(Subgraph subgraph, Location location, Problems problems, boolean mustHaveClassName) {
        ValueFactories valueFactories = this.context.getValueFactories();
        ValueFactory<String> stringFactory = valueFactories.getStringFactory();
        Object node = subgraph.getNode(location);
        assert (location.hasPath());
        Path path = node.getLocation().getPath();
        Map<Name, Property> properties = node.getPropertiesByName();
        Property classnameProperty = properties.get(ModeShapeLexicon.CLASSNAME);
        Property classpathProperty = properties.get(ModeShapeLexicon.CLASSPATH);
        if (classnameProperty == null) {
            if (mustHaveClassName) {
                problems.addError(RepositoryI18n.requiredPropertyIsMissingFromNode, ModeShapeLexicon.CLASSNAME, path);
            }
            return null;
        }
        if (problems.hasErrors()) {
            return null;
        }
        String classname = stringFactory.create(classnameProperty.getValues().next());
        String[] classpath = classpathProperty == null ? new String[]{} : stringFactory.create(classpathProperty.getValuesAsArray());
        ClassLoader classLoader = this.context.getClassLoader(classpath);
        Object instance = null;
        try {
            Class<?> sourceClass = classLoader.loadClass(classname);
            instance = sourceClass.newInstance();
        }
        catch (ClassNotFoundException err) {
            problems.addError((Throwable)err, RepositoryI18n.unableToLoadClassUsingClasspath, classname, classpath);
        }
        catch (IllegalAccessException err) {
            problems.addError((Throwable)err, RepositoryI18n.unableToAccessClassUsingClasspath, classname, classpath);
        }
        catch (Throwable err) {
            problems.addError(err, RepositoryI18n.unableToInstantiateClassUsingClasspath, classname, classpath);
        }
        if (instance == null) {
            return null;
        }
        Property nameProperty = this.context.getPropertyFactory().create(JcrLexicon.NAME, path.getLastSegment().getName().getLocalName());
        properties.put(JcrLexicon.NAME, nameProperty);
        this.setBeanPropertyIfExistsAndNotSet(instance, "configurationSourceName", this.getConfigurationSourceName());
        this.setBeanPropertyIfExistsAndNotSet(instance, "configurationWorkspaceName", this.getConfigurationWorkspaceName());
        this.setBeanPropertyIfExistsAndNotSet(instance, "configurationPath", stringFactory.create(path));
        Reflection reflection = new Reflection(instance.getClass());
        block18: for (Map.Entry<Name, Property> entry : properties.entrySet()) {
            Name propertyName = entry.getKey();
            Property property = entry.getValue();
            String javaPropertyName = propertyName.getLocalName();
            if (property.isEmpty()) continue;
            Object[] value = null;
            for (Method setter : reflection.findAllMethods("set" + javaPropertyName, false)) {
                try {
                    Class<?> paramType;
                    PropertyType allowedType;
                    Class<?>[] parameterTypes = setter.getParameterTypes();
                    if (parameterTypes.length != 1 || (allowedType = PropertyType.discoverType(paramType = parameterTypes[0])) == null) continue;
                    ValueFactory<?> factory = this.context.getValueFactories().getValueFactory(allowedType);
                    if (paramType.isArray()) {
                        int i;
                        Object[] primitiveValues;
                        if (paramType.getComponentType().isArray()) continue;
                        ?[] values = factory.create(property.getValuesAsArray());
                        Class<?> componentType = paramType.getComponentType();
                        if (Integer.TYPE.equals(componentType)) {
                            primitiveValues = new int[values.length];
                            for (i = 0; i != values.length; ++i) {
                                primitiveValues[i] = ((Long)values[i]).intValue();
                            }
                            value = primitiveValues;
                        } else if (Short.TYPE.equals(componentType)) {
                            primitiveValues = new short[values.length];
                            for (i = 0; i != values.length; ++i) {
                                primitiveValues[i] = ((Long)values[i]).shortValue();
                            }
                            value = primitiveValues;
                        } else if (Long.TYPE.equals(componentType)) {
                            primitiveValues = new long[values.length];
                            for (i = 0; i != values.length; ++i) {
                                primitiveValues[i] = (int)((Long)values[i]).longValue();
                            }
                            value = primitiveValues;
                        } else if (Double.TYPE.equals(componentType)) {
                            primitiveValues = new double[values.length];
                            for (i = 0; i != values.length; ++i) {
                                primitiveValues[i] = (int)((Double)values[i]).doubleValue();
                            }
                            value = primitiveValues;
                        } else if (Float.TYPE.equals(componentType)) {
                            primitiveValues = new float[values.length];
                            for (i = 0; i != values.length; ++i) {
                                primitiveValues[i] = (int)((Double)values[i]).floatValue();
                            }
                            value = primitiveValues;
                        } else if (Boolean.TYPE.equals(componentType)) {
                            primitiveValues = new boolean[values.length];
                            for (i = 0; i != values.length; ++i) {
                                primitiveValues[i] = ((Boolean)values[i]).booleanValue() ? 1 : 0;
                            }
                            value = primitiveValues;
                        } else {
                            value = values;
                        }
                    } else {
                        value = (Object[])factory.create(property.getFirstValue());
                        if (Integer.TYPE.equals(paramType)) {
                            value = new Integer(((Long)value).intValue());
                        } else if (Short.TYPE.equals(paramType)) {
                            value = new Short(((Long)value).shortValue());
                        } else if (Float.TYPE.equals(paramType)) {
                            value = new Float(((Double)value).floatValue());
                        }
                    }
                    String msg = "Setting property {0} to {1} on source at {2} in configuration repository {3} in workspace {4}";
                    Logger.getLogger(this.getClass()).trace(msg, javaPropertyName, value, path, this.configurationSourceName, this.configurationWorkspaceName);
                    setter.invoke(instance, new Object[]{value});
                    continue block18;
                }
                catch (ValueFormatException vfe) {
                }
                catch (SecurityException err) {
                    problems.addWarning((Throwable)err, RepositoryI18n.securityExceptionWhileSettingProperty, instance.getClass(), setter);
                }
                catch (IllegalArgumentException err) {
                    problems.addWarning((Throwable)err, RepositoryI18n.invalidArgumentExceptionWhileSettingProperty, setter, value, path, this.configurationSourceName, this.configurationWorkspaceName);
                }
                catch (IllegalAccessException err) {
                    problems.addWarning((Throwable)err, RepositoryI18n.illegalAccessExceptionWhileSettingProperty, instance.getClass(), setter);
                }
                catch (InvocationTargetException err) {
                    problems.addWarning((Throwable)err, RepositoryI18n.invocationTargetExceptionWhileSettingProperty, setter, value, path, this.configurationSourceName, this.configurationWorkspaceName);
                }
            }
        }
        for (Location childLocation : node.getChildren()) {
            assert (childLocation.hasPath());
            Path childPath = childLocation.getPath();
            Name childName = childPath.getLastSegment().getName();
            Object value = this.createInstanceFromProperties(subgraph, childLocation, problems, false);
            if (problems.hasErrors()) {
                return null;
            }
            String javaPropertyName = childName.getLocalName();
            Method setter = null;
            try {
                Class<?> valueClass = null;
                if (value != null) {
                    valueClass = value.getClass();
                }
                setter = reflection.findBestMethodWithSignature("set" + javaPropertyName, false, valueClass);
            }
            catch (NoSuchMethodException nsme) {
                continue;
            }
            try {
                String msg = "Setting property {0} to {1} on object at {2} in configuration repository {3} in workspace {4}";
                Logger.getLogger(this.getClass()).trace(msg, javaPropertyName, value, childPath, this.configurationSourceName, this.configurationWorkspaceName);
                setter.invoke(instance, value);
            }
            catch (ClassCastException vfe) {
            }
            catch (SecurityException err) {
                problems.addWarning((Throwable)err, RepositoryI18n.securityExceptionWhileSettingProperty, instance.getClass(), setter);
            }
            catch (IllegalArgumentException err) {
                problems.addWarning((Throwable)err, RepositoryI18n.invalidArgumentExceptionWhileSettingProperty, setter, value, childPath, this.configurationSourceName, this.configurationWorkspaceName);
            }
            catch (IllegalAccessException err) {
                problems.addWarning((Throwable)err, RepositoryI18n.illegalAccessExceptionWhileSettingProperty, instance.getClass(), setter);
            }
            catch (InvocationTargetException err) {
                problems.addWarning((Throwable)err, RepositoryI18n.invocationTargetExceptionWhileSettingProperty, setter, value, childPath, this.configurationSourceName, this.configurationWorkspaceName);
            }
        }
        return instance;
    }

    protected boolean setBeanPropertyIfExistsAndNotSet(Object target, String propertyName, Object value) {
        Reflection reflection = new Reflection(target.getClass());
        try {
            if (reflection.invokeGetterMethodOnTarget(propertyName, target) == null) {
                reflection.invokeSetterMethodOnTarget(propertyName, target, value);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).debug("Unknown property '{0}' on '{1}' class", propertyName, target.getClass().getName());
            return false;
        }
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public void notify(Changes changes) {
        this.configurationChangeObserver.notify(changes);
    }

    public boolean requiresGarbageCollection() {
        for (RepositorySource source : this.getRepositoryLibrary().getSources()) {
            if (source.getCapabilities().supportsAutomaticGarbageCollection()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runGarbageCollection(Problems problems) {
        Logger logger = Logger.getLogger(this.getClass());
        LinkedList<GarbageCollectedSource> sourcesToGc = new LinkedList<GarbageCollectedSource>();
        for (RepositorySource source : this.getRepositoryLibrary().getSources()) {
            if (source.getCapabilities().supportsAutomaticGarbageCollection()) continue;
            sourcesToGc.add(new GarbageCollectedSource(source));
        }
        while (!sourcesToGc.isEmpty()) {
            RepositorySource source;
            GarbageCollectedSource gcSource = (GarbageCollectedSource)sourcesToGc.poll();
            source = gcSource.source;
            RepositoryConnection connection = this.getRepositoryLibrary().createConnection(source.getName());
            try {
                logger.debug("Garbage collection requested for {0}", source.getName());
                CollectGarbageRequest request = new CollectGarbageRequest();
                connection.execute(this.context, request);
                gcSource.recordPass();
                if (request.isAdditionalPassRequired() && gcSource.hasPassesRemaining()) {
                    sourcesToGc.offer(gcSource);
                    logger.debug("Garbage collection partially completed for {0}; enqueuing again", source.getName());
                    continue;
                }
                logger.debug("Garbage collection completed for {0}", source.getName());
            }
            catch (Throwable t) {
                I18n msg = RepositoryI18n.errorCollectingGarbageInSource;
                if (problems != null) {
                    problems.addError(t, msg, source.getName(), t.getMessage());
                    continue;
                }
                logger.error(msg, source.getName(), t.getMessage());
            }
            finally {
                connection.close();
            }
        }
    }

    protected class ConfigurationChangeObserver
    extends NetChangeObserver {
        protected ConfigurationChangeObserver() {
        }

        @Override
        protected void notify(NetChangeObserver.NetChanges netChanges) {
            if (RepositoryService.this.getConfigurationWorkspaceName() == null) {
                return;
            }
            if (!RepositoryService.this.getConfigurationSourceName().equals(netChanges.getSourceName())) {
                return;
            }
            for (NetChangeObserver.NetChange change : netChanges.getNetChanges()) {
                boolean changedNodeIsPotentiallySource;
                if (!RepositoryService.this.getConfigurationWorkspaceName().equals(change.getRepositoryWorkspaceName())) {
                    return;
                }
                Path changedPath = change.getPath();
                Path configPath = RepositoryService.this.getPathToConfigurationRoot();
                if (!changedPath.isAtOrBelow(RepositoryService.this.getPathToSources())) {
                    return;
                }
                boolean bl = changedNodeIsPotentiallySource = configPath.size() + 1 == changedPath.size();
                if (changedNodeIsPotentiallySource && change.includes(NetChangeObserver.ChangeType.NODE_REMOVED)) {
                    String sourceName = changedPath.getLastSegment().getName().getLocalName();
                    RepositoryService.this.getRepositoryLibrary().removeSource(sourceName);
                    continue;
                }
                Path sourcePath = changedNodeIsPotentiallySource ? changedPath : changedPath.subpath(0, configPath.size() + 1);
                SimpleProblems problems = new SimpleProblems();
                Graph graph = Graph.create(RepositoryService.this.getConfigurationSourceName(), RepositoryService.this.getRepositoryLibrary(), RepositoryService.this.getExecutionEnvironment());
                try {
                    Subgraph subgraph;
                    RepositorySource source;
                    String workspaceName = RepositoryService.this.getConfigurationWorkspaceName();
                    if (workspaceName != null) {
                        graph.useWorkspace(workspaceName);
                    }
                    if ((source = RepositoryService.this.createRepositorySource(subgraph = graph.getSubgraphOfDepth(Integer.MAX_VALUE).at(sourcePath), Location.create(sourcePath), problems)) == null) continue;
                    RepositoryService.this.getRepositoryLibrary().addSource(source, true);
                }
                catch (PathNotFoundException e) {
                    String sourceName = changedPath.getLastSegment().getName().getLocalName();
                    RepositoryService.this.getRepositoryLibrary().removeSource(sourceName);
                }
            }
        }
    }

    protected static class GarbageCollectedSource {
        protected final RepositorySource source;
        private int passesRemaining = 10;

        protected GarbageCollectedSource(RepositorySource source) {
            this.source = source;
        }

        protected void recordPass() {
            --this.passesRemaining;
        }

        protected boolean hasPassesRemaining() {
            return this.passesRemaining > 0;
        }
    }

    protected class Administrator
    extends AbstractServiceAdministrator {
        protected Administrator() {
            super(RepositoryI18n.repositoryServiceName, ServiceAdministrator.State.PAUSED);
        }

        @Override
        protected boolean doCheckIsTerminated() {
            return true;
        }

        @Override
        protected void doStart(ServiceAdministrator.State fromState) {
            super.doStart(fromState);
            RepositoryService.this.startService();
        }

        @Override
        protected void doShutdown(ServiceAdministrator.State fromState) {
            super.doShutdown(fromState);
            RepositoryService.this.shutdownService();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }
    }
}

