/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.sequencer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.component.ClassLoaderFactory;
import org.modeshape.common.component.ComponentLibrary;
import org.modeshape.common.component.StandardClassLoaderFactory;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Node;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.observe.ChangeObserver;
import org.modeshape.graph.observe.NetChangeObserver;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.repository.RepositoryI18n;
import org.modeshape.repository.RepositoryLibrary;
import org.modeshape.repository.sequencer.Sequencer;
import org.modeshape.repository.sequencer.SequencerConfig;
import org.modeshape.repository.sequencer.SequencerContext;
import org.modeshape.repository.sequencer.SequencerException;
import org.modeshape.repository.sequencer.SequencerLibrary;
import org.modeshape.repository.sequencer.SequencerPathExpression;
import org.modeshape.repository.service.AbstractServiceAdministrator;
import org.modeshape.repository.service.AdministeredService;
import org.modeshape.repository.service.ServiceAdministrator;
import org.modeshape.repository.util.RepositoryNodePath;

public class SequencingService
implements AdministeredService {
    public static final Selector DEFAULT_SEQUENCER_SELECTOR = new DefaultSelector();
    protected static final ClassLoaderFactory DEFAULT_CLASSLOADER_FACTORY = new StandardClassLoaderFactory(SequencingService.class.getClassLoader());
    private ExecutionContext executionContext;
    private SequencerLibrary sequencerLibrary = new SequencerLibrary();
    private List<Sequencer> sequencersList = new ArrayList<Sequencer>();
    private Selector sequencerSelector = DEFAULT_SEQUENCER_SELECTOR;
    private ExecutorService executorService;
    private RepositoryLibrary repositoryLibrary;
    private ChangeObserver repositoryObserver;
    private final Statistics statistics = new Statistics();
    private final Administrator administrator = new Administrator();

    public SequencingService() {
        this.sequencerLibrary.setClassLoaderFactory(DEFAULT_CLASSLOADER_FACTORY);
    }

    @Override
    public ServiceAdministrator getAdministrator() {
        return this.administrator;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    protected ComponentLibrary<Sequencer, SequencerConfig> getSequencerLibrary() {
        return this.sequencerLibrary;
    }

    public boolean addSequencer(SequencerConfig config) {
        return this.sequencerLibrary.add(config);
    }

    public List<SequencerConfig> getSequencers() {
        return this.sequencerLibrary.getSequenceConfigs();
    }

    public boolean updateSequencer(SequencerConfig config) {
        return this.sequencerLibrary.update(config);
    }

    public boolean removeSequencer(SequencerConfig config) {
        return this.sequencerLibrary.remove(config);
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        CheckArg.isNotNull(executionContext, "execution context");
        if (this.getAdministrator().isStarted()) {
            throw new IllegalStateException(RepositoryI18n.unableToChangeExecutionContextWhileRunning.text(new Object[0]));
        }
        this.executionContext = executionContext;
        this.sequencerLibrary.setClassLoaderFactory(executionContext);
    }

    public RepositoryLibrary getRepositoryLibrary() {
        return this.repositoryLibrary;
    }

    public void setRepositoryLibrary(RepositoryLibrary repositoryLibrary) {
        this.repositoryLibrary = repositoryLibrary;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        CheckArg.isNotNull(executorService, "executor service");
        if (this.getAdministrator().isStarted()) {
            throw new IllegalStateException(RepositoryI18n.unableToChangeExecutionContextWhileRunning.text(new Object[0]));
        }
        this.executorService = executorService;
    }

    protected ExecutorService createDefaultExecutorService() {
        return Executors.newSingleThreadExecutor(new NamedThreadFactory("sequencing"));
    }

    protected void startService() {
        if (this.getExecutionContext() == null) {
            throw new IllegalStateException(RepositoryI18n.unableToStartSequencingServiceWithoutExecutionContext.text(new Object[0]));
        }
        if (this.executorService == null) {
            this.executorService = this.createDefaultExecutorService();
        }
        assert (this.executorService != null);
        assert (this.sequencerSelector != null);
        assert (this.sequencerLibrary != null);
        assert (this.repositoryLibrary != null);
        this.repositoryObserver = new RepositoryObserver();
        this.repositoryLibrary.register(this.repositoryObserver);
    }

    protected void shutdownService() {
        if (this.repositoryObserver != null) {
            this.repositoryObserver.unregister();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    protected boolean isServiceTerminated() {
        if (this.executorService != null) {
            return this.executorService.isTerminated();
        }
        return true;
    }

    protected boolean doAwaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.executorService == null || this.executorService.isTerminated()) {
            return true;
        }
        return this.executorService.awaitTermination(timeout, unit);
    }

    public Selector getSequencerSelector() {
        return this.sequencerSelector;
    }

    public void setSequencerSelector(Selector sequencerSelector) {
        this.sequencerSelector = sequencerSelector != null ? sequencerSelector : DEFAULT_SEQUENCER_SELECTOR;
    }

    protected void processChange(NetChangeObserver.NetChanges changes) {
        ExecutionContext context = this.getExecutionContext();
        Logger logger = context.getLogger(this.getClass());
        assert (logger != null);
        try {
            List allSequencers = null;
            String repositorySourceName = changes.getSourceName();
            for (NetChangeObserver.NetChange change : changes.getNetChanges()) {
                Object propertyName;
                if (!change.includes(NetChangeObserver.ChangeType.NODE_ADDED, NetChangeObserver.ChangeType.PROPERTY_ADDED, NetChangeObserver.ChangeType.PROPERTY_CHANGED)) continue;
                String repositoryWorkspaceName = change.getRepositoryWorkspaceName();
                Path nodePath = change.getPath();
                String nodePathStr = context.getValueFactories().getStringFactory().create(nodePath);
                SequencerCalls sequencerCalls = new SequencerCalls();
                if (allSequencers == null) {
                    allSequencers = this.sequencerLibrary.getInstances();
                }
                List<Sequencer> sequencers = new LinkedList<Sequencer>();
                for (Sequencer sequencer : allSequencers) {
                    SequencerConfig config = (SequencerConfig)sequencer.getConfiguration();
                    block6: for (SequencerPathExpression pathExpression : config.getPathExpressions()) {
                        for (Property property : change.getAddedOrModifiedProperties()) {
                            propertyName = property.getName();
                            String propertyNameStr = context.getValueFactories().getStringFactory().create((Name)propertyName);
                            String path = repositorySourceName + ":" + repositoryWorkspaceName + ":" + nodePathStr + "/@" + propertyNameStr;
                            SequencerPathExpression.Matcher matcher = pathExpression.matcher(path);
                            if (!matcher.matches()) continue;
                            RepositoryNodePath outputPath = RepositoryNodePath.parse(matcher.getOutputPath(), matcher.getOutputRepositoryName(), matcher.getOutputWorkspaceName());
                            SequencerCall call = new SequencerCall(sequencer, propertyNameStr);
                            sequencerCalls.record(call, outputPath);
                            sequencers.add(sequencer);
                            continue block6;
                        }
                    }
                }
                RepositorySource source = this.repositoryLibrary.getSource(repositorySourceName);
                Graph sourceGraph = Graph.create(source, context);
                Node node = null;
                if (!sequencers.isEmpty()) {
                    node = sourceGraph.getNodeAt(nodePath);
                    sequencers = this.sequencerSelector.selectSequencers(sequencers, node, change);
                }
                if (sequencers.isEmpty()) {
                    this.statistics.recordNodeSkipped();
                    if (!logger.isDebugEnabled()) continue;
                    logger.trace("Skipping '{0}': no sequencers matched this condition", change);
                    continue;
                }
                for (SequencerCall sequencerCall : sequencerCalls) {
                    Sequencer sequencer = sequencerCall.getSequencer();
                    String sequencerName = ((SequencerConfig)sequencer.getConfiguration()).getName();
                    propertyName = sequencerCall.getSequencedPropertyName();
                    Map<String, Set<RepositoryNodePath>> outputPathsBySourceName = sequencerCalls.getOutputPathsFor(sequencerCall);
                    assert (!outputPathsBySourceName.isEmpty());
                    for (Map.Entry<String, Set<RepositoryNodePath>> outputEntry : outputPathsBySourceName.entrySet()) {
                        String sourceName = outputEntry.getKey();
                        Set<RepositoryNodePath> outputPathsInSource = outputEntry.getValue();
                        RepositorySource outputSource = this.repositoryLibrary.getSource(sourceName);
                        Graph outputGraph = Graph.create(outputSource, context);
                        SimpleProblems problems = new SimpleProblems();
                        SequencerContext sequencerContext = new SequencerContext(context, sourceGraph, outputGraph, changes.getTimestamp());
                        try {
                            sequencer.execute(node, (String)propertyName, change, outputPathsInSource, sequencerContext, problems);
                            sequencerContext.getDestination().submit();
                        }
                        catch (SequencerException e) {
                            logger.error(e, RepositoryI18n.errorWhileSequencingNode, sequencerName, change);
                        }
                    }
                }
                this.statistics.recordNodeSequenced();
            }
        }
        catch (Throwable e) {
            logger.error(e, RepositoryI18n.errorFindingSequencersToRunAgainstNode, changes);
        }
    }

    public void setSequencersList(List<Sequencer> sequencersList) {
        this.sequencersList = sequencersList;
    }

    public List<Sequencer> getSequencersList() {
        return this.sequencersList;
    }

    protected class SequencerCalls
    implements Iterable<SequencerCall> {
        private final Map<SequencerCall, Map<String, Set<RepositoryNodePath>>> sequencerCalls = new HashMap<SequencerCall, Map<String, Set<RepositoryNodePath>>>();

        protected SequencerCalls() {
        }

        protected void record(SequencerCall call, RepositoryNodePath outputPath) {
            Set<RepositoryNodePath> outputPaths;
            assert (outputPath != null);
            String sourceName = outputPath.getRepositorySourceName();
            assert (sourceName != null);
            Map<String, Set<RepositoryNodePath>> outputPathsBySourceName = this.sequencerCalls.get(call);
            if (outputPathsBySourceName == null) {
                outputPathsBySourceName = new HashMap<String, Set<RepositoryNodePath>>();
                this.sequencerCalls.put(call, outputPathsBySourceName);
            }
            if ((outputPaths = outputPathsBySourceName.get(sourceName)) == null) {
                outputPaths = new HashSet<RepositoryNodePath>();
                outputPathsBySourceName.put(sourceName, outputPaths);
            }
            outputPaths.add(outputPath);
        }

        protected Iterable<SequencerCall> getCalls() {
            return this.sequencerCalls.keySet();
        }

        @Override
        public Iterator<SequencerCall> iterator() {
            return this.sequencerCalls.keySet().iterator();
        }

        protected Map<String, Set<RepositoryNodePath>> getOutputPathsFor(SequencerCall call) {
            return this.sequencerCalls.get(call);
        }

        public String toString() {
            return this.sequencerCalls.toString();
        }
    }

    protected class RepositoryObserver
    extends NetChangeObserver {
        protected RepositoryObserver() {
        }

        @Override
        protected void notify(final NetChangeObserver.NetChanges netChanges) {
            try {
                SequencingService.this.getExecutorService().execute(new Runnable(){

                    @Override
                    public void run() {
                        SequencingService.this.processChange(netChanges);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    @Immutable
    protected class SequencerCall {
        private final Sequencer sequencer;
        private final String sequencerName;
        private final String sequencedPropertyName;
        private final int hc;

        protected SequencerCall(Sequencer sequencer, String sequencedPropertyName) {
            this.sequencer = sequencer;
            this.sequencerName = ((SequencerConfig)sequencer.getConfiguration()).getName();
            this.sequencedPropertyName = sequencedPropertyName;
            this.hc = HashCode.compute(this.sequencerName, this.sequencedPropertyName);
        }

        public Sequencer getSequencer() {
            return this.sequencer;
        }

        public String getSequencedPropertyName() {
            return this.sequencedPropertyName;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SequencerCall) {
                SequencerCall that = (SequencerCall)obj;
                if (!this.sequencerName.equals(that.sequencerName)) {
                    return false;
                }
                return this.sequencedPropertyName.equals(that.sequencedPropertyName);
            }
            return false;
        }

        public String toString() {
            return this.sequencerName + " (" + this.sequencedPropertyName;
        }
    }

    @ThreadSafe
    public class Statistics {
        private final AtomicLong numberOfNodesSequenced = new AtomicLong(0L);
        private final AtomicLong numberOfNodesSkipped = new AtomicLong(0L);
        private final AtomicLong startTime = new AtomicLong(System.currentTimeMillis());

        protected Statistics() {
        }

        public Statistics reset() {
            this.startTime.set(System.currentTimeMillis());
            this.numberOfNodesSequenced.set(0L);
            this.numberOfNodesSkipped.set(0L);
            return this;
        }

        public long getStartTime() {
            return this.startTime.get();
        }

        public long getNumberOfNodesSequenced() {
            return this.numberOfNodesSequenced.get();
        }

        public long getNumberOfNodesSkipped() {
            return this.numberOfNodesSkipped.get();
        }

        protected void recordNodeSequenced() {
            this.numberOfNodesSequenced.incrementAndGet();
        }

        protected void recordNodeSkipped() {
            this.numberOfNodesSkipped.incrementAndGet();
        }
    }

    protected class Administrator
    extends AbstractServiceAdministrator {
        protected Administrator() {
            super(RepositoryI18n.sequencingServiceName, ServiceAdministrator.State.PAUSED);
        }

        @Override
        protected void doStart(ServiceAdministrator.State fromState) {
            super.doStart(fromState);
            SequencingService.this.startService();
        }

        @Override
        protected void doShutdown(ServiceAdministrator.State fromState) {
            super.doShutdown(fromState);
            SequencingService.this.shutdownService();
        }

        @Override
        protected boolean doCheckIsTerminated() {
            return SequencingService.this.isServiceTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return SequencingService.this.doAwaitTermination(timeout, unit);
        }
    }

    protected static class DefaultSelector
    implements Selector {
        protected DefaultSelector() {
        }

        @Override
        public List<Sequencer> selectSequencers(List<Sequencer> sequencers, Node node, NetChangeObserver.NetChange nodeChange) {
            return sequencers;
        }
    }

    public static interface Selector {
        public List<Sequencer> selectSequencers(List<Sequencer> var1, Node var2, NetChangeObserver.NetChange var3);
    }
}

