/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.br;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.br.BrazilianStemFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrazilianAnalyzer
extends StopwordAnalyzerBase {
    @Deprecated
    public static final String[] BRAZILIAN_STOP_WORDS = new String[]{"a", "ainda", "alem", "ambas", "ambos", "antes", "ao", "aonde", "aos", "apos", "aquele", "aqueles", "as", "assim", "com", "como", "contra", "contudo", "cuja", "cujas", "cujo", "cujos", "da", "das", "de", "dela", "dele", "deles", "demais", "depois", "desde", "desta", "deste", "dispoe", "dispoem", "diversa", "diversas", "diversos", "do", "dos", "durante", "e", "ela", "elas", "ele", "eles", "em", "entao", "entre", "essa", "essas", "esse", "esses", "esta", "estas", "este", "estes", "ha", "isso", "isto", "logo", "mais", "mas", "mediante", "menos", "mesma", "mesmas", "mesmo", "mesmos", "na", "nas", "nao", "nas", "nem", "nesse", "neste", "nos", "o", "os", "ou", "outra", "outras", "outro", "outros", "pelas", "pelas", "pelo", "pelos", "perante", "pois", "por", "porque", "portanto", "proprio", "propios", "quais", "qual", "qualquer", "quando", "quanto", "que", "quem", "quer", "se", "seja", "sem", "sendo", "seu", "seus", "sob", "sobre", "sua", "suas", "tal", "tambem", "teu", "teus", "toda", "todas", "todo", "todos", "tua", "tuas", "tudo", "um", "uma", "umas", "uns"};
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private Set<?> excltable = Collections.emptySet();

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public BrazilianAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public BrazilianAnalyzer(Version matchVersion, Set<?> stopwords) {
        super(matchVersion, stopwords);
    }

    public BrazilianAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclusionSet) {
        this(matchVersion, stopwords);
        this.excltable = CharArraySet.unmodifiableSet(CharArraySet.copy(matchVersion, stemExclusionSet));
    }

    @Deprecated
    public BrazilianAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet(matchVersion, stopwords));
    }

    @Deprecated
    public BrazilianAnalyzer(Version matchVersion, Map<?, ?> stopwords) {
        this(matchVersion, stopwords.keySet());
    }

    @Deprecated
    public BrazilianAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet(stopwords));
    }

    @Deprecated
    public void setStemExclusionTable(String ... exclusionlist) {
        this.excltable = StopFilter.makeStopSet(this.matchVersion, exclusionlist);
        this.setPreviousTokenStream(null);
    }

    @Deprecated
    public void setStemExclusionTable(Map<?, ?> exclusionlist) {
        this.excltable = new HashSet(exclusionlist.keySet());
        this.setPreviousTokenStream(null);
    }

    @Deprecated
    public void setStemExclusionTable(File exclusionlist) throws IOException {
        this.excltable = WordlistLoader.getWordSet(exclusionlist);
        this.setPreviousTokenStream(null);
    }

    @Override
    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        StandardTokenizer source = new StandardTokenizer(this.matchVersion, reader);
        TokenFilter result = new LowerCaseFilter(this.matchVersion, source);
        result = new StandardFilter(this.matchVersion, result);
        result = new StopFilter(this.matchVersion, (TokenStream)result, this.stopwords);
        if (this.excltable != null && !this.excltable.isEmpty()) {
            result = new KeywordMarkerFilter((TokenStream)result, this.excltable);
        }
        return new ReusableAnalyzerBase.TokenStreamComponents(source, new BrazilianStemFilter(result));
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = CharArraySet.unmodifiableSet(new CharArraySet(Version.LUCENE_CURRENT, WordlistLoader.getWordSet(BrazilianAnalyzer.class, BrazilianAnalyzer.DEFAULT_STOPWORD_FILE, "#"), false));
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

