/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.basic.BasicSingleValueProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class LocationWithProperties
extends Location {
    private static final long serialVersionUID = 1L;
    private final List<Property> idProperties;
    private final int hashCode;

    LocationWithProperties(List<Property> idProperties) {
        assert (idProperties != null);
        assert (!idProperties.isEmpty());
        this.idProperties = Collections.unmodifiableList(idProperties);
        this.hashCode = HashCode.compute(idProperties);
    }

    @Override
    public final Path getPath() {
        return null;
    }

    @Override
    public final boolean hasPath() {
        return false;
    }

    @Override
    public final List<Property> getIdProperties() {
        return this.idProperties;
    }

    @Override
    public final boolean hasIdProperties() {
        return this.idProperties.size() > 0;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Location with(Property newIdProperty) {
        if (newIdProperty == null || newIdProperty.isEmpty()) {
            return this;
        }
        assert (this.hasIdProperties());
        ArrayList<Property> newIdProperties = new ArrayList<Property>(this.idProperties.size() + 1);
        for (Property property : this.idProperties) {
            if (newIdProperty.getName().equals(property.getName())) continue;
            newIdProperties.add(property);
        }
        newIdProperties.add(newIdProperty);
        newIdProperties = Collections.unmodifiableList(newIdProperties);
        return LocationWithProperties.create(newIdProperties);
    }

    @Override
    public Location with(Path newPath) {
        if (newPath == null) {
            return this;
        }
        return LocationWithProperties.create(newPath, this.idProperties);
    }

    @Override
    public Location with(UUID uuid) {
        Property existing;
        if (uuid == null) {
            return this;
        }
        BasicSingleValueProperty newProperty = new BasicSingleValueProperty(ModeShapeLexicon.UUID, uuid);
        if (this.hasIdProperties() && (existing = this.getIdProperty(ModeShapeLexicon.UUID)) != null && existing.equals(newProperty)) {
            return this;
        }
        ArrayList<Property> newIdProperties = new ArrayList<Property>(this.idProperties.size() + 1);
        newIdProperties.addAll(this.idProperties);
        newIdProperties.add(newProperty);
        return LocationWithProperties.create(newIdProperties);
    }
}

