/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.observe;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.observe.ChangeObserver;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.Observable;
import org.modeshape.graph.observe.Observer;

@ThreadSafe
public class ChangeObservers
implements Observable {
    private final CopyOnWriteArrayList<ObserverReference> observers = new CopyOnWriteArrayList();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public boolean register(Observer observer) {
        if (observer != null && !this.shutdown.get() && this.observers.addIfAbsent(new ObserverReference(observer))) {
            if (observer instanceof ChangeObserver) {
                ((ChangeObserver)observer).registeredWith(this);
            }
            return true;
        }
        return false;
    }

    public boolean unregister(Observer observer) {
        if (observer != null && this.observers.remove(observer)) {
            if (observer instanceof ChangeObserver) {
                ((ChangeObserver)observer).unregisteredWith(this);
            }
            return true;
        }
        return false;
    }

    public void shutdown() {
        this.shutdown.set(true);
        while (!this.observers.isEmpty()) {
            Iterator<ObserverReference> iter = this.observers.iterator();
            this.observers.clear();
            while (iter.hasNext()) {
                Observer observer;
                ObserverReference reference = iter.next();
                if (reference.get() == null || !((observer = (Observer)reference.get()) instanceof ChangeObserver)) continue;
                ((ChangeObserver)observer).unregisteredWith(this);
            }
        }
    }

    public boolean isEmpty() {
        return this.observers.isEmpty();
    }

    public void broadcast(Changes changes) {
        CheckArg.isNotNull(changes, "changes");
        for (ObserverReference observerReference : this.observers) {
            Observer observer = (Observer)observerReference.get();
            if (observer == null) {
                this.observers.remove(observerReference);
                continue;
            }
            try {
                observer.notify(changes);
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass()).debug(t, "Exception while notifying", new Object[0]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ObserverReference
    extends WeakReference<Observer> {
        final int hc;

        protected ObserverReference(Observer source) {
            super(source);
            this.hc = source.hashCode();
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ObserverReference) {
                Observer thatSource;
                ObserverReference that = (ObserverReference)obj;
                Observer thisSource = (Observer)this.get();
                return thisSource == (thatSource = (Observer)that.get());
            }
            if (obj instanceof Observer) {
                Observer that = (Observer)obj;
                return this.get() == that;
            }
            return false;
        }
    }
}

