/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

@Immutable
public class And
implements Constraint {
    private static final long serialVersionUID = 1L;
    private final Constraint left;
    private final Constraint right;
    private final int hc;

    public And(Constraint left, Constraint right) {
        CheckArg.isNotNull(left, "left");
        CheckArg.isNotNull(right, "right");
        this.left = left;
        this.right = right;
        this.hc = HashCode.compute(this.left, this.right);
    }

    public Constraint left() {
        return this.left;
    }

    public Constraint right() {
        return this.right;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof And) {
            And that = (And)obj;
            if (this.hc != that.hc) {
                return false;
            }
            return this.left.equals(that.left) && this.right.equals(that.right);
        }
        return false;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

