/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import org.modeshape.graph.property.Name;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNode;
import org.modeshape.jcr.JcrVersionHistoryNode;

class JcrVersionNode
extends JcrNode
implements Version {
    private static final Version[] EMPTY_VERSION_ARRAY = new Version[0];

    JcrVersionNode(AbstractJcrNode node) {
        super(node.cache, node.nodeId, node.location);
        assert (!node.isRoot()) : "Versions should always be located in the /jcr:system/jcr:versionStorage subgraph";
    }

    public JcrVersionHistoryNode getContainingHistory() throws RepositoryException {
        return new JcrVersionHistoryNode(this.getParent());
    }

    public Calendar getCreated() throws RepositoryException {
        return this.getProperty(JcrLexicon.CREATED).getDate();
    }

    public AbstractJcrNode getFrozenNode() throws RepositoryException {
        return this.getNode(JcrLexicon.FROZEN_NODE);
    }

    public Version[] getPredecessors() throws RepositoryException {
        return this.getNodesForProperty(JcrLexicon.PREDECESSORS);
    }

    public Version[] getSuccessors() throws RepositoryException {
        return this.getNodesForProperty(JcrLexicon.SUCCESSORS);
    }

    private final Version[] getNodesForProperty(Name propertyName) throws RepositoryException {
        assert (JcrLexicon.SUCCESSORS.equals(propertyName) || JcrLexicon.PREDECESSORS.equals(propertyName));
        AbstractJcrProperty references = this.getProperty(propertyName);
        if (references == null) {
            return EMPTY_VERSION_ARRAY;
        }
        Value[] values = references.getValues();
        ArrayList<JcrVersionNode> versions = new ArrayList<JcrVersionNode>(values.length);
        for (int i = 0; i < values.length; ++i) {
            String uuid = values[i].getString();
            AbstractJcrNode node = this.session().getNodeByUUID(uuid);
            versions.add((JcrVersionNode)node);
        }
        return versions.toArray(EMPTY_VERSION_ARRAY);
    }

    private final JcrVersionNode getFirstNodeForProperty(Name propertyName) throws RepositoryException {
        assert (JcrLexicon.SUCCESSORS.equals(propertyName) || JcrLexicon.PREDECESSORS.equals(propertyName));
        AbstractJcrProperty references = this.getProperty(propertyName);
        if (references == null) {
            return null;
        }
        Value[] values = references.getValues();
        if (values.length == 0) {
            return null;
        }
        String uuid = values[0].getString();
        AbstractJcrNode node = this.session().getNodeByUUID(uuid);
        return (JcrVersionNode)node;
    }

    boolean isSuccessorOf(JcrVersionNode other) throws RepositoryException {
        if (!other.hasProperty(JcrLexicon.SUCCESSORS)) {
            return false;
        }
        Value[] successors = other.getProperty(JcrLexicon.SUCCESSORS).getValues();
        String uuidString = this.uuid().toString();
        for (int i = 0; i < successors.length; ++i) {
            if (!uuidString.equals(successors[i].getString())) continue;
            return true;
        }
        return false;
    }

    public JcrVersionNode getLinearPredecessor() throws RepositoryException {
        return this.getFirstNodeForProperty(JcrLexicon.PREDECESSORS);
    }

    public JcrVersionNode getLinearSuccessor() throws RepositoryException {
        return this.getFirstNodeForProperty(JcrLexicon.SUCCESSORS);
    }
}

