/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.lang.ref.SoftReference;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.graph.session.InvalidStateException;
import org.modeshape.graph.session.ValidationException;
import org.modeshape.jcr.AbstractJcrItem;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrItemDefinition;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrMultiValueProperty;
import org.modeshape.jcr.JcrNode;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrRootNode;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSharedNode;
import org.modeshape.jcr.JcrSingleValueProperty;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrVersionHistoryNode;
import org.modeshape.jcr.JcrVersionNode;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.ModeShapeIntLexicon;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.PropertyDefinitionId;
import org.modeshape.jcr.PropertyTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
class SessionCache {
    protected static final boolean INCLUDE_PROPERTIES_NOT_ALLOWED_BY_NODE_TYPE_OR_MIXINS = true;
    protected static final Set<Name> EMPTY_NAMES = Collections.emptySet();
    private final JcrSession session;
    private final String workspaceName;
    protected final ExecutionContext context;
    protected final ValueFactories factories;
    protected final PathFactory pathFactory;
    protected final NameFactory nameFactory;
    protected final ValueFactory<String> stringFactory;
    protected final NamespaceRegistry namespaces;
    protected final PropertyFactory propertyFactory;
    private final Graph store;
    protected final Name defaultPrimaryTypeName;
    protected final Property defaultPrimaryTypeProperty;
    protected final Path rootPath;
    protected final Name residualName;
    private final CustomGraphSession graphSession;

    public SessionCache(JcrSession session) {
        this(session, session.workspace().getName(), session.getExecutionContext(), session.nodeTypeManager(), session.graph());
    }

    public SessionCache(JcrSession session, String workspaceName, ExecutionContext context, JcrNodeTypeManager nodeTypes, Graph store) {
        assert (session != null);
        assert (workspaceName != null);
        assert (context != null);
        assert (store != null);
        this.session = session;
        this.workspaceName = workspaceName;
        this.store = store;
        this.context = context;
        this.factories = context.getValueFactories();
        this.pathFactory = this.factories.getPathFactory();
        this.nameFactory = this.factories.getNameFactory();
        this.stringFactory = context.getValueFactories().getStringFactory();
        this.namespaces = context.getNamespaceRegistry();
        this.propertyFactory = context.getPropertyFactory();
        this.defaultPrimaryTypeName = JcrNtLexicon.UNSTRUCTURED;
        this.defaultPrimaryTypeProperty = this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, this.defaultPrimaryTypeName);
        this.rootPath = this.pathFactory.createRootPath();
        this.residualName = (Name)this.nameFactory.create("*");
        this.graphSession = new CustomGraphSession(this.store, this.workspaceName, new JcrNodeOperations(), new JcrAuthorizer());
        try {
            int depth = Integer.parseInt(session.repository().getOptions().get((Object)JcrRepository.Option.READ_DEPTH));
            if (depth > 0) {
                this.graphSession.setDepthForLoadingNodes(depth);
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    final GraphSession<JcrNodePayload, JcrPropertyPayload> graphSession() {
        return this.graphSession;
    }

    Graph.Batch currentBatch() {
        return this.graphSession.operations();
    }

    JcrSession session() {
        return this.session;
    }

    String workspaceName() {
        return this.workspaceName;
    }

    String sourceName() {
        return this.store.getSourceName();
    }

    ExecutionContext context() {
        return this.context;
    }

    ValueFactories factories() {
        return this.factories;
    }

    PathFactory pathFactory() {
        return this.pathFactory;
    }

    NameFactory nameFactory() {
        return this.nameFactory;
    }

    UuidFactory uuidFactory() {
        return this.factories.getUuidFactory();
    }

    ValueFactory<String> stringFactory() {
        return this.factories.getStringFactory();
    }

    JcrNodeTypeManager nodeTypes() {
        return this.session.nodeTypeManager();
    }

    final String readable(Name name) {
        return name.getString(this.namespaces);
    }

    final String readable(Path.Segment segment) {
        return segment.getString(this.namespaces);
    }

    final String readable(Path path) {
        return path.getString(this.namespaces);
    }

    final String readable(Location location) {
        return location.getString(this.namespaces);
    }

    final String readable(Value value) throws RepositoryException {
        return value.getString();
    }

    final String readable(Value[] values) throws RepositoryException {
        StringBuilder sb = new StringBuilder(91);
        boolean first = true;
        for (Value value : values) {
            if (first) {
                first = false;
            }
            sb.append(',');
            sb.append(value.getString());
        }
        return sb.toString();
    }

    final String readable(Iterable<Name> names) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        for (Name name : names) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(name.getString(this.namespaces));
        }
        sb.append(']');
        return sb.toString();
    }

    boolean hasPendingChanges() {
        return this.graphSession.hasPendingChanges();
    }

    public void refresh(boolean keepChanges) {
        this.graphSession.refresh(keepChanges);
    }

    public void refresh(GraphSession.NodeId nodeId, Path absolutePath, boolean keepChanges) throws InvalidItemStateException, RepositoryException {
        assert (nodeId != null);
        try {
            GraphSession.Node node = this.graphSession.findNodeWith(nodeId, absolutePath);
            this.graphSession.refresh(node, keepChanges);
        }
        catch (InvalidStateException e) {
            throw new InvalidItemStateException(e.getLocalizedMessage());
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new InvalidItemStateException(e.getLocalizedMessage());
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getLocalizedMessage());
        }
    }

    public void refresh(Path absolutePath, boolean keepChanges) throws InvalidItemStateException, RepositoryException {
        try {
            this.graphSession.refresh(absolutePath, keepChanges);
        }
        catch (InvalidStateException e) {
            throw new InvalidItemStateException(e.getLocalizedMessage());
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new InvalidItemStateException(e.getLocalizedMessage());
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getLocalizedMessage());
        }
    }

    public void refreshProperties(Location location) throws InvalidItemStateException, RepositoryException {
        assert (location != null);
        try {
            GraphSession.Node node = this.graphSession.findNodeWith(location);
            this.graphSession.refreshProperties(node);
        }
        catch (InvalidStateException e) {
            throw new InvalidItemStateException(e.getLocalizedMessage());
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new InvalidItemStateException(e.getLocalizedMessage());
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getLocalizedMessage());
        }
    }

    protected JcrNodeDefinition findBestNodeDefinition(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> parent, Name newNodeName, Name newNodePrimaryTypeName) throws ItemExistsException, ConstraintViolationException, RepositoryException {
        assert (parent != null);
        assert (newNodeName != null);
        Name primaryTypeName = parent.getPayload().getPrimaryTypeName();
        List<Name> mixinTypeNames = parent.getPayload().getMixinTypeNames();
        int snsCount = parent.getChildrenCount(newNodeName) + 1;
        JcrNodeDefinition definition = this.nodeTypes().findChildNodeDefinition(primaryTypeName, mixinTypeNames, newNodeName, newNodePrimaryTypeName, snsCount, true);
        if (definition == null) {
            if (snsCount > 1 && (definition = this.nodeTypes().findChildNodeDefinition(primaryTypeName, mixinTypeNames, newNodeName, newNodePrimaryTypeName, 1, true)) != null) {
                throw new ItemExistsException(JcrI18n.noSnsDefinition.text(this.readable(newNodeName), this.readable(parent.getPath()), this.readable(primaryTypeName), this.readable(mixinTypeNames)));
            }
            throw new ConstraintViolationException(JcrI18n.noDefinition.text("child node", this.readable(newNodeName), this.readable(parent.getPath()), this.readable(primaryTypeName), this.readable(mixinTypeNames)));
        }
        return definition;
    }

    public void save() throws ItemNotFoundException, AccessDeniedException, ConstraintViolationException, RepositoryException {
        try {
            this.graphSession.save();
        }
        catch (ValidationException e) {
            throw new ConstraintViolationException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (InvalidStateException e) {
            throw new InvalidItemStateException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public void save(GraphSession.NodeId nodeId, Path absolutePath) throws ItemNotFoundException, AccessDeniedException, ConstraintViolationException, RepositoryException {
        assert (nodeId != null);
        try {
            GraphSession.Node node = this.graphSession.findNodeWith(nodeId, absolutePath);
            assert (node != null);
            this.graphSession.save(node);
        }
        catch (ValidationException e) {
            throw new ConstraintViolationException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (InvalidStateException e) {
            throw new InvalidItemStateException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public GraphSession.Node<JcrNodePayload, JcrPropertyPayload> findNode(GraphSession.NodeId id, Path absolutePath) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        try {
            return this.graphSession.findNodeWith(id, absolutePath);
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public GraphSession.Node<JcrNodePayload, JcrPropertyPayload> findNodeWith(Location location) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        try {
            return this.graphSession.findNodeWith(location);
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public GraphSession.Node<JcrNodePayload, JcrPropertyPayload> findNode(GraphSession.NodeId from, Path fromAbsolutePath, Path relativePath) throws PathNotFoundException, ItemNotFoundException, AccessDeniedException, RepositoryException {
        GraphSession.Node<JcrNodePayload, JcrPropertyPayload> referenceNode = this.findNode(from, fromAbsolutePath);
        try {
            return this.graphSession.findNodeRelativeTo(referenceNode, relativePath);
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new PathNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public JcrRootNode findJcrRootNode() throws RepositoryException {
        return (JcrRootNode)((JcrNodePayload)this.graphSession.getRoot().getPayload()).getJcrNode();
    }

    public AbstractJcrNode findJcrNode(Location location) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        try {
            return ((JcrNodePayload)this.graphSession.findNodeWith(location).getPayload()).getJcrNode();
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public AbstractJcrNode findJcrNode(GraphSession.NodeId id, Path absolutePath) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.findNode(id, absolutePath).getPayload().getJcrNode();
    }

    public AbstractJcrNode findJcrNode(GraphSession.NodeId from, Path fromAbsolutePath, Path relativePath) throws ItemNotFoundException, PathNotFoundException, InvalidItemStateException, AccessDeniedException, RepositoryException {
        GraphSession.Node<JcrNodePayload, JcrPropertyPayload> referenceNode = this.findNode(from, fromAbsolutePath);
        try {
            return this.graphSession.findNodeRelativeTo(referenceNode, relativePath).getPayload().getJcrNode();
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new PathNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public AbstractJcrProperty findJcrProperty(GraphSession.NodeId id, Path absolutePath, Name propertyName) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node = this.findNode(id, absolutePath);
        GraphSession.PropertyInfo<JcrPropertyPayload> propertyInfo = node.getProperty(propertyName);
        if (propertyInfo != null) {
            if (propertyName.equals(JcrLexicon.UUID) && !this.isReferenceable(node)) {
                return null;
            }
            return propertyInfo.getPayload().getJcrProperty();
        }
        return null;
    }

    public Collection<AbstractJcrProperty> findJcrPropertiesFor(GraphSession.NodeId id, Path absolutePath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        try {
            GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node = this.graphSession.findNodeWith(id, absolutePath);
            ArrayList<AbstractJcrProperty> result = new ArrayList<AbstractJcrProperty>(node.getPropertyCount());
            for (GraphSession.PropertyInfo property : node.getProperties()) {
                AbstractJcrProperty prop;
                Name propertyName = property.getName();
                if (propertyName.equals(JcrLexicon.UUID) && !this.isReferenceable(node) || propertyName.getNamespaceUri().equals("http://www.modeshape.org/internal/1.0") || (prop = ((JcrPropertyPayload)property.getPayload()).getJcrProperty()) == null) continue;
                result.add(prop);
            }
            return result;
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new PathNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public AbstractJcrItem findJcrItem(GraphSession.NodeId from, Path fromAbsolutePath, Path relativePath) throws ItemNotFoundException, InvalidItemStateException, RepositoryException {
        Path.Segment lastSegment;
        if (from == null && fromAbsolutePath == null) {
            from = this.graphSession.getRoot().getNodeId();
        }
        if (relativePath.size() == 0) {
            return this.findJcrNode(from, fromAbsolutePath);
        }
        if (relativePath.size() == 1) {
            Path.Segment segment = relativePath.getLastSegment();
            if (segment.isSelfReference()) {
                return this.findJcrNode(from, fromAbsolutePath);
            }
            if (segment.isParentReference()) {
                return this.findJcrNode(from, fromAbsolutePath, relativePath);
            }
        }
        if ((lastSegment = relativePath.getLastSegment()).getIndex() > 1) {
            return this.findJcrNode(from, fromAbsolutePath);
        }
        GraphSession.Node fromNode = null;
        GraphSession.Node parent = null;
        try {
            fromNode = this.graphSession.findNodeWith(from, fromAbsolutePath);
            if (from == null) {
                from = fromNode.getNodeId();
            }
            assert (from != null);
            parent = relativePath.size() == 1 ? fromNode : this.graphSession.findNodeRelativeTo(fromNode, relativePath.getParent());
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
        if (parent.hasChild(lastSegment)) {
            GraphSession.Node child = parent.getChild(lastSegment);
            return ((JcrNodePayload)child.getPayload()).getJcrNode();
        }
        GraphSession.PropertyInfo propertyInfo = parent.getProperty(lastSegment.getName());
        if (propertyInfo != null) {
            return ((JcrPropertyPayload)propertyInfo.getPayload()).getJcrProperty();
        }
        String msg = null;
        if (from.equals(this.graphSession.getRoot().getNodeId())) {
            Path absolutePath = this.rootPath.resolve(relativePath);
            msg = JcrI18n.itemNotFoundAtPath.text(this.readable(absolutePath), this.workspaceName);
        } else {
            Path referenceNodePath = fromNode.getPath();
            msg = JcrI18n.itemNotFoundAtPathRelativeToReferenceNode.text(this.readable(relativePath), this.readable(referenceNodePath), this.workspaceName);
        }
        throw new ItemNotFoundException(msg);
    }

    public final boolean isNodeType(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node, Name nodeType) throws RepositoryException {
        Name primaryTypeName = node.getPayload().getPrimaryTypeName();
        JcrNodeType primaryType = this.nodeTypes().getNodeType(primaryTypeName);
        if (primaryType.isNodeType(nodeType)) {
            return true;
        }
        JcrNodeTypeManager nodeTypes = this.session().nodeTypeManager();
        for (Name mixinTypeName : node.getPayload().getMixinTypeNames()) {
            JcrNodeType mixinType = nodeTypes.getNodeType(mixinTypeName);
            if (mixinType == null || !mixinType.isNodeType(nodeType)) continue;
            return true;
        }
        return false;
    }

    public boolean isReferenceable(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node) throws RepositoryException {
        return this.isNodeType(node, JcrMixLexicon.REFERENCEABLE);
    }

    public boolean isVersionable(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node) throws RepositoryException {
        return this.isNodeType(node, JcrMixLexicon.VERSIONABLE);
    }

    public NodeEditor getEditorFor(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node) {
        return new NodeEditor(node);
    }

    public NodeEditor getEditorFor(GraphSession.NodeId id, Path absolutePath) throws ItemNotFoundException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node = this.graphSession.findNodeWith(id, absolutePath);
        return new NodeEditor(node);
    }

    Path getPathForCorrespondingNode(String workspaceName, UUID uuid, Path relativePath) throws NoSuchWorkspaceException, AccessDeniedException, ItemNotFoundException, RepositoryException {
        assert (workspaceName != null);
        assert (uuid != null || relativePath != null);
        try {
            try {
                this.store.useWorkspace(workspaceName);
            }
            catch (InvalidWorkspaceException iwe) {
                throw new NoSuchWorkspaceException(JcrI18n.workspaceNameIsInvalid.text(this.store.getSourceName(), workspaceName));
            }
            Node node = null;
            if (uuid != null) {
                node = this.store.getNodeAt(uuid);
                if (relativePath != null) {
                    Path nodePath = node.getLocation().getPath();
                    Path absolutePath = relativePath.resolveAgainst(nodePath);
                    node = this.store.getNodeAt(absolutePath);
                }
            } else {
                assert (relativePath != null);
                Path absolutePath = this.pathFactory.createAbsolutePath(relativePath.getSegmentsList());
                node = this.store.getNodeAt(absolutePath);
            }
            assert (node != null);
            Path path = node.getLocation().getPath();
            try {
                this.session().checkPermission(workspaceName, path, "read");
            }
            catch (AccessControlException ace) {
                throw new AccessDeniedException((Throwable)ace);
            }
            Path path2 = path;
            return path2;
        }
        catch (org.modeshape.graph.property.PathNotFoundException pnfe) {
            throw new ItemNotFoundException((Throwable)pnfe);
        }
        finally {
            this.store.useWorkspace(this.workspaceName);
        }
    }

    protected JcrPropertyDefinition findBestPropertyDefintion(Name primaryTypeNameOfParent, List<Name> mixinTypeNamesOfParent, Property dnaProperty, int propertyType, boolean isSingle, boolean skipProtected) {
        JcrPropertyDefinition definition = null;
        if (propertyType == 0) {
            propertyType = PropertyTypeUtil.jcrPropertyTypeFor(dnaProperty);
        }
        if (isSingle) {
            Object value = dnaProperty.getFirstValue();
            JcrValue jcrValue = new JcrValue(this.factories(), this, propertyType, value);
            definition = this.nodeTypes().findPropertyDefinition(primaryTypeNameOfParent, mixinTypeNamesOfParent, dnaProperty.getName(), jcrValue, true, skipProtected);
        } else {
            Value[] jcrValues = new Value[dnaProperty.size()];
            int index = 0;
            for (Object value : dnaProperty) {
                jcrValues[index++] = new JcrValue(this.factories(), this, propertyType, value);
            }
            definition = this.nodeTypes().findPropertyDefinition(primaryTypeNameOfParent, mixinTypeNamesOfParent, dnaProperty.getName(), jcrValues, skipProtected);
        }
        if (definition != null) {
            return definition;
        }
        return null;
    }

    protected final void updateSingleMultipleProperty(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node, Name singleMultiPropertyName, boolean add) {
        GraphSession.PropertyInfo<JcrPropertyPayload> existing = node.getProperty(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES);
        Set<Object> singleMultiPropertyNames = null;
        if (existing != null) {
            singleMultiPropertyNames = new HashSet();
            for (Object value : existing.getProperty()) {
                singleMultiPropertyNames.add(this.nameFactory().create(value));
            }
            if (add) {
                singleMultiPropertyNames.add(singleMultiPropertyName);
            } else {
                singleMultiPropertyNames.remove(singleMultiPropertyName);
            }
        } else if (add) {
            singleMultiPropertyNames = Collections.singleton(singleMultiPropertyName);
        } else {
            return;
        }
        if (singleMultiPropertyNames.isEmpty()) {
            assert (existing != null);
            node.removeProperty(existing.getName());
            return;
        }
        GraphSession.PropertyInfo<JcrPropertyPayload> property = this.createSingleMultipleProperty(node.getPayload(), existing, singleMultiPropertyNames);
        node.setProperty(property.getProperty(), property.isMultiValued(), property.getPayload());
    }

    protected GraphSession.PropertyInfo<JcrPropertyPayload> createSingleMultipleProperty(JcrNodePayload nodePayload, GraphSession.PropertyInfo<JcrPropertyPayload> existing, Set<Name> singleMultiPropertyNames) {
        int number = singleMultiPropertyNames.size();
        String[] names = new String[number];
        Value[] values = new JcrValue[number];
        if (number == 1) {
            String str;
            names[0] = str = singleMultiPropertyNames.iterator().next().getString(this.namespaces);
            values[0] = new JcrValue(this.factories(), this, 1, str);
        } else {
            int index = 0;
            for (Name name : singleMultiPropertyNames) {
                String str;
                names[index] = str = name.getString(this.namespaces);
                values[index] = new JcrValue(this.factories(), this, 1, str);
                ++index;
            }
        }
        JcrPropertyDefinition definition = this.nodeTypes().findPropertyDefinition(nodePayload.getPrimaryTypeName(), nodePayload.getMixinTypeNames(), ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES, values, false);
        Property dnaProp = this.propertyFactory.create(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES, singleMultiPropertyNames.iterator());
        return this.createPropertyInfo(nodePayload, dnaProp, definition, 1, existing);
    }

    protected final GraphSession.PropertyInfo<JcrPropertyPayload> createPropertyInfo(JcrNodePayload nodePayload, Property dnaProp, JcrPropertyDefinition definition, int propertyType, GraphSession.PropertyInfo<JcrPropertyPayload> existing) {
        AbstractJcrProperty jcrProp = null;
        if (existing != null && existing.getPayload() != null) {
            jcrProp = existing.getPayload().getJcrProperty();
        } else {
            AbstractJcrNode jcrNode = nodePayload.getJcrNode();
            jcrProp = definition.isMultiple() ? new JcrMultiValueProperty(this, jcrNode, dnaProp.getName()) : new JcrSingleValueProperty(this, jcrNode, dnaProp.getName());
        }
        assert (jcrProp != null);
        JcrPropertyPayload propPayload = new JcrPropertyPayload(definition.getId(), propertyType, jcrProp);
        GraphSession.Status status = existing != null ? GraphSession.Status.CHANGED : GraphSession.Status.NEW;
        return new GraphSession.PropertyInfo<JcrPropertyPayload>(dnaProp, definition.isMultiple(), status, propPayload);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    static class JcrSharedNodePayload
    extends JcrNodePayload {
        protected SoftReference<AbstractJcrNode> sharedNode;
        protected Location sharedLocation;

        JcrSharedNodePayload(SessionCache cache, GraphSession.Node<JcrNodePayload, JcrPropertyPayload> owner, Name primaryTypeName, List<Name> mixinTypeNames, NodeDefinitionId nodeDefinitionId, AbstractJcrNode sharedNode) {
            super(cache, owner, primaryTypeName, mixinTypeNames, nodeDefinitionId);
            assert (sharedNode != null);
            this.sharedNode = new SoftReference<AbstractJcrNode>(sharedNode);
            this.sharedLocation = sharedNode.location();
        }

        JcrSharedNodePayload(SessionCache cache, GraphSession.Node<JcrNodePayload, JcrPropertyPayload> owner, Name primaryTypeName, List<Name> mixinTypeNames, NodeDefinitionId nodeDefinitionId, SoftReference<AbstractJcrNode> jcrNode, SoftReference<AbstractJcrNode> sharedNode) {
            super(cache, owner, primaryTypeName, mixinTypeNames, nodeDefinitionId, jcrNode);
            assert (this.sharedNode != null);
            this.sharedNode = sharedNode;
        }

        @Override
        public AbstractJcrNode getJcrNode() {
            AbstractJcrNode proxy = super.getJcrNode();
            AbstractJcrNode shared = this.sharedNode.get();
            if (shared == null) {
                UUID uuid = (UUID)this.cache.uuidFactory().create(this.owner.getProperty(ModeShapeLexicon.SHARED_UUID));
                try {
                    AbstractJcrNode node = this.cache.findJcrNode(Location.create(uuid));
                    this.sharedNode = new SoftReference<AbstractJcrNode>(node);
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
            }
            return new JcrSharedNode(proxy, this.sharedNode.get());
        }

        @Override
        public JcrNodePayload with(Name primaryTypeName) {
            return new JcrSharedNodePayload(this.cache, this.owner, primaryTypeName, this.mixinTypeNames, this.nodeDefinitionId, this.jcrNode, this.sharedNode);
        }

        @Override
        public JcrNodePayload with(List<Name> mixinTypeNames) {
            return new JcrSharedNodePayload(this.cache, this.owner, this.primaryTypeName, mixinTypeNames, this.nodeDefinitionId, this.jcrNode, this.sharedNode);
        }

        @Override
        public JcrNodePayload with(NodeDefinitionId nodeDefinitionId) {
            return new JcrSharedNodePayload(this.cache, this.owner, this.primaryTypeName, this.mixinTypeNames, nodeDefinitionId, this.jcrNode, this.sharedNode);
        }

        @Override
        public JcrNodePayload with(AbstractJcrNode jcrNode) {
            return new JcrSharedNodePayload(this.cache, this.owner, this.primaryTypeName, this.mixinTypeNames, this.nodeDefinitionId, new SoftReference<AbstractJcrNode>(jcrNode), null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    static class JcrNodePayload {
        protected final SessionCache cache;
        protected final GraphSession.Node<JcrNodePayload, JcrPropertyPayload> owner;
        protected final Name primaryTypeName;
        protected final List<Name> mixinTypeNames;
        protected final NodeDefinitionId nodeDefinitionId;
        protected SoftReference<AbstractJcrNode> jcrNode;

        JcrNodePayload(SessionCache cache, GraphSession.Node<JcrNodePayload, JcrPropertyPayload> owner, Name primaryTypeName, List<Name> mixinTypeNames, NodeDefinitionId nodeDefinitionId) {
            assert (owner != null);
            assert (cache != null);
            this.cache = cache;
            this.owner = owner;
            this.primaryTypeName = primaryTypeName;
            this.mixinTypeNames = mixinTypeNames;
            this.nodeDefinitionId = nodeDefinitionId;
            this.jcrNode = new SoftReference<Object>(null);
        }

        JcrNodePayload(SessionCache cache, GraphSession.Node<JcrNodePayload, JcrPropertyPayload> owner, Name primaryTypeName, List<Name> mixinTypeNames, NodeDefinitionId nodeDefinitionId, SoftReference<AbstractJcrNode> jcrNode) {
            assert (jcrNode != null);
            assert (owner != null);
            assert (cache != null);
            this.cache = cache;
            this.owner = owner;
            this.primaryTypeName = primaryTypeName;
            this.mixinTypeNames = mixinTypeNames;
            this.nodeDefinitionId = nodeDefinitionId;
            this.jcrNode = jcrNode;
        }

        public Name getPrimaryTypeName() {
            return this.primaryTypeName;
        }

        public List<Name> getMixinTypeNames() {
            return this.mixinTypeNames != null ? this.mixinTypeNames : Collections.emptyList();
        }

        public NodeDefinitionId getDefinitionId() {
            return this.nodeDefinitionId;
        }

        public AbstractJcrNode getJcrNode(boolean loadIfMissing) {
            return loadIfMissing ? this.getJcrNode() : this.jcrNode.get();
        }

        public AbstractJcrNode getJcrNode() {
            AbstractJcrNode node = this.jcrNode.get();
            if (node == null) {
                node = this.owner.isRoot() ? new JcrRootNode(this.cache, this.owner.getNodeId(), this.owner.getLocation()) : new JcrNode(this.cache, this.owner.getNodeId(), this.owner.getLocation());
                this.jcrNode = new SoftReference<AbstractJcrNode>(node);
            }
            if (JcrNtLexicon.VERSION.equals(this.primaryTypeName)) {
                return new JcrVersionNode(this.jcrNode.get());
            }
            if (JcrNtLexicon.VERSION_HISTORY.equals(this.primaryTypeName)) {
                return new JcrVersionHistoryNode(this.jcrNode.get());
            }
            return this.jcrNode.get();
        }

        public JcrNodePayload with(Name primaryTypeName) {
            return new JcrNodePayload(this.cache, this.owner, primaryTypeName, this.mixinTypeNames, this.nodeDefinitionId, this.jcrNode);
        }

        public JcrNodePayload with(List<Name> mixinTypeNames) {
            return new JcrNodePayload(this.cache, this.owner, this.primaryTypeName, mixinTypeNames, this.nodeDefinitionId, this.jcrNode);
        }

        public JcrNodePayload with(NodeDefinitionId nodeDefinitionId) {
            return new JcrNodePayload(this.cache, this.owner, this.primaryTypeName, this.mixinTypeNames, nodeDefinitionId, this.jcrNode);
        }

        public JcrNodePayload with(AbstractJcrNode jcrNode) {
            return new JcrNodePayload(this.cache, this.owner, this.primaryTypeName, this.mixinTypeNames, this.nodeDefinitionId, new SoftReference<AbstractJcrNode>(jcrNode));
        }
    }

    @Immutable
    static final class JcrPropertyPayload {
        private final PropertyDefinitionId propertyDefinitionId;
        private final int jcrPropertyType;
        private final AbstractJcrProperty jcrProperty;

        JcrPropertyPayload(PropertyDefinitionId propertyDefinitionId, int jcrPropertyType, AbstractJcrProperty jcrProperty) {
            assert (jcrProperty != null);
            this.propertyDefinitionId = propertyDefinitionId;
            this.jcrPropertyType = jcrPropertyType;
            this.jcrProperty = jcrProperty;
        }

        public AbstractJcrProperty getJcrProperty() {
            return this.jcrProperty;
        }

        public int getPropertyType() {
            return this.jcrPropertyType;
        }

        public PropertyDefinitionId getPropertyDefinitionId() {
            return this.propertyDefinitionId;
        }

        public JcrPropertyPayload with(PropertyDefinitionId propertyDefinitionId) {
            return new JcrPropertyPayload(propertyDefinitionId, this.jcrPropertyType, this.jcrProperty);
        }

        public JcrPropertyPayload with(int jcrPropertyType) {
            return new JcrPropertyPayload(this.propertyDefinitionId, jcrPropertyType, this.jcrProperty);
        }

        public JcrPropertyPayload with(AbstractJcrProperty jcrProperty) {
            return new JcrPropertyPayload(this.propertyDefinitionId, this.jcrPropertyType, jcrProperty);
        }
    }

    @Immutable
    final class JcrAuthorizer
    implements GraphSession.Authorizer {
        JcrAuthorizer() {
        }

        public void checkPermissions(Path path, GraphSession.Authorizer.Action action) throws AccessControlException {
            String jcrAction = null;
            switch (action) {
                case ADD_NODE: {
                    jcrAction = "add_node";
                    break;
                }
                case READ: {
                    jcrAction = "read";
                    break;
                }
                case REMOVE: {
                    jcrAction = "remove";
                    break;
                }
                case SET_PROPERTY: {
                    jcrAction = "set_property";
                }
            }
            SessionCache.this.session().checkPermission(path, jcrAction);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    final class JcrNodeOperations
    extends GraphSession.NodeOperations<JcrNodePayload, JcrPropertyPayload> {
        private final Logger LOGGER = Logger.getLogger(JcrNodeOperations.class);
        private final String user = SessionCache.this.session().getUserID();

        JcrNodeOperations() {
        }

        private Map<Name, GraphSession.PropertyInfo<JcrPropertyPayload>> buildProperties(Node persistentNode, GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node, JcrNodePayload nodePayload, boolean referenceable) {
            AbstractJcrNode jcrNode = nodePayload.getJcrNode();
            Name primaryTypeName = nodePayload.getPrimaryTypeName();
            List<Name> mixinTypeNames = nodePayload.getMixinTypeNames();
            Location location = persistentNode.getLocation();
            Map<Name, Property> graphProperties = persistentNode.getPropertiesByName();
            if (!graphProperties.containsKey(JcrLexicon.PRIMARY_TYPE)) {
                Property primaryTypeProperty = location.getPath().isRoot() ? SessionCache.this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, primaryTypeName) : SessionCache.this.defaultPrimaryTypeProperty;
                graphProperties = new HashMap<Name, Property>(graphProperties);
                graphProperties.put(primaryTypeProperty.getName(), primaryTypeProperty);
            }
            Set<Name> multiValuedPropertyNames = EMPTY_NAMES;
            HashSet<Name> newSingleMultiPropertyNames = null;
            Property multiValuedPropNamesProp = graphProperties.get(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES);
            if (multiValuedPropNamesProp != null && !multiValuedPropNamesProp.isEmpty()) {
                multiValuedPropertyNames = this.getSingleMultiPropertyNames(multiValuedPropNamesProp, location);
            }
            HashMap<Name, GraphSession.PropertyInfo<JcrPropertyPayload>> props = new HashMap<Name, GraphSession.PropertyInfo<JcrPropertyPayload>>();
            for (Property dnaProp : graphProperties.values()) {
                int definitionType;
                boolean isMultiple;
                int propertyType;
                JcrPropertyDefinition propertyDefinition;
                Name name = dnaProp.getName();
                if (ModeShapeLexicon.UUID.equals(name)) continue;
                boolean isSingle = dnaProp.isSingle();
                if (isSingle && multiValuedPropertyNames.contains(name)) {
                    isSingle = false;
                }
                if ((propertyDefinition = SessionCache.this.findBestPropertyDefintion(primaryTypeName, mixinTypeNames, dnaProp, propertyType = PropertyTypeUtil.jcrPropertyTypeFor(dnaProp), isSingle, false)) == null) {
                    JcrNodeType unstructured = SessionCache.this.nodeTypes().getNodeType(JcrNtLexicon.UNSTRUCTURED);
                    for (PropertyDefinition anyDefinition : unstructured.getDeclaredPropertyDefinitions()) {
                        if (!anyDefinition.isMultiple()) continue;
                        propertyDefinition = anyDefinition;
                        break;
                    }
                }
                if (propertyDefinition == null || !(isMultiple = propertyDefinition.isMultiple()) && dnaProp.isEmpty()) continue;
                if (isMultiple && isSingle) {
                    if (newSingleMultiPropertyNames == null) {
                        newSingleMultiPropertyNames = new HashSet<Name>();
                    }
                    newSingleMultiPropertyNames.add(name);
                }
                if ((definitionType = propertyDefinition.getRequiredType()) != 0) {
                    propertyType = definitionType;
                }
                JcrPropertyDefinition defn = propertyDefinition;
                AbstractJcrProperty jcrProp = null;
                jcrProp = isMultiple ? new JcrMultiValueProperty(SessionCache.this, jcrNode, dnaProp.getName()) : new JcrSingleValueProperty(SessionCache.this, jcrNode, dnaProp.getName());
                JcrPropertyPayload payload = new JcrPropertyPayload(defn.getId(), propertyType, jcrProp);
                GraphSession.PropertyInfo<JcrPropertyPayload> propInfo = new GraphSession.PropertyInfo<JcrPropertyPayload>(dnaProp, defn.isMultiple(), GraphSession.Status.UNCHANGED, payload);
                props.put(name, propInfo);
            }
            if (referenceable) {
                UUID uuid = location.getUuid();
                Property uuidProperty = null;
                if (uuid != null) {
                    uuidProperty = location.getIdProperty(JcrLexicon.UUID);
                    if (uuidProperty == null) {
                        uuidProperty = SessionCache.this.propertyFactory.create(JcrLexicon.UUID, uuid);
                    }
                } else {
                    uuidProperty = location.getIdProperty(JcrLexicon.UUID);
                    if (uuidProperty != null) {
                        uuid = (UUID)SessionCache.this.factories().getUuidFactory().create(uuidProperty.getFirstValue());
                    } else {
                        uuidProperty = graphProperties.get(ModeShapeLexicon.UUID);
                        uuid = (UUID)SessionCache.this.factories().getUuidFactory().create(uuidProperty.getFirstValue());
                        uuidProperty = null;
                    }
                }
                if (uuid != null && uuidProperty == null) {
                    uuidProperty = SessionCache.this.propertyFactory.create(JcrLexicon.UUID, uuid);
                }
                JcrValue value = new JcrValue(SessionCache.this.factories(), SessionCache.this, 1, uuid);
                JcrPropertyDefinition propDefn = SessionCache.this.nodeTypes().findPropertyDefinition(primaryTypeName, mixinTypeNames, JcrLexicon.UUID, value, false, false);
                GraphSession.PropertyInfo<JcrPropertyPayload> propInfo = SessionCache.this.createPropertyInfo(nodePayload, uuidProperty, propDefn, 1, null);
                props.put(JcrLexicon.UUID, propInfo);
            } else {
                props.remove(JcrLexicon.UUID);
            }
            props.remove(ModeShapeLexicon.UUID);
            if (newSingleMultiPropertyNames != null) {
                GraphSession.PropertyInfo<JcrPropertyPayload> info = SessionCache.this.createSingleMultipleProperty(nodePayload, null, newSingleMultiPropertyNames);
                props.put(info.getName(), info);
            }
            return props;
        }

        @Override
        public void materializeProperties(Node persistentNode, GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node) {
            JcrNodePayload nodePayload = node.getPayload();
            boolean referenceable = false;
            try {
                referenceable = SessionCache.this.isReferenceable(node);
            }
            catch (RepositoryException re) {
                throw new IllegalStateException(re);
            }
            Map props = this.buildProperties(persistentNode, node, nodePayload, referenceable);
            node.loadedWith(props);
        }

        @Override
        public void materialize(Node persistentNode, GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node) {
            Property sharedUuidProperty;
            Location location = node.getLocation();
            Map<Name, Property> graphProperties = persistentNode.getPropertiesByName();
            boolean isRoot = location.getPath().isRoot();
            Name primaryTypeName = null;
            Property primaryTypeProperty = graphProperties.get(JcrLexicon.PRIMARY_TYPE);
            if (primaryTypeProperty != null && !primaryTypeProperty.isEmpty()) {
                try {
                    primaryTypeName = (Name)SessionCache.this.factories.getNameFactory().create(primaryTypeProperty.getFirstValue());
                }
                catch (ValueFormatException e) {
                    // empty catch block
                }
            }
            if (primaryTypeName == null) {
                if (isRoot) {
                    primaryTypeName = ModeShapeLexicon.ROOT;
                    primaryTypeProperty = SessionCache.this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, primaryTypeName);
                } else {
                    primaryTypeName = SessionCache.this.defaultPrimaryTypeName;
                    primaryTypeProperty = SessionCache.this.defaultPrimaryTypeProperty;
                }
            }
            assert (primaryTypeProperty != null);
            assert (!primaryTypeProperty.isEmpty());
            boolean isSharedNode = ModeShapeLexicon.SHARE.equals(primaryTypeName);
            UUID sharedUuid = null;
            if (isSharedNode && (sharedUuidProperty = graphProperties.get(ModeShapeLexicon.SHARED_UUID)) != null) {
                sharedUuid = (UUID)SessionCache.this.uuidFactory().create(sharedUuidProperty.getFirstValue());
            }
            JcrNodeDefinition definition = null;
            Property nodeDefnProperty = graphProperties.get(ModeShapeIntLexicon.NODE_DEFINITON);
            if (nodeDefnProperty != null && !nodeDefnProperty.isEmpty()) {
                String nodeDefinitionString = SessionCache.this.stringFactory.create(nodeDefnProperty.getFirstValue());
                NodeDefinitionId id = NodeDefinitionId.fromString(nodeDefinitionString, SessionCache.this.nameFactory);
                definition = SessionCache.this.nodeTypes().getNodeDefinition(id);
            }
            if (definition == null) {
                if (isRoot) {
                    try {
                        definition = SessionCache.this.nodeTypes().getRootNodeDefinition();
                    }
                    catch (RepositoryException e) {
                        throw new ValidationException(e.getMessage(), e);
                    }
                }
                Name primaryTypeForDefn = primaryTypeName;
                if (isSharedNode) {
                    try {
                        AbstractJcrNode originalShareable = SessionCache.this.findJcrNode(Location.create(sharedUuid));
                        primaryTypeForDefn = originalShareable.getPrimaryTypeName();
                    }
                    catch (RepositoryException e) {
                        // empty catch block
                    }
                }
                Name childName = node.getName();
                GraphSession.Node<JcrNodePayload, JcrPropertyPayload> parent = node.getParent();
                JcrNodePayload parentInfo = parent.getPayload();
                int numExistingChildrenWithSameName = parent.getChildrenCount(childName);
                definition = SessionCache.this.nodeTypes().findChildNodeDefinition(parentInfo.getPrimaryTypeName(), parentInfo.getMixinTypeNames(), childName, primaryTypeForDefn, --numExistingChildrenWithSameName, false);
            }
            if (definition == null) {
                String msg = JcrI18n.nodeDefinitionCouldNotBeDeterminedForNode.text(SessionCache.this.readable(node.getPath()), SessionCache.this.workspaceName(), SessionCache.this.sourceName());
                throw new ValidationException(msg);
            }
            boolean referenceable = false;
            JcrNodeType primaryType = SessionCache.this.nodeTypes().getNodeType(primaryTypeName);
            if (primaryType == null) {
                Path path = location.getPath();
                String msg = JcrI18n.missingNodeTypeForExistingNode.text(SessionCache.this.readable(primaryTypeName), SessionCache.this.readable(path), SessionCache.this.workspaceName(), SessionCache.this.sourceName());
                throw new ValidationException(msg);
            }
            if (primaryType.isNodeType(JcrMixLexicon.REFERENCEABLE)) {
                referenceable = true;
            }
            Property mixinTypesProperty = graphProperties.get(JcrLexicon.MIXIN_TYPES);
            LinkedList<Name> mixinTypeNames = null;
            if (mixinTypesProperty != null && !mixinTypesProperty.isEmpty()) {
                for (Object mixinTypeValue : mixinTypesProperty) {
                    Name mixinTypeName = (Name)SessionCache.this.nameFactory.create(mixinTypeValue);
                    if (mixinTypeNames == null) {
                        mixinTypeNames = new LinkedList<Name>();
                    }
                    mixinTypeNames.add(mixinTypeName);
                    JcrNodeType mixinType = SessionCache.this.nodeTypes().getNodeType(mixinTypeName);
                    if (mixinType == null || referenceable || !mixinType.isNodeType(JcrMixLexicon.REFERENCEABLE)) continue;
                    referenceable = true;
                }
            }
            JcrNodePayload nodePayload = this.createJcrNodePayload(node, primaryTypeName, mixinTypeNames, definition.getId(), sharedUuid);
            Map props = this.buildProperties(persistentNode, node, nodePayload, referenceable);
            node.loadedWith(persistentNode.getChildren(), props, persistentNode.getExpirationTime());
            node.setPayload(nodePayload);
        }

        protected JcrNodePayload createJcrNodePayload(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node, Name primaryTypeName, List<Name> mixinTypeNames, NodeDefinitionId defnId, UUID sharedUuid) {
            if (sharedUuid != null) {
                try {
                    AbstractJcrNode shared = SessionCache.this.findJcrNode(Location.create(sharedUuid));
                    return new JcrSharedNodePayload(SessionCache.this, node, primaryTypeName, mixinTypeNames, defnId, shared);
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
            }
            return new JcrNodePayload(SessionCache.this, node, primaryTypeName, mixinTypeNames, defnId);
        }

        @Override
        public void postSetProperty(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node, Name propertyName, GraphSession.PropertyInfo<JcrPropertyPayload> oldProperty) {
            GraphSession.PropertyInfo<JcrPropertyPayload> changedProperty;
            super.postSetProperty(node, propertyName, oldProperty);
            if (propertyName.equals(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES)) {
                return;
            }
            if (propertyName.equals(JcrLexicon.MIXIN_TYPES)) {
                HashSet mixinTypeNames = new HashSet();
                NameFactory nameFactory = SessionCache.this.context().getValueFactories().getNameFactory();
                for (Object value : node.getProperty(propertyName).getProperty()) {
                    mixinTypeNames.add(nameFactory.create(value));
                }
                node.setPayload(node.getPayload().with(new ArrayList<Name>(mixinTypeNames)));
            }
            if ((changedProperty = node.getProperty(propertyName)).isMultiValued()) {
                if (changedProperty.getProperty().isSingle()) {
                    SessionCache.this.updateSingleMultipleProperty(node, propertyName, true);
                } else {
                    SessionCache.this.updateSingleMultipleProperty(node, propertyName, false);
                }
            }
        }

        @Override
        public void preSave(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node, DateTime saveTime) throws ValidationException {
            boolean bl;
            JcrNodePayload payload = node.getPayload();
            AbstractJcrNode jcrNode = payload.getJcrNode();
            if (jcrNode.isShared()) {
                jcrNode = ((JcrSharedNode)jcrNode).proxyNode();
                try {
                    payload = jcrNode.nodeInfo().getPayload();
                }
                catch (RepositoryException e) {
                    throw new ValidationException(e.getMessage(), e);
                }
            }
            Name primaryTypeName = payload.getPrimaryTypeName();
            List<Name> mixinTypeNames = payload.getMixinTypeNames();
            HashSet<JcrNodeDefinition> satisfiedChildNodes = new HashSet<JcrNodeDefinition>();
            HashSet<JcrPropertyDefinition> satisfiedProperties = new HashSet<JcrPropertyDefinition>();
            boolean referenceable = false;
            try {
                referenceable = SessionCache.this.isReferenceable(node);
            }
            catch (RepositoryException e) {
                throw new ValidationException(e.getLocalizedMessage());
            }
            for (GraphSession.PropertyInfo<JcrPropertyPayload> propertyInfo : node.getProperties()) {
                if (propertyInfo.getName().equals(JcrLexicon.UUID) && !referenceable) continue;
                JcrPropertyPayload propPayload = propertyInfo.getPayload();
                JcrPropertyDefinition definition = SessionCache.this.findBestPropertyDefintion(primaryTypeName, mixinTypeNames, propertyInfo.getProperty(), propPayload.getPropertyType(), propertyInfo.getProperty().isSingle(), false);
                if (definition == null) {
                    throw new ValidationException(JcrI18n.noDefinition.text("property", SessionCache.this.readable(propertyInfo.getName()), SessionCache.this.readable(node.getPath()), SessionCache.this.readable(primaryTypeName), SessionCache.this.readable(mixinTypeNames)));
                }
                satisfiedProperties.add(definition);
            }
            for (GraphSession.Node node2 : node.getChildren()) {
                JcrNodeDefinition definition;
                int snsCount = node.getChildrenCount(node2.getName());
                JcrNodePayload childPayload = (JcrNodePayload)node2.getPayload();
                AbstractJcrNode childJcrNode = childPayload.getJcrNode();
                if (childJcrNode.isShared()) {
                    childJcrNode = ((JcrSharedNode)childJcrNode).proxyNode();
                    try {
                        childPayload = childJcrNode.nodeInfo().getPayload();
                    }
                    catch (RepositoryException e) {
                        throw new ValidationException(e.getMessage(), e);
                    }
                }
                if ((definition = SessionCache.this.nodeTypes().findChildNodeDefinition(primaryTypeName, mixinTypeNames, node2.getName(), childPayload.getPrimaryTypeName(), snsCount, false)) == null) {
                    throw new ValidationException(JcrI18n.noDefinition.text("child node", SessionCache.this.readable(node2.getName()), SessionCache.this.readable(node.getPath()), SessionCache.this.readable(primaryTypeName), SessionCache.this.readable(mixinTypeNames)));
                }
                satisfiedChildNodes.add(definition);
            }
            JcrNodeType primaryType = SessionCache.this.nodeTypes().getNodeType(primaryTypeName);
            boolean bl2 = primaryType.isNodeType(JcrMixLexicon.LAST_MODIFIED);
            boolean isCreatedType = primaryType.isNodeType(JcrMixLexicon.CREATED);
            boolean isETag = primaryType.isNodeType(JcrMixLexicon.ETAG);
            for (JcrPropertyDefinition jcrPropertyDefinition : primaryType.getPropertyDefinitions()) {
                if (!jcrPropertyDefinition.isMandatory() || jcrPropertyDefinition.isProtected() || satisfiedProperties.contains(jcrPropertyDefinition)) continue;
                throw new ValidationException(JcrI18n.noDefinition.text("property", jcrPropertyDefinition.getName(), SessionCache.this.readable(node.getPath()), SessionCache.this.readable(primaryTypeName), SessionCache.this.readable(mixinTypeNames)));
            }
            for (JcrItemDefinition jcrItemDefinition : primaryType.getChildNodeDefinitions()) {
                if (!jcrItemDefinition.isMandatory() || jcrItemDefinition.isProtected() || satisfiedChildNodes.contains(jcrItemDefinition)) continue;
                throw new ValidationException(JcrI18n.noDefinition.text("child node", jcrItemDefinition.getName(), SessionCache.this.readable(node.getPath()), SessionCache.this.readable(primaryTypeName), SessionCache.this.readable(mixinTypeNames)));
            }
            if (mixinTypeNames != null) {
                for (Name mixinTypeName : mixinTypeNames) {
                    JcrNodeType mixinType = SessionCache.this.nodeTypes().getNodeType(mixinTypeName);
                    bl = bl || mixinType.isNodeType(JcrMixLexicon.LAST_MODIFIED);
                    isCreatedType = isCreatedType || mixinType.isNodeType(JcrMixLexicon.CREATED);
                    isETag = isETag || mixinType.isNodeType(JcrMixLexicon.ETAG);
                    for (JcrPropertyDefinition jcrPropertyDefinition : mixinType.getPropertyDefinitions()) {
                        if (!jcrPropertyDefinition.isMandatory() || jcrPropertyDefinition.isProtected() || satisfiedProperties.contains(jcrPropertyDefinition)) continue;
                        throw new ValidationException(JcrI18n.noDefinition.text("child node", jcrPropertyDefinition.getName(), SessionCache.this.readable(node.getPath()), SessionCache.this.readable(primaryTypeName), SessionCache.this.readable(mixinTypeNames)));
                    }
                    for (JcrNodeDefinition jcrNodeDefinition : mixinType.getChildNodeDefinitions()) {
                        if (!jcrNodeDefinition.isMandatory() || jcrNodeDefinition.isProtected() || satisfiedChildNodes.contains(jcrNodeDefinition)) continue;
                        throw new ValidationException(JcrI18n.noDefinition.text("child node", jcrNodeDefinition.getName(), SessionCache.this.readable(node.getPath()), SessionCache.this.readable(primaryTypeName), SessionCache.this.readable(mixinTypeNames)));
                    }
                }
            }
            if (isETag) {
                ArrayList<Name> binaryPropertyNames = new ArrayList<Name>();
                for (GraphSession.PropertyInfo<JcrPropertyPayload> property : node.getProperties()) {
                    if (property.getProperty().size() == 0 || property.getPayload().getPropertyType() != 2) continue;
                    binaryPropertyNames.add(property.getName());
                }
                StringBuilder sb = new StringBuilder();
                if (!binaryPropertyNames.isEmpty()) {
                    Collections.sort(binaryPropertyNames);
                    BinaryFactory binaryFactory = SessionCache.this.context().getValueFactories().getBinaryFactory();
                    for (Name name : binaryPropertyNames) {
                        GraphSession.PropertyInfo<JcrPropertyPayload> property = node.getProperty(name);
                        for (Object value : property.getProperty()) {
                            Binary binary = (Binary)binaryFactory.create(value);
                            String hash = new String(binary.getHash());
                            sb.append(hash);
                        }
                    }
                }
                String etagValue = sb.toString();
                this.setProperty(node, primaryTypeName, mixinTypeNames, false, JcrLexicon.ETAG, 1, etagValue);
            }
            if (isCreatedType) {
                this.setPropertyIfAbsent(node, primaryTypeName, mixinTypeNames, false, JcrLexicon.CREATED, 5, saveTime);
                this.setPropertyIfAbsent(node, primaryTypeName, mixinTypeNames, false, JcrLexicon.CREATED_BY, 1, this.user);
            }
            if (bl) {
                this.setPropertyIfAbsent(node, primaryTypeName, mixinTypeNames, false, JcrLexicon.LAST_MODIFIED, 5, saveTime);
                this.setPropertyIfAbsent(node, primaryTypeName, mixinTypeNames, false, JcrLexicon.LAST_MODIFIED_BY, 1, this.user);
            }
        }

        protected void setPropertyIfAbsent(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node, Name primaryTypeName, List<Name> mixinTypeNames, boolean skipProtected, Name propertyName, int propertyType, Object value) {
            if (node.getProperty(propertyName) != null) {
                return;
            }
            this.setProperty(node, primaryTypeName, mixinTypeNames, skipProtected, propertyName, propertyType, value);
        }

        protected void setProperty(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node, Name primaryTypeName, List<Name> mixinTypeNames, boolean skipProtected, Name propertyName, int propertyType, Object value) {
            Property graphProp = SessionCache.this.propertyFactory.create(propertyName, value);
            JcrPropertyDefinition propDefn = SessionCache.this.findBestPropertyDefintion(primaryTypeName, mixinTypeNames, graphProp, propertyType, true, skipProtected);
            AbstractJcrNode jcrNode = node.getPayload().getJcrNode();
            JcrSingleValueProperty jcrProp = new JcrSingleValueProperty(SessionCache.this, jcrNode, propertyName);
            JcrPropertyPayload propPayload = new JcrPropertyPayload(propDefn.getId(), propertyType, jcrProp);
            node.setProperty(graphProp, false, propPayload);
        }

        @Override
        public void compute(Graph.Batch batch, GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node) {
            try {
                JcrWorkspace workspace = SessionCache.this.session().workspace();
                if (workspace != null) {
                    workspace.versionManager().initializeVersionHistoryFor(batch, node, null, false);
                }
            }
            catch (RepositoryException re) {
                throw new IllegalStateException(re);
            }
        }

        @Override
        public void postCreateChild(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> parent, GraphSession.Node<JcrNodePayload, JcrPropertyPayload> child, Map<Name, GraphSession.PropertyInfo<JcrPropertyPayload>> properties) throws ValidationException {
            super.postCreateChild(parent, child, properties);
            GraphSession.PropertyInfo<JcrPropertyPayload> primaryTypeInfo = properties.get(JcrLexicon.PRIMARY_TYPE);
            GraphSession.PropertyInfo<JcrPropertyPayload> nodeDefnInfo = properties.get(ModeShapeIntLexicon.NODE_DEFINITON);
            Name primaryTypeName = (Name)SessionCache.this.nameFactory().create(primaryTypeInfo.getProperty().getFirstValue());
            String nodeDefnIdStr = SessionCache.this.stringFactory().create(nodeDefnInfo.getProperty().getFirstValue());
            NodeDefinitionId nodeDefnId = NodeDefinitionId.fromString(nodeDefnIdStr, SessionCache.this.nameFactory);
            GraphSession.PropertyInfo sharedUuidInfo = properties.get(ModeShapeLexicon.SHARED_UUID);
            UUID sharedUuid = sharedUuidInfo != null && ModeShapeLexicon.SHARE.equals(primaryTypeName) ? (UUID)SessionCache.this.uuidFactory().create(sharedUuidInfo.getProperty().getFirstValue()) : null;
            JcrNodePayload nodePayload = this.createJcrNodePayload(child, primaryTypeName, null, nodeDefnId, sharedUuid);
            child.setPayload(nodePayload);
            JcrNodeType ntBase = SessionCache.this.nodeTypes().getNodeType(JcrNtLexicon.BASE);
            assert (ntBase != null);
            primaryTypeInfo = SessionCache.this.createPropertyInfo(child.getPayload(), primaryTypeInfo.getProperty(), ntBase.allPropertyDefinitions(JcrLexicon.PRIMARY_TYPE).iterator().next(), 7, primaryTypeInfo);
            properties.put(primaryTypeInfo.getName(), primaryTypeInfo);
            nodeDefnInfo = SessionCache.this.createPropertyInfo(child.getPayload(), nodeDefnInfo.getProperty(), ntBase.allPropertyDefinitions(ModeShapeIntLexicon.NODE_DEFINITON).iterator().next(), 1, nodeDefnInfo);
            properties.put(nodeDefnInfo.getName(), nodeDefnInfo);
            GraphSession.PropertyInfo<JcrPropertyPayload> uuidInfo = properties.get(JcrLexicon.UUID);
            if (uuidInfo != null) {
                JcrNodeType mixRef = SessionCache.this.nodeTypes().getNodeType(JcrMixLexicon.REFERENCEABLE);
                assert (mixRef != null);
                uuidInfo = SessionCache.this.createPropertyInfo(child.getPayload(), uuidInfo.getProperty(), mixRef.allPropertyDefinitions(JcrLexicon.UUID).iterator().next(), 1, uuidInfo);
                properties.put(uuidInfo.getName(), uuidInfo);
            }
        }

        protected final Set<Name> getSingleMultiPropertyNames(Property dnaProperty, Location location) {
            HashSet<Name> multiValuedPropertyNames = new HashSet<Name>();
            for (Object value : dnaProperty) {
                try {
                    multiValuedPropertyNames.add((Name)SessionCache.this.nameFactory.create(value));
                }
                catch (ValueFormatException e) {
                    String msg = "{0} value \"{1}\" on {2} in \"{3}\" workspace is not a valid name and is being ignored";
                    this.LOGGER.trace(e, msg, SessionCache.this.readable(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES), value, SessionCache.this.readable(location), SessionCache.this.workspaceName());
                }
            }
            return multiValuedPropertyNames;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class NodeEditor {
        private final GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node;

        protected NodeEditor(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node) {
            this.node = node;
        }

        protected GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node() {
            return this.node;
        }

        private void checkCardinalityOfExistingProperty(Name propertyName, boolean isMultiple) throws javax.jcr.ValueFormatException, RepositoryException {
            GraphSession.PropertyInfo<JcrPropertyPayload> propInfo = this.node.getProperty(propertyName);
            if (propInfo != null && propInfo.isMultiValued() != isMultiple) {
                String workspaceName = SessionCache.this.workspaceName();
                String propName = SessionCache.this.readable(propertyName);
                String path = SessionCache.this.readable(this.node.getPath());
                if (isMultiple) {
                    I18n msg = JcrI18n.unableToSetSingleValuedPropertyUsingMultipleValues;
                    throw new javax.jcr.ValueFormatException(msg.text(propName, path, workspaceName));
                }
                I18n msg = JcrI18n.unableToSetMultiValuedPropertyUsingSingleValue;
                throw new javax.jcr.ValueFormatException(msg.text(propName, path, workspaceName));
            }
        }

        boolean isCheckedOut() throws RepositoryException {
            GraphSession.Node<JcrNodePayload, JcrPropertyPayload> curr = this.node;
            while (curr.getParent() != null) {
                if (SessionCache.this.isNodeType(curr, JcrMixLexicon.VERSIONABLE)) {
                    GraphSession.PropertyInfo<JcrPropertyPayload> prop = curr.getProperty(JcrLexicon.IS_CHECKED_OUT);
                    return prop == null || prop.getPayload().getJcrProperty().getBoolean();
                }
                curr = curr.getParent();
            }
            return true;
        }

        public AbstractJcrProperty setProperty(Name name, JcrValue value) throws AccessDeniedException, ConstraintViolationException, RepositoryException {
            return this.setProperty(name, value, true, false);
        }

        public AbstractJcrProperty setProperty(Name name, JcrValue value, boolean skipProtected, boolean skipReferenceValidation) throws AccessDeniedException, ConstraintViolationException, VersionException, RepositoryException {
            assert (name != null);
            assert (value != null);
            if (!this.isCheckedOut() && skipProtected) {
                String path = this.node.getLocation().getPath().getString(SessionCache.this.context().getNamespaceRegistry());
                throw new VersionException(JcrI18n.nodeIsCheckedIn.text(path));
            }
            this.checkCardinalityOfExistingProperty(name, false);
            JcrPropertyDefinition definition = null;
            GraphSession.PropertyInfo<JcrPropertyPayload> existing = this.node.getProperty(name);
            if (existing != null && (definition = SessionCache.this.nodeTypes().getPropertyDefinition(existing.getPayload().getPropertyDefinitionId())) != null) {
                if (definition.getRequiredType() != 0 && definition.getRequiredType() != value.getType()) {
                    definition = null;
                } else if (!definition.satisfiesConstraints(value)) {
                    definition = null;
                }
            }
            JcrNodePayload payload = this.node.getPayload();
            if (definition == null) {
                boolean referencePropMissedConstraints;
                definition = SessionCache.this.nodeTypes().findPropertyDefinition(payload.getPrimaryTypeName(), payload.getMixinTypeNames(), name, value, true, skipProtected);
                boolean bl = referencePropMissedConstraints = !skipReferenceValidation && definition != null && (definition.getRequiredType() == 9 || definition.getRequiredType() == 10) && !definition.canCastToTypeAndSatisfyConstraints(value);
                if (definition == null) {
                    definition = SessionCache.this.nodeTypes().findPropertyDefinition(payload.getPrimaryTypeName(), payload.getMixinTypeNames(), name, value, true, skipProtected, false);
                    if (definition != null) {
                        String msg = JcrI18n.valueViolatesConstraintsOnDefinition.text(SessionCache.this.readable(name), SessionCache.this.readable(value), SessionCache.this.readable(this.node.getPath()), definition.getName(), definition.getDeclaringNodeType().getName());
                        throw new ConstraintViolationException(msg);
                    }
                    throw new ConstraintViolationException(JcrI18n.noDefinition.text("property", SessionCache.this.readable(name), SessionCache.this.readable(this.node.getPath()), SessionCache.this.readable(payload.getPrimaryTypeName()), SessionCache.this.readable(payload.getMixinTypeNames())));
                }
                if (referencePropMissedConstraints) {
                    I18n i18n = definition.getRequiredType() == 9 ? JcrI18n.referenceValueViolatesConstraintsOnDefinition : JcrI18n.weakReferenceValueViolatesConstraintsOnDefinition;
                    String msg = i18n.text(SessionCache.this.readable(name), SessionCache.this.readable(value), SessionCache.this.readable(this.node.getPath()), definition.getName(), definition.getDeclaringNodeType().getName());
                    throw new ConstraintViolationException(msg);
                }
            } else if (skipProtected && definition.isProtected()) {
                throw new ConstraintViolationException(JcrI18n.noDefinition.text("property", SessionCache.this.readable(name), SessionCache.this.readable(this.node.getPath()), SessionCache.this.readable(payload.getPrimaryTypeName()), SessionCache.this.readable(payload.getMixinTypeNames())));
            }
            Object objValue = value.value();
            int propertyType = definition.getRequiredType();
            if (propertyType == 0 || propertyType == value.getType()) {
                propertyType = value.getType();
            } else {
                org.modeshape.graph.property.PropertyType dnaPropertyType = PropertyTypeUtil.dnaPropertyTypeFor(propertyType);
                ValueFactory<?> factory = SessionCache.this.factories().getValueFactory(dnaPropertyType);
                objValue = factory.create(objValue);
            }
            Property dnaProp = SessionCache.this.propertyFactory.create(name, objValue);
            try {
                AbstractJcrProperty jcrProp = null;
                if (existing != null) {
                    jcrProp = existing.getPayload().getJcrProperty();
                } else {
                    AbstractJcrNode jcrNode = payload.getJcrNode();
                    jcrProp = definition.isMultiple() ? new JcrMultiValueProperty(SessionCache.this, jcrNode, dnaProp.getName()) : new JcrSingleValueProperty(SessionCache.this, jcrNode, dnaProp.getName());
                }
                assert (jcrProp != null);
                JcrPropertyPayload propPayload = new JcrPropertyPayload(definition.getId(), propertyType, jcrProp);
                this.node.setProperty(dnaProp, definition.isMultiple(), propPayload);
                return jcrProp;
            }
            catch (ValidationException e) {
                throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
        }

        public AbstractJcrProperty setProperty(Name name, Value[] values, int valueType) throws AccessDeniedException, ConstraintViolationException, RepositoryException, javax.jcr.ValueFormatException {
            return this.setProperty(name, values, valueType, true);
        }

        public AbstractJcrProperty setProperty(Name name, Value[] values, int valueType, boolean skipProtected) throws AccessDeniedException, ConstraintViolationException, RepositoryException, javax.jcr.ValueFormatException, VersionException {
            return this.setProperty(name, values, valueType, skipProtected, false);
        }

        public AbstractJcrProperty setProperty(Name name, Value[] values, int valueType, boolean skipProtected, boolean skipReferenceValidation) throws AccessDeniedException, ConstraintViolationException, RepositoryException, javax.jcr.ValueFormatException, VersionException {
            assert (name != null);
            assert (values != null);
            if (!this.isCheckedOut() && skipProtected) {
                String path = this.node.getLocation().getPath().getString(SessionCache.this.context().getNamespaceRegistry());
                throw new VersionException(JcrI18n.nodeIsCheckedIn.text(path));
            }
            this.checkCardinalityOfExistingProperty(name, true);
            int len = values.length;
            Value[] newValues = null;
            if (len == 0) {
                newValues = JcrMultiValueProperty.EMPTY_VALUES;
            } else {
                ArrayList<Value> valuesWithDesiredType = new ArrayList<Value>(len);
                int expectedType = -1;
                for (int i = 0; i != len; ++i) {
                    Value value = values[i];
                    if (value == null) continue;
                    if (expectedType == -1) {
                        expectedType = value.getType();
                    } else if (value.getType() != expectedType) {
                        StringBuilder sb = new StringBuilder();
                        sb.append('[');
                        for (int j = 0; j != values.length; ++j) {
                            if (j != 0) {
                                sb.append(",");
                            }
                            sb.append(values[j].toString());
                        }
                        sb.append(']');
                        String propType = PropertyType.nameFromValue((int)expectedType);
                        I18n msg = JcrI18n.allPropertyValuesMustHaveSameType;
                        String path = SessionCache.this.readable(this.node.getPath());
                        String workspaceName = SessionCache.this.workspaceName();
                        throw new javax.jcr.ValueFormatException(msg.text(SessionCache.this.readable(name), values, propType, path, workspaceName));
                    }
                    if (value.getType() != valueType && valueType != 0) {
                        value = ((JcrValue)value).asType(valueType);
                    }
                    valuesWithDesiredType.add(value);
                }
                newValues = valuesWithDesiredType.isEmpty() ? JcrMultiValueProperty.EMPTY_VALUES : valuesWithDesiredType.toArray(new Value[valuesWithDesiredType.size()]);
            }
            int numValues = newValues.length;
            JcrPropertyDefinition definition = null;
            GraphSession.PropertyInfo<JcrPropertyPayload> existing = this.node.getProperty(name);
            if (existing != null && (definition = SessionCache.this.nodeTypes().getPropertyDefinition(existing.getPayload().getPropertyDefinitionId())) != null && numValues != 0) {
                int type = newValues[0].getType();
                if (definition.getRequiredType() != 0 && definition.getRequiredType() != type) {
                    definition = null;
                } else if (!definition.satisfiesConstraints(newValues)) {
                    definition = null;
                }
            }
            JcrNodePayload payload = this.node.getPayload();
            if (definition == null) {
                boolean referencePropMissedConstraints;
                definition = SessionCache.this.nodeTypes().findPropertyDefinition(payload.getPrimaryTypeName(), payload.getMixinTypeNames(), name, newValues, skipProtected);
                boolean bl = referencePropMissedConstraints = !skipReferenceValidation && definition != null && (definition.getRequiredType() == 9 || definition.getRequiredType() == 10) && !definition.canCastToTypeAndSatisfyConstraints(newValues);
                if (definition == null) {
                    definition = SessionCache.this.nodeTypes().findPropertyDefinition(payload.getPrimaryTypeName(), payload.getMixinTypeNames(), name, values, skipProtected, false);
                    if (definition != null) {
                        String msg = JcrI18n.valueViolatesConstraintsOnDefinition.text(SessionCache.this.readable(name), SessionCache.this.readable(values), SessionCache.this.readable(this.node.getPath()), definition.getName(), definition.getDeclaringNodeType().getName());
                        throw new ConstraintViolationException(msg);
                    }
                    throw new ConstraintViolationException(JcrI18n.noDefinition.text("property", SessionCache.this.readable(name), SessionCache.this.readable(this.node.getPath()), SessionCache.this.readable(payload.getPrimaryTypeName()), SessionCache.this.readable(payload.getMixinTypeNames())));
                }
                if (referencePropMissedConstraints) {
                    I18n i18n = definition.getRequiredType() == 9 ? JcrI18n.referenceValuesViolateConstraintsOnDefinition : JcrI18n.weakReferenceValuesViolateConstraintsOnDefinition;
                    String msg = i18n.text(SessionCache.this.readable(name), SessionCache.this.readable(values), SessionCache.this.readable(this.node.getPath()), definition.getName(), definition.getDeclaringNodeType().getName());
                    referencePropMissedConstraints = (definition.getRequiredType() == 9 || definition.getRequiredType() == 10) && !definition.canCastToTypeAndSatisfyConstraints(newValues);
                    throw new ConstraintViolationException(msg);
                }
            } else if (skipProtected && definition.isProtected()) {
                throw new ConstraintViolationException(JcrI18n.noDefinition.text("property", SessionCache.this.readable(name), SessionCache.this.readable(this.node.getPath()), SessionCache.this.readable(payload.getPrimaryTypeName()), SessionCache.this.readable(payload.getMixinTypeNames())));
            }
            int type = numValues != 0 ? newValues[0].getType() : definition.getRequiredType();
            Object[] objValues = new Object[numValues];
            int propertyType = definition.getRequiredType();
            if (propertyType == 0 || propertyType == type) {
                propertyType = type;
                for (int i = 0; i != numValues; ++i) {
                    objValues[i] = ((JcrValue)newValues[i]).value();
                }
            } else {
                assert (propertyType != type);
                org.modeshape.graph.property.PropertyType dnaPropertyType = PropertyTypeUtil.dnaPropertyTypeFor(propertyType);
                ValueFactory<?> factory = SessionCache.this.factories().getValueFactory(dnaPropertyType);
                for (int i = 0; i != numValues; ++i) {
                    objValues[i] = factory.create(((JcrValue)newValues[i]).value());
                }
            }
            Property dnaProp = SessionCache.this.propertyFactory.create(name, objValues);
            try {
                AbstractJcrProperty jcrProp = null;
                if (existing != null) {
                    jcrProp = existing.getPayload().getJcrProperty();
                } else {
                    AbstractJcrNode jcrNode = payload.getJcrNode();
                    jcrProp = definition.isMultiple() ? new JcrMultiValueProperty(SessionCache.this, jcrNode, dnaProp.getName()) : new JcrSingleValueProperty(SessionCache.this, jcrNode, dnaProp.getName());
                }
                assert (jcrProp != null);
                JcrPropertyPayload propPayload = new JcrPropertyPayload(definition.getId(), propertyType, jcrProp);
                this.node.setProperty(dnaProp, definition.isMultiple(), propPayload);
                return jcrProp;
            }
            catch (ValidationException e) {
                throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
        }

        public boolean removeProperty(Name name) throws AccessDeniedException, RepositoryException {
            try {
                return this.node.removeProperty(name) != null;
            }
            catch (ValidationException e) {
                throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
        }

        public void orderChildBefore(Path.Segment childToBeMoved, Path.Segment before) throws AccessDeniedException, RepositoryException {
            try {
                this.node.orderChildBefore(childToBeMoved, before);
            }
            catch (ValidationException e) {
                throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
        }

        public GraphSession.Node<JcrNodePayload, JcrPropertyPayload> moveToBeChild(AbstractJcrNode child, Name newNodeName) throws ItemNotFoundException, InvalidItemStateException, ConstraintViolationException, RepositoryException {
            GraphSession.Node<JcrNodePayload, JcrPropertyPayload> existingChild;
            if (child instanceof JcrSharedNode) {
                child = ((JcrSharedNode)child).proxyNode();
            }
            if ((existingChild = SessionCache.this.findNode(child.nodeId, child.location.getPath())).equals(this.node) || this.node.isAtOrBelow(existingChild)) {
                String pathOfChild = SessionCache.this.readable(existingChild.getPath());
                String thisPath = SessionCache.this.readable(this.node.getPath());
                String msg = JcrI18n.unableToMoveNodeToBeChildOfDecendent.text(pathOfChild, thisPath, SessionCache.this.workspaceName());
                throw new RepositoryException(msg);
            }
            JcrNodeDefinition defn = SessionCache.this.findBestNodeDefinition(this.node, newNodeName, child.getPrimaryTypeName());
            try {
                existingChild.moveTo(this.node, newNodeName);
                NodeDefinitionId existingChildDefinitionId = existingChild.getPayload().getDefinitionId();
                if (!defn.getId().equals(existingChildDefinitionId)) {
                    NodeEditor newChildEditor = SessionCache.this.getEditorFor(existingChild);
                    try {
                        JcrValue value = new JcrValue(SessionCache.this.factories(), SessionCache.this, 1, defn.getId().getString());
                        newChildEditor.setProperty(ModeShapeIntLexicon.NODE_DEFINITON, value);
                    }
                    catch (ConstraintViolationException e) {
                        existingChild.setPayload(existingChild.getPayload().with(defn.getId()));
                        newChildEditor.removeProperty(ModeShapeIntLexicon.NODE_DEFINITON);
                    }
                }
                Path newPath = existingChild.getPath();
                this.setNewLocation(existingChild, newPath);
                return existingChild;
            }
            catch (ValidationException e) {
                throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
        }

        private void setNewLocation(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node, Path newPath) {
            AbstractJcrNode jcrNode = node.getPayload().getJcrNode(false);
            if (jcrNode != null) {
                node.getPayload().getJcrNode().setLocation(node.getLocation().with(newPath));
                for (GraphSession.Node<JcrNodePayload, JcrPropertyPayload> child : node.getChildren()) {
                    if (!child.isLoaded()) continue;
                    Path newChildPath = SessionCache.this.pathFactory.create(newPath, child.getSegment());
                    this.setNewLocation(child, newChildPath);
                }
            }
        }

        public void addMixin(JcrNodeType mixinCandidateType) throws javax.jcr.ValueFormatException, RepositoryException {
            try {
                GraphSession.PropertyInfo<JcrPropertyPayload> existingMixinProperty = this.node.getProperty(JcrLexicon.MIXIN_TYPES);
                Value[] existingMixinValues = existingMixinProperty != null ? existingMixinProperty.getPayload().getJcrProperty().getValues() : new Value[]{};
                Value[] newMixinValues = new Value[existingMixinValues.length + 1];
                System.arraycopy(existingMixinValues, 0, newMixinValues, 0, existingMixinValues.length);
                newMixinValues[newMixinValues.length - 1] = new JcrValue(SessionCache.this.factories(), SessionCache.this, 7, mixinCandidateType.getInternalName());
                this.setProperty(JcrLexicon.MIXIN_TYPES, newMixinValues, 7, false);
                this.autoCreateItemsFor(mixinCandidateType);
                if (mixinCandidateType.isNodeType(JcrMixLexicon.REFERENCEABLE)) {
                    UUID uuid = this.node.getLocation().getUuid();
                    if (uuid == null) {
                        uuid = (UUID)this.node.getLocation().getIdProperty(JcrLexicon.UUID).getFirstValue();
                    }
                    if (uuid == null) {
                        uuid = UUID.randomUUID();
                    }
                    JcrValue value = new JcrValue(SessionCache.this.factories(), SessionCache.this, 1, uuid);
                    this.setProperty(JcrLexicon.UUID, value, false, false);
                }
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
        }

        private void autoCreateItemsFor(JcrNodeType nodeType) throws InvalidItemStateException, ConstraintViolationException, AccessDeniedException, RepositoryException {
            for (JcrPropertyDefinition propertyDefinition : nodeType.allPropertyDefinitions()) {
                GraphSession.PropertyInfo<JcrPropertyPayload> autoCreatedProp;
                if (!propertyDefinition.isAutoCreated() || propertyDefinition.isProtected() || (autoCreatedProp = this.node.getProperty(propertyDefinition.getInternalName())) != null || propertyDefinition.getDefaultValues() == null) continue;
                if (propertyDefinition.isMultiple()) {
                    this.setProperty(propertyDefinition.getInternalName(), propertyDefinition.getDefaultValues(), propertyDefinition.getRequiredType());
                    continue;
                }
                assert (propertyDefinition.getDefaultValues().length == 1);
                this.setProperty(propertyDefinition.getInternalName(), (JcrValue)propertyDefinition.getDefaultValues()[0]);
            }
            for (JcrNodeDefinition nodeDefinition : nodeType.allChildNodeDefinitions()) {
                Name nodeName;
                if (!nodeDefinition.isAutoCreated() || nodeDefinition.isProtected() || this.node.getChildrenCount(nodeName = nodeDefinition.getInternalName()) != 0) continue;
                assert (nodeDefinition.getDefaultPrimaryType() != null);
                this.createChild(nodeName, null, ((JcrNodeType)nodeDefinition.getDefaultPrimaryType()).getInternalName());
            }
        }

        public JcrNode createChild(Name name, UUID desiredUuid, Name primaryTypeName) throws InvalidItemStateException, ConstraintViolationException, AccessDeniedException, RepositoryException {
            if (desiredUuid == null) {
                desiredUuid = UUID.randomUUID();
            }
            try {
                int numSns = this.node.getChildrenCount(name) + 1;
                JcrNodePayload payload = this.node.getPayload();
                JcrNodeDefinition definition = SessionCache.this.nodeTypes().findChildNodeDefinition(payload.getPrimaryTypeName(), payload.getMixinTypeNames(), name, primaryTypeName, numSns, true);
                if (definition == null) {
                    definition = SessionCache.this.nodeTypes().findChildNodeDefinition(payload.getPrimaryTypeName(), payload.getMixinTypeNames(), name, primaryTypeName, numSns - 1, true);
                    if (definition != null) {
                        Path pathForChild = SessionCache.this.pathFactory.create(this.node.getPath(), name, numSns);
                        String msg = JcrI18n.noSnsDefinitionForNode.text(pathForChild, SessionCache.this.workspaceName());
                        throw new ItemExistsException(msg);
                    }
                    Path pathForChild = SessionCache.this.pathFactory.create(this.node.getPath(), name, numSns);
                    String msg = JcrI18n.nodeDefinitionCouldNotBeDeterminedForNode.text(pathForChild, SessionCache.this.workspaceName(), SessionCache.this.sourceName());
                    throw new ConstraintViolationException(msg);
                }
                JcrNodeType primaryType = null;
                if (primaryTypeName != null) {
                    primaryType = SessionCache.this.nodeTypes().getNodeType(primaryTypeName);
                    if (primaryType == null) {
                        Path pathForChild = SessionCache.this.pathFactory.create(this.node.getPath(), name, numSns);
                        I18n msg = JcrI18n.unableToCreateNodeWithPrimaryTypeThatDoesNotExist;
                        throw new NoSuchNodeTypeException(msg.text(primaryTypeName, pathForChild, SessionCache.this.workspaceName()));
                    }
                    if (primaryType.isMixin()) {
                        I18n msg = JcrI18n.cannotUseMixinTypeAsPrimaryType;
                        throw new ConstraintViolationException(msg.text(primaryType.getName()));
                    }
                    if (primaryType.isAbstract()) {
                        I18n msg = JcrI18n.primaryTypeCannotBeAbstract;
                        throw new ConstraintViolationException(msg.text(primaryType.getName()));
                    }
                } else {
                    primaryType = (JcrNodeType)definition.getDefaultPrimaryType();
                    if (primaryType == null) {
                        Path pathForChild = SessionCache.this.pathFactory.create(this.node.getPath(), name, numSns);
                        I18n msg = JcrI18n.unableToCreateNodeWithNoDefaultPrimaryTypeOnChildNodeDefinition;
                        String nodeTypeName = definition.getDeclaringNodeType().getName();
                        throw new NoSuchNodeTypeException(msg.text(definition.getName(), nodeTypeName, pathForChild, SessionCache.this.workspaceName()));
                    }
                }
                primaryTypeName = primaryType.getInternalName();
                Property primaryTypeProp = SessionCache.this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, primaryTypeName);
                Property nodeDefinitionProp = SessionCache.this.propertyFactory.create(ModeShapeIntLexicon.NODE_DEFINITON, definition.getId().getString());
                GraphSession.Node<JcrNodePayload, JcrPropertyPayload> result = null;
                boolean isReferenceable = primaryType.isNodeType(JcrMixLexicon.REFERENCEABLE);
                Property uuidProperty = null;
                if (desiredUuid != null || isReferenceable) {
                    if (desiredUuid == null) {
                        desiredUuid = UUID.randomUUID();
                    }
                    uuidProperty = SessionCache.this.propertyFactory.create(JcrLexicon.UUID, desiredUuid);
                }
                result = uuidProperty != null ? this.node.createChild(name, Collections.singleton(uuidProperty), primaryTypeProp, nodeDefinitionProp) : this.node.createChild(name, primaryTypeProp, nodeDefinitionProp);
                JcrNode jcrNode = (JcrNode)result.getPayload().getJcrNode();
                JcrValue now = jcrNode.valueFrom(Calendar.getInstance());
                JcrValue by = jcrNode.valueFrom(SessionCache.this.session().getUserID());
                boolean isCreatedType = primaryType.isNodeType(JcrMixLexicon.CREATED);
                boolean isHierarchyNode = primaryType.isNodeType(JcrNtLexicon.HIERARCHY_NODE);
                if (isHierarchyNode || isCreatedType) {
                    NodeEditor editor = jcrNode.editor();
                    if (isHierarchyNode) {
                        editor.setProperty(JcrLexicon.CREATED, now, false, false);
                    }
                    if (isCreatedType) {
                        editor.setProperty(JcrLexicon.CREATED, now, false, false);
                        editor.setProperty(JcrLexicon.CREATED_BY, by, false, false);
                    }
                }
                jcrNode.editor().autoCreateItemsFor(primaryType);
                return jcrNode;
            }
            catch (ValidationException e) {
                throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
        }

        public boolean destroyChild(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> child) throws AccessDeniedException, RepositoryException {
            if (!child.getParent().equals(this.node)) {
                return false;
            }
            try {
                child.destroy();
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
            return true;
        }

        public boolean destroy() throws AccessDeniedException, RepositoryException {
            try {
                this.node.destroy();
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CustomGraphSession
    extends GraphSession<JcrNodePayload, JcrPropertyPayload> {
        CustomGraphSession(Graph graph, String workspaceName, GraphSession.Operations<JcrNodePayload, JcrPropertyPayload> nodeOperations, GraphSession.Authorizer authorizer) {
            super(graph, workspaceName, nodeOperations, authorizer);
        }

        @Override
        protected Graph.Batch operations() {
            return super.operations();
        }
    }
}

