/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.optimize.OptimizerRule;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.plan.PlanUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushProjects
implements OptimizerRule {
    public static final PushProjects INSTANCE = new PushProjects();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        Iterator<PlanNode> i$ = plan.findAllAtOrBelow(PlanNode.Type.ACCESS).iterator();
        while (i$.hasNext()) {
            PlanNode accessParent;
            PlanNode access;
            PlanNode parentOfProject = access = i$.next();
            while (parentOfProject.isOneOf(PlanNode.Type.LIMIT, PlanNode.Type.SORT, PlanNode.Type.DUP_REMOVE)) {
                parentOfProject = parentOfProject.getParent();
            }
            assert (parentOfProject.getChildCount() == 1);
            PlanNode child = parentOfProject.getFirstChild();
            if (child.is(PlanNode.Type.PROJECT)) {
                accessParent = access.getParent();
                if (accessParent == null || accessParent.isNot(PlanNode.Type.PROJECT)) continue;
                assert (accessParent.is(PlanNode.Type.PROJECT));
                child.extractFromParent();
                child = parentOfProject.getFirstChild();
            }
            if ((accessParent = access.getParent()) != null && accessParent.is(PlanNode.Type.PROJECT)) {
                PlanNode project = accessParent;
                if (project == plan) {
                    plan = access;
                    access.removeFromParent();
                } else {
                    project.extractFromParent();
                }
                child.insertAsParent(project);
                if (plan == access) break;
                List<Column> requiredColumns = PlanUtil.findRequiredColumns(context, project);
                List<String> requiredTypes = PlanUtil.findRequiredColumnTypes(context, requiredColumns, child);
                project.setProperty(PlanNode.Property.PROJECT_COLUMNS, requiredColumns);
                project.setProperty(PlanNode.Property.PROJECT_COLUMN_TYPES, requiredTypes);
                project.addSelectors(this.getSelectorsFor(requiredColumns));
                continue;
            }
            List<Column> requiredColumns = PlanUtil.findRequiredColumns(context, child);
            List<String> requiredTypes = PlanUtil.findRequiredColumnTypes(context, requiredColumns, child);
            PlanNode projectNode = new PlanNode(PlanNode.Type.PROJECT);
            projectNode.setProperty(PlanNode.Property.PROJECT_COLUMNS, requiredColumns);
            projectNode.setProperty(PlanNode.Property.PROJECT_COLUMN_TYPES, requiredTypes);
            projectNode.addSelectors(this.getSelectorsFor(requiredColumns));
            child.insertAsParent(projectNode);
        }
        return plan;
    }

    protected Set<SelectorName> getSelectorsFor(List<Column> columns) {
        HashSet<SelectorName> selectors = new HashSet<SelectorName>();
        for (Column column : columns) {
            selectors.add(column.selectorName());
        }
        return selectors;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

