/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.model.Visitors;
import org.modeshape.graph.query.parse.InvalidQueryException;
import org.modeshape.graph.query.parse.QueryParser;
import org.modeshape.graph.query.plan.PlanHints;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrEmptyNodeIterator;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.SessionCache;
import org.modeshape.jcr.api.query.qom.QueryObjectModelFactory;
import org.modeshape.jcr.query.JcrQuery;
import org.modeshape.jcr.query.JcrQueryContext;
import org.modeshape.jcr.query.JcrSearch;
import org.modeshape.jcr.query.JcrTypeSystem;
import org.modeshape.jcr.query.qom.JcrQueryObjectModel;
import org.modeshape.jcr.query.qom.JcrQueryObjectModelFactory;
import org.modeshape.jcr.query.qom.JcrSelectQuery;
import org.modeshape.jcr.query.qom.JcrSetQuery;
import org.modeshape.jcr.query.qom.JcrSetQueryObjectModel;

@Immutable
class JcrQueryManager
implements QueryManager {
    public static final int MAXIMUM_RESULTS_FOR_FULL_TEXT_SEARCH_QUERIES = Integer.MAX_VALUE;
    private final JcrSession session;
    private final JcrQueryContext context;
    private final JcrTypeSystem typeSystem;
    private final QueryObjectModelFactory factory;

    JcrQueryManager(JcrSession session) {
        this.session = session;
        this.context = new SessionQueryContext(this.session);
        this.typeSystem = new SessionTypeSystem(this.session);
        this.factory = new JcrQueryObjectModelFactory(this.context);
    }

    public javax.jcr.query.qom.QueryObjectModelFactory getQOMFactory() {
        return this.factory;
    }

    public Query createQuery(String statement, String language) throws javax.jcr.query.InvalidQueryException, RepositoryException {
        CheckArg.isNotNull(statement, "statement");
        CheckArg.isNotNull(language, "language");
        return this.createQuery(statement, language, null);
    }

    public Query createQuery(String expression, String language, Path storedAtPath) throws javax.jcr.query.InvalidQueryException, RepositoryException {
        this.session.checkLive();
        QueryParser parser = this.session.repository().queryParsers().getParserFor(language);
        if (parser == null) {
            Set<String> languages = this.session.repository().queryParsers().getLanguages();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.invalidQueryLanguage.text(language, languages));
        }
        if (parser.getLanguage().equals("Search")) {
            return new JcrSearch(this.context, expression, parser.getLanguage(), storedAtPath);
        }
        try {
            QueryCommand command = parser.parseQuery(expression, this.typeSystem);
            if (command == null) {
                throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryCannotBeParsedUsingLanguage.text(language, expression));
            }
            PlanHints hints = new PlanHints();
            hints.showPlan = true;
            hints.hasFullTextSearch = true;
            hints.validateColumnExistance = false;
            return this.resultWith(expression, parser.getLanguage(), command, hints, storedAtPath);
        }
        catch (ParsingException e) {
            String reason = e.getMessage();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryCannotBeParsedUsingLanguage.text(language, expression, reason));
        }
        catch (InvalidQueryException e) {
            String reason = e.getMessage();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryInLanguageIsNotValid.text(language, expression, reason));
        }
    }

    public Query createQuery(QueryCommand command) throws javax.jcr.query.InvalidQueryException, RepositoryException {
        this.session.checkLive();
        if (command == null) {
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryInLanguageIsNotValid.text("JCR-SQL2", command));
        }
        String expression = Visitors.readable(command);
        try {
            PlanHints hints = new PlanHints();
            hints.showPlan = true;
            hints.hasFullTextSearch = true;
            return this.resultWith(expression, "JCR-SQL2", command, hints, null);
        }
        catch (InvalidQueryException e) {
            String reason = e.getMessage();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryInLanguageIsNotValid.text("JCR-SQL2", expression, reason));
        }
    }

    public Query getQuery(Node node) throws javax.jcr.query.InvalidQueryException, RepositoryException {
        AbstractJcrNode jcrNode = CheckArg.getInstanceOf(node, AbstractJcrNode.class, "node");
        JcrNodeType nodeType = jcrNode.getPrimaryNodeType();
        if (!nodeType.getInternalName().equals(JcrNtLexicon.QUERY)) {
            NamespaceRegistry registry = this.session.getExecutionContext().getNamespaceRegistry();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.notStoredQuery.text(jcrNode.path().getString(registry)));
        }
        String statement = jcrNode.getProperty(JcrLexicon.STATEMENT).getString();
        String language = jcrNode.getProperty(JcrLexicon.LANGUAGE).getString();
        return this.createQuery(statement, language, jcrNode.path());
    }

    public String[] getSupportedQueryLanguages() {
        Set<String> languages = this.session.repository().queryParsers().getLanguages();
        return languages.toArray(new String[languages.size()]);
    }

    protected Query resultWith(String expression, String language, QueryCommand command, PlanHints hints, Path storedAtPath) {
        if (command instanceof JcrSelectQuery) {
            JcrSelectQuery query = (JcrSelectQuery)command;
            return new JcrQueryObjectModel(this.context, expression, language, query, hints, storedAtPath);
        }
        if (command instanceof JcrSetQuery) {
            JcrSetQuery query = (JcrSetQuery)command;
            return new JcrSetQueryObjectModel(this.context, expression, language, query, hints, storedAtPath);
        }
        return new JcrQuery(this.context, expression, language, command, hints, storedAtPath);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SessionTypeSystem
    implements JcrTypeSystem {
        protected final JcrSession session;
        protected final TypeSystem delegate;

        protected SessionTypeSystem(JcrSession session) {
            this.session = session;
            this.delegate = session.getExecutionContext().getValueFactories().getTypeSystem();
        }

        @Override
        public Set<String> getTypeNames() {
            return this.delegate.getTypeNames();
        }

        @Override
        public TypeSystem.TypeFactory<?> getTypeFactory(Object prototype) {
            return this.delegate.getTypeFactory(prototype);
        }

        @Override
        public TypeSystem.TypeFactory<?> getTypeFactory(String typeName) {
            return this.delegate.getTypeFactory(typeName);
        }

        @Override
        public TypeSystem.TypeFactory<String> getStringFactory() {
            return this.delegate.getStringFactory();
        }

        @Override
        public TypeSystem.TypeFactory<?> getReferenceFactory() {
            return this.delegate.getReferenceFactory();
        }

        @Override
        public TypeSystem.TypeFactory<?> getPathFactory() {
            return this.delegate.getPathFactory();
        }

        @Override
        public TypeSystem.TypeFactory<Long> getLongFactory() {
            return this.delegate.getLongFactory();
        }

        @Override
        public TypeSystem.TypeFactory<Double> getDoubleFactory() {
            return this.delegate.getDoubleFactory();
        }

        @Override
        public String getDefaultType() {
            return this.delegate.getDefaultType();
        }

        @Override
        public Comparator<Object> getDefaultComparator() {
            return this.delegate.getDefaultComparator();
        }

        @Override
        public TypeSystem.TypeFactory<BigDecimal> getDecimalFactory() {
            return this.delegate.getDecimalFactory();
        }

        @Override
        public TypeSystem.TypeFactory<?> getDateTimeFactory() {
            return this.delegate.getDateTimeFactory();
        }

        @Override
        public String getCompatibleType(String type1, String type2) {
            return this.delegate.getCompatibleType(type1, type2);
        }

        @Override
        public TypeSystem.TypeFactory<Boolean> getBooleanFactory() {
            return this.delegate.getBooleanFactory();
        }

        @Override
        public TypeSystem.TypeFactory<?> getBinaryFactory() {
            return this.delegate.getBinaryFactory();
        }

        @Override
        public String asString(Object value) {
            return this.delegate.asString(value);
        }

        @Override
        public ValueFactory getValueFactory() {
            return this.session.getValueFactory();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SessionQueryContext
    implements JcrQueryContext {
        private final JcrSession session;
        private final ValueFactories factories;
        private final SessionCache cache;

        protected SessionQueryContext(JcrSession session) {
            this.session = session;
            this.factories = session.getExecutionContext().getValueFactories();
            this.cache = session.cache();
        }

        @Override
        public Value createValue(int propertyType, Object value) {
            return new JcrValue(this.factories, this.cache, propertyType, value);
        }

        @Override
        public NodeIterator emptyNodeIterator() {
            return new JcrEmptyNodeIterator();
        }

        @Override
        public QueryResults execute(QueryCommand query, PlanHints hints, Map<String, Object> variables) throws RepositoryException {
            this.session.checkLive();
            Schemata schemata = this.session.workspace().nodeTypeManager().schemata();
            return this.session.repository().queryManager().query(this.session.workspace().getName(), query, schemata, hints, variables);
        }

        @Override
        public ExecutionContext getExecutionContext() {
            return this.session.getExecutionContext();
        }

        @Override
        public Node getNode(Location location) throws RepositoryException {
            if (!this.session.wasRemovedInSession(location)) {
                try {
                    return this.session.getNode(location.getPath());
                }
                catch (PathNotFoundException e) {
                }
                catch (AccessDeniedException accessDeniedException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public Schemata getSchemata() {
            return this.session.nodeTypeManager().schemata();
        }

        @Override
        public boolean isLive() {
            return this.session.isLive();
        }

        @Override
        public QueryResults search(String searchExpression, int maxRowCount, int offset) throws RepositoryException {
            return this.session.repository().queryManager().search(this.session.workspace().getName(), searchExpression, maxRowCount, offset);
        }

        @Override
        public Node store(String absolutePath, Name nodeType, String language, String statement) throws RepositoryException {
            Path path;
            this.session.checkLive();
            NamespaceRegistry namespaces = this.session.namespaces();
            try {
                path = (Path)this.session.getExecutionContext().getValueFactories().getPathFactory().create(absolutePath);
            }
            catch (IllegalArgumentException iae) {
                throw new RepositoryException(JcrI18n.invalidPathParameter.text("absolutePath", absolutePath));
            }
            Path parentPath = path.getParent();
            AbstractJcrNode parentNode = this.session.getNode(parentPath);
            if (!parentNode.isCheckedOut()) {
                throw new VersionException(JcrI18n.nodeIsCheckedIn.text(parentNode.getPath()));
            }
            Node queryNode = parentNode.addNode(path.relativeTo(parentPath).getString(namespaces), JcrNtLexicon.QUERY.getString(namespaces));
            queryNode.setProperty(JcrLexicon.LANGUAGE.getString(namespaces), language);
            queryNode.setProperty(JcrLexicon.STATEMENT.getString(namespaces), statement);
            return queryNode;
        }
    }
}

