/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.text.Jsr283Encoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Results;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ReferenceFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.request.FunctionRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrChildNodeIterator;
import org.modeshape.jcr.JcrGraph;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrVersionHistoryNode;
import org.modeshape.jcr.JcrVersionNode;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.ModeShapeIntLexicon;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.PropertyDefinitionId;
import org.modeshape.jcr.SessionCache;
import org.modeshape.jcr.SystemFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JcrVersionManager
implements VersionManager {
    private static final Logger LOGGER = Logger.getLogger(JcrVersionManager.class);
    protected static final TextEncoder NODE_ENCODER = new Jsr283Encoder();
    static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    static final Set<Name> IGNORED_PROP_NAMES_FOR_RESTORE = Collections.unmodifiableSet(new HashSet<Name>(Arrays.asList(JcrLexicon.FROZEN_PRIMARY_TYPE, JcrLexicon.FROZEN_MIXIN_TYPES, JcrLexicon.FROZEN_UUID, JcrLexicon.PRIMARY_TYPE, JcrLexicon.MIXIN_TYPES, JcrLexicon.UUID)));
    private final JcrSession session;
    protected final Path versionStoragePath;
    private final PathAlgorithm hiearchicalPathAlgorithm;
    private final PathAlgorithm flatPathAlgorithm;
    private final PathAlgorithm versionHistoryPathAlgorithm;

    public JcrVersionManager(JcrSession session) {
        this.session = session;
        this.versionStoragePath = this.absolutePath(JcrLexicon.SYSTEM, JcrLexicon.VERSION_STORAGE);
        String storageFormat = session.repository().getOptions().get((Object)JcrRepository.Option.VERSION_HISTORY_STRUCTURE);
        if (storageFormat != null) {
            storageFormat = storageFormat.trim().toLowerCase();
        }
        ExecutionContext context = session.getExecutionContext();
        boolean isHier = "hierarchical".equals(storageFormat);
        this.hiearchicalPathAlgorithm = new HiearchicalPathAlgorithm(this.versionStoragePath, context);
        this.flatPathAlgorithm = new FlatPathAlgorithm(this.versionStoragePath, context);
        this.versionHistoryPathAlgorithm = isHier ? this.hiearchicalPathAlgorithm : this.flatPathAlgorithm;
    }

    ExecutionContext context() {
        return this.session.getExecutionContext();
    }

    private ValueFactories factories() {
        return this.context().getValueFactories();
    }

    UUID uuid(Object ob) {
        return (UUID)this.factories().getUuidFactory().create(ob);
    }

    Name name(String s) {
        return (Name)this.factories().getNameFactory().create(s);
    }

    Name name(Object ob) {
        return (Name)this.factories().getNameFactory().create(ob);
    }

    final Path path(Path root, Name child) {
        return this.factories().getPathFactory().create(root, child);
    }

    Path path(Path root, Path.Segment childSegment) {
        return this.factories().getPathFactory().create(root, childSegment);
    }

    private Path absolutePath(Name ... absolutePathSegments) {
        return this.factories().getPathFactory().createAbsolutePath(absolutePathSegments);
    }

    DateTime dateTime(Calendar cal) {
        return (DateTime)this.factories().getDateFactory().create(cal);
    }

    private PropertyFactory propertyFactory() {
        return this.context().getPropertyFactory();
    }

    SessionCache cache() {
        return this.session.cache();
    }

    private JcrRepository repository() {
        return this.session.repository();
    }

    JcrSession session() {
        return this.session;
    }

    JcrWorkspace workspace() {
        return this.session.workspace();
    }

    Path versionHistoryPathFor(UUID uuid) {
        return this.versionHistoryPathAlgorithm.versionHistoryPathFor(uuid);
    }

    JcrVersionHistoryNode getVersionHistory(AbstractJcrNode node) throws RepositoryException {
        this.session.checkLive();
        this.checkVersionable(node);
        Location historyLocation = Location.create(this.versionHistoryPathFor(node.uuid()));
        try {
            return (JcrVersionHistoryNode)this.cache().findJcrNode(historyLocation);
        }
        catch (ItemNotFoundException infe) {
            if (this.versionHistoryPathAlgorithm != this.flatPathAlgorithm) {
                try {
                    Location flatHistoryLocation = Location.create(this.versionHistoryPathFor(node.uuid()));
                    return (JcrVersionHistoryNode)this.cache().findJcrNode(flatHistoryLocation);
                }
                catch (ItemNotFoundException nested) {
                    // empty catch block
                }
            }
            this.initializeVersionHistoryFor(node);
            JcrVersionHistoryNode historyNode = (JcrVersionHistoryNode)this.cache().findJcrNode(historyLocation);
            LOGGER.debug("Repaired version storage located at: {0}", historyLocation);
            return historyNode;
        }
    }

    JcrNodeDefinition nodeDefinitionFor(GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> node) throws RepositoryException {
        NodeDefinitionId nodeDefnId = node.getPayload().getDefinitionId();
        return this.session().nodeTypeManager().getNodeDefinition(nodeDefnId);
    }

    JcrVersionNode checkin(AbstractJcrNode node) throws RepositoryException {
        this.session.checkLive();
        this.checkVersionable(node);
        if (node.isNew() || node.isModified()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowed.text(new Object[0]));
        }
        if (node.isLocked() && !node.holdsLock()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(node.getPath()));
        }
        if (node.getProperty(JcrLexicon.MERGE_FAILED) != null) {
            throw new VersionException(JcrI18n.pendingMergeConflicts.text(node.getPath()));
        }
        AbstractJcrProperty isCheckedOut = node.getProperty(JcrLexicon.IS_CHECKED_OUT);
        if (!isCheckedOut.getBoolean()) {
            return node.getBaseVersion();
        }
        UUID jcrUuid = node.uuid();
        Name primaryTypeName = node.getPrimaryTypeName();
        List<Name> mixinTypeNames = node.getMixinTypeNames();
        Property predecessorsProp = node.getProperty(JcrLexicon.PREDECESSORS).property();
        List<Property> versionedProperties = this.versionedPropertiesFor(node, false);
        Path historyPath = this.versionHistoryPathFor(jcrUuid);
        DateTime now = this.context().getValueFactories().getDateFactory().create();
        Name versionName = this.name(NODE_ENCODER.encode(now.getString()));
        Path versionPath = this.path(historyPath, versionName);
        Path frozenVersionPath = this.path(versionPath, JcrLexicon.FROZEN_NODE);
        JcrGraph systemGraph = this.repository().createSystemGraph(this.context());
        Graph.Batch systemBatch = systemGraph.batch();
        systemBatch.applyFunction(SystemFunctions.CREATE_VERSION_NODE).withInput("versionHistoryPath", historyPath).withInput("versionName", versionName).withInput("versionedNodeUuid", jcrUuid).withInput("primaryTypeName", primaryTypeName).withInput("mixinTypeNameList", mixinTypeNames).withInput("predecessorProperty", predecessorsProp).withInput("versionPropertyList", versionedProperties).to(this.versionStoragePath);
        NodeIterator childNodes = node.getNodes();
        while (childNodes.hasNext()) {
            AbstractJcrNode childNode = (AbstractJcrNode)childNodes.nextNode();
            this.versionNodeAt(childNode, frozenVersionPath, systemBatch, false);
        }
        Results results = systemBatch.execute();
        List<Request> requests = results.getRequests();
        FunctionRequest createVersionFunction = (FunctionRequest)requests.get(0);
        if (createVersionFunction.hasError()) {
            Throwable error = createVersionFunction.getError();
            String msg = JcrI18n.errorDuringCheckinNode.text(node.getPath(), error.getMessage());
            throw new VersionException(msg, error);
        }
        Path highestChanged = (Path)createVersionFunction.output("pathOfHighestModifiedNode");
        UUID versionHistoryUuid = (UUID)createVersionFunction.output("versionHistoryUuid");
        UUID versionUuid = (UUID)createVersionFunction.output("versionUuid");
        versionPath = (Path)createVersionFunction.output("versionPath");
        Location versionLocation = Location.create(versionPath, versionUuid);
        Path refreshPath = highestChanged.getParent();
        this.cache().refresh(refreshPath, false);
        if (!refreshPath.isAtOrAbove(historyPath)) {
            this.cache().refresh(historyPath, false);
        }
        AbstractJcrNode newVersion = this.cache().findJcrNode(versionLocation);
        SessionCache.NodeEditor editor = node.editor();
        editor.setProperty(JcrLexicon.PREDECESSORS, node.valuesFrom(9, EMPTY_OBJECT_ARRAY), 9, false);
        editor.setProperty(JcrLexicon.VERSION_HISTORY, node.valueFrom(versionHistoryUuid), false, false);
        editor.setProperty(JcrLexicon.BASE_VERSION, node.valueFrom(versionUuid), false, false);
        editor.setProperty(JcrLexicon.IS_CHECKED_OUT, node.valueFrom(6, false), false, false);
        node.save();
        return (JcrVersionNode)newVersion;
    }

    private void versionNodeAt(AbstractJcrNode node, Path verisonedParentPath, Graph.Batch batch, boolean forceCopy) throws RepositoryException {
        Path childPath = this.path(verisonedParentPath, node.path().getLastSegment());
        int onParentVersion = 0;
        onParentVersion = forceCopy ? 1 : node.getDefinition().getOnParentVersion();
        switch (onParentVersion) {
            case 6: {
                throw new VersionException(JcrI18n.cannotCheckinNodeWithAbortChildNode.text(node.getName(), node.getParent().getName()));
            }
            case 2: {
                if (node.isNodeType(JcrMixLexicon.VERSIONABLE)) {
                    JcrVersionHistoryNode history = node.getVersionHistory();
                    UUID historyUuid = history.uuid();
                    batch.create(childPath).with(JcrLexicon.PRIMARY_TYPE, JcrNtLexicon.VERSIONED_CHILD).with(JcrLexicon.CHILD_VERSION_HISTORY, historyUuid).and();
                    return;
                }
            }
            case 1: {
                forceCopy = true;
                Name primaryTypeName = node.getPrimaryTypeName();
                List<Name> mixinTypeNames = node.getMixinTypeNames();
                UUID uuid = UUID.randomUUID();
                if (node.isReferenceable()) {
                    uuid = node.uuid();
                }
                batch.create(childPath).with(JcrLexicon.PRIMARY_TYPE, JcrNtLexicon.FROZEN_NODE).and(JcrLexicon.FROZEN_PRIMARY_TYPE, primaryTypeName).and(JcrLexicon.FROZEN_MIXIN_TYPES, mixinTypeNames).and(JcrLexicon.FROZEN_UUID, uuid).and(this.versionedPropertiesFor(node, forceCopy)).and();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                return;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + onParentVersion);
            }
        }
        NodeIterator childNodes = node.getNodes();
        while (childNodes.hasNext()) {
            AbstractJcrNode childNode = (AbstractJcrNode)childNodes.nextNode();
            this.versionNodeAt(childNode, childPath, batch, forceCopy);
        }
    }

    private List<Property> versionedPropertiesFor(AbstractJcrNode node, boolean forceCopy) throws RepositoryException {
        LinkedList<Property> props = new LinkedList<Property>();
        AbstractJcrProperty multiValuedProperties = node.getProperty(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES);
        if (multiValuedProperties != null) {
            props.add(multiValuedProperties.property());
        }
        PropertyIterator iter = node.getProperties();
        while (iter.hasNext()) {
            AbstractJcrProperty property = (AbstractJcrProperty)iter.nextProperty();
            Name name = property.name();
            if (JcrLexicon.PRIMARY_TYPE.equals(name) || JcrLexicon.MIXIN_TYPES.equals(name) || JcrLexicon.UUID.equals(name)) continue;
            Property prop = property.property();
            if (forceCopy) {
                props.add(prop);
                continue;
            }
            PropertyDefinitionId propDefnId = property.propertyInfo().getPayload().getPropertyDefinitionId();
            JcrPropertyDefinition propDefn = this.cache().nodeTypes().getPropertyDefinition(propDefnId);
            switch (propDefn.getOnParentVersion()) {
                case 6: {
                    I18n msg = JcrI18n.cannotCheckinNodeWithAbortProperty;
                    throw new VersionException(msg.text(property.getName(), node.getName()));
                }
                case 1: 
                case 2: {
                    props.add(prop);
                    break;
                }
            }
        }
        return props;
    }

    void checkout(AbstractJcrNode node) throws LockException, RepositoryException {
        Property multiValuedProps;
        this.session.checkLive();
        this.checkVersionable(node);
        if (node.isLocked() && !node.holdsLock()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(node.getPath()));
        }
        if (!node.hasProperty(JcrLexicon.BASE_VERSION)) {
            return;
        }
        if (node.getProperty(JcrLexicon.IS_CHECKED_OUT).getBoolean()) {
            return;
        }
        PropertyFactory propFactory = this.propertyFactory();
        GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload> mvProp = node.nodeInfo().getProperty(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES);
        Property property = multiValuedProps = mvProp != null ? mvProp.getProperty() : null;
        if (multiValuedProps == null) {
            multiValuedProps = propFactory.create(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES, JcrLexicon.PREDECESSORS);
        } else if (!Arrays.asList(multiValuedProps.getValues()).contains(JcrLexicon.PREDECESSORS)) {
            LinkedList<Object> values = new LinkedList<Object>();
            for (Object value : multiValuedProps) {
                values.add(value);
            }
            values.add(JcrLexicon.PREDECESSORS);
            multiValuedProps = propFactory.create(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES, values);
        }
        ReferenceFactory refFactory = this.context().getValueFactories().getReferenceFactory();
        Object[] newPreds = new Object[]{refFactory.create(node.getBaseVersion().uuid())};
        Property isCheckedOut = propFactory.create(JcrLexicon.IS_CHECKED_OUT, true);
        Property predecessors = propFactory.create(JcrLexicon.PREDECESSORS, newPreds);
        JcrGraph graph = this.workspace().graph();
        Location location = Location.create(node.uuid());
        graph.set(isCheckedOut, predecessors, multiValuedProps).on(location).and();
        this.cache().refreshProperties(location);
    }

    public void restore(Version[] versions, boolean removeExisting) throws RepositoryException {
        this.session.checkLive();
        if (this.session.hasPendingChanges()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowed.text(new Object[0]));
        }
        HashMap<Version, AbstractJcrNode> existingVersions = new HashMap<Version, AbstractJcrNode>(versions.length);
        HashSet<Path> versionRootPaths = new HashSet<Path>(versions.length);
        ArrayList<Version> nonExistingVersions = new ArrayList<Version>(versions.length);
        for (int i = 0; i < versions.length; ++i) {
            VersionHistory history = versions[i].getContainingHistory();
            if (history.getRootVersion().isSame((Item)versions[i])) {
                throw new VersionException(JcrI18n.cannotRestoreRootVersion.text(versions[i].getPath()));
            }
            try {
                AbstractJcrNode existingNode = this.session.getNodeByIdentifier(history.getVersionableIdentifier());
                existingVersions.put(versions[i], existingNode);
                versionRootPaths.add(existingNode.path());
                continue;
            }
            catch (ItemNotFoundException infe) {
                nonExistingVersions.add(versions[i]);
            }
        }
        if (existingVersions.isEmpty()) {
            throw new VersionException(JcrI18n.noExistingVersionForRestore.text(new Object[0]));
        }
        RestoreCommand op = new RestoreCommand(existingVersions, versionRootPaths, nonExistingVersions, null, removeExisting);
        op.execute();
        this.session.save();
    }

    void restore(Path path, Version version, String labelToRestore, boolean removeExisting) throws RepositoryException {
        AbstractJcrNode nodeToCheckLock;
        this.session.checkLive();
        if (this.session().hasPendingChanges()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowed.text(new Object[0]));
        }
        AbstractJcrNode parentNode = this.cache().findJcrNode(null, path.getParent());
        AbstractJcrNode existingNode = null;
        JcrVersionNode jcrVersion = (JcrVersionNode)version;
        try {
            nodeToCheckLock = existingNode = this.cache().findJcrNode(null, path);
            JcrVersionHistoryNode versionHistory = existingNode.getVersionHistory();
            if (!versionHistory.isSame(jcrVersion.getParent())) {
                throw new VersionException(JcrI18n.invalidVersion.text(version.getPath(), versionHistory.getPath()));
            }
            if (!versionHistory.isSame(existingNode.getVersionHistory())) {
                throw new VersionException(JcrI18n.invalidVersion.text(version.getPath(), existingNode.getVersionHistory().getPath()));
            }
            if (jcrVersion.isSame(versionHistory.getRootVersion())) {
                throw new VersionException(JcrI18n.cannotRestoreRootVersion.text(existingNode.getPath()));
            }
        }
        catch (ItemNotFoundException pnfe) {
            if (!parentNode.isCheckedOut()) {
                String parentPath = path.getString(this.context().getNamespaceRegistry());
                throw new VersionException(JcrI18n.nodeIsCheckedIn.text(parentPath));
            }
            AbstractJcrNode sourceNode = this.frozenNodeFor(version);
            Name primaryTypeName = this.name(sourceNode.getProperty(JcrLexicon.FROZEN_PRIMARY_TYPE).property().getFirstValue());
            AbstractJcrProperty uuidProp = sourceNode.getProperty(JcrLexicon.FROZEN_UUID);
            UUID desiredUuid = this.uuid(uuidProp.property().getFirstValue());
            existingNode = parentNode.editor().createChild(path.getLastSegment().getName(), desiredUuid, primaryTypeName);
            nodeToCheckLock = parentNode;
        }
        if (nodeToCheckLock.isLocked() && !nodeToCheckLock.holdsLock()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(nodeToCheckLock.getPath()));
        }
        RestoreCommand op = new RestoreCommand(Collections.singletonMap(version, existingNode), Collections.singleton(existingNode.path()), Collections.<Version>emptySet(), labelToRestore, removeExisting);
        op.execute();
        SessionCache.NodeEditor editor = existingNode.editor();
        editor.setProperty(JcrLexicon.IS_CHECKED_OUT, existingNode.valueFrom(6, false), false, false);
        editor.setProperty(JcrLexicon.BASE_VERSION, existingNode.valueFrom(jcrVersion), false, false);
        this.session().save();
    }

    AbstractJcrNode frozenNodeFor(Version version) throws RepositoryException {
        return ((AbstractJcrNode)version).getNode(JcrLexicon.FROZEN_NODE);
    }

    void doneMerge(AbstractJcrNode targetNode, Version version) throws RepositoryException {
        this.session.checkLive();
        this.checkVersionable(targetNode);
        if (targetNode.isNew() || targetNode.isModified()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowedForNode.text(new Object[0]));
        }
        if (!targetNode.isNodeType(JcrMixLexicon.VERSIONABLE)) {
            throw new VersionException(JcrI18n.requiresVersionable.text(new Object[0]));
        }
        AbstractJcrProperty prop = targetNode.getProperty(JcrLexicon.PREDECESSORS);
        JcrValue[] values = (JcrValue[])prop.getValues();
        Value[] newValues = new JcrValue[values.length + 1];
        System.arraycopy(values, 0, newValues, 0, values.length);
        newValues[values.length] = targetNode.valueFrom((Node)version);
        targetNode.editor().setProperty(JcrLexicon.PREDECESSORS, newValues, 9, false);
        this.removeVersionFromMergeFailedProperty(targetNode, version);
        targetNode.save();
    }

    void cancelMerge(AbstractJcrNode targetNode, Version version) throws RepositoryException {
        this.session.checkLive();
        this.checkVersionable(targetNode);
        if (targetNode.isNew() || targetNode.isModified()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowedForNode.text(new Object[0]));
        }
        if (!targetNode.isNodeType(JcrMixLexicon.VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException(JcrI18n.requiresVersionable.text(new Object[0]));
        }
        this.removeVersionFromMergeFailedProperty(targetNode, version);
        targetNode.save();
    }

    private void removeVersionFromMergeFailedProperty(AbstractJcrNode targetNode, Version version) throws RepositoryException {
        if (!targetNode.hasProperty(JcrLexicon.MERGE_FAILED)) {
            throw new VersionException(JcrI18n.versionNotInMergeFailed.text(version.getName(), targetNode.getPath()));
        }
        AbstractJcrProperty prop = targetNode.getProperty(JcrLexicon.MERGE_FAILED);
        Value[] values = prop.getValues();
        String uuidString = version.getUUID();
        int matchIndex = -1;
        for (int i = 0; i < values.length; ++i) {
            if (!uuidString.equals(values[i].getString())) continue;
            matchIndex = i;
            break;
        }
        if (matchIndex == -1) {
            throw new VersionException(JcrI18n.versionNotInMergeFailed.text(version.getName(), targetNode.getPath()));
        }
        if (values.length == 1) {
            prop.remove();
        } else {
            Value[] newValues = new JcrValue[values.length - 2];
            if (matchIndex == 0) {
                System.arraycopy(values, 1, newValues, 0, values.length - 1);
            } else if (matchIndex == values.length - 1) {
                System.arraycopy(values, 0, newValues, 0, values.length - 2);
            } else {
                System.arraycopy(values, 0, newValues, 0, matchIndex);
                System.arraycopy(values, matchIndex + 1, newValues, matchIndex, values.length - matchIndex - 1);
            }
            prop.setValue(newValues);
        }
    }

    NodeIterator merge(AbstractJcrNode targetNode, String srcWorkspace, boolean bestEffort, boolean isShallow) throws RepositoryException {
        this.session.checkLive();
        if (this.session().hasPendingChanges()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowed.text(new Object[0]));
        }
        try {
            targetNode.correspondingNodePath(srcWorkspace);
        }
        catch (ItemNotFoundException infe) {
            return new JcrChildNodeIterator(Collections.<AbstractJcrNode>emptySet(), 0);
        }
        JcrSession sourceSession = this.session().with(srcWorkspace);
        MergeCommand op = new MergeCommand(targetNode, sourceSession, bestEffort, isShallow);
        op.execute();
        this.session.save();
        return op.getFailures();
    }

    void restoreProperty(AbstractJcrProperty property, SessionCache.NodeEditor editor) throws RepositoryException {
        Name propName = property.name();
        editor.removeProperty(propName);
        if (property.isMultiple()) {
            Value[] values = (JcrValue[])property.getValues();
            editor.setProperty(propName, values, property.getType(), false);
        } else {
            JcrValue value = (JcrValue)property.getValue();
            editor.setProperty(propName, value, false, false);
        }
    }

    void initializeVersionHistoryFor(AbstractJcrNode node) throws RepositoryException {
        this.initializeVersionHistoryFor(node, null);
    }

    void initializeVersionHistoryFor(AbstractJcrNode node, UUID originalVersionUuid) throws RepositoryException {
        Graph.Batch batch = this.session().createBatch();
        this.initializeVersionHistoryFor(batch, node.nodeInfo(), originalVersionUuid, true);
        if (batch.isExecuteRequired()) {
            batch.execute();
            this.cache().refresh(node.internalId(), node.path(), true);
        }
    }

    void initializeVersionHistoryFor(Graph.Batch batch, GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> node, UUID originalVersionUuid, boolean forceWrite) throws RepositoryException {
        boolean initialized;
        if (!this.cache().isVersionable(node)) {
            return;
        }
        boolean bl = initialized = node.getProperty(JcrLexicon.IS_CHECKED_OUT) != null;
        if (!forceWrite && initialized) {
            return;
        }
        SessionCache.JcrNodePayload payload = node.getPayload();
        Name primaryTypeName = payload.getPrimaryTypeName();
        List<Name> mixinTypeNames = payload.getMixinTypeNames();
        GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload> jcrUuidProp = node.getProperty(JcrLexicon.UUID);
        UUID jcrUuid = this.uuid(jcrUuidProp.getProperty().getFirstValue());
        Path historyPath = this.versionHistoryPathFor(jcrUuid);
        Map outputs = null;
        JcrGraph systemGraph = this.session().repository().createSystemGraph(this.context());
        outputs = (Map)systemGraph.applyFunction(SystemFunctions.INITIALIZE_VERSION_HISTORY).withInput("versionedNodeUuid", jcrUuid).withInput("originalUuid", originalVersionUuid).withInput("versionHistoryPath", historyPath).withInput("primaryTypeName", primaryTypeName).withInput("mixinTypeNameList", mixinTypeNames).to(this.versionStoragePath);
        List predecessorUuids = (List)outputs.get("predecessorUuidList");
        UUID baseVersionUuid = (UUID)outputs.get("baseVersionUuid");
        UUID historyUuid = (UUID)outputs.get("versionHistoryUuid");
        Path highestModifiedPath = (Path)outputs.get("pathOfHighestModifiedNode");
        ReferenceFactory refFactory = this.context().getValueFactories().getReferenceFactory();
        Object[] predecessorRefs = new Object[predecessorUuids.size()];
        if (!predecessorUuids.isEmpty()) {
            int i = 0;
            for (UUID existingPredecessor : predecessorUuids) {
                assert (existingPredecessor != null);
                predecessorRefs[i++] = refFactory.create(existingPredecessor);
            }
        }
        Reference historyRef = (Reference)refFactory.create(historyUuid);
        Reference baseVersionRef = (Reference)refFactory.create(baseVersionUuid);
        PropertyFactory propFactory = this.propertyFactory();
        Property isCheckedOut = propFactory.create(JcrLexicon.IS_CHECKED_OUT, true);
        Property versionHistory = propFactory.create(JcrLexicon.VERSION_HISTORY, historyRef);
        Property baseVersion = propFactory.create(JcrLexicon.BASE_VERSION, baseVersionRef);
        Property predecessors = propFactory.create(JcrLexicon.PREDECESSORS, predecessorRefs);
        batch.set(isCheckedOut, versionHistory, baseVersion, predecessors).on(node.getPath()).and();
        Path refreshPath = historyPath;
        if (highestModifiedPath != null && highestModifiedPath.isAncestorOf(historyPath)) {
            refreshPath = highestModifiedPath;
        }
        this.cache().refresh(refreshPath.getParent(), false);
    }

    public void cancelMerge(String absPath, Version version) throws VersionException, InvalidItemStateException, RepositoryException {
        this.cancelMerge(this.session.getNode(absPath), version);
    }

    private void checkVersionable(AbstractJcrNode node) throws UnsupportedRepositoryOperationException, RepositoryException {
        if (!node.isNodeType(JcrMixLexicon.VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException(JcrI18n.requiresVersionable.text(new Object[0]));
        }
    }

    public Version checkin(String absPath) throws VersionException, InvalidItemStateException, LockException, RepositoryException {
        return this.checkin(this.session.getNode(absPath));
    }

    public void checkout(String absPath) throws LockException, RepositoryException {
        this.checkout(this.session.getNode(absPath));
    }

    public Version checkpoint(String absPath) throws VersionException, InvalidItemStateException, LockException, RepositoryException {
        Version version = this.checkin(absPath);
        this.checkout(absPath);
        return version;
    }

    public void doneMerge(String absPath, Version version) throws VersionException, InvalidItemStateException, RepositoryException {
        this.doneMerge(this.session.getNode(absPath), version);
    }

    public Node getActivity() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public Version getBaseVersion(String absPath) throws RepositoryException {
        return this.session.getNode(absPath).getBaseVersion();
    }

    public VersionHistory getVersionHistory(String absPath) throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.session.getNode(absPath).getVersionHistory();
    }

    public boolean isCheckedOut(String absPath) throws RepositoryException {
        AbstractJcrNode node = this.session.getNode(absPath);
        return node.isCheckedOut();
    }

    public NodeIterator merge(Node activityNode) throws VersionException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeIterator merge(String absPath, String srcWorkspace, boolean bestEffort, boolean isShallow) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        CheckArg.isNotNull(srcWorkspace, "source workspace name");
        AbstractJcrNode node = this.session.getNode(absPath);
        return this.merge(node, srcWorkspace, bestEffort, isShallow);
    }

    public NodeIterator merge(String absPath, String srcWorkspace, boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        return this.merge(absPath, srcWorkspace, bestEffort, false);
    }

    public void restore(String absPath, String versionName, boolean removeExisting) throws VersionException, ItemExistsException, LockException, InvalidItemStateException, RepositoryException {
        Version version = null;
        Path path = this.session.pathFor(absPath, "absPath");
        AbstractJcrNode existingNode = this.session.getNode(path);
        JcrVersionHistoryNode historyNode = existingNode.getVersionHistory();
        if (historyNode != null) {
            version = historyNode.getVersion(versionName);
        }
        assert (version != null);
        this.restore(path, version, null, removeExisting);
    }

    public void restore(String absPath, Version version, boolean removeExisting) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, LockException, InvalidItemStateException, RepositoryException {
        Path path = this.session.pathFor(absPath, "absPath");
        this.restore(path, version, null, removeExisting);
    }

    public void restore(Version version, boolean removeExisting) throws VersionException, ItemExistsException, InvalidItemStateException, LockException, RepositoryException {
        AbstractJcrNode node = this.session.getNodeByIdentifier(version.getContainingHistory().getVersionableIdentifier());
        Path path = node.path();
        this.restore(path, version, null, removeExisting);
    }

    public void restoreByLabel(String absPath, String versionLabel, boolean removeExisting) throws VersionException, ItemExistsException, LockException, InvalidItemStateException, RepositoryException {
        this.session.getNode(absPath).restoreByLabel(versionLabel, removeExisting);
    }

    public Node setActivity(Node activity) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void removeActivity(Node activityNode) throws UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public Node createActivity(String title) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public Node createConfiguration(String absPath) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    protected static class FlatPathAlgorithm
    extends BasePathAlgorithm {
        protected FlatPathAlgorithm(Path versionStoragePath, ExecutionContext context) {
            super(versionStoragePath, context);
        }

        public Path versionHistoryPathFor(UUID uuid) {
            return this.paths.createAbsolutePath(JcrLexicon.SYSTEM, JcrLexicon.VERSION_STORAGE, (Name)this.names.create(uuid.toString()));
        }
    }

    protected static class HiearchicalPathAlgorithm
    extends BasePathAlgorithm {
        protected HiearchicalPathAlgorithm(Path versionStoragePath, ExecutionContext context) {
            super(versionStoragePath, context);
        }

        public Path versionHistoryPathFor(UUID uuid) {
            String uuidStr = uuid.toString();
            Name p1 = (Name)this.names.create(uuidStr.substring(0, 2));
            Name p2 = (Name)this.names.create(uuidStr.substring(2, 4));
            Name p3 = (Name)this.names.create(uuidStr.substring(4, 6));
            Name p4 = (Name)this.names.create(uuidStr.substring(6, 8));
            Name p5 = (Name)this.names.create(uuidStr.substring(9));
            return this.paths.createAbsolutePath(JcrLexicon.SYSTEM, JcrLexicon.VERSION_STORAGE, p1, p2, p3, p4, p5);
        }
    }

    protected static abstract class BasePathAlgorithm
    implements PathAlgorithm {
        protected final PathFactory paths;
        protected final NameFactory names;
        protected final Path versionStoragePath;

        protected BasePathAlgorithm(Path versionStoragePath, ExecutionContext context) {
            this.paths = context.getValueFactories().getPathFactory();
            this.names = context.getValueFactories().getNameFactory();
            this.versionStoragePath = versionStoragePath;
        }
    }

    protected static interface PathAlgorithm {
        public Path versionHistoryPathFor(UUID var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    private class MergeCommand {
        private final Collection<AbstractJcrNode> failures;
        private final AbstractJcrNode targetNode;
        private final boolean bestEffort;
        private final boolean isShallow;
        private final JcrSession sourceSession;
        private final String workspaceName;

        public MergeCommand(AbstractJcrNode targetNode, JcrSession sourceSession, boolean bestEffort, boolean isShallow) {
            this.targetNode = targetNode;
            this.sourceSession = sourceSession;
            this.bestEffort = bestEffort;
            this.isShallow = isShallow;
            this.workspaceName = sourceSession.getWorkspace().getName();
            this.failures = new LinkedList<AbstractJcrNode>();
        }

        final JcrChildNodeIterator getFailures() {
            return new JcrChildNodeIterator(this.failures, this.failures.size());
        }

        void execute() throws RepositoryException {
            this.doMerge(this.targetNode);
        }

        private void doMerge(AbstractJcrNode targetNode) throws RepositoryException {
            JcrVersionNode targetVersion;
            AbstractJcrNode sourceNode;
            Path sourcePath = targetNode.correspondingNodePath(this.workspaceName);
            try {
                sourceNode = this.sourceSession.getNode(sourcePath);
            }
            catch (ItemNotFoundException infe) {
                this.doLeave(targetNode);
                return;
            }
            if (!targetNode.isNodeType(JcrMixLexicon.VERSIONABLE)) {
                this.doUpdate(targetNode, sourceNode);
                return;
            }
            if (!sourceNode.isNodeType(JcrMixLexicon.VERSIONABLE)) {
                this.doLeave(targetNode);
                return;
            }
            JcrVersionNode sourceVersion = sourceNode.getBaseVersion();
            if (sourceVersion.isSuccessorOf(targetVersion = targetNode.getBaseVersion()) && !targetNode.isCheckedOut()) {
                this.doUpdate(targetNode, sourceNode);
                return;
            }
            if (targetVersion.isSuccessorOf(sourceVersion) || targetVersion.uuid().equals(sourceVersion.uuid())) {
                this.doLeave(targetNode);
                return;
            }
            this.doFail(targetNode, sourceVersion);
        }

        private void doLeave(AbstractJcrNode targetNode) throws RepositoryException {
            if (!this.isShallow) {
                NodeIterator iter = targetNode.getNodes();
                while (iter.hasNext()) {
                    this.doMerge((AbstractJcrNode)iter.nextNode());
                }
            }
        }

        private void doUpdate(AbstractJcrNode targetNode, AbstractJcrNode sourceNode) throws RepositoryException {
            this.restoreProperties(sourceNode, targetNode);
            LinkedHashMap<String, AbstractJcrNode> sourceNodes = this.childNodeMapFor(sourceNode);
            LinkedHashMap<String, AbstractJcrNode> targetNodes = this.childNodeMapFor(targetNode);
            LinkedHashMap<String, AbstractJcrNode> sourceOnly = new LinkedHashMap<String, AbstractJcrNode>(sourceNodes);
            sourceOnly.keySet().removeAll(targetNodes.keySet());
            for (AbstractJcrNode node : sourceOnly.values()) {
                JcrVersionManager.this.workspace().copy(this.workspaceName, node.getPath(), targetNode.getPath() + "/" + node.getName());
            }
            LinkedHashMap<String, AbstractJcrNode> targetOnly = new LinkedHashMap<String, AbstractJcrNode>(targetNodes);
            targetOnly.keySet().removeAll(targetOnly.keySet());
            for (AbstractJcrNode node : targetOnly.values()) {
                node.remove();
            }
            HashMap<String, AbstractJcrNode> presentInBoth = new HashMap<String, AbstractJcrNode>(targetNodes);
            presentInBoth.keySet().retainAll(sourceNodes.keySet());
            for (AbstractJcrNode node : presentInBoth.values()) {
                if (this.isShallow && node.isNodeType(JcrMixLexicon.VERSIONABLE)) continue;
                this.doMerge(node);
            }
        }

        private LinkedHashMap<String, AbstractJcrNode> childNodeMapFor(AbstractJcrNode node) throws RepositoryException {
            LinkedHashMap<String, AbstractJcrNode> childNodes = new LinkedHashMap<String, AbstractJcrNode>();
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                AbstractJcrNode child = (AbstractJcrNode)iter.nextNode();
                childNodes.put(child.getName(), child);
            }
            return childNodes;
        }

        private void doFail(AbstractJcrNode targetNode, JcrVersionNode sourceVersion) throws RepositoryException {
            if (!this.bestEffort) {
                throw new MergeException();
            }
            SessionCache.NodeEditor targetEditor = targetNode.editor();
            if (targetNode.hasProperty(JcrLexicon.MERGE_FAILED)) {
                JcrValue[] existingValues = (JcrValue[])targetNode.getProperty(JcrLexicon.MERGE_FAILED).getValues();
                boolean found = false;
                String sourceUuidString = sourceVersion.uuid().toString();
                for (int i = 0; i < existingValues.length; ++i) {
                    if (!sourceUuidString.equals(existingValues[i].getString())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    Value[] newValues = new JcrValue[existingValues.length + 1];
                    System.arraycopy(existingValues, 0, newValues, 0, existingValues.length);
                    newValues[newValues.length - 1] = targetNode.valueFrom(sourceVersion);
                    targetEditor.setProperty(JcrLexicon.MERGE_FAILED, newValues, 9, false);
                }
            } else {
                targetEditor.setProperty(JcrLexicon.MERGE_FAILED, targetNode.valueFrom(sourceVersion), false, false);
            }
            this.failures.add(targetNode);
            if (!this.isShallow) {
                NodeIterator iter = targetNode.getNodes();
                while (iter.hasNext()) {
                    AbstractJcrNode childNode = (AbstractJcrNode)iter.nextNode();
                    if (!childNode.isNodeType(JcrMixLexicon.VERSIONABLE)) continue;
                    this.doMerge(childNode);
                }
            }
        }

        private void restoreProperties(AbstractJcrNode sourceNode, AbstractJcrNode targetNode) throws RepositoryException {
            SessionCache.NodeEditor childEditor = targetNode.editor();
            HashMap<Name, GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload>> sourcePropertyNames = new HashMap<Name, GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload>>();
            for (GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload> propInfo : sourceNode.nodeInfo().getProperties()) {
                if (IGNORED_PROP_NAMES_FOR_RESTORE.contains(propInfo.getName())) continue;
                sourcePropertyNames.put(propInfo.getName(), propInfo);
            }
            ArrayList<GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload>> targetProps = new ArrayList<GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload>>(targetNode.nodeInfo().getProperties());
            for (GraphSession.PropertyInfo propertyInfo : targetProps) {
                Name propName = propertyInfo.getName();
                if (sourcePropertyNames.containsKey(propName)) {
                    JcrVersionManager.this.restoreProperty(((SessionCache.JcrPropertyPayload)((GraphSession.PropertyInfo)sourcePropertyNames.get(propName)).getPayload()).getJcrProperty(), childEditor);
                    sourcePropertyNames.remove(propName);
                    continue;
                }
                PropertyDefinitionId propDefnId = ((SessionCache.JcrPropertyPayload)propertyInfo.getPayload()).getPropertyDefinitionId();
                JcrPropertyDefinition propDefn = JcrVersionManager.this.session().nodeTypeManager().getPropertyDefinition(propDefnId);
                switch (propDefn.getOnParentVersion()) {
                    case 1: 
                    case 2: 
                    case 6: {
                        childEditor.removeProperty(propName);
                        break;
                    }
                }
            }
            for (Map.Entry entry : sourcePropertyNames.entrySet()) {
                JcrVersionManager.this.restoreProperty(((SessionCache.JcrPropertyPayload)((GraphSession.PropertyInfo)entry.getValue()).getPayload()).getJcrProperty(), childEditor);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    private class RestoreCommand {
        private Map<Version, AbstractJcrNode> existingVersions;
        private Set<Path> versionRootPaths;
        private Collection<Version> nonExistingVersions;
        private boolean removeExisting;
        private String labelToRestore;
        private Map<AbstractJcrNode, AbstractJcrNode> changedNodes;

        public RestoreCommand(Map<Version, AbstractJcrNode> existingVersions, Set<Path> versionRootPaths, Collection<Version> nonExistingVersions, String labelToRestore, boolean removeExisting) {
            this.existingVersions = existingVersions;
            this.versionRootPaths = versionRootPaths;
            this.nonExistingVersions = nonExistingVersions;
            this.removeExisting = removeExisting;
            this.labelToRestore = labelToRestore;
            this.changedNodes = new HashMap<AbstractJcrNode, AbstractJcrNode>(100);
        }

        void execute() throws RepositoryException {
            ArrayList<Version> versionsToCheck = new ArrayList<Version>(this.existingVersions.keySet());
            for (Version version : versionsToCheck) {
                AbstractJcrNode root = this.existingVersions.get(version);
                if (root == null) continue;
                this.restoreNodeMixins(JcrVersionManager.this.frozenNodeFor(version), root);
                this.restoreNode(JcrVersionManager.this.frozenNodeFor(version), root, JcrVersionManager.this.dateTime(version.getCreated()));
                this.clearCheckoutStatus(JcrVersionManager.this.frozenNodeFor(version), root);
            }
            if (!this.nonExistingVersions.isEmpty()) {
                StringBuilder versions = new StringBuilder();
                boolean bl = true;
                for (Version version : this.nonExistingVersions) {
                    boolean bl2;
                    if (!bl2) {
                        versions.append(", ");
                    } else {
                        bl2 = false;
                    }
                    versions.append(version.getName());
                }
                throw new VersionException(JcrI18n.unrootedVersionsInRestore.text(versions.toString()));
            }
            for (Map.Entry entry : this.changedNodes.entrySet()) {
                this.restoreProperties((AbstractJcrNode)entry.getKey(), (AbstractJcrNode)entry.getValue());
            }
        }

        private void restoreNode(AbstractJcrNode sourceNode, AbstractJcrNode targetNode, DateTime checkinTime) throws RepositoryException {
            this.changedNodes.put(sourceNode, targetNode);
            SessionCache.NodeEditor targetEditor = targetNode.editor();
            GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> targetNodeInfo = targetNode.nodeInfo();
            GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> sourceNodeInfo = sourceNode.nodeInfo();
            HashSet<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>> versionedChildrenThatShouldNotBeRestored = new HashSet<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>>();
            HashMap<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>, GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>> presentInBoth = new HashMap<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>, GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>>();
            List<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>> inTargetOnly = this.copyOf(targetNodeInfo.getChildren(), targetNodeInfo.getChildrenCount());
            HashMap<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>, GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>> inSourceOnly = new HashMap<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>, GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>>();
            for (GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> sourceChild : sourceNodeInfo.getChildren()) {
                boolean isVersionedChild = JcrNtLexicon.VERSIONED_CHILD.equals(JcrVersionManager.this.name(sourceChild.getProperty(JcrLexicon.PRIMARY_TYPE).getProperty().getFirstValue()));
                GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> node = this.resolveSourceNode(sourceChild, checkinTime);
                GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> match = this.findMatchFor(node);
                if (match != null) {
                    if (isVersionedChild) {
                        if (!this.removeExisting) {
                            Object rawUuid = match.getProperty(JcrLexicon.UUID).getProperty().getFirstValue();
                            String uuid = rawUuid == null ? null : rawUuid.toString();
                            throw new ItemExistsException(JcrI18n.itemAlreadyExistsWithUuid.text(uuid, JcrVersionManager.this.workspace().getName(), match.getPath()));
                        }
                        versionedChildrenThatShouldNotBeRestored.add(match);
                    }
                    inTargetOnly.remove(match);
                    presentInBoth.put(sourceChild, match);
                    continue;
                }
                inSourceOnly.put(sourceChild, node);
            }
            for (GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> targetChild : inTargetOnly) {
                switch (JcrVersionManager.this.nodeDefinitionFor(targetChild).getOnParentVersion()) {
                    case 1: 
                    case 2: 
                    case 6: {
                        targetEditor.destroyChild(targetChild);
                        break;
                    }
                }
            }
            LinkedList<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>> reversedChildren = new LinkedList<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>>();
            for (GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> sourceChild : sourceNodeInfo.getChildren()) {
                reversedChildren.addFirst(sourceChild);
            }
            GraphSession.Node prevChild = null;
            for (GraphSession.Node node : reversedChildren) {
                AbstractJcrNode targetChildNode;
                AbstractJcrNode sourceChildNode;
                GraphSession.Node resolvedChild;
                GraphSession.Node targetChild = (GraphSession.Node)presentInBoth.get(node);
                boolean shouldRestore = !versionedChildrenThatShouldNotBeRestored.contains(targetChild);
                boolean shouldRestoreMixinsAndUuid = false;
                if (targetChild != null) {
                    resolvedChild = this.resolveSourceNode(node, checkinTime);
                    sourceChildNode = JcrVersionManager.this.cache().findJcrNode(resolvedChild.getNodeId(), resolvedChild.getPath());
                    targetChildNode = JcrVersionManager.this.cache().findJcrNode(targetChild.getNodeId(), targetChild.getPath());
                } else {
                    UUID desiredUuid;
                    GraphSession.PropertyInfo uuidProp;
                    Name primaryTypeName;
                    resolvedChild = (GraphSession.Node)inSourceOnly.get(node);
                    sourceChildNode = JcrVersionManager.this.cache().findJcrNode(resolvedChild.getNodeId(), resolvedChild.getPath());
                    shouldRestoreMixinsAndUuid = true;
                    if (JcrNtLexicon.FROZEN_NODE.equals(resolvedChild.getProperty(JcrLexicon.PRIMARY_TYPE))) {
                        primaryTypeName = JcrVersionManager.this.name(resolvedChild.getProperty(JcrLexicon.FROZEN_PRIMARY_TYPE).getProperty().getFirstValue());
                        uuidProp = resolvedChild.getProperty(JcrLexicon.FROZEN_UUID);
                        desiredUuid = JcrVersionManager.this.uuid(uuidProp.getProperty().getFirstValue());
                        targetChildNode = targetEditor.createChild(node.getName(), desiredUuid, primaryTypeName);
                    } else {
                        primaryTypeName = JcrVersionManager.this.name(resolvedChild.getProperty(JcrLexicon.PRIMARY_TYPE).getProperty().getFirstValue());
                        uuidProp = resolvedChild.getProperty(JcrLexicon.UUID);
                        desiredUuid = uuidProp == null ? null : JcrVersionManager.this.uuid(uuidProp.getProperty().getFirstValue());
                        targetChildNode = targetEditor.createChild(node.getName(), desiredUuid, primaryTypeName);
                    }
                    assert (shouldRestore);
                }
                if (shouldRestore) {
                    if (shouldRestoreMixinsAndUuid) {
                        this.restoreNodeMixins(sourceChildNode, targetChildNode);
                    }
                    if (sourceChildNode.getParent().isNodeType(JcrNtLexicon.VERSION)) {
                        this.clearCheckoutStatus(sourceChildNode, targetChildNode);
                    }
                    this.restoreNode(sourceChildNode, targetChildNode, checkinTime);
                }
                this.orderBefore(node, prevChild, targetEditor);
                prevChild = node;
            }
        }

        private void clearCheckoutStatus(AbstractJcrNode sourceChildNode, AbstractJcrNode targetChildNode) throws RepositoryException {
            SessionCache.NodeEditor editor = targetChildNode.editor();
            editor.setProperty(JcrLexicon.IS_CHECKED_OUT, targetChildNode.valueFrom(6, false), false, false);
            editor.setProperty(JcrLexicon.BASE_VERSION, targetChildNode.valueFrom(sourceChildNode.getParent()), false, false);
        }

        private void orderBefore(GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> targetNode, GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> beforeNode, SessionCache.NodeEditor parentEditor) throws RepositoryException {
            Path.Segment beforeSegment = beforeNode == null ? null : beforeNode.getSegment();
            parentEditor.orderChildBefore(targetNode.getSegment(), beforeSegment);
        }

        private void restoreNodeMixins(AbstractJcrNode sourceNode, AbstractJcrNode targetNode) throws RepositoryException {
            SessionCache.NodeEditor childEditor = targetNode.editor();
            AbstractJcrProperty mixinTypesProp = sourceNode.getProperty(JcrLexicon.FROZEN_MIXIN_TYPES);
            AbstractJcrProperty uuidProp = null;
            if (mixinTypesProp == null) {
                mixinTypesProp = sourceNode.getProperty(JcrLexicon.MIXIN_TYPES);
                uuidProp = sourceNode.getProperty(JcrLexicon.UUID);
                if (uuidProp != null) {
                    JcrVersionManager.this.restoreProperty(uuidProp, childEditor);
                }
            }
            Object[] mixinTypeNames = mixinTypesProp == null ? EMPTY_OBJECT_ARRAY : mixinTypesProp.property().getValuesAsArray();
            HashSet<Name> currentMixinTypes = new HashSet<Name>(targetNode.getMixinTypeNames());
            for (int i = 0; i < mixinTypeNames.length; ++i) {
                Name mixinTypeName = JcrVersionManager.this.name(mixinTypeNames[i]);
                if (currentMixinTypes.remove(mixinTypeName)) continue;
                JcrNodeType mixinType = JcrVersionManager.this.session().nodeTypeManager().getNodeType(mixinTypeName);
                childEditor.addMixin(mixinType);
            }
        }

        private void restoreProperties(AbstractJcrNode sourceNode, AbstractJcrNode targetNode) throws RepositoryException {
            SessionCache.NodeEditor childEditor = targetNode.editor();
            HashMap<Name, GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload>> sourcePropertyNames = new HashMap<Name, GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload>>();
            for (GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload> propInfo : sourceNode.nodeInfo().getProperties()) {
                if (IGNORED_PROP_NAMES_FOR_RESTORE.contains(propInfo.getName())) continue;
                sourcePropertyNames.put(propInfo.getName(), propInfo);
            }
            ArrayList<GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload>> targetProps = new ArrayList<GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload>>(targetNode.nodeInfo().getProperties());
            for (GraphSession.PropertyInfo propertyInfo : targetProps) {
                Name propName = propertyInfo.getName();
                if (sourcePropertyNames.containsKey(propName)) {
                    JcrVersionManager.this.restoreProperty(((SessionCache.JcrPropertyPayload)((GraphSession.PropertyInfo)sourcePropertyNames.get(propName)).getPayload()).getJcrProperty(), childEditor);
                    sourcePropertyNames.remove(propName);
                    continue;
                }
                PropertyDefinitionId propDefnId = ((SessionCache.JcrPropertyPayload)propertyInfo.getPayload()).getPropertyDefinitionId();
                JcrPropertyDefinition propDefn = JcrVersionManager.this.session().nodeTypeManager().getPropertyDefinition(propDefnId);
                switch (propDefn.getOnParentVersion()) {
                    case 1: 
                    case 2: 
                    case 6: {
                        childEditor.removeProperty(propName);
                        break;
                    }
                }
            }
            for (Map.Entry entry : sourcePropertyNames.entrySet()) {
                JcrVersionManager.this.restoreProperty(((SessionCache.JcrPropertyPayload)((GraphSession.PropertyInfo)entry.getValue()).getPayload()).getJcrProperty(), childEditor);
            }
        }

        private GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> resolveSourceNode(GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> sourceNode, DateTime checkinTime) throws RepositoryException {
            Name sourcePrimaryTypeName = JcrVersionManager.this.name(sourceNode.getProperty(JcrLexicon.PRIMARY_TYPE).getProperty().getFirstValue());
            if (JcrNtLexicon.FROZEN_NODE.equals(sourcePrimaryTypeName)) {
                return sourceNode;
            }
            if (!JcrNtLexicon.VERSIONED_CHILD.equals(sourcePrimaryTypeName)) {
                return sourceNode;
            }
            assert (JcrNtLexicon.VERSIONED_CHILD.equals(sourcePrimaryTypeName));
            GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload> historyUuidProp = sourceNode.getProperty(JcrLexicon.CHILD_VERSION_HISTORY);
            UUID uuid = JcrVersionManager.this.uuid(historyUuidProp.getProperty().getFirstValue());
            assert (uuid != null);
            String uuidString = uuid.toString();
            for (Version version : this.nonExistingVersions) {
                if (!uuidString.equals(version.getContainingHistory().getIdentifier())) continue;
                JcrVersionNode versionNode = (JcrVersionNode)version;
                this.nonExistingVersions.remove(version);
                return versionNode.getFrozenNode().nodeInfo();
            }
            for (Version version : this.existingVersions.keySet()) {
                if (!uuidString.equals(version.getContainingHistory().getIdentifier())) continue;
                JcrVersionNode versionNode = (JcrVersionNode)version;
                this.existingVersions.remove(version);
                return versionNode.getFrozenNode().nodeInfo();
            }
            JcrVersionHistoryNode versionHistory = (JcrVersionHistoryNode)JcrVersionManager.this.cache().findJcrNode(Location.create(uuid));
            if (this.labelToRestore != null) {
                try {
                    JcrVersionNode versionNode = versionHistory.getVersionByLabel(this.labelToRestore);
                    return versionNode.getFrozenNode().nodeInfo();
                }
                catch (VersionException noVersionWithThatLabel) {
                    // empty catch block
                }
            }
            AbstractJcrNode match = this.closestMatchFor(versionHistory, checkinTime);
            return match.nodeInfo();
        }

        private GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> findMatchFor(GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> sourceNode) throws ItemExistsException, RepositoryException {
            GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload> uuidProp = sourceNode.getProperty(JcrLexicon.FROZEN_UUID);
            if (uuidProp == null) {
                return null;
            }
            UUID sourceUuid = JcrVersionManager.this.uuid(uuidProp.getProperty().getFirstValue());
            try {
                AbstractJcrNode match = JcrVersionManager.this.cache().findJcrNode(Location.create(sourceUuid));
                if (this.nodeIsOutsideRestoredForest(match)) {
                    return null;
                }
                return match.nodeInfo();
            }
            catch (ItemNotFoundException infe) {
                return null;
            }
        }

        private List<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>> copyOf(Iterable<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>> rawElements, int size) {
            ArrayList<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>> newList = new ArrayList<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>>(size);
            for (GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> node : rawElements) {
                newList.add(node);
            }
            return newList;
        }

        private boolean nodeIsOutsideRestoredForest(AbstractJcrNode node) throws ItemExistsException, RepositoryException {
            Path nodePath = node.path();
            for (Path rootPath : this.versionRootPaths) {
                if (!nodePath.isAtOrBelow(rootPath)) continue;
                return false;
            }
            if (!this.removeExisting) {
                throw new ItemExistsException(JcrI18n.itemAlreadyExistsWithUuid.text(node.uuid(), JcrVersionManager.this.workspace().getName(), node.getPath()));
            }
            node.remove();
            return true;
        }

        private AbstractJcrNode closestMatchFor(JcrVersionHistoryNode versionHistory, DateTime checkinTime) throws RepositoryException {
            DateTimeFactory dateFactory = JcrVersionManager.this.context().getValueFactories().getDateFactory();
            VersionIterator iter = versionHistory.getAllVersions();
            HashMap versions = new HashMap((int)iter.getSize());
            while (iter.hasNext()) {
                Version version = iter.nextVersion();
                versions.put(dateFactory.create(version.getCreated()), version);
            }
            ArrayList versionDates = new ArrayList(versions.keySet());
            Collections.sort(versionDates);
            for (int i = versionDates.size() - 1; i >= 0; --i) {
                if (!((DateTime)versionDates.get(i)).isBefore(checkinTime)) continue;
                Version version = (Version)versions.get(versionDates.get(i));
                return ((JcrVersionNode)version).getFrozenNode();
            }
            throw new IllegalStateException("First checkin must be before the checkin time of the node to be restored");
        }
    }
}

