/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionManager;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.UuidAlreadyExistsException;
import org.modeshape.graph.property.InvalidPathException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.LocalNamespaceRegistry;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrContentHandler;
import org.modeshape.jcr.JcrGraph;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrLockManager;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNamespaceRegistry;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrObservationManager;
import org.modeshape.jcr.JcrQueryManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSharedNode;
import org.modeshape.jcr.JcrVersionManager;
import org.modeshape.jcr.ModeShapeIntLexicon;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.SessionCache;
import org.modeshape.jcr.WorkspaceLockManager;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
class JcrWorkspace
implements Workspace {
    private final String name;
    private final ExecutionContext context;
    private final JcrRepository repository;
    private final JcrGraph graph;
    private final JcrNamespaceRegistry workspaceRegistry;
    private final JcrNodeTypeManager nodeTypeManager;
    private final JcrVersionManager versionManager;
    private final JcrQueryManager queryManager;
    private final JcrObservationManager observationManager;
    private final JcrLockManager lockManager;
    private final JcrSession session;

    JcrWorkspace(JcrRepository repository, String workspaceName, ExecutionContext context, Map<String, Object> sessionAttributes) {
        assert (workspaceName != null);
        assert (context != null);
        assert (context.getSecurityContext() != null);
        assert (repository != null);
        this.name = workspaceName;
        this.repository = repository;
        org.modeshape.graph.property.NamespaceRegistry globalRegistry = context.getNamespaceRegistry();
        LocalNamespaceRegistry localRegistry = new LocalNamespaceRegistry(globalRegistry);
        this.context = context.with(localRegistry);
        localRegistry.getNamespaces();
        this.graph = this.repository.createWorkspaceGraph(this.name, this.context);
        this.session = new JcrSession(this.repository, this, this.context, globalRegistry, sessionAttributes);
        this.nodeTypeManager = new JcrNodeTypeManager(this.session, this.repository.getRepositoryTypeManager());
        this.versionManager = new JcrVersionManager(this.session);
        this.queryManager = new JcrQueryManager(this.session);
        this.observationManager = new JcrObservationManager(this.session, this.repository.getRepositoryObservable());
        this.workspaceRegistry = new JcrNamespaceRegistry(this.repository.getPersistentRegistry(), this.session);
        this.lockManager = new JcrLockManager(this.session, repository.getRepositoryLockManager().getLockManager(workspaceName));
    }

    final JcrGraph graph() {
        return this.graph;
    }

    final String getSourceName() {
        return this.repository.getRepositorySourceName();
    }

    final JcrNodeTypeManager nodeTypeManager() {
        return this.nodeTypeManager;
    }

    final ExecutionContext context() {
        return this.context;
    }

    final JcrLockManager lockManager() {
        return this.lockManager;
    }

    final JcrObservationManager observationManager() {
        return this.observationManager;
    }

    final JcrQueryManager queryManager() {
        return this.queryManager;
    }

    public final String getName() {
        return this.name;
    }

    public final Session getSession() {
        return this.session;
    }

    public final NamespaceRegistry getNamespaceRegistry() {
        return this.workspaceRegistry;
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        this.session.checkLive();
        try {
            Set<String> workspaceNamesFromGraph = this.graph.getWorkspaces();
            HashSet<String> workspaceNames = new HashSet<String>(workspaceNamesFromGraph.size());
            for (String workspaceName : workspaceNamesFromGraph) {
                try {
                    this.session.checkPermission(workspaceName, null, "read");
                    workspaceNames.add(workspaceName);
                }
                catch (AccessControlException ace) {}
            }
            return workspaceNames.toArray(new String[workspaceNames.size()]);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(JcrI18n.errorObtainingWorkspaceNames.text(this.getSourceName(), e.getMessage()), (Throwable)e);
        }
    }

    public final NodeTypeManager getNodeTypeManager() {
        return this.nodeTypeManager;
    }

    public final ObservationManager getObservationManager() {
        return this.observationManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public final QueryManager getQueryManager() {
        return this.queryManager;
    }

    final JcrVersionManager versionManager() {
        return this.versionManager;
    }

    public void clone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        CheckArg.isNotNull(srcWorkspace, "source workspace name");
        CheckArg.isNotNull(srcAbsPath, "source path");
        CheckArg.isNotNull(destAbsPath, "destination path");
        boolean sameWorkspace = this.getName().equals(srcWorkspace);
        if (sameWorkspace && removeExisting) {
            this.move(srcAbsPath, destAbsPath);
            return;
        }
        this.session.checkLive();
        if (!sameWorkspace && !this.graph.getWorkspaces().contains(srcWorkspace)) {
            throw new NoSuchWorkspaceException(JcrI18n.workspaceNameIsInvalid.text(this.graph.getSourceName(), this.name));
        }
        PathFactory factory = this.context.getValueFactories().getPathFactory();
        Path srcPath = null;
        Path destPath = null;
        try {
            srcPath = (Path)factory.create(srcAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(srcAbsPath, "srcAbsPath"), (Throwable)e);
        }
        try {
            destPath = (Path)factory.create(destAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(destAbsPath, "destAbsPath"), (Throwable)e);
        }
        if (!sameWorkspace && !destPath.isIdentifier() && destAbsPath.endsWith("]")) {
            throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(destAbsPath));
        }
        try {
            Set<UUID> uuidsInCloneBranch;
            JcrNodeType nodeType;
            Lock newParentLock;
            SessionCache cache = this.session.cache();
            AbstractJcrNode parentNode = null;
            Name newNodeName = null;
            if (destPath.isIdentifier()) {
                AbstractJcrNode existingDestNode = cache.findJcrNode(Location.create(destPath));
                parentNode = existingDestNode.getParent();
                newNodeName = existingDestNode.segment().getName();
                destPath = factory.create(parentNode.path(), newNodeName);
            } else {
                parentNode = cache.findJcrNode(null, destPath.getParent());
                newNodeName = destPath.getLastSegment().getName();
            }
            Node sourceNode = this.repository.createWorkspaceGraph(srcWorkspace, this.context).getNodeAt(srcPath);
            Property uuidProp = sourceNode.getProperty(ModeShapeLexicon.UUID);
            UUID sourceUuid = null;
            if (uuidProp != null) {
                sourceUuid = (UUID)this.context.getValueFactories().getUuidFactory().create(uuidProp.getFirstValue());
                WorkspaceLockManager.ModeShapeLock sourceLock = this.lockManager().lockFor(sourceUuid);
                if (sourceLock != null && sourceLock.getLockToken() == null) {
                    throw new LockException(JcrI18n.lockTokenNotHeld.text(srcAbsPath));
                }
            }
            if (parentNode.isLocked() && (newParentLock = parentNode.getLock()) != null && newParentLock.getLockToken() == null) {
                throw new LockException(destAbsPath);
            }
            if (!parentNode.isCheckedOut()) {
                throw new VersionException(JcrI18n.nodeIsCheckedIn.text(parentNode.getPath()));
            }
            GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> parent = cache.findNode(parentNode.nodeId, parentNode.path());
            JcrNodeDefinition childDefn = null;
            try {
                childDefn = cache.findBestNodeDefinition(parent, newNodeName, parent.getPayload().getPrimaryTypeName());
            }
            catch (RepositoryException e) {
                if (sameWorkspace) {
                    AbstractJcrNode originalShareable = cache.findJcrNode(Location.create(sourceUuid));
                    Name originalShareablePrimaryType = originalShareable.getPrimaryTypeName();
                    childDefn = cache.findBestNodeDefinition(parent, newNodeName, originalShareablePrimaryType);
                }
                throw e;
            }
            if (sameWorkspace) {
                Property mixinTypes;
                assert (!removeExisting);
                Property primaryType = sourceNode.getProperty(JcrLexicon.PRIMARY_TYPE);
                NameFactory nameFactory = this.context.getValueFactories().getNameFactory();
                boolean shareable = false;
                if (primaryType != null) {
                    Name primaryTypeName = (Name)nameFactory.create(primaryType.getFirstValue());
                    JcrNodeType nodeType2 = this.nodeTypeManager().getNodeType(primaryTypeName);
                    if (nodeType2 != null && nodeType2.isNodeType(JcrMixLexicon.SHAREABLE)) {
                        shareable = true;
                    }
                }
                if (!shareable && (mixinTypes = sourceNode.getProperty(JcrLexicon.MIXIN_TYPES)) != null) {
                    for (Object value : mixinTypes) {
                        Name mixinTypeName = (Name)nameFactory.create(value);
                        nodeType = this.nodeTypeManager().getNodeType(mixinTypeName);
                        if (nodeType == null || !nodeType.isNodeType(JcrMixLexicon.SHAREABLE)) continue;
                        shareable = true;
                        break;
                    }
                }
                if (shareable) {
                    assert (sourceUuid != null);
                    assert (childDefn != null);
                    PropertyFactory propertyFactory = this.context.getPropertyFactory();
                    ArrayList<Property> properties = new ArrayList<Property>(2);
                    properties.add(propertyFactory.create(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.SHARE));
                    properties.add(propertyFactory.create(ModeShapeLexicon.SHARED_UUID, sourceUuid));
                    properties.add(propertyFactory.create(ModeShapeIntLexicon.NODE_DEFINITON, childDefn.getId().getString()));
                    cache.graphSession().immediateCreateOrReplace(destPath, properties);
                    return;
                }
            }
            if (removeExisting && !(uuidsInCloneBranch = this.getUuidsInBranch(srcPath, srcWorkspace)).isEmpty()) {
                SessionCache.CustomGraphSession graphSession = cache.graphSession();
                GraphSession.Node node = null;
                for (UUID uuid : uuidsInCloneBranch) {
                    Location location = Location.create(uuid);
                    try {
                        node = graphSession.findNodeWith(location);
                    }
                    catch (org.modeshape.graph.property.PathNotFoundException e) {
                        continue;
                    }
                    NodeDefinitionId childDefnId = ((SessionCache.JcrNodePayload)node.getPayload()).getDefinitionId();
                    nodeType = this.nodeTypeManager().getNodeType(childDefnId.getNodeTypeName());
                    childDefn = nodeType.childNodeDefinition(childDefnId);
                    if (childDefn.isMandatory()) {
                        String path = node.getPath().getString(this.context.getNamespaceRegistry());
                        throw new ConstraintViolationException(JcrI18n.cannotRemoveNodeFromClone.text(path, uuid));
                    }
                    if (!node.isChanged(true)) continue;
                    String path = node.getPath().getString(this.context.getNamespaceRegistry());
                    throw new RepositoryException(JcrI18n.cannotRemoveNodeFromCloneDueToChangesInSession.text(path, uuid));
                }
            }
            cache.graphSession().immediateClone(srcPath, srcWorkspace, destPath, removeExisting, false);
        }
        catch (ItemNotFoundException e) {
            throw new PathNotFoundException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new PathNotFoundException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (UuidAlreadyExistsException e) {
            throw new ItemExistsException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (InvalidWorkspaceException e) {
            throw new NoSuchWorkspaceException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<UUID> getUuidsInBranch(Path sourcePath, String workspace) {
        String existingWorkspace = this.graph.getCurrentWorkspaceName();
        try {
            this.graph.useWorkspace(workspace);
            Location location = Location.create(sourcePath);
            Subgraph subgraph = this.graph.getSubgraphOfDepth(Integer.MAX_VALUE).at(location);
            HashSet<UUID> uuids = new HashSet<UUID>();
            for (SubgraphNode nodeInSubgraph : subgraph) {
                UUID uuid = nodeInSubgraph.getLocation().getUuid();
                if (uuid == null) continue;
                uuids.add(uuid);
            }
            HashSet<UUID> hashSet = uuids;
            return hashSet;
        }
        finally {
            this.graph.useWorkspace(existingWorkspace);
        }
    }

    public void copy(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.copy(this.name, srcAbsPath, destAbsPath);
    }

    public void copy(String srcWorkspace, String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        CheckArg.isNotNull(srcWorkspace, "source workspace name");
        CheckArg.isNotNull(srcAbsPath, "source path");
        CheckArg.isNotNull(destAbsPath, "destination path");
        this.session.checkLive();
        if (!this.graph.getWorkspaces().contains(srcWorkspace)) {
            throw new NoSuchWorkspaceException(JcrI18n.workspaceNameIsInvalid.text(this.graph.getSourceName(), this.name));
        }
        PathFactory factory = this.context.getValueFactories().getPathFactory();
        Path srcPath = null;
        Path destPath = null;
        try {
            srcPath = (Path)factory.create(srcAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(srcAbsPath, "srcAbsPath"), (Throwable)e);
        }
        try {
            destPath = (Path)factory.create(destAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(destAbsPath, "destAbsPath"), (Throwable)e);
        }
        if (!destPath.isIdentifier() && destAbsPath.endsWith("]")) {
            throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(destAbsPath));
        }
        try {
            Lock newParentLock;
            SessionCache cache = this.session.cache();
            AbstractJcrNode parentNode = null;
            Name newNodeName = null;
            if (destPath.isIdentifier()) {
                AbstractJcrNode existingDestNode = cache.findJcrNode(Location.create(destPath));
                parentNode = existingDestNode.getParent();
                newNodeName = existingDestNode.segment().getName();
                destPath = factory.create(parentNode.path(), newNodeName);
            } else {
                parentNode = cache.findJcrNode(null, destPath.getParent());
                newNodeName = destPath.getLastSegment().getName();
            }
            Node sourceNode = this.repository.createWorkspaceGraph(srcWorkspace, this.context).getNodeAt(srcPath);
            Property uuidProp = sourceNode.getProperty(ModeShapeLexicon.UUID);
            if (uuidProp != null) {
                UUID sourceUuid = (UUID)this.context.getValueFactories().getUuidFactory().create(uuidProp.getFirstValue());
                WorkspaceLockManager.ModeShapeLock sourceLock = this.lockManager().lockFor(sourceUuid);
                if (sourceLock != null && sourceLock.getLockToken() == null) {
                    throw new LockException(srcAbsPath);
                }
            }
            Property primaryTypeProp = sourceNode.getProperty(JcrLexicon.PRIMARY_TYPE);
            Name primaryTypeName = (Name)this.context.getValueFactories().getNameFactory().create(primaryTypeProp.getFirstValue());
            if (parentNode.isLocked() && (newParentLock = parentNode.getLock()) != null && newParentLock.getLockToken() == null) {
                throw new LockException(destAbsPath);
            }
            if (!parentNode.isCheckedOut()) {
                throw new VersionException(JcrI18n.nodeIsCheckedIn.text(parentNode.getPath()));
            }
            cache.findBestNodeDefinition(parentNode.nodeInfo(), newNodeName, primaryTypeName);
            Location copy = cache.graphSession().immediateCopy(srcPath, srcWorkspace, destPath);
            destPath = copy.getPath();
            if (this.repository.isQueryExecutionEnabled()) {
                String queryStr = "SELECT [jcr:path],[jcr:uuid] FROM [mix:versionable] WHERE PATH() = '" + srcAbsPath + "' OR PATH() LIKE '" + srcAbsPath + "/%'";
                Query query = this.getQueryManager().createQuery(queryStr, "JCR-SQL2");
                QueryResult result = query.execute();
                Graph.Batch batch = this.repository.createWorkspaceGraph(srcWorkspace, this.context).batch();
                NodeIterator versionableIter = result.getNodes();
                int initializedCount = 0;
                while (versionableIter.hasNext()) {
                    AbstractJcrNode versionable = (AbstractJcrNode)versionableIter.nextNode();
                    Path sourcePath = versionable.path();
                    Path newNodePath = null;
                    if (sourcePath.equals(srcPath)) {
                        newNodePath = destPath;
                    } else {
                        Path relativePath = versionable.path().relativeTo(srcPath);
                        newNodePath = relativePath.resolveAgainst(destPath);
                    }
                    AbstractJcrNode newVersionableNode = cache.findJcrNode(Location.create(newNodePath));
                    if (newVersionableNode instanceof JcrSharedNode) continue;
                    UUID originalVersion = versionable.getBaseVersion().uuid();
                    this.versionManager.initializeVersionHistoryFor(batch, newVersionableNode.nodeInfo(), originalVersion, true);
                    ++initializedCount;
                }
                batch.execute();
            } else {
                LinkedList<AbstractJcrNode> nodesToCheck = new LinkedList<AbstractJcrNode>();
                nodesToCheck.add(cache.findJcrNode(Location.create(destPath)));
                Graph.Batch batch = this.repository.createWorkspaceGraph(srcWorkspace, this.context).batch();
                while (!nodesToCheck.isEmpty()) {
                    Path nodeDestPath;
                    Path nodeSourcePath;
                    AbstractJcrNode fromNode;
                    AbstractJcrNode node = (AbstractJcrNode)nodesToCheck.remove(0);
                    if (node.isNodeType(JcrMixLexicon.VERSIONABLE) && !((fromNode = cache.findJcrNode(Location.create(nodeSourcePath = (nodeDestPath = node.path().relativeTo(destPath)).resolveAgainst(srcPath)))) instanceof JcrSharedNode)) {
                        UUID originalVersion = fromNode.getBaseVersion().uuid();
                        this.versionManager.initializeVersionHistoryFor(batch, node.nodeInfo(), originalVersion, true);
                    }
                    NodeIterator iter = node.getNodes();
                    while (iter.hasNext()) {
                        nodesToCheck.add((AbstractJcrNode)iter.nextNode());
                    }
                }
                batch.execute();
            }
        }
        catch (ItemNotFoundException e) {
            throw new PathNotFoundException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new PathNotFoundException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (UuidAlreadyExistsException e) {
            throw new ItemExistsException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (InvalidWorkspaceException e) {
            throw new NoSuchWorkspaceException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        catch (InvalidPathException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, AccessDeniedException, RepositoryException {
        CheckArg.isNotNull(parentAbsPath, "parentAbsPath");
        this.session.checkLive();
        Path parentPath = (Path)this.context.getValueFactories().getPathFactory().create(parentAbsPath);
        Repository repo = this.getSession().getRepository();
        boolean retainLifecycleInfo = repo.getDescriptorValue("option.lifecycle.supported").getBoolean();
        boolean retainRetentionInfo = repo.getDescriptorValue("option.retention.supported").getBoolean();
        return new JcrContentHandler(this.session, parentPath, uuidBehavior, JcrContentHandler.SaveMode.WORKSPACE, retainRetentionInfo, retainLifecycleInfo);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, LockException, AccessDeniedException, RepositoryException {
        CheckArg.isNotNull(parentAbsPath, "parentAbsPath");
        CheckArg.isNotNull(in, "in");
        this.session.checkLive();
        boolean error = false;
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(this.getImportContentHandler(parentAbsPath, uuidBehavior));
            parser.parse(new InputSource(in));
        }
        catch (JcrContentHandler.EnclosingSAXException ese) {
            Exception cause = ese.getException();
            if (cause instanceof ItemExistsException) {
                throw (ItemExistsException)cause;
            }
            if (cause instanceof ConstraintViolationException) {
                throw (ConstraintViolationException)((Object)cause);
            }
            throw new RepositoryException((Throwable)cause);
        }
        catch (SAXParseException se) {
            error = true;
            throw new InvalidSerializedDataException((Throwable)se);
        }
        catch (SAXException se) {
            error = true;
            throw new RepositoryException((Throwable)se);
        }
        finally {
            block17: {
                try {
                    in.close();
                }
                catch (IOException t) {
                    if (!error) {
                        throw t;
                    }
                }
                catch (RuntimeException re) {
                    if (error) break block17;
                    throw re;
                }
            }
        }
    }

    public void move(String srcAbsPath, String destAbsPath) throws PathNotFoundException, RepositoryException {
        CheckArg.isNotEmpty(srcAbsPath, "srcAbsPath");
        CheckArg.isNotEmpty(destAbsPath, "destAbsPath");
        this.session.checkLive();
        PathFactory factory = this.context.getValueFactories().getPathFactory();
        Path srcPath = null;
        Path destPath = null;
        try {
            srcPath = (Path)factory.create(srcAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(srcAbsPath, "srcAbsPath"), (Throwable)e);
        }
        try {
            destPath = (Path)factory.create(destAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(destAbsPath, "destAbsPath"), (Throwable)e);
        }
        if (!destPath.isIdentifier() && destAbsPath.endsWith("]")) {
            throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(destAbsPath));
        }
        try {
            Lock newParentLock;
            Lock sourceLock;
            SessionCache cache = this.session.cache();
            GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> newParent = null;
            Name newNodeName = null;
            if (destPath.isIdentifier()) {
                GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> existingDestNode = cache.findNodeWith(Location.create(destPath));
                newParent = existingDestNode.getParent();
                newNodeName = existingDestNode.getName();
                destPath = factory.create(newParent.getPath(), newNodeName);
            } else {
                newParent = cache.findNode(null, destPath.getParent());
                newNodeName = destPath.getLastSegment().getName();
            }
            cache.findBestNodeDefinition(newParent, newNodeName, newParent.getPayload().getPrimaryTypeName());
            AbstractJcrNode sourceNode = cache.findJcrNode(Location.create(srcPath));
            if (sourceNode.isLocked() && (sourceLock = sourceNode.getLock()) != null && sourceLock.getLockToken() == null) {
                throw new LockException(srcAbsPath);
            }
            AbstractJcrNode parentNode = cache.findJcrNode(newParent.getNodeId(), newParent.getPath());
            if (parentNode.isLocked() && (newParentLock = parentNode.getLock()) != null && newParentLock.getLockToken() == null) {
                throw new LockException(destAbsPath);
            }
            if (!sourceNode.isCheckedOut()) {
                throw new VersionException(JcrI18n.nodeIsCheckedIn.text(sourceNode.getPath()));
            }
            if (!parentNode.isCheckedOut()) {
                throw new VersionException(JcrI18n.nodeIsCheckedIn.text(parentNode.getPath()));
            }
            cache.graphSession().immediateMove(srcPath, destPath);
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException((Throwable)infe);
        }
        catch (org.modeshape.graph.property.PathNotFoundException pnfe) {
            throw new PathNotFoundException((Throwable)pnfe);
        }
    }

    public void restore(Version[] versions, boolean removeExisting) throws RepositoryException {
        this.versionManager().restore(versions, removeExisting);
    }

    public void createWorkspace(String name, String srcWorkspace) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        CheckArg.isNotNull(srcWorkspace, "srcWorkspace");
        this.session.checkLive();
        try {
            this.session.checkPermission(srcWorkspace, null, "read");
            this.session.checkPermission(name, null, "create_workspace");
            this.repository.createWorkspace(name, srcWorkspace);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException((Throwable)e);
        }
        catch (InvalidWorkspaceException e) {
            throw new NoSuchWorkspaceException((Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void createWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.session.checkLive();
        try {
            this.session.checkPermission(name, null, "create_workspace");
            this.repository.createWorkspace(name, null);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException((Throwable)e);
        }
        catch (InvalidWorkspaceException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void deleteWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.session.checkLive();
        try {
            this.session.checkPermission(name, null, "delete_workspace");
            this.repository.destroyWorkspace(name, this);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException((Throwable)e);
        }
        catch (InvalidWorkspaceException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public VersionManager getVersionManager() {
        return this.versionManager;
    }
}

