/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.security;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JaasSecurityContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.api.JaasCredentials;
import org.modeshape.jcr.security.AuthenticationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaasProvider
implements AuthenticationProvider {
    private final String policyName;

    public JaasProvider(String policyName) throws LoginException {
        CheckArg.isNotNull(policyName, "policyName");
        this.policyName = policyName;
        try {
            new LoginContext(policyName);
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }

    @Override
    public ExecutionContext authenticate(final Credentials credentials, String repositoryName, String workspaceName, ExecutionContext repositoryContext, Map<String, Object> sessionAttributes) {
        try {
            if (credentials == null) {
                Subject subject = Subject.getSubject(AccessController.getContext());
                if (subject != null) {
                    return repositoryContext.with(new JaasSecurityContext(subject));
                }
                return null;
            }
            if (credentials instanceof SimpleCredentials) {
                SimpleCredentials simple = (SimpleCredentials)credentials;
                String[] attributeNames = simple.getAttributeNames();
                if (attributeNames != null && attributeNames.length != 0) {
                    sessionAttributes = new HashMap<String, Object>();
                    for (String attributeName : simple.getAttributeNames()) {
                        Object attributeValue = simple.getAttribute(attributeName);
                        sessionAttributes.put(attributeName, attributeValue);
                    }
                }
                return repositoryContext.with(new JaasSecurityContext(this.policyName, simple.getUserID(), simple.getPassword()));
            }
            LoginContext loginContext = null;
            if (credentials instanceof JaasCredentials) {
                loginContext = ((JaasCredentials)credentials).getLoginContext();
            } else {
                try {
                    final Method method = credentials.getClass().getMethod("getLoginContext", new Class[0]);
                    Object result = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return method.invoke((Object)credentials, new Object[0]);
                        }
                    });
                    if (result instanceof LoginContext) {
                        loginContext = (LoginContext)result;
                    } else {
                        Logger.getLogger(JaasProvider.class).error(JcrI18n.credentialsMustReturnLoginContext, credentials.getClass().getName());
                    }
                }
                catch (NoSuchMethodException error) {
                }
                catch (PrivilegedActionException e) {
                    Logger.getLogger(JaasProvider.class).warn(JcrI18n.noPrivilegeToGetLoginContextFromCredentials, credentials.getClass().getName());
                }
            }
            if (loginContext != null) {
                return repositoryContext.with(new JaasSecurityContext(loginContext));
            }
        }
        catch (LoginException error) {
            // empty catch block
        }
        return null;
    }
}

